package com.dtyunxi.yundt.cube.center.user.api.dto.response;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 组织单元-公司相关信息响应dto
 */
@ApiModel(value = "OrgAdvInfoRespDto", description = "组织单元-公司相关信息响应dto")
public class OrgAdvInfoRespDto extends RequestDto {

    private static final long serialVersionUID = 3700482220590033023L;
    /**
     * 统一社会信用代码
     */
    @ApiModelProperty(value = "统一社会信用代码，新增必填")
    private String creditCode;

    /**
     * 法人姓名
     */
    @ApiModelProperty(value = "法人姓名，新增必填")
    private String legalName;

    /**
     * 营业执照URL
     */
    @ApiModelProperty(value = "营业执照URL，选填")
    private String bussinessLicenseUrl;

    /**
     * 身份证正面
     */
    @ApiModelProperty(value = "身份证正面，选填")
    private String idCardFront;

    /**
     * 身份证反面
     */
    @ApiModelProperty(value = "身份证反面，选填")
    private String idCardBack;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称(公司名称)，新增必填")
    private String orgName;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码")
    private String orgCode;

    /**
     * 执照类型,1:多证合一营业执照,2:普通营业执照
     */
    @ApiModelProperty(value = "执照类型,1:多证合一营业执照,2:普通营业执照")
    private Integer businessLicenseType;
    /**
     * 营业期限类型,1:短期有效，2：长期有效
     */
    @ApiModelProperty(value = "营业期限类型,1:短期有效，2：长期有效")
    private String businessTermType;

    /**
     * 营业期限开始时间
     */
    @ApiModelProperty(value = "营业期限类型,1:短期有效，2：长期有效")
    private Date termBeginTime;
    /**
     * 营业期限结束时间
     */
    @ApiModelProperty(value = "营业期限类型,1:短期有效，2：长期有效")
    private Date termEndTime;

    /**
     * 公司地址
     */
    @ApiModelProperty(value = "公司地址")
    private String address;

    /**
     * 法人证件类型,1:大陆居民省份证，2：港澳台，3：护照
     */
    @ApiModelProperty(value = "法人证件类型,1:大陆居民省份证，2：港澳台，3：护照")
    private Integer legalCardType;
    /**
     * 法人证件号码
     */
    @ApiModelProperty(value = "法人证件号码")
    private String legalCardNum;
    /**
     * 法人证件有效期类型，1:短期有效，2：长期有效
     */
    @ApiModelProperty(value = "法人证件有效期类型，1:短期有效，2：长期有效")
    private Integer cardEffectType;
    /**
     * 法人证件有效期开始时间
     */
    @ApiModelProperty(value = "法人证件有效期开始时间")
    private Date cardEffectBeginTime;
    /**
     * 法人证件有效期结束时间
     */
    @ApiModelProperty(value = "法人证件有效期结束时间")
    private Date cardEffectEndTime;

    /**
     * 经营资质
     */
    @ApiModelProperty(value = "经营资质")
    private String businessQualification;

    /**
     * 组织单元id
     */
    @ApiModelProperty(value = "组织单元id")
    private Long orgId;

    /**
     * 主体类型（company：企业，individual：个体户，zooid：个人）
     */
    @ApiModelProperty(value = "主体类型（company：企业，individual：个体户，zooid：个人）")
    private String subjectType;

    public String getSubjectType() {
        return subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getBusinessLicenseType() {
        return businessLicenseType;
    }

    public void setBusinessLicenseType(Integer businessLicenseType) {
        this.businessLicenseType = businessLicenseType;
    }

    public String getBusinessTermType() {
        return businessTermType;
    }

    public void setBusinessTermType(String businessTermType) {
        this.businessTermType = businessTermType;
    }

    public Date getTermBeginTime() {
        return termBeginTime;
    }

    public void setTermBeginTime(Date termBeginTime) {
        this.termBeginTime = termBeginTime;
    }

    public Date getTermEndTime() {
        return termEndTime;
    }

    public void setTermEndTime(Date termEndTime) {
        this.termEndTime = termEndTime;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getLegalCardType() {
        return legalCardType;
    }

    public void setLegalCardType(Integer legalCardType) {
        this.legalCardType = legalCardType;
    }

    public String getLegalCardNum() {
        return legalCardNum;
    }

    public void setLegalCardNum(String legalCardNum) {
        this.legalCardNum = legalCardNum;
    }

    public Integer getCardEffectType() {
        return cardEffectType;
    }

    public void setCardEffectType(Integer cardEffectType) {
        this.cardEffectType = cardEffectType;
    }

    public Date getCardEffectBeginTime() {
        return cardEffectBeginTime;
    }

    public void setCardEffectBeginTime(Date cardEffectBeginTime) {
        this.cardEffectBeginTime = cardEffectBeginTime;
    }

    public Date getCardEffectEndTime() {
        return cardEffectEndTime;
    }

    public void setCardEffectEndTime(Date cardEffectEndTime) {
        this.cardEffectEndTime = cardEffectEndTime;
    }

    public String getBusinessQualification() {
        return businessQualification;
    }

    public void setBusinessQualification(String businessQualification) {
        this.businessQualification = businessQualification;
    }

    public String getCreditCode() {
        return creditCode;
    }

    public void setCreditCode(String creditCode) {
        this.creditCode = creditCode;
    }

    public String getLegalName() {
        return legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public String getBussinessLicenseUrl() {
        return bussinessLicenseUrl;
    }

    public void setBussinessLicenseUrl(String bussinessLicenseUrl) {
        this.bussinessLicenseUrl = bussinessLicenseUrl;
    }

    public String getIdCardFront() {
        return idCardFront;
    }

    public void setIdCardFront(String idCardFront) {
        this.idCardFront = idCardFront;
    }

    public String getIdCardBack() {
        return idCardBack;
    }

    public void setIdCardBack(String idCardBack) {
        this.idCardBack = idCardBack;
    }
}
