/**
 * @(#)UserExceptionCode.java 1.0 2016-11-10
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.exception;

/**
 *
 * @author : 萧玄
 * @Date: 14:01 2020/4/22
 */
public enum BundleExceptionCode implements IExceptionEnum {

    /**
     *
     */
    COMPANY_NOT_ALLOWED_BELONG_TO_DEPARTMENT("B-0001", "不允许在部门下创建公司"),
    EXISTS_CHILDREN_NODE("B-0002", "存在子组织，请先解除关联关系"),
    EXISTS_CHILDREN_EMPLOYEE_OR_POST("B-0003", "存在关联的员工或岗位，请先解除关联关系"),
    POST_CODE_EXISTED("B-0004", "岗位编号不能重复"),
    POST_CODE_CAN_NOT_MODIFY("B-0005", "岗位编号不能修改"),
    POST_ASSIGNMENT_INFO_INTEGRALITY_ERROR("B-0006", "岗位分配参数不完整"),
    ORG_NOT_EXIST("B-0007", "组织不存在"),
    POST_CAN_NOT_REMOVE_AS_EXISTS_EMPLOYEE("B-0008", "岗位已关联员工，请先解除岗位与员工关系"),
    CAN_NOT_CHANGE_ORG("B-0009", "无法变更岗位所属组织，先解除员工和岗位关系"),
    CAN_NOT_BIND_DISABLE_POST("B-0010", "员工不能关联已被禁用的岗位"),
    POST_NOT_BIND_ORG("B-0011", "岗位必须关联组织"),
    MUST_BIND_2_ORG("B-0013", "新增员工必须关联组织"),
    EMPLOYEE_NOT_FOUND("B-0014", "员工不存在"),
    POST_NOT_FOUND("B-0015", "岗位不存在"),
    ;

    private final String code;

    private final String msg;

    private BundleExceptionCode(String val, String info) {
        this.code = val;
        this.msg = info;

    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getMsg() {
        return msg;

    }
}
