package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrganizationPropQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrganizationPropRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 组织属性服务接口
 *
 * @author qiuzhi
 * @since 2020-09-01
 */
@Api(tags = {"用户中心：组织属性服务(v2)"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-user-api-query-IOrganizationPropQueryApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v2/org-prop"
)
public interface IOrganizationPropQueryApi {

    /**
     * 根据id查询组织属性
     *
     * @param id 组织属性id
     * @return 组织属性数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询组织属性", notes = "根据id查询组织属性")
    @Capability(capabilityCode = "user.organization.queryOrganizationPropById")
    RestResponse<OrganizationPropRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 组织属性分页数据
     *
     * @param reqDto   组织属性查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 组织属性分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "组织属性分页数据", notes = "根据filter查询条件查询组织属性数据，filter=OrganizationPropReqDto")
    @Capability(capabilityCode = "user.organization.queryOrganizationPropByPage")
    RestResponse<PageInfo<OrganizationPropRespDto>> queryByPage(@SpringQueryMap OrganizationPropQueryReqDto reqDto,
                                                                @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
