/**
 * @(#)EmployeeDto.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved. YUNXI
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.Set;


/**
 * 员工信息Dto
 * 用于创建,查询,存放员工信息的数据传输对象
 *
 * @author 南枫
 * @since 1.0.0
 * @see com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeAddReqDto
 * @see com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeModifyReqDto
 * @see com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeQueryReqDto
 */
@ApiModel(value = "EmployeeDto", description = "员工信息")
public class EmployeeDto extends BaseDto {
    private static final long serialVersionUID = -7570899923271087283L;

    /**
     * 员工id
     */
    @ApiModelProperty(value = "员工id")
    private Long id;

    /**
     * 员工姓名
     */
    @ApiModelProperty(value = "员工姓名, 选填")
    private String name;

    /**
     * 员工英文名
     */
    @ApiModelProperty(value = "员工英文名, 选填")
    private String nameEn;

    /**
     * 岗位
     */
    @ApiModelProperty(value = "岗位, 选填")
    private String station;

    /**
     * 员工号
     */
    @ApiModelProperty(value = "员工号, 选填")
    private String employeeNo;

    /**
     * 手机号码
     */
    @ApiModelProperty(value = "手机号码, 选填")
    private String phoneNum;

    /**
     * 邮箱号
     */
    @ApiModelProperty(value = "邮箱号, 选填")
    private String email;

    /**
     * 员工状态：1，启用，2禁用
     */
    @ApiModelProperty(value = "员工状态, 1，启用，2禁用, 默认启用")
    private Integer status;

    /**
     * 用户Id
     */
    @ApiModelProperty(value = "用户Id, 选填")
    private Long userId;

    /**
     * 用户
     */
    @ApiModelProperty(value = "用户, 选填")
    private UserDto user;

    /**
     * 组织IdSet
     */
    @ApiModelProperty(value = "组织IdSet, 选填, 修改信息时, 会先解绑原有的员工和组织的关系, 再与orgIdSet的组织做关联")
    private Set<Long> orgIdSet = Sets.newHashSet();

    /**
     * 组织列表
     */
    @ApiModelProperty(value = "组织列表.仅在响应时使用, 请求内容包含的此参数无效")
    private Set<OrganizationDto> organizationSet = Sets.newHashSet();

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称, 选填")
    private String nickName;

    /**
     * 设备ID
     */
    @ApiModelProperty(value = "设备ID, 选填")
    private String deviceId;

    /**
     * 业务编码
     */
    @ApiModelProperty(value = "业务编码, 选填")
    private String busicode;

    /**
     * 注册时间
     */
    @ApiModelProperty(value = "注册时间, 选填")
    private Date registerTime;

    /**
     * 组织ID
     */
    @ApiModelProperty(value = "组织ID, 选填")
    private Long organizationId;

    /**
     * 会员卡ID
     */
    @ApiModelProperty(value = "会员卡ID, 选填")
    private String memberId;

    /**
     * 是否允许同一用户在同一组织下有多个成员对应,默认不允许
     */
    @ApiModelProperty(value = "是否允许同一用户在同一组织下有多个成员对应,默认不允许")
    private boolean allowMultiUnderOrg;


    @ApiModelProperty(value = "备注")
    private String remark;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameEn() {
        return nameEn;
    }

    public void setNameEn(String nameEn) {
        this.nameEn = nameEn;
    }

    public String getStation() {
        return station;
    }

    public void setStation(String station) {
        this.station = station;
    }

    public String getEmployeeNo() {
        return employeeNo;
    }

    public void setEmployeeNo(String employeeNo) {
        this.employeeNo = employeeNo;
    }

    public String getPhoneNum() {
        return phoneNum;
    }

    public void setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public UserDto getUser() {
        return user;
    }

    public void setUser(UserDto user) {
        this.user = user;
    }

    public Set<OrganizationDto> getOrganizationSet() {
        return organizationSet;
    }

    public void setOrganizationSet(Set<OrganizationDto> organizationSet) {
        this.organizationSet = organizationSet;
    }

    public Set<Long> getOrgIdSet() {
        return orgIdSet;
    }

    public void setOrgIdSet(Set<Long> orgIdSet) {
        this.orgIdSet = orgIdSet;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getBusicode() {
        return busicode;
    }

    public void setBusicode(String busicode) {
        this.busicode = busicode;
    }

    public Date getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getMemberId() {
        return memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public boolean isAllowMultiUnderOrg() {
        return allowMultiUnderOrg;
    }

    public EmployeeDto setAllowMultiUnderOrg(boolean allowMultiUnderOrg) {
        this.allowMultiUnderOrg = allowMultiUnderOrg;
        return this;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
