package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author yufan
 * @time 2020/9/27 15:29
 */
@ApiModel(value = "CustomerOrgInfoQueryReqDto", description = "客户组织信息查询dto")
public class CustomerOrgInfoQueryReqDto extends BaseDto {
    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long id;
    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称")
    private String orgName;
    /**
     * 组织编号
     */
    @ApiModelProperty(value = "组织编号")
    private String orgCode;
    /**
     * 机构类型
     */
    @ApiModelProperty(value = "机构类型，默认‘customer’")
    private String orgType = "customer";
    /**
     * 用户Id
     */
    @ApiModelProperty(value = "管理员账号id")
    private Long userId;

    @ApiModelProperty(name = "idList", value = "id列表")
    private List<Long> idList;

    @ApiModelProperty(name = "idList", value = "管理员账号id列表")
    private List<Long> userIdList;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgType() {
        return orgType;
    }

    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public List<Long> getIdList() {
        return idList;
    }

    public void setIdList(List<Long> idList) {
        this.idList = idList;
    }

    public List<Long> getUserIdList() {
        return userIdList;
    }

    public void setUserIdList(List<Long> userIdList) {
        this.userIdList = userIdList;
    }
}
