package com.dtyunxi.yundt.cube.center.user.api.dto.response;

import com.dtyunxi.cube.utils.tree.ITreeNode;
import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import static com.dtyunxi.yundt.cube.center.user.api.constants.OrgUserConstants.ORG_ROOT_ID;

/**
 * 高级用户组织功能包的查询组织的业务单元树请求dto
 *
 * @author shuangqing
 */
@ApiModel(value = "OrgAdvTreeRespDto", description = "查询组织的业务单元树请求dto")
public class OrgAdvTreeRespDto extends BaseDto implements ITreeNode<OrgAdvTreeRespDto> {

    /**
     * 组织单元id
     */
    @ApiModelProperty(value = "组织单元id")
    private Long id;

    /**
     * 组织单元编号
     */
    @ApiModelProperty(value = "组织单元编号")
    private String code;

    /**
     * 组织类型
     */
    @ApiModelProperty(value = "用户组织功能包需求 0：公司 1：部门 2：业务组织单元 3：虚拟组织单元")
    private String type;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织单元名称")
    private String name;

    /**
     * 父级编码(保存当前组织单元的上级组织单元编码)
     */
    @ApiModelProperty(value = "父级ID(保存当前组织单元的上级组织单元ID)")
    private Long parentId;

    /**
     * 公司组织机构码
     */
    @ApiModelProperty(value = "公司组织机构码")
    private String companyOrgCode;

    /**
     * 公司组织机构名称
     */
    @ApiModelProperty(value = "公司组织机构名称")
    private String companyOrgName;


    /**
     * 状态(0禁用,1启用)
     */
    @ApiModelProperty(value = "状态(0禁用,1启用)")
    private String status;

    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号")
    private Integer sortNO;

    /**
     * 子业务单元列表
     */
    @ApiModelProperty(value = "子业务单元列表")
    private List<OrgAdvTreeRespDto> children;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public List<OrgAdvTreeRespDto> getChildren() {
        return children;
    }

    @Override
    public void setChildren(List<OrgAdvTreeRespDto> children) {
        this.children = children;
    }

    @Override
    public String getKey() {
        return this.getId().toString();
    }

    @Override
    public String getParentKey() {
        return this.getParentId().toString();
    }

    @Override
    public Boolean isRootNode() {
        return ORG_ROOT_ID.equals(this.getParentId());
    }

    @Override
    public void addChild(OrgAdvTreeRespDto iTreeNode) {
        children.add(iTreeNode);
    }


    public Integer getSortNO() {
        return sortNO;
    }

    public void setSortNO(Integer sortNO) {
        this.sortNO = sortNO;
    }

    public String getCompanyOrgCode() {
        return companyOrgCode;
    }

    public void setCompanyOrgCode(String companyOrgCode) {
        this.companyOrgCode = companyOrgCode;
    }

    public String getCompanyOrgName() {
        return companyOrgName;
    }

    public void setCompanyOrgName(String companyOrgName) {
        this.companyOrgName = companyOrgName;
    }
}
