/**
 * @(#) IPersonalInfoQueryApi.java 1.0 2019/1/18
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationTreeDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrganizationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.BizOrganizationRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 组织结构服务
 * create By shenfei on 2019/7/3
 */
@Api(tags = {"用户中心：组织结构服务拓展(v1)"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-user-api-query-IBizOrganizationQueryApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v1/organization"
)
public interface IBizOrganizationQueryApi {

    /**
     * 查询组织结构树
     *
     * @param instanceId 实例ID
     * @param userId     用户ID
     * @return
     */
    @GetMapping(value = {"/{instanceId}/organization/tree/{userId}"}, produces = "application/json")
    @ApiOperation(value = "获取个人组织机构树", notes = "获取个人组织机构树")
    @Capability(capabilityCode = "user.biz-organization.get-organization-tree")
    RestResponse<List<OrganizationTreeDto>> getOrganizationTree(@PathVariable("instanceId") Long instanceId, @PathVariable("userId") Long userId);

    /**
     * 根据id批量获取组织信息
     *
     * @param orgNos 组织id列表
     * @return
     */
    @PostMapping(value = {"/getByNos"}, produces = "application/json")
    @ApiOperation(value = "根据编号批量获取组织信息", notes = "根据编号批量获取组织信息")
    @Capability(capabilityCode = "user.biz-organization.get-organizations")
    RestResponse<List<OrganizationDto>> getOrganizations(@RequestBody List<String> orgNos);

    /**
     * 根据id批量获取组织信息
     *
     * @param ids 组织id列表
     * @return
     */
    @Deprecated
    @PostMapping(value = {"/getByIds"}, produces = "application/json")
    @ApiOperation(value = "根据id批量获取组织信息（废弃）", notes = "根据id批量获取组织信息（废弃）")
    @Capability(capabilityCode = "user.biz-organization.get-organizations-by-ids")
    RestResponse<List<OrganizationDto>> getOrganizationsByIds(@RequestBody List<Long> ids);

    @GetMapping(value = {"/tree/{instanceId}"}, produces = "application/json")
    @ApiOperation(value = "获取组织", notes = "获取组织")
    @Capability(capabilityCode = "user.biz-organization.get-org")
    RestResponse<List<OrganizationDto>> getOrg(@PathVariable("instanceId") Long instanceId, @RequestParam(value = "parentId", required = false) Long parentId);

    /**
     * 根据shopId获取店铺信息
     *
     * @param shopId 店铺id
     * @return 店铺信息
     */
    @GetMapping(value = "/shopId/{shopId}", produces = "application/json")
    @ApiOperation(value = "根据shopId获取店铺信息", notes = "根据shopId获取店铺信息 ")
    @Capability(capabilityCode = "user.biz-organization.get-organization-by-shop-id")
    RestResponse<OrganizationDto> getOrganizationByShopId(@PathVariable("shopId") String shopId);

    /**
     * 根据shopIds批量获取店铺信息
     *
     * @param shopIds
     * @return
     */
    @GetMapping(value = "/getOrganizationByShopIds", produces = "application/json")
    @ApiOperation(value = "根据shopIds批量获取店铺信息", notes = "根据shopIds批量获取店铺信息 ")
    @Capability(capabilityCode = "user.biz-organization.get-organization-by-shop-ids")
    RestResponse<List<OrganizationDto>> getOrganizationByShopIds(@RequestParam("shopIds") List<String> shopIds);

    /**
     * 根据店铺编码列表获取店铺信息
     *
     * @param codeList 店铺编码列表
     * @return 店铺信息列表
     */
    @GetMapping(value = "/code", produces = "application/json")
    @ApiOperation(value = "根据店铺编码列表获取店铺信息", notes = "根据店铺编码列表获取店铺信息 ")
    @Capability(capabilityCode = "user.biz-organization.query-info-by-code-list")
    RestResponse<List<OrganizationDto>> queryInfoByCodeList(@RequestParam("codeList") List<String> codeList);

    /**
     * 根据updateTime获取店铺信息
     *
     * @param instanceId 实例id
     * @param updateTime 更新时间
     * @return 店铺信息
     */
    @GetMapping(value = "/instanceId/{instanceId}/updateTime/{updateTime}", produces = "application/json")
    @ApiOperation(value = "根据shopId获取店铺信息", notes = "根据shopId获取店铺信息")
    @Capability(capabilityCode = "user.biz-organization.list-organization-by-update-time")
    RestResponse<List<OrganizationDto>> listOrganizationByUpdateTime(@PathVariable("instanceId") Long instanceId, @PathVariable("updateTime") String updateTime);


    @GetMapping(value = "/query/page", produces = "application/json")
    @ApiOperation(value = "根据条件分页查询店铺列表信息", notes = "根据shopId获取店铺信息")
    @Capability(capabilityCode = "user.biz-organization.query-page-by-condition")
    RestResponse<PageInfo<OrganizationDto>> queryPageByCondition(@SpringQueryMap OrganizationReqDto reqDto,
                                                                 @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                 @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 分页查询组织机构信息
     *
     * @param filter
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping(value = "/page")
    @ApiOperation(value = "分页查询组织机构信息", notes = "分页查询组织机构信息")
    @ApiImplicitParams({@ApiImplicitParam(name = "filter", value = "查询条件json字符串,例如 {name:\"App1\"}", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    @Capability(capabilityCode = "user.biz-organization.query-biz-organization-by-page")
    RestResponse<PageInfo<BizOrganizationRespDto>> queryBizOrganizationByPage(@RequestParam("filter") String filter, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);
}
