/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service;

import com.dtyunxi.cube.framework.das.ComBaseDas;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.user.biz.utils.SqlFilterBuilder;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IDataCollectionAndBind<KEY, TARGET, SOURCE_EO, TARGET_EO extends BaseEo> {
    public static final Logger LOGGER = LoggerFactory.getLogger(IDataCollectionAndBind.class);

    public List<SOURCE_EO> search();

    public List<TARGET> collect(List<SOURCE_EO> var1, Map<KEY, List<TARGET>> var2);

    public KEY getKey(TARGET_EO var1);

    public void bind(TARGET var1, TARGET_EO var2);

    default public <P, DAS extends ComBaseDas<TARGET_EO, P>> List<TARGET> process(TARGET_EO selectParam, String key, DAS das) {
        List<SOURCE_EO> sources = this.search();
        if (CollectionUtils.isEmpty(sources)) {
            LOGGER.info("\u6570\u636e\u6e90\u4e3a\u7a7a\uff1a{}", (Object)key);
            return Collections.EMPTY_LIST;
        }
        HashMap map = Maps.newHashMap();
        List<TARGET> list = this.collect(sources, map);
        if (CollectionUtils.isNotEmpty(map.keySet())) {
            selectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter(key, map.keySet()).get());
            List sourceList = das.select(selectParam);
            if (CollectionUtils.isNotEmpty((Collection)sourceList)) {
                sourceList.forEach(eo -> {
                    List targets = (List)map.get(this.getKey(eo));
                    if (CollectionUtils.isNotEmpty((Collection)targets)) {
                        targets.forEach(target -> this.bind(target, eo));
                    }
                });
            }
        }
        return list;
    }
}

