/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.constants.RedisKeyConstants;
import com.dtyunxi.yundt.cube.center.user.api.dto.EmployeeDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.EmployeeOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.PersonalInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeOrgRelationBatchUpdateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.IExceptionEnum;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrgGroupService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.Collection2SqlInConditionUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.user.biz.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.user.conf.ext.IAddEmployeeValidationExt;
import com.dtyunxi.yundt.cube.center.user.conf.ext.IEmployeeChangeOrgExt;
import com.dtyunxi.yundt.cube.center.user.conf.vo.OrgEmployeeVo;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeOrgDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.PersonalInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.PersonalInfoEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdEmployeeEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdEmployeeOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdOrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Deprecated
@Service
public class EmployeeServiceImpl
implements IEmployeeService {
    private static final Logger logger = LoggerFactory.getLogger(EmployeeServiceImpl.class);
    @Resource
    private EmployeeDas employeeDas;
    @Resource
    private OrganizationDas organizationDas;
    @Resource
    private EmployeeOrgDas employeeOrganizationRelationDas;
    @Resource
    private UserDas userDas;
    @Resource
    private PersonalInfoDas personalInfoDas;
    @Resource
    private IUserService userService;
    @Resource
    private IContext iContext;
    @Resource
    private IEmployeeChangeOrgExt employeeChangeOrgExt;
    @Resource
    private IAddEmployeeValidationExt addEmployeeValidationExt;
    @Resource
    private IOrgGroupService orgGroupService;
    @Resource
    private ICacheService cacheService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(EmployeeDto employeeDto) {
        this.addEmployeeValidationExt.execute(employeeDto);
        EmployeeEo employeeEo = new EmployeeEo();
        DtoHelper.dto2Eo((BaseVo)employeeDto, (BaseEo)employeeEo, (String[])new String[]{"orgIdSet", "user"});
        if (employeeDto.getUser() != null) {
            UserEo userEo;
            UserDto userDto = employeeDto.getUser();
            if (userDto.getId() != null) {
                List existEmployees;
                userEo = (UserEo)this.userDas.selectByPrimaryKey(userDto.getId());
                if (userEo == null) {
                    throw new BizException(UserExceptionCode.USER_IDCHECK_FAIL.getCode(), "\u627e\u4e0d\u5230\u5bf9\u5e94\u8bb0\u5f55,user.id:" + userDto.getId());
                }
                if (!employeeDto.isAllowMultiUnderOrg() && CollectionUtils.isNotEmpty((Collection)(existEmployees = this.employeeDas.findByUserId(userEo.getId())))) {
                    return ((EmployeeEo)existEmployees.get(0)).getId();
                }
            } else {
                userEo = this.userService.addUser(employeeDto.getInstanceId(), userDto);
            }
            employeeEo.setUserId(userEo.getId());
        }
        this.checkEmployeeNoUnique(employeeEo);
        this.employeeDas.insert((BaseEo)employeeEo);
        this.addEmployeeOrganizationRelation(employeeEo.getId(), employeeDto);
        return employeeEo.getId();
    }

    private void checkEmployeeNoUnique(EmployeeEo employeeEo) {
        if (StringUtils.isNotBlank((CharSequence)employeeEo.getEmployeeNo())) {
            Assert.notNull((Object)employeeEo.getInstanceId(), (String)"\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a");
            EmployeeEo select = new EmployeeEo();
            select.setEmployeeNo(employeeEo.getEmployeeNo());
            select.setInstanceId(employeeEo.getInstanceId());
            List employeeEoList = this.employeeDas.select((BaseEo)select);
            if (CollectionUtils.isNotEmpty((Collection)employeeEoList)) {
                throw new BizException(UserExceptionCode.EMPLOYEE_NO_EXIST_FAIL.getCode(), UserExceptionCode.EMPLOYEE_NO_EXIST_FAIL.getMsg());
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    protected List<EmployeeOrgEo> addEmployeeOrganizationRelation(Long employeeId, EmployeeDto employeeDto) {
        EmployeeOrgEo deleteOldParam = new EmployeeOrgEo();
        deleteOldParam.setEmployeeId(employeeId);
        this.employeeOrganizationRelationDas.delete((BaseEo)deleteOldParam);
        Set orgIdSet = employeeDto.getOrgIdSet();
        ArrayList<EmployeeOrgEo> results = new ArrayList<EmployeeOrgEo>();
        if (CollectionUtils.isNotEmpty((Collection)orgIdSet)) {
            OrganizationEo organizationSelectParam = new OrganizationEo();
            organizationSelectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("id", orgIdSet).get());
            List organizationEoList = this.organizationDas.select((BaseEo)organizationSelectParam);
            if (CollectionUtils.isNotEmpty((Collection)organizationEoList)) {
                Long orgGroupId = this.orgGroupService.queryDefaultHumanOrgGroup(employeeDto.getTenantId());
                if (orgGroupId == null) {
                    throw new BizException("500", "orgGroupId\u4e0d\u80fd\u4e3a\u7a7a");
                }
                results.addAll(organizationEoList.stream().map(organizationEo -> {
                    EmployeeOrgEo employeeOrganizationRelationEo = new EmployeeOrgEo();
                    employeeOrganizationRelationEo.setEmployeeId(employeeId);
                    employeeOrganizationRelationEo.setExtension("");
                    employeeOrganizationRelationEo.setOrgGroupId(orgGroupId);
                    employeeOrganizationRelationEo.setOrganizationId(organizationEo.getId());
                    employeeOrganizationRelationEo.setInstanceId(employeeDto.getInstanceId());
                    employeeOrganizationRelationEo.setTenantId(employeeDto.getTenantId());
                    return employeeOrganizationRelationEo;
                }).collect(Collectors.toList()));
                if (CollectionUtils.isNotEmpty(results)) {
                    this.employeeOrganizationRelationDas.insertBatch(results);
                }
            }
        }
        String key = RedisKeyConstants.combineKey((String)"findByEmployeeId", (Object[])new Object[]{employeeId});
        this.cacheService.setCache(key, (Object)JSONObject.toJSONString(results));
        return results;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long modify(Long oldOrganizationId, EmployeeDto employeeDto) {
        AssertUtil.isTrue((employeeDto.getId() != null ? 1 : 0) != 0, (String)"employeeDto\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        EmployeeEo employeeEo = (EmployeeEo)this.employeeDas.selectByPrimaryKey(employeeDto.getId());
        AssertUtil.isTrue((employeeEo != null ? 1 : 0) != 0, (String)UserExceptionCode.EMPLOYEE__IDCHECK_FAIL.getCode(), (String)UserExceptionCode.EMPLOYEE__IDCHECK_FAIL.getMsg(), (Object[])new Object[0]);
        this.deleteEmployeeOrganizationRelation(employeeDto.getId());
        DtoHelper.dto2Eo((BaseVo)employeeDto, (BaseEo)employeeEo, (String[])new String[]{"user", "orgIdSet", "organizationSet"});
        this.employeeDas.update((BaseEo)employeeEo);
        this.addEmployeeOrganizationRelation(employeeEo.getId(), employeeDto);
        return employeeEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyEmployee(EmployeeDto employeeDto) {
        EmployeeEo employeeEo = (EmployeeEo)this.employeeDas.selectByPrimaryKey(employeeDto.getId());
        AssertUtil.isTrue((employeeEo != null ? 1 : 0) != 0, (String)UserExceptionCode.EMPLOYEE__IDCHECK_FAIL.getCode(), (String)UserExceptionCode.EMPLOYEE__IDCHECK_FAIL.getMsg(), (Object[])new Object[0]);
        DtoHelper.dto2Eo((BaseVo)employeeDto, (BaseEo)employeeEo);
        this.employeeDas.updateSelective((BaseEo)employeeEo);
        this.addEmployeeOrganizationRelation(employeeEo.getId(), employeeDto);
    }

    private void deleteEmployeeOrganizationRelation(Long employeeId) {
        List employeeOrganizationRelations = this.employeeOrganizationRelationDas.findByEmployeeId(employeeId);
        if (CollectionUtils.isNotEmpty((Collection)employeeOrganizationRelations)) {
            employeeOrganizationRelations.forEach(relation -> this.employeeOrganizationRelationDas.deleteById(relation.getId()));
        }
    }

    @Override
    public PageInfo<EmployeeDto> queryPage(Long organizationId, EmployeeQueryReqDto employeeDtoFilter, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.employeeDas.queryPage(organizationId, employeeDtoFilter);
        if (employeeDtoFilter.getReturnWithUser().booleanValue()) {
            this.addUserDto(list);
        }
        if (employeeDtoFilter.getReturnWithOrgIds().booleanValue()) {
            for (EmployeeDto employeeDto : list) {
                Set<Long> orgIdSet = this.queryOrgIds(employeeDto.getId(), employeeDto.getUserId());
                employeeDto.setOrgIdSet(orgIdSet);
            }
        }
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    private Set<Long> queryOrgIds(Long employeeId, Long userId) {
        Set orgIdSet;
        List eoList;
        List relations = this.employeeOrganizationRelationDas.findByEmployeeId(employeeId);
        if (CollectionUtils.isNotEmpty((Collection)relations) && CollectionUtils.isNotEmpty((Collection)(eoList = this.organizationDas.findByIds(new ArrayList(orgIdSet = relations.stream().map(StdEmployeeOrgEo::getOrganizationId).collect(Collectors.toSet())))))) {
            return eoList.stream().map(StdOrganizationEo::getId).collect(Collectors.toSet());
        }
        return new HashSet<Long>();
    }

    @Override
    public PageInfo<EmployeeDto> queryPage(Long organizationId, String filter, String[] userTypes, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        EmployeeDto employeeDto = (EmployeeDto)QueryUtil.validateExampleAndReturn((String)filter, EmployeeDto.class);
        List list = this.employeeDas.queryPage(organizationId, employeeDto, userTypes);
        this.addUserDto(list);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    @Override
    public PageInfo<EmployeeDto> queryPageByActiveUser(String filter, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        EmployeeDto employeeDto = (EmployeeDto)QueryUtil.validateExampleAndReturn((String)filter, EmployeeDto.class);
        List list = this.employeeDas.findByActiveUser(employeeDto);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    private void addUserDto(List<EmployeeDto> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(employeeDto -> this.employeeAddUserDto((EmployeeDto)employeeDto));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public EmployeeDto detail(Long id) {
        EmployeeEo employeeEo = (EmployeeEo)this.employeeDas.selectByPrimaryKey(id);
        if (employeeEo == null) {
            logger.info("\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\uff0c\u901a\u8fc7id\u67e5\u627e\u5458\u5de5\u4fe1\u606f\u5f02\u5e38" + id);
            throw new BizException(UserExceptionCode.EMPLOYEE__IDCHECK_FAIL.getCode(), UserExceptionCode.EMPLOYEE__IDCHECK_FAIL.getMsg());
        }
        List organizationEos = this.organizationDas.findByEmployeeId(employeeEo.getId());
        HashSet organizationDtos = new HashSet();
        DtoHelper.eoList2DtoList((Collection)organizationEos, organizationDtos, OrganizationDto.class);
        EmployeeDto employeeDto = new EmployeeDto();
        DtoHelper.eo2Dto((BaseEo)employeeEo, (BaseVo)employeeDto);
        employeeDto.setOrganizationSet(organizationDtos);
        this.employeeAddUserDto(employeeDto);
        return employeeDto;
    }

    private void employeeAddUserDto(EmployeeDto employeeDto) {
        if (employeeDto.getUserId() != null) {
            UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(employeeDto.getUserId());
            UserDto userDto = new UserDto();
            DtoHelper.eo2Dto((BaseEo)userEo, (BaseVo)userDto);
            if (userEo != null && userEo.getPersonId() != null) {
                PersonalInfoEo personalInfoEo = (PersonalInfoEo)this.personalInfoDas.selectByPrimaryKey(userEo.getPersonId());
                PersonalInfoDto personalInfoDto = new PersonalInfoDto();
                DtoHelper.eo2Dto((BaseEo)personalInfoEo, (BaseVo)personalInfoDto);
                userDto.setPersonalInfo(personalInfoDto);
            }
            employeeDto.setUser(userDto);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long remove(Long organizationId, Long id) {
        EmployeeEo employeeEo = (EmployeeEo)this.employeeDas.selectByPrimaryKey(id);
        if (employeeEo == null) {
            logger.info("\u5220\u9664\u5458\u5de5\u4fe1\u606f\uff0c\u901a\u8fc7id\u67e5\u627e\u5458\u5de5\u4fe1\u606f\u5f02\u5e38" + id);
            throw new BizException(UserExceptionCode.EMPLOYEE__IDCHECK_FAIL.getCode(), UserExceptionCode.EMPLOYEE__IDCHECK_FAIL.getMsg());
        }
        this.deleteEmployeeOrganizationRelation(id);
        this.employeeDas.logicDeleteById(id);
        return id;
    }

    @Override
    public List<EmployeeDto> queryByUserId(Long userId) {
        List employeeList = this.employeeDas.findByUserId(userId);
        ArrayList employeeDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)employeeList, (Collection)employeeDtoList, EmployeeDto.class);
        employeeDtoList.forEach(employeeDto -> {
            List organizationEos = this.organizationDas.findByEmployeeId(employeeDto.getId());
            HashSet organizationDtoSet = Sets.newHashSet();
            DtoHelper.eoList2DtoList((Collection)organizationEos, (Collection)organizationDtoSet, OrganizationDto.class);
            employeeDto.setOrganizationSet((Set)organizationDtoSet);
        });
        return employeeDtoList;
    }

    @Override
    public List<EmployeeDto> queryByUserIdList(String userIds) {
        String[] idAy = userIds.split(",");
        AssertUtil.isTrue((idAy.length <= 1000 ? 1 : 0) != 0, (String)"ID \u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc71000");
        HashSet idSet = Sets.newHashSet();
        for (String id : idAy) {
            idSet.add(Long.valueOf(id));
        }
        List eoList = this.employeeDas.findByUserIdList((Set)idSet);
        ArrayList dtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eoList, (Collection)dtoList, EmployeeDto.class);
        return dtoList;
    }

    @Override
    public void modifyStatus(Long employeeId, Integer status) {
        EmployeeEo employeeEo = (EmployeeEo)this.employeeDas.selectByPrimaryKey(employeeId);
        if (employeeEo == null) {
            throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), UserExceptionCode.NON_EXIST_FAIL.getMsg());
        }
        employeeEo.setStatus(status);
        if (employeeEo.getUserId() != null) {
            UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(employeeEo.getUserId());
            userEo.setStatus(status);
            this.userDas.updateSelective((BaseEo)userEo);
        }
        this.employeeDas.updateSelective((BaseEo)employeeEo);
    }

    @Override
    public void deleteEmployee(Long employeeId) {
        this.employeeDas.logicDeleteById(employeeId);
        EmployeeOrgEo relationEo = new EmployeeOrgEo();
        relationEo.setEmployeeId(employeeId);
        this.employeeOrganizationRelationDas.delete((BaseEo)relationEo);
    }

    @Override
    public Long addEmployeeOrgRelation(EmployeeOrgRelationReqDto employeeOrgRelationReqDto) {
        EmployeeOrgEo relationEo = this.queryRelation(employeeOrgRelationReqDto.getEmployeeId(), employeeOrgRelationReqDto.getOrgId());
        if (relationEo != null) {
            return relationEo.getId();
        }
        EmployeeDto employeeDto = new EmployeeDto();
        HashSet<Long> orgIdSet = new HashSet<Long>();
        orgIdSet.add(employeeOrgRelationReqDto.getOrgId());
        employeeDto.setOrgIdSet(orgIdSet);
        employeeDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        employeeDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        List<EmployeeOrgEo> relationEos = this.addEmployeeOrganizationRelation(employeeOrgRelationReqDto.getEmployeeId(), employeeDto);
        if (CollectionUtils.isNotEmpty(relationEos)) {
            return relationEos.get(0).getId();
        }
        throw new BizException("\u6dfb\u52a0\u5458\u5de5-\u7ec4\u7ec7\u5173\u7cfb\u5931\u8d25, db\u64cd\u4f5c\u8fd4\u56de\u8bb0\u5f55\u4e3a\u7a7a");
    }

    @Override
    public EmployeeOrgEo queryRelation(Long employeeId, Long orgId) {
        EmployeeOrgEo criteria = new EmployeeOrgEo();
        criteria.setEmployeeId(employeeId);
        criteria.setOrganizationId(orgId);
        PageInfo relationEos = this.employeeOrganizationRelationDas.selectPage((BaseEo)criteria, Integer.valueOf(1), Integer.valueOf(2));
        if (relationEos != null && CollectionUtils.isNotEmpty((Collection)relationEos.getList())) {
            return (EmployeeOrgEo)relationEos.getList().get(0);
        }
        return null;
    }

    @Override
    public Long removeEmployeeOrgRelation(EmployeeOrgRelationReqDto employeeOrgRelationReqDto) {
        EmployeeOrgEo relationEo = this.queryRelation(employeeOrgRelationReqDto.getEmployeeId(), employeeOrgRelationReqDto.getOrgId());
        Long id = null;
        if (relationEo != null) {
            EmployeeOrgEo deleteCriteria = new EmployeeOrgEo();
            deleteCriteria.setId(relationEo.getId());
            deleteCriteria.setUserId(relationEo.getUserId());
            deleteCriteria.setPersonId(relationEo.getPersonId());
            this.employeeOrganizationRelationDas.logicDelete((BaseEo)deleteCriteria);
            id = relationEo.getId();
        }
        this.employeeChangeOrgExt.execute(new OrgEmployeeVo(employeeOrgRelationReqDto.getOrgId(), new Long[]{employeeOrgRelationReqDto.getEmployeeId()}));
        return id;
    }

    @Override
    public void relateEmployeeUser(Long employeeId, Long userId) {
        UserEo queryEo;
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        EmployeeEo employeeEo = (EmployeeEo)this.employeeDas.selectByPrimaryKey(employeeId);
        if (!userEo.getTenantId().equals(employeeEo.getTenantId())) {
            throw new BizException("\u89d2\u8272\u4e0e\u7528\u6237\u4e0d\u5728\u540c\u4e00\u79df\u6237\u4e0b");
        }
        if (null != employeeEo.getUserId() && (queryEo = (UserEo)this.userDas.selectByPrimaryKey(employeeEo.getUserId())) != null) {
            throw new BizException("\u8be5\u5458\u5de5\u5df2\u5173\u8054\u8d26\u53f7, \u8bf7\u5148\u89e3\u9664\u5173\u8054");
        }
        employeeEo.setUserId(userId);
        this.employeeDas.updateSelective((BaseEo)employeeEo);
    }

    @Override
    public void removeEmployeeUserRelation(Long employeeId) {
        EmployeeEo employeeEo = (EmployeeEo)this.employeeDas.selectByPrimaryKey(employeeId);
        Long userId = employeeEo.getUserId();
        if (null == userId) {
            throw new BizException("\u8be5\u5458\u5de5\u5c1a\u672a\u5173\u8054\u8d26\u53f7");
        }
        employeeEo.setUserId(null);
        this.employeeDas.update((BaseEo)employeeEo);
        String key = RedisKeyConstants.combineKey((String)"findByUserId", (Object[])new Object[]{userId});
        this.cacheService.delCache(key);
    }

    @Override
    public PageInfo<UserRespDto> queryNotRelateEmployeeUsers(String userName, Integer pageNum, Integer pageSize) {
        EmployeeEo employeeEo = new EmployeeEo();
        employeeEo.setTenantId(this.iContext.tenantId());
        List employeeEoList = this.employeeDas.select((BaseEo)employeeEo).stream().filter(related -> related.getUserId() != null).collect(Collectors.toList());
        List userIdList = null;
        if (CollectionUtils.isNotEmpty(employeeEoList)) {
            userIdList = employeeEoList.stream().map(StdEmployeeEo::getUserId).collect(Collectors.toList());
        }
        UserEo userEo = new UserEo();
        userEo.setTenantId(this.iContext.tenantId());
        if (StrUtil.isNotBlank((CharSequence)userName)) {
            userEo.setUserName(userName);
        }
        if (CollectionUtils.isEmpty(userIdList)) {
            PageInfo eoPageInfo = this.userDas.selectPage((BaseEo)userEo, pageNum, pageSize);
            return QueryUtil.eoPage2DtoPage((PageInfo)eoPageInfo, UserRespDto.class);
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List eoList = this.userDas.selectListNotInIdsAndUserInfo(userEo, userIdList);
        PageInfo eoPageInfo = new PageInfo(eoList);
        return QueryUtil.eoPage2DtoPage((PageInfo)eoPageInfo, UserRespDto.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reBindRelation(Long organizationId, EmployeeOrgRelationBatchUpdateReqDto employeeOrgRelationReqDto) {
        AssertUtil.isTrue((this.organizationDas.selectByPrimaryKey(organizationId) != null ? 1 : 0) != 0, (IExceptionEnum)UserExceptionCode.ORGANIZATION__IDCHECK_FAIL);
        List employeeIds = employeeOrgRelationReqDto.getEmployeeIds();
        EmployeeEo existedParam = new EmployeeEo();
        ArrayList<SqlFilter> existedSqlFilters = new ArrayList<SqlFilter>();
        SqlFilter existedSqlFilter = new SqlFilter();
        existedSqlFilter.setValue((Object)Collection2SqlInConditionUtil.transefer((Collection)employeeIds, Long.class));
        existedSqlFilter.setOperator(SqlFilter.Operator.in);
        existedSqlFilter.setProperty("id");
        existedSqlFilters.add(existedSqlFilter);
        existedParam.setSqlFilters(existedSqlFilters);
        List existList = this.employeeDas.select(existedParam, new String[]{"id"});
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)existList), (IExceptionEnum)UserExceptionCode.EMPLOYEE__IDCHECK_FAIL);
        Long orgGroupId = this.orgGroupService.queryDefaultHumanOrgGroup(employeeOrgRelationReqDto.getTenantId());
        if (orgGroupId == null) {
            throw new BizException("500", "orgGroupId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List relationEoList = existList.stream().map(employeeEo -> {
            EmployeeOrgEo employeeOrganizationRelationEo = new EmployeeOrgEo();
            employeeOrganizationRelationEo.setInstanceId(employeeOrgRelationReqDto.getInstanceId());
            employeeOrganizationRelationEo.setTenantId(employeeOrgRelationReqDto.getTenantId());
            employeeOrganizationRelationEo.setOrganizationId(organizationId);
            employeeOrganizationRelationEo.setEmployeeId(employeeEo.getId());
            employeeOrganizationRelationEo.setOrgGroupId(orgGroupId);
            return employeeOrganizationRelationEo;
        }).collect(Collectors.toList());
        EmployeeOrgEo deleteParam = new EmployeeOrgEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        SqlFilter sqlFilter = new SqlFilter();
        sqlFilter.setValue((Object)organizationId);
        sqlFilter.setOperator(SqlFilter.Operator.eq);
        sqlFilter.setProperty("organizationId");
        sqlFilters.add(sqlFilter);
        deleteParam.setSqlFilters(sqlFilters);
        this.employeeOrganizationRelationDas.delete((BaseEo)deleteParam);
        this.employeeOrganizationRelationDas.insertBatch(relationEoList);
    }
}

