/*
 Navicat Premium Data Transfer

 Source Server         : mpc_test.33.12
 Source Server Type    : MySQL
 Source Server Version : 50725
 Source Host           : 192.168.33.12:8906
 Source Schema         : cube_test_user

 Target Server Type    : MySQL
 Target Server Version : 50725
 File Encoding         : 65001

 Date: 07/01/2021 20:04:39
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for us_customer
-- ----------------------------

CREATE TABLE IF NOT EXISTS `us_customer`  (
  `id` bigint(20) NOT NULL  COMMENT '主键ID',
  `business_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务识别码, 在租户下唯一，值为客户信息在业务方的唯一标识，如主键',
  `nick_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户昵称',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户的真实姓名',
  `phone` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户手机号码',
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户邮箱',
  `company` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户所在的企业名称',
  `qq` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户QQ号',
  `weixin` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户微信号',
  `province_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户所在省编号',
  `city_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户所在市编号',
  `district_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户所在区编号',
  `street_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户所在街道编号',
  `postcode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户所在地邮政编码',
  `province` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户所在省名称',
  `city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户所在市名称',
  `district` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户所在区名称',
  `address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户所在地址',
  `type` tinyint(4) NULL DEFAULT NULL COMMENT '客户类型，1:潜在客户  2:目标客户 3:现实客户 4:流失客户',
  `tag` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户标签，多个标签用逗号隔开，如：理智型，教师',
  `status` tinyint(4) NOT NULL DEFAULT 1 COMMENT '客户状态， 1:有效 0:失效',
  `device` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户所用设备',
  `device_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户所用设备ID',
  `user_id` bigint(20) NULL DEFAULT NULL COMMENT '客户转化为注册用户时对应的用户ID',
  `member_id` bigint(20) NULL DEFAULT NULL COMMENT '客户转化为会员时对应的会员ID',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '客户表(不再使用)' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for us_employee
-- ----------------------------

CREATE TABLE IF NOT EXISTS `us_employee`  (
  `id` bigint(20) NOT NULL ,
  `employee_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '工号',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '姓名',
  `name_en` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '英文名',
  `phone_num` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手机号',
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮箱',
  `station` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '岗位 (应该放到人员-部门关系)',
  `status` tinyint(2) NULL DEFAULT 0 COMMENT '状态:1启用,2禁用',
  `remark` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '备注',
  `device_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备ID',
  `busicode` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务唯一编码',
  `register_time` datetime(0) NULL DEFAULT NULL COMMENT '注册时间',
  `organization_id` bigint(20) NULL DEFAULT NULL COMMENT '组织ID',
  `member_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '会员卡ID(imk一个不合理设置遗留,不推荐关联)',
  `nick_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '昵称',
  `user_id` bigint(20) NULL DEFAULT NULL COMMENT '关联账号',
  `person_id` bigint(20) NULL DEFAULT NULL COMMENT '关联个人',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_user_id`(`user_id`) USING BTREE,
  INDEX `idx_busicode`(`organization_id`, `busicode`) USING BTREE,
  INDEX `idx_employee_user_id`(`user_id`) USING BTREE,
  INDEX `migrate_instance_id`(`instance_id`) USING BTREE,
  INDEX `idx_employee_no`(`employee_no`) USING BTREE,
  INDEX `idx_name`(`name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '员工信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for us_org_group
-- ----------------------------

CREATE TABLE IF NOT EXISTS `us_org_group`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '组织机构编码',
  `name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `func_type_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '职能类型编码',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展值',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `create_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '修改人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '最后一次修改时间',
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '组织分类' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for us_org_prop_option
-- ----------------------------

CREATE TABLE IF NOT EXISTS `us_org_prop_option`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `prop_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '组织单元属性id',
  `value` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '值',
  `sort` tinyint(4) NOT NULL DEFAULT 0 COMMENT '序号',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展值',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `create_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '修改人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '最后一次修改时间',
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '属性选项' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for us_org_prop_value
-- ----------------------------

CREATE TABLE IF NOT EXISTS `us_org_prop_value`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `org_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '组织单元id',
  `func_type_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '组织职能类型编码',
  `prop_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '组织单元属性id',
  `value` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '值',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展值',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `create_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '修改人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '最后一次修改时间',
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '组织单元属性值' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for us_organization
-- ----------------------------

CREATE TABLE IF NOT EXISTS `us_organization`  (
  `id` bigint(20) NOT NULL ,
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织代码',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织名称',
  `name_i1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织名称1',
  `name_i2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织名称2',
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织的描述说明',
  `type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织类型[开放应用自定义(2020-04-22 用户组织功能包需求-产品中心的定义 0：公司 1：部门)]',
  `parent_id` bigint(20) NULL DEFAULT NULL COMMENT '上级id',
  `status` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '1' COMMENT '状态(0禁用,1启用)',
  `remark` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '备注',
  `address` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '地址',
  `principal` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '负责人',
  `telephone` varchar(22) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '电话',
  `company_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '公司组织机构码',
  `company_org_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '公司组织机构名称',
  `entity_prop_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '实体属性编码',
  `parent_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '父编码',
  `sortno` int(11) NULL DEFAULT 0 COMMENT '序号',
  `shop_id` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '(LP)店铺id',
  `user_id` bigint(20) NULL DEFAULT NULL COMMENT '关联账号',
  `person_id` bigint(20) NULL DEFAULT NULL COMMENT '关联个人',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_instance_id`(`instance_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '组织, 用于管理企业的内外部组织结构 (LP定制了很多内容, 需要剥离)' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for us_organization_info
-- ----------------------------

CREATE TABLE IF NOT EXISTS `us_organization_info`  (
  `id` bigint(20) NOT NULL ,
  `org_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织代码',
  `org_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织名称',
  `org_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织类型',
  `simple_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '简称',
  `registered_capital` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '注册资本',
  `founding_time` date NULL DEFAULT NULL COMMENT '成立时间',
  `credit_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '统一社会信用代码',
  `tax_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税号',
  `org_cert_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织机构代码',
  `business_license_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '营业执照编号',
  `address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司地址',
  `phone_num` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系电话',
  `account_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '银行开户名',
  `account_num` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '银行账户号',
  `branch_account_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开户行支行名称',
  `branch_account_num` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开户行职场联行号',
  `busi_scope` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '经营范围',
  `company_email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司邮箱',
  `company_tel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司电话',
  `fax` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'fax',
  `legal_card_num` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '法人证件号码',
  `legal_man_card` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '法人证件身份证',
  `legal_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '法人代表',
  `linkman` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系人',
  `postcode` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮编',
  `bussiness_license_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '营业执照图片url',
  `logo_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司logo',
  `staff_num` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '员工数量',
  `id_card_back` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '身份证反面',
  `id_card_front` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '身份证正面',
  `user_id` bigint(20) NULL DEFAULT NULL,
  `person_id` bigint(20) NULL DEFAULT NULL,
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_user_id`(`user_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '企业/法人/组织信息表, 注意 ,不是 us_organization的info' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for us_organization_prop
-- ----------------------------

CREATE TABLE IF NOT EXISTS `us_organization_prop`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '编码',
  `name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `func_type_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '职能类型编码',
  `edit_type` tinyint(2) NOT NULL DEFAULT 0 COMMENT '属性值枚举方式(0填写,1单选,2多选)',
  `value_type` tinyint(2) NOT NULL DEFAULT 0 COMMENT '属性值字符类型(0字符串,1数字,2时间)',
  `length` smallint(6) NOT NULL DEFAULT 0 COMMENT '属性值字段长度',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '备注',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展值',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `create_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '修改人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '最后一次修改时间',
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '组织属性' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for us_post
-- ----------------------------

CREATE TABLE IF NOT EXISTS `us_post`  (
  `id` bigint(20) NOT NULL ,
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '岗位名称',
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '岗位编码',
  `org_group_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '组织分类编码',
  `org_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织编码',
  `remark` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `status` tinyint(2) NOT NULL DEFAULT 0 COMMENT '状态 [0禁用 1启用]',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '岗位 （跟组织强绑定多对1，跟员工多对多）' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for us_r_customer_organization
-- ----------------------------

CREATE TABLE IF NOT EXISTS `us_r_customer_organization`  (
  `id` bigint(20) NOT NULL  COMMENT '主键ID',
  `customer_id` bigint(20) NOT NULL COMMENT '客户ID',
  `organization_id` bigint(20) NOT NULL COMMENT '组织机构ID',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '客户组织关系表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for us_r_employee_organization
-- ----------------------------

CREATE TABLE IF NOT EXISTS `us_r_employee_organization`  (
  `id` bigint(20) NOT NULL ,
  `org_group_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '组织id',
  `employee_id` bigint(20) NOT NULL COMMENT 'employee_id',
  `organization_id` bigint(20) NOT NULL COMMENT 'organization_id',
  `person_id` bigint(20) NULL DEFAULT NULL,
  `user_id` bigint(20) NULL DEFAULT NULL,
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `emp_org_empId_idx`(`employee_id`) USING BTREE,
  INDEX `emp_org_orgId_idx`(`organization_id`) USING BTREE,
  INDEX `migrate_instance_id`(`instance_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for us_r_employee_post
-- ----------------------------

CREATE TABLE IF NOT EXISTS `us_r_employee_post`  (
  `id` bigint(20) NOT NULL ,
  `employee_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '员工id',
  `post_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '岗位id',
  `post_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '岗位编码',
  `employee_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '工号',
  `status` tinyint(2) NOT NULL DEFAULT 0 COMMENT '状态 [0禁用 1启用]',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '员工-岗位关系表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for us_r_org_func_type
-- ----------------------------

CREATE TABLE IF NOT EXISTS `us_r_org_func_type`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `org_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '组织单元id',
  `func_type_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '组织功能类型编码',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展值',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `create_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '修改人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '最后一次修改时间',
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '组织单元职能类型关系' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for us_r_org_org
-- ----------------------------

CREATE TABLE IF NOT EXISTS `us_r_org_org`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `org_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '组织单元id',
  `parent_org_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '组织单元父id',
  `org_group_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '组织id',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展值',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `create_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '修改人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '最后一次修改时间',
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '组织单元关系' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for us_r_org_post
-- ----------------------------

CREATE TABLE IF NOT EXISTS `us_r_org_post`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `org_group_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '组织id',
  `org_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '组织单元id',
  `post_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '岗位id',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展值',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `create_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '修改人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '最后一次修改时间',
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '组织分类组织单元岗位关系(us_r_post_org)' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for us_r_user_organization
-- ----------------------------

CREATE TABLE IF NOT EXISTS `us_r_user_organization`  (
  `id` bigint(20) NOT NULL  COMMENT '主键ID',
  `user_id` bigint(20) NULL DEFAULT NULL COMMENT '用户ID',
  `organization_id` bigint(20) NOT NULL COMMENT '组织ID',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '业务定义扩展值',
  `instance_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '租户ID',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除标记',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_user_id`(`user_id`) USING BTREE,
  INDEX `idx_organization_id`(`organization_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户组织关系表' ROW_FORMAT = Dynamic;