CREATE TABLE IF NOT EXISTS `us_r_org_third` (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `org_id` bigint(20) NOT NULL COMMENT '组织id，对应us_organization表id',
  `third_org_id` varchar(255) NOT NULL COMMENT '第三方组织id',
  `type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '第三方类型，1企业微信',
  `extension` varchar(1024) NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '租户ID',
  `dr` tinyint(2) NOT NULL DEFAULT '0' COMMENT '逻辑删除标记',
  `create_person` varchar(50) NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50) NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`),
  KEY `idx_org_id` (`org_id`),
  KEY `idx_third_org_id` (`third_org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='组织-第三方组织id关系表';

CREATE TABLE IF NOT EXISTS `us_r_employee_third` (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `employee_id` bigint(20) NOT NULL COMMENT '员工id',
  `third_employee_id` varchar(255) NOT NULL COMMENT '第三方员工id',
  `type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '第三方类型，1企业微信',
  `extension` varchar(1024) NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '租户ID',
  `dr` tinyint(2) NOT NULL DEFAULT '0' COMMENT '逻辑删除标记',
  `create_person` varchar(50) NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50) NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`),
  KEY `idx_employee_id` (`employee_id`),
  KEY `idx_third_employee_id` (`third_employee_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='员工-第三方员工id关系表';
