/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.domain;

import com.dtyunxi.yundt.cube.center.data.api.dto.response.AbstractConfValue;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingValueEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSettingValueEo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SettingCandidateValue {
    private List<SettingValueEo> globalValues;
    private List<SettingValueEo> tenantValues;
    private Map<String, List<SettingValueEo>> spaceValues;
    private Map<String, List<SettingValueEo>> bizIdValues;

    public static SettingCandidateValue build(List<SettingValueEo> values) {
        SettingCandidateValue candidateValue = new SettingCandidateValue();
        candidateValue.globalValues = new ArrayList<SettingValueEo>();
        candidateValue.tenantValues = new ArrayList<SettingValueEo>();
        candidateValue.spaceValues = new HashMap<String, List<SettingValueEo>>(4);
        candidateValue.bizIdValues = new HashMap<String, List<SettingValueEo>>(4);
        for (SettingValueEo value : values) {
            String bizId = value.getBizId();
            String spaceCode = value.getBizSpaceCode();
            Long tenantId = value.getTenantId();
            if (StringUtils.isNotBlank((CharSequence)bizId)) {
                candidateValue.bizIdValues.putIfAbsent(bizId, new ArrayList());
                candidateValue.bizIdValues.get(bizId).add(value);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)spaceCode)) {
                candidateValue.spaceValues.putIfAbsent(spaceCode, new ArrayList());
                candidateValue.spaceValues.get(spaceCode).add(value);
                continue;
            }
            if (tenantId != null && tenantId > 1L) {
                candidateValue.tenantValues.add(value);
                continue;
            }
            candidateValue.globalValues.add(value);
        }
        return candidateValue;
    }

    public Value readValues(String bizIdCode, String bizSpaceCode) {
        Value value = new Value();
        if (CollectionUtils.isNotEmpty(this.globalValues)) {
            value.setBizIdCode(this.globalValues.get(0).getBizId());
            value.setGlobalValueEos(this.globalValues);
            value.setGlobalValues(this.globalValues.stream().map(StdSettingValueEo::getSettingValue).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(this.tenantValues)) {
            value.setBizIdCode(this.tenantValues.get(0).getBizId());
            value.setTenantValueEos(this.tenantValues);
            value.setTenantValues(this.tenantValues.stream().map(StdSettingValueEo::getSettingValue).collect(Collectors.toList()));
        }
        if (bizSpaceCode != null && MapUtils.isNotEmpty(this.spaceValues) && this.spaceValues.containsKey(bizSpaceCode)) {
            value.setSpaceValueEos(this.spaceValues.get(bizSpaceCode));
            value.setSpaceValues(value.getSpaceValueEos().stream().map(StdSettingValueEo::getSettingValue).collect(Collectors.toList()));
            value.setBizIdCode(value.getSpaceValueEos().get(0).getBizId());
        }
        if (bizIdCode != null && MapUtils.isNotEmpty(this.bizIdValues) && this.bizIdValues.containsKey(bizIdCode)) {
            value.setIdValueEos(this.bizIdValues.get(bizIdCode));
            value.setIdValues(value.getIdValueEos().stream().map(StdSettingValueEo::getSettingValue).collect(Collectors.toList()));
            value.setBizIdCode(value.getIdValueEos().get(0).getBizId());
        }
        return value;
    }

    public List<SettingValueEo> getGlobalValues() {
        return this.globalValues;
    }

    public SettingCandidateValue setGlobalValues(List<SettingValueEo> globalValues) {
        this.globalValues = globalValues;
        return this;
    }

    public List<SettingValueEo> getTenantValues() {
        return this.tenantValues;
    }

    public SettingCandidateValue setTenantValues(List<SettingValueEo> tenantValues) {
        this.tenantValues = tenantValues;
        return this;
    }

    public Map<String, List<SettingValueEo>> getSpaceValues() {
        return this.spaceValues;
    }

    public SettingCandidateValue setSpaceValues(Map<String, List<SettingValueEo>> spaceValues) {
        this.spaceValues = spaceValues;
        return this;
    }

    public Map<String, List<SettingValueEo>> getBizIdValues() {
        return this.bizIdValues;
    }

    public SettingCandidateValue setBizIdValues(Map<String, List<SettingValueEo>> bizIdValues) {
        this.bizIdValues = bizIdValues;
        return this;
    }

    public class Value
    extends AbstractConfValue {
        private String bizIdCode;
        private List<SettingValueEo> idValueEos;
        private List<SettingValueEo> spaceValueEos;
        private List<SettingValueEo> tenantValueEos;
        private List<SettingValueEo> globalValueEos;

        public String getBizIdCode() {
            return this.bizIdCode;
        }

        public void setBizIdCode(String bizIdCode) {
            this.bizIdCode = bizIdCode;
        }

        public List<SettingValueEo> getIdValueEos() {
            return this.idValueEos;
        }

        public void setIdValueEos(List<SettingValueEo> idValueEos) {
            this.idValueEos = idValueEos;
        }

        public List<SettingValueEo> getSpaceValueEos() {
            return this.spaceValueEos;
        }

        public void setSpaceValueEos(List<SettingValueEo> spaceValueEos) {
            this.spaceValueEos = spaceValueEos;
        }

        public List<SettingValueEo> getTenantValueEos() {
            return this.tenantValueEos;
        }

        public void setTenantValueEos(List<SettingValueEo> tenantValueEos) {
            this.tenantValueEos = tenantValueEos;
        }

        public List<SettingValueEo> getGlobalValueEos() {
            return this.globalValueEos;
        }

        public void setGlobalValueEos(List<SettingValueEo> globalValueEos) {
            this.globalValueEos = globalValueEos;
        }
    }
}

