/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.func.api.constants.AbilityConstants;
import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.constants.DocConstants;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityGroupCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityGroupDocDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityGroupModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityGroupQueryDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityGroupQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityGroupRemoveReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityGroupSortDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityGroupTreeReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceAbilityGroupReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AbilityGroupRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AbilityGroupTreeDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SceneDto;
import com.dtyunxi.yundt.cube.center.func.api.exception.CenterDataExceptionCode;
import com.dtyunxi.yundt.cube.center.func.biz.service.IAbilityGroupService;
import com.dtyunxi.yundt.cube.center.func.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.func.dao.das.AbilityGroupDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizSpaceAbilityRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.CapabilityDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.DocDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.DomainDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.GroupAbilityRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.AbilityGroupEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizSpaceAbilityRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.CapabilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DocEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DomainEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdAbilityGroupEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdBizSpaceAbilityRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdCapabilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdGroupAbilityRelationEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AbilityGroupServiceImpl
implements IAbilityGroupService {
    @Resource
    private AbilityGroupDas abilityGroupDas;
    @Resource
    private GroupAbilityRelationDas groupAbilityRelationDas;
    @Resource
    private BizSpaceAbilityRelationDas bizSpaceAbilityRelationDas;
    @Resource
    private DocDas docDas;
    @Resource
    private CapabilityDas capabilityDas;
    @Resource
    private DomainDas domainDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String addAbilityGroup(AbilityGroupCreateReqDto abilityGroupCreateReqDto) {
        AbilityGroupEo abilityGroupEo = new AbilityGroupEo();
        abilityGroupEo.setCode(abilityGroupCreateReqDto.getCode());
        abilityGroupEo.setType(abilityGroupCreateReqDto.getType());
        AssertUtil.isTrue(this.abilityGroupDas.count((BaseEo)abilityGroupEo) == 0, CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + ":\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
        abilityGroupEo.setCode(null);
        abilityGroupEo.setName(abilityGroupCreateReqDto.getName());
        AssertUtil.isTrue(this.abilityGroupDas.count((BaseEo)abilityGroupEo) == 0, CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + ":\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
        DtoHelper.dto2Eo((BaseVo)abilityGroupCreateReqDto, (BaseEo)abilityGroupEo);
        if (null == abilityGroupCreateReqDto.getStatus()) {
            abilityGroupEo.setStatus(AbilityConstants.ENABLE);
        } else if (!abilityGroupCreateReqDto.getStatus().equals(AbilityConstants.ENABLE) && !abilityGroupCreateReqDto.getStatus().equals(AbilityConstants.DISABLE)) {
            throw new BizException(CenterDataExceptionCode.PARAM_INVALID.getCode(), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ": \u72b6\u6001\u8d4b\u503c\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isNotBlank((CharSequence)abilityGroupCreateReqDto.getExtension())) {
            abilityGroupEo.setExtension("");
        }
        if (abilityGroupCreateReqDto.getSort() == null) {
            AbilityGroupEo parent = new AbilityGroupEo();
            parent.setParentCode(abilityGroupCreateReqDto.getParentCode());
            parent.setOrderBy("sort");
            parent.setType(abilityGroupCreateReqDto.getType());
            List children = this.abilityGroupDas.select((BaseEo)parent);
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                Integer finalNodeSort = this.getSortNum(children, children.size() - 1);
                abilityGroupEo.setSort(Integer.valueOf(finalNodeSort + 1));
            } else {
                abilityGroupEo.setSort(Integer.valueOf(0));
            }
        }
        this.abilityGroupDas.insert((BaseEo)abilityGroupEo);
        return abilityGroupEo.getCode();
    }

    private Integer getSortNum(List<AbilityGroupEo> abilityGroupEos, Integer index) {
        AbilityGroupEo finalNode = abilityGroupEos.get(index);
        if (finalNode.getSort() == null) {
            if (abilityGroupEos.size() != 1) {
                this.getSortNum(abilityGroupEos, index - 1);
            } else {
                finalNode.setSort(Integer.valueOf(0));
                this.abilityGroupDas.updateSelective((BaseEo)finalNode);
                return 0;
            }
        }
        return finalNode.getSort();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyAbilityGroup(AbilityGroupModifyReqDto abilityGroupModifyReqDto) {
        if (null != abilityGroupModifyReqDto.getStatus() && !abilityGroupModifyReqDto.getStatus().equals(AbilityConstants.ENABLE) && !abilityGroupModifyReqDto.getStatus().equals(AbilityConstants.DISABLE)) {
            throw new BizException(CenterDataExceptionCode.PARAM_INVALID.getCode(), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ": \u72b6\u6001\u8d4b\u503c\u4e0d\u6b63\u786e");
        }
        AbilityGroupEo abilityGroupEo = new AbilityGroupEo();
        List abilityGroupEos = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)abilityGroupModifyReqDto.getName())) {
            AbilityGroupEo abilityGroupNameEo = new AbilityGroupEo();
            abilityGroupNameEo.setName(abilityGroupModifyReqDto.getName());
            abilityGroupNameEo.setType(abilityGroupModifyReqDto.getType());
            abilityGroupEos = this.abilityGroupDas.select((BaseEo)abilityGroupNameEo);
            if (CollectionUtils.isNotEmpty(abilityGroupEos)) {
                AssertUtil.isTrue(abilityGroupEos.size() == 1, CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + ":\u671f\u5f85\u6570\u636e\u4e00\u822c\u53ea\u6709\u4e00\u6761");
                AssertUtil.isTrue(abilityGroupModifyReqDto.getCode().equals(((AbilityGroupEo)abilityGroupEos.get(0)).getCode()), CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + ":\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
            }
        }
        if (abilityGroupModifyReqDto.getStatus() != null && abilityGroupModifyReqDto.getStatus().equals(AbilityConstants.DISABLE)) {
            try {
                this.checkExsitAbility(abilityGroupModifyReqDto.getType(), abilityGroupModifyReqDto.getCode());
                this.checkDoc(abilityGroupModifyReqDto.getType(), abilityGroupModifyReqDto.getCode());
            }
            catch (Exception e) {
                if (abilityGroupModifyReqDto.getType().equals(AbilityConstants.REALM)) {
                    throw new BizException(CenterDataExceptionCode.RELATION_EXISTS.getCode(), "\u8be5\u9886\u57df\u4e0b\u6709\u5173\u8054\u80fd\u529b\u6216\u7b80\u4ecb\u6587\u7ae0\uff0c\u4e0d\u80fd\u7981\u7528");
                }
                throw new BizException(CenterDataExceptionCode.RELATION_EXISTS.getCode(), "\u8be5\u573a\u666f\u4e0b\u6709\u5173\u8054\u80fd\u529b\u6216\u7b80\u4ecb\u6587\u7ae0\uff0c\u4e0d\u80fd\u7981\u7528");
            }
            if (abilityGroupModifyReqDto.getType().equals(AbilityConstants.REALM)) {
                AbilityGroupEo sceneEo = new AbilityGroupEo();
                sceneEo.setType(AbilityConstants.SCENE);
                sceneEo.setParentCode(abilityGroupModifyReqDto.getCode());
                PageInfo results = this.abilityGroupDas.selectPage((BaseEo)sceneEo, Integer.valueOf(1), Integer.valueOf(1000));
                if (null != results && CollectionUtils.isNotEmpty((Collection)results.getList())) {
                    for (AbilityGroupEo scene : results.getList()) {
                        scene.setStatus(AbilityConstants.DISABLE);
                        this.abilityGroupDas.updateSelective((BaseEo)scene);
                    }
                }
            }
        }
        abilityGroupEo.setType(abilityGroupModifyReqDto.getType());
        abilityGroupEo.setCode(abilityGroupModifyReqDto.getCode());
        abilityGroupEos = this.abilityGroupDas.select((BaseEo)abilityGroupEo);
        if (!CollectionUtils.isNotEmpty(abilityGroupEos)) {
            throw new BizException(CenterDataExceptionCode.RECORD_NOT_EXISTS.getCode(), CenterDataExceptionCode.RECORD_NOT_EXISTS.getMsg());
        }
        AssertUtil.isTrue(abilityGroupEos.size() == 1, CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + ":\u671f\u5f85\u6570\u636e\u4e00\u822c\u53ea\u6709\u4e00\u6761");
        abilityGroupEo.setId(((AbilityGroupEo)abilityGroupEos.get(0)).getId());
        DtoHelper.dto2Eo((BaseVo)abilityGroupModifyReqDto, (BaseEo)abilityGroupEo);
        this.abilityGroupDas.updateSelective((BaseEo)abilityGroupEo);
    }

    private void checkExsitAbility(Integer type, String abilityGroupCode) {
        if (AbilityConstants.REALM.equals(type)) {
            AbilityGroupEo abilityGroupEo = new AbilityGroupEo();
            abilityGroupEo.setParentCode(abilityGroupCode);
            List abilityGroupEoLsit = this.abilityGroupDas.select((BaseEo)abilityGroupEo);
            List sceneCodes = abilityGroupEoLsit.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getCode())).map(StdAbilityGroupEo::getCode).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(sceneCodes)) {
                List groupAbilityRelationEos = this.groupAbilityRelationDas.selectByAbilityGroupCodes(sceneCodes, AbilityConstants.SCENE);
                AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)groupAbilityRelationEos), CenterDataExceptionCode.RELATION_EXISTS.getMsg() + ":\u5df2\u5173\u8054\u80fd\u529b");
            }
        } else if (AbilityConstants.SCENE.equals(type)) {
            ArrayList<String> sceneCodes = new ArrayList<String>();
            sceneCodes.add(abilityGroupCode);
            List groupAbilityRelationEos = this.groupAbilityRelationDas.selectByAbilityGroupCodes(sceneCodes, AbilityConstants.SCENE);
            AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)groupAbilityRelationEos), CenterDataExceptionCode.RELATION_EXISTS.getMsg() + ":\u5df2\u5173\u8054\u80fd\u529b");
        }
    }

    private void checkDoc(Integer type, String abilityGroupCode) {
        if (AbilityConstants.REALM.equals(type)) {
            AbilityGroupEo abilityGroupEo = new AbilityGroupEo();
            abilityGroupEo.setParentCode(abilityGroupCode);
            List abilityGroupEoLsit = this.abilityGroupDas.select((BaseEo)abilityGroupEo);
            List sceneCodes = abilityGroupEoLsit.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getCode())).map(StdAbilityGroupEo::getCode).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(sceneCodes)) {
                ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                sqlFilters.add(SqlFilter.in((String)"ability_group_code", (Object)StringUtils.join(sceneCodes, (String)",")));
                DocEo docEo = new DocEo();
                docEo.setSqlFilters(sqlFilters);
                List docEos = this.docDas.select((BaseEo)docEo);
                AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)docEos), CenterDataExceptionCode.RELATION_EXISTS.getMsg() + ":\u8be5\u5206\u7c7b\u4e0b\u6709\u7b80\u4ecb\u6587\u7ae0\uff0c\u4e0d\u80fd\u5220\u9664");
            }
        }
        DocEo docEo = new DocEo();
        docEo.setDocType(type);
        docEo.setAbilityGroupCode(abilityGroupCode);
        AssertUtil.isTrue(this.docDas.count((BaseEo)docEo) <= 0, CenterDataExceptionCode.RELATION_EXISTS.getMsg() + ":\u8be5\u5206\u7c7b\u4e0b\u6709\u7b80\u4ecb\u6587\u7ae0\uff0c\u4e0d\u80fd\u5220\u9664");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAbilityGroup(AbilityGroupRemoveReqDto abilityGroupRemoveReqDto) {
        try {
            this.checkExsitAbility(abilityGroupRemoveReqDto.getType(), abilityGroupRemoveReqDto.getCode());
            this.checkDoc(abilityGroupRemoveReqDto.getType(), abilityGroupRemoveReqDto.getCode());
        }
        catch (Exception e) {
            if (abilityGroupRemoveReqDto.getType().equals(AbilityConstants.REALM)) {
                throw new BizException(CenterDataExceptionCode.RELATION_EXISTS.getCode(), "\u8be5\u9886\u57df\u4e0b\u6709\u5173\u8054\u80fd\u529b\u6216\u7b80\u4ecb\u6587\u7ae0\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            throw new BizException(CenterDataExceptionCode.RELATION_EXISTS.getCode(), "\u8be5\u573a\u666f\u4e0b\u6709\u5173\u8054\u80fd\u529b\u6216\u7b80\u4ecb\u6587\u7ae0\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        AbilityGroupEo abilityGroupEo = new AbilityGroupEo();
        DtoHelper.dto2Eo((BaseVo)abilityGroupRemoveReqDto, (BaseEo)abilityGroupEo);
        this.abilityGroupDas.logicDelete((BaseEo)abilityGroupEo);
        if (abilityGroupRemoveReqDto.getType().equals(AbilityConstants.REALM)) {
            AbilityGroupEo sceneEo = new AbilityGroupEo();
            sceneEo.setParentCode(abilityGroupRemoveReqDto.getCode());
            sceneEo.setType(AbilityConstants.SCENE);
            this.abilityGroupDas.logicDelete((BaseEo)sceneEo);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sortAbilityGroup(AbilityGroupSortDto abilityGroupSortDto) {
        AbilityGroupEo abilityGroupEo = new AbilityGroupEo();
        abilityGroupEo.setCode(abilityGroupSortDto.getAbilityGroupCode());
        abilityGroupEo.setType(abilityGroupSortDto.getType());
        List abilityGroupEos = this.abilityGroupDas.select((BaseEo)abilityGroupEo);
        if (CollectionUtils.isNotEmpty((Collection)abilityGroupEos)) {
            AssertUtil.isTrue(abilityGroupEos.size() == 1, "\u671f\u5f85\u7ed3\u679c\u5b58\u5728\u4e00\u6761\u6570\u636e");
            AbilityGroupEo result = (AbilityGroupEo)abilityGroupEos.get(0);
            AbilityGroupEo parent = new AbilityGroupEo();
            parent.setParentCode(result.getParentCode());
            parent.setOrderBy("sort");
            parent.setType(abilityGroupSortDto.getType());
            List children = this.abilityGroupDas.select((BaseEo)parent);
            List childrenCode = children.stream().map(StdAbilityGroupEo::getCode).collect(Collectors.toList());
            Integer current = childrenCode.indexOf(result.getCode());
            if (current >= 0) {
                void var14_19;
                String code = result.getCode();
                Integer currentSort = result.getSort();
                String sortType = abilityGroupSortDto.getSortType();
                ArrayList<Object> updateEos = new ArrayList<Object>();
                String string = sortType;
                int n = -1;
                switch (string.hashCode()) {
                    case 2251860: {
                        if (!string.equals("INCR")) break;
                        boolean bl = false;
                        break;
                    }
                    case 2094256: {
                        if (!string.equals("DECR")) break;
                        boolean bl = true;
                        break;
                    }
                    case 83253: {
                        if (!string.equals("TOP")) break;
                        int n2 = 2;
                        break;
                    }
                    case 1965067819: {
                        if (!string.equals("BOTTOM")) break;
                        int n3 = 3;
                    }
                }
                switch (var14_19) {
                    case 0: {
                        Integer sortNum;
                        if (current == 0) break;
                        AbilityGroupEo frontEo = (AbilityGroupEo)children.get(current - 1);
                        HashMap<String, AbilityGroupEo> code2Eo = new HashMap<String, AbilityGroupEo>();
                        if (frontEo.getSort().equals(currentSort)) {
                            sortNum = 0;
                            for (AbilityGroupEo abilityGroupEo2 : children) {
                                sortNum = sortNum + 1;
                                abilityGroupEo2.setSort(sortNum);
                                code2Eo.put(abilityGroupEo2.getCode(), abilityGroupEo2);
                            }
                            AbilityGroupEo frontResultEo = (AbilityGroupEo)children.get(current - 1);
                            AbilityGroupEo abilityGroupEo3 = (AbilityGroupEo)children.get(current);
                            Integer incr = frontResultEo.getSort();
                            frontResultEo.setSort(abilityGroupEo3.getSort());
                            abilityGroupEo3.setSort(incr);
                            code2Eo.remove(frontResultEo.getCode());
                            code2Eo.remove(abilityGroupEo3.getCode());
                            updateEos.addAll(code2Eo.values());
                            updateEos.add(frontResultEo);
                            updateEos.add(abilityGroupEo3);
                            break;
                        }
                        result.setSort(frontEo.getSort());
                        frontEo.setSort(currentSort);
                        updateEos.add(frontEo);
                        updateEos.add(result);
                        break;
                    }
                    case 1: {
                        Integer sortNum;
                        if (current == children.size() - 1) break;
                        AbilityGroupEo behindEo = (AbilityGroupEo)children.get(current + 1);
                        HashMap<String, AbilityGroupEo> code2Eo = new HashMap();
                        if (behindEo.getSort().equals(currentSort)) {
                            sortNum = 0;
                            for (AbilityGroupEo abilityGroupEo4 : children) {
                                sortNum = sortNum + 1;
                                abilityGroupEo4.setSort(sortNum);
                                code2Eo.put(abilityGroupEo4.getCode(), abilityGroupEo4);
                            }
                            AbilityGroupEo behindResultEo = (AbilityGroupEo)children.get(current + 1);
                            AbilityGroupEo abilityGroupEo5 = (AbilityGroupEo)children.get(current);
                            Integer decr = behindResultEo.getSort();
                            behindResultEo.setSort(abilityGroupEo5.getSort());
                            abilityGroupEo5.setSort(decr);
                            code2Eo.remove(behindResultEo.getCode());
                            code2Eo.remove(abilityGroupEo5.getCode());
                            updateEos.addAll(code2Eo.values());
                            updateEos.add(behindResultEo);
                            updateEos.add(abilityGroupEo5);
                            break;
                        }
                        result.setSort(behindEo.getSort());
                        behindEo.setSort(currentSort);
                        updateEos.add(behindEo);
                        updateEos.add(result);
                        break;
                    }
                    case 2: {
                        List processEos = children.stream().filter(r -> !r.getCode().equals(code)).collect(Collectors.toList());
                        ArrayList<Object> sortEos = new ArrayList<Object>();
                        sortEos.add(result);
                        sortEos.addAll(processEos);
                        Integer sortNum = 0;
                        for (AbilityGroupEo abilityGroupEo6 : sortEos) {
                            abilityGroupEo6.setSort(sortNum);
                            sortNum = sortNum + 1;
                        }
                        updateEos.addAll(sortEos);
                        break;
                    }
                    case 3: {
                        List sortEos = children.stream().filter(r -> !r.getCode().equals(code)).collect(Collectors.toList());
                        sortEos.add(result);
                        Integer sortNum = 0;
                        for (AbilityGroupEo eo : sortEos) {
                            eo.setSort(sortNum);
                            sortNum = sortNum + 1;
                        }
                        updateEos.addAll(sortEos);
                        break;
                    }
                    default: {
                        throw new BizException(CenterDataExceptionCode.PARAM_INVALID.getCode(), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u6392\u5e8f\u7c7b\u578b\u6709\u8bef");
                    }
                }
                for (AbilityGroupEo abilityGroupEo7 : updateEos) {
                    this.abilityGroupDas.updateSelective((BaseEo)abilityGroupEo7);
                }
            }
        }
    }

    @Override
    public AbilityGroupRespDto queryByCode(AbilityGroupQueryReqDto abilityGroupQueryReqDto) {
        AbilityGroupEo abilityGroupEo = new AbilityGroupEo();
        DtoHelper.dto2Eo((BaseVo)abilityGroupQueryReqDto, (BaseEo)abilityGroupEo);
        List abilityGroupEos = this.abilityGroupDas.select((BaseEo)abilityGroupEo);
        AbilityGroupRespDto abilityGroupRespDto = new AbilityGroupRespDto();
        if (CollectionUtils.isNotEmpty((Collection)abilityGroupEos)) {
            AssertUtil.isTrue(1 == abilityGroupEos.size(), CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + ":\u671f\u5f85\u4e00\u822c\u53ea\u6709\u4e00\u6761\u6570\u636e");
            DtoHelper.eo2Dto((BaseEo)((BaseEo)abilityGroupEos.get(0)), (BaseVo)abilityGroupRespDto);
        }
        return abilityGroupRespDto;
    }

    @Override
    public AbilityGroupTreeDto queryByTree(AbilityGroupTreeReqDto abilityGroupTreeReqDto) {
        List<AbilityGroupEo> eoList;
        AbilityGroupTreeDto abilityGroupTreeDto = new AbilityGroupTreeDto();
        if (abilityGroupTreeReqDto.getSort() == null) {
            abilityGroupTreeReqDto.setSort(AbilityConstants.TRUE);
        }
        if (CollectionUtils.isNotEmpty(eoList = this.queryAbilityGroupEos(abilityGroupTreeReqDto))) {
            abilityGroupTreeDto = this.processTree(eoList);
        }
        return abilityGroupTreeDto;
    }

    @Override
    public List<AbilityGroupRespDto> queryByList(AbilityGroupQueryDto abilityGroupQueryDto) {
        Integer type = abilityGroupQueryDto.getType();
        if (null == type) {
            type = StringUtils.isBlank((CharSequence)abilityGroupQueryDto.getParentCode()) ? AbilityConstants.SCENE : ("0".equals(abilityGroupQueryDto.getParentCode()) ? AbilityConstants.REALM : AbilityConstants.SCENE);
        }
        String code = abilityGroupQueryDto.getCode();
        String name = abilityGroupQueryDto.getName();
        Integer status = abilityGroupQueryDto.getStatus();
        String parentCode = abilityGroupQueryDto.getParentCode();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + name + "%")));
        }
        ArrayList<AbilityGroupRespDto> abilityGroupRespDtos = new ArrayList<AbilityGroupRespDto>();
        if (type.equals(AbilityConstants.REALM)) {
            DomainEo domainEo = new DomainEo();
            domainEo.setCode(code);
            domainEo.setSqlFilters(sqlFilters);
            List domainEos = this.domainDas.select((BaseEo)domainEo, Integer.valueOf(1), Integer.valueOf(1000));
            domainEos.forEach(eo -> {
                AbilityGroupRespDto abilityGroupRespDto = new AbilityGroupRespDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)abilityGroupRespDto);
                abilityGroupRespDto.setType(AbilityConstants.REALM);
                abilityGroupRespDto.setParentCode("0");
                abilityGroupRespDtos.add(abilityGroupRespDto);
            });
        } else if (type.equals(AbilityConstants.SCENE)) {
            CapabilityEo capabilityEo = new CapabilityEo();
            capabilityEo.setCode(code);
            capabilityEo.setStatus(status);
            capabilityEo.setDomain(parentCode);
            capabilityEo.setParentCode("ROOT_NODE");
            capabilityEo.setSqlFilters(sqlFilters);
            List sceneEos = this.capabilityDas.select((BaseEo)capabilityEo, Integer.valueOf(1), Integer.valueOf(5000));
            sceneEos.forEach(eo -> {
                AbilityGroupRespDto abilityGroupRespDto = new AbilityGroupRespDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)abilityGroupRespDto);
                abilityGroupRespDto.setType(AbilityConstants.SCENE);
                abilityGroupRespDto.setParentCode(eo.getDomain());
                abilityGroupRespDtos.add(abilityGroupRespDto);
            });
        }
        return abilityGroupRespDtos;
    }

    @Override
    public List<AbilityGroupEo> queryAbilityGroupEos(AbilityGroupTreeReqDto abilityGroupTreeReqDto) {
        PageInfo abilityGroupEos;
        AbilityGroupEo abilityGroupEo = new AbilityGroupEo();
        DtoHelper.dto2Eo((BaseVo)abilityGroupTreeReqDto, (BaseEo)abilityGroupEo);
        abilityGroupEo.setSort(null);
        if (abilityGroupTreeReqDto.getSort() != null && abilityGroupTreeReqDto.getSort() == 1) {
            abilityGroupEo.setOrderBy("sort");
        }
        if (abilityGroupTreeReqDto.getNewest() != null && abilityGroupTreeReqDto.getNewest() == 1) {
            abilityGroupEo.setOrderByDesc("create_time");
        }
        if ((abilityGroupEos = this.abilityGroupDas.selectPage((BaseEo)abilityGroupEo, Integer.valueOf(1), Integer.valueOf(1000))) != null && CollectionUtils.isNotEmpty((Collection)abilityGroupEos.getList())) {
            return abilityGroupEos.getList();
        }
        return new ArrayList<AbilityGroupEo>();
    }

    private AbilityGroupTreeDto processTree(List<AbilityGroupEo> abilityGroupEos) {
        AbilityGroupTreeDto rootDto = new AbilityGroupTreeDto();
        for (AbilityGroupEo eo : abilityGroupEos) {
            if (!"0".equals(eo.getCode())) continue;
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)rootDto);
            rootDto.setKey("0");
            rootDto.setParentkey("0");
            break;
        }
        if (null == rootDto) {
            throw new BizException(CenterDataExceptionCode.RECORD_NOT_EXISTS.getCode(), CenterDataExceptionCode.RECORD_NOT_EXISTS.getMsg() + ":\u65e0\u6cd5\u627e\u5230\u9876\u7ea7\u80fd\u529b\u5206\u7c7b");
        }
        Map<String, List<AbilityGroupEo>> parent2AbilityGroupEos = abilityGroupEos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getParentCode())).collect(Collectors.groupingBy(StdAbilityGroupEo::getParentCode));
        List<AbilityGroupEo> children = parent2AbilityGroupEos.get(rootDto.getCode());
        ArrayList<AbilityGroupTreeDto> rootChildren = new ArrayList<AbilityGroupTreeDto>();
        if (CollectionUtils.isNotEmpty(children)) {
            for (AbilityGroupEo childEo : children) {
                AbilityGroupTreeDto abilityGroupTreeDto = new AbilityGroupTreeDto();
                DtoHelper.eo2Dto((BaseEo)childEo, (BaseVo)abilityGroupTreeDto);
                List<AbilityGroupEo> sceneChildren = parent2AbilityGroupEos.get(childEo.getCode());
                ArrayList<AbilityGroupTreeDto> childrenDto = new ArrayList<AbilityGroupTreeDto>();
                DtoHelper.eoList2DtoList(sceneChildren, childrenDto, AbilityGroupTreeDto.class);
                if (CollectionUtils.isNotEmpty(childrenDto)) {
                    childrenDto.sort(Comparator.comparing(AbilityGroupTreeDto::getSort));
                }
                for (AbilityGroupTreeDto scene : childrenDto) {
                    scene.setKey(scene.getCode() + scene.getType());
                    scene.setParentkey(scene.getParentCode() + AbilityConstants.REALM);
                }
                abilityGroupTreeDto.setChildren(childrenDto);
                abilityGroupTreeDto.setKey(childEo.getCode() + childEo.getType());
                abilityGroupTreeDto.setParentkey("0");
                rootChildren.add(abilityGroupTreeDto);
            }
        }
        if (CollectionUtils.isNotEmpty(rootChildren)) {
            rootChildren.sort(Comparator.comparing(AbilityGroupTreeDto::getSort));
        }
        rootDto.setChildren(rootChildren);
        return rootDto;
    }

    @Override
    public List<AbilityGroupRespDto> queryByBizSpaceCode(BizSpaceAbilityGroupReqDto bizSpaceAbilityGroupReqDto) {
        List abilityGroupCodeList;
        List groupAbilityRelationEoList;
        List abilityCodeList;
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        AssertUtil.isTrue(tenantId != null, "tenantId\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)bizSpaceAbilityGroupReqDto.getCode()), "\u4e1a\u52a1\u7a7a\u95f4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<AbilityGroupRespDto> abilityGroupRespDtoList = new ArrayList<AbilityGroupRespDto>();
        BizSpaceAbilityRelationEo queryEo = new BizSpaceAbilityRelationEo();
        queryEo.setBizSpaceCode(bizSpaceAbilityGroupReqDto.getCode());
        queryEo.setTenantId(tenantId);
        List bizSpaceAbilityRelationEoList = this.bizSpaceAbilityRelationDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)bizSpaceAbilityRelationEoList) && CollectionUtils.isNotEmpty(abilityCodeList = bizSpaceAbilityRelationEoList.stream().filter(eo -> StringUtils.isNotBlank((CharSequence)eo.getAbilityCode())).map(StdBizSpaceAbilityRelationEo::getAbilityCode).collect(Collectors.toList())) && CollectionUtils.isNotEmpty((Collection)(groupAbilityRelationEoList = this.groupAbilityRelationDas.selectByAbilityCodes(abilityCodeList))) && CollectionUtils.isNotEmpty(abilityGroupCodeList = groupAbilityRelationEoList.stream().filter(eo -> StringUtils.isNotBlank((CharSequence)eo.getAbilityGroupCode())).map(StdGroupAbilityRelationEo::getAbilityGroupCode).collect(Collectors.toList()))) {
            Integer type = bizSpaceAbilityGroupReqDto.getType() == null ? AbilityConstants.SCENE : bizSpaceAbilityGroupReqDto.getType();
            List abilityGroupEoList = this.abilityGroupDas.selectByCodes(abilityGroupCodeList, null, type);
            DtoHelper.eoList2DtoList((Collection)abilityGroupEoList, abilityGroupRespDtoList, AbilityGroupRespDto.class);
        }
        return abilityGroupRespDtoList;
    }

    @Override
    public List<SceneDto> querySceneDocList(AbilityGroupDocDto abilityGroupDocDto) {
        List capabilityEos;
        ArrayList<SceneDto> sceneDtos = new ArrayList<SceneDto>();
        CapabilityEo capabilityEo = new CapabilityEo();
        capabilityEo.setParentCode("ROOT_NODE");
        capabilityEo.setStatus(Constants.ENABLE);
        capabilityEo.setDomain(abilityGroupDocDto.getRealmCode());
        capabilityEo.setOrderBy("sort");
        if (StringUtils.isNotBlank((CharSequence)abilityGroupDocDto.getName())) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + abilityGroupDocDto.getName() + "%")));
            capabilityEo.setSqlFilters(sqlFilters);
        }
        if (CollectionUtils.isNotEmpty((Collection)(capabilityEos = this.capabilityDas.select((BaseEo)capabilityEo, Integer.valueOf(1), Integer.valueOf(1000))))) {
            Map<String, String> scene = capabilityEos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getCode())).collect(Collectors.toMap(StdCapabilityEo::getCode, StdCapabilityEo::getName, (k1, k2) -> k1));
            DocEo docEo = new DocEo();
            docEo.setDocType(DocConstants.SCENE_DOC);
            docEo.setStatus(DocConstants.ON_SHElF);
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"ability_group_code", scene.keySet()));
            docEo.setSqlFilters(sqlFilterList);
            List docEos = this.docDas.select((BaseEo)docEo, Integer.valueOf(1), Integer.valueOf(1000));
            HashMap<String, String> map = new HashMap<String, String>();
            for (DocEo sceneDoc : docEos) {
                String abilityGroupCode = sceneDoc.getAbilityGroupCode();
                if (map.get(abilityGroupCode) != null) continue;
                map.put(abilityGroupCode, abilityGroupCode);
                SceneDto sceneDto = new SceneDto();
                DtoHelper.eo2Dto((BaseEo)sceneDoc, (BaseVo)sceneDto);
                sceneDto.setDocId(sceneDoc.getId());
                String sceneName = scene.get(abilityGroupCode);
                sceneDto.setName(sceneName);
                sceneDto.setCode(sceneDoc.getAbilityGroupCode());
                sceneDtos.add(sceneDto);
            }
        }
        return sceneDtos;
    }
}

