/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.starter.bundle.dto.BundleBaseDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleApiRespDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleApisRespDto;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AppBundleRespDto;
import com.dtyunxi.yundt.cube.center.data.dto.ApiBatchDto;
import com.dtyunxi.yundt.cube.center.data.dto.ErrorCodeDto;
import com.dtyunxi.yundt.cube.center.func.api.constants.DocConstants;
import com.dtyunxi.yundt.cube.center.func.api.dto.TwoTuple;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ApiBaseReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ApiComboBoxReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ApiQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BindApiReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleApiQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.RealmApiQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.RealmErrorCodeQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ShelfStatusReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.UnBindApiReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ApiBaseRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ApiComboBoxRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ApiDetailRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ApiDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ApiGroupDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ApiRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BundleApiQueryRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ModuleDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.RealmApiRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.RealmErrorCodeRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SceneDto;
import com.dtyunxi.yundt.cube.center.func.api.exception.CenterDataExceptionCode;
import com.dtyunxi.yundt.cube.center.func.api.exception.DocApiExceptionCode;
import com.dtyunxi.yundt.cube.center.func.biz.config.BatchUpdateSizeConfig;
import com.dtyunxi.yundt.cube.center.func.biz.service.IApiService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IAppBundleService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBundleService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ICapabilityDomainService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ICapabilityService;
import com.dtyunxi.yundt.cube.center.func.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.func.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.func.biz.util.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.func.biz.vo.BundleApiVo;
import com.dtyunxi.yundt.cube.center.func.dao.das.ApiDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.ApiHistoryDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.ApiSceneRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.CapabilityDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.DocDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.DomainAppDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.DomainDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.ErrorCodeDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.ModuleDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ApiEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ApiHistoryEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ApiSceneRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.CapabilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DocEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DomainAppEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DomainEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ErrorCodeEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ModuleEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdApiEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdApiSceneRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdCapabilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdDomainEo;
import com.dtyunxi.yundt.cube.center.func.dao.vo.MyPair;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@RefreshScope
@Service
public class ApiServiceImpl
implements IApiService {
    private static final Logger logger = LoggerFactory.getLogger(ApiServiceImpl.class);
    @Resource
    private ApiDas apiDas;
    @Resource
    private ModuleDas moduleDas;
    @Resource
    private ErrorCodeDas errorCodeDas;
    @Resource
    private ApiSceneRelationDas relationDas;
    @Resource
    private DocDas docDas;
    @Resource
    private ApiSceneRelationDas apiSceneRelationDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private CapabilityDas capabilityDas;
    @Resource
    private ICapabilityService capabilityService;
    @Resource
    private ICapabilityDomainService capabilityDomainService;
    @Resource
    private IBundleService bundleService;
    @Resource
    private ApiHistoryDas apiHistoryDas;
    @Resource
    private IAppBundleService appBundleService;
    @Resource
    private DomainDas domainDas;
    @Resource
    private DomainAppDas domainAppDas;
    @Autowired
    private BatchUpdateSizeConfig batchUpdateSizeConfig;
    private static final String REGEX = "[:\uff1a]";
    private static final String COLON_EN = ":";
    private static final String COLON_CHS = "\uff1a";

    @Override
    public void addApi(BindApiReqDto bindApReqDto) {
        if (!CollectionUtils.isEmpty((Collection)bindApReqDto.getApiIds())) {
            List<Long> collect = bindApReqDto.getApiIds().stream().distinct().collect(Collectors.toList());
            ApiSceneRelationEo apiSceneRelationEo = new ApiSceneRelationEo();
            apiSceneRelationEo.setSceneCode(bindApReqDto.getCode());
            this.apiSceneRelationDas.delete((BaseEo)apiSceneRelationEo);
            ArrayList longs = new ArrayList();
            collect.forEach(apiId -> {
                ApiEo apiEo = new ApiEo();
                apiEo.setId(apiId);
                ApiEo apiEo1 = (ApiEo)this.apiDas.selectOne((BaseEo)apiEo);
                if (null == apiEo1) {
                    longs.add(apiId);
                }
            });
            if (!CollectionUtils.isEmpty(longs)) {
                collect.remove(longs);
            }
            ArrayList<ApiSceneRelationEo> apiSceneRelationEos = new ArrayList<ApiSceneRelationEo>();
            for (Long apiId2 : collect) {
                ApiSceneRelationEo relationEo = new ApiSceneRelationEo();
                relationEo.setApiId(apiId2);
                relationEo.setSceneCode(bindApReqDto.getCode());
                apiSceneRelationEos.add(relationEo);
            }
            this.relationDas.insertBatch(apiSceneRelationEos);
        }
    }

    @Override
    public void modifyApi(ShelfStatusReqDto statusReqDto) {
        ApiEo apiEo1 = (ApiEo)this.apiDas.selectByPrimaryKey(statusReqDto.getId());
        if (!statusReqDto.getStatus().equals(apiEo1.getStatus())) {
            if (DocConstants.OFF_SHELF.equals(statusReqDto.getStatus())) {
                if (DocConstants.CONFIRM.equals(statusReqDto.getConfirm())) {
                    ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                    sqlFilters.add(SqlFilter.eq((String)"api_id", (Object)apiEo1.getId()));
                    ApiSceneRelationEo relationEo = new ApiSceneRelationEo();
                    relationEo.setSqlFilters(sqlFilters);
                    List select = this.relationDas.select((BaseEo)relationEo);
                    if (!CollectionUtils.isEmpty((Collection)select)) {
                        select.forEach(relationEo1 -> this.relationDas.logicDeleteById(relationEo1.getId()));
                    }
                } else {
                    throw new BizException(DocApiExceptionCode.API_OFF_SHELF.getCode(), DocApiExceptionCode.API_OFF_SHELF.getMsg());
                }
            }
            ApiEo apiEo = new ApiEo();
            DtoHelper.dto2Eo((BaseVo)statusReqDto, (BaseEo)apiEo);
            this.apiDas.updateSelective((BaseEo)apiEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeApi(UnBindApiReqDto unBindApiReqDto) {
        ApiSceneRelationEo relationEo = new ApiSceneRelationEo();
        relationEo.setApiId(unBindApiReqDto.getApiId());
        relationEo.setSceneCode(unBindApiReqDto.getCode());
        this.relationDas.delete((BaseEo)relationEo);
    }

    @Override
    public List<String> queryGroupName() {
        List apiEos;
        ApiEo apiEo = new ApiEo();
        PageInfo pageInfo = this.apiDas.selectPage((BaseEo)apiEo, Integer.valueOf(1), Integer.valueOf(10000));
        ArrayList<String> groupNames = new ArrayList<String>();
        if (pageInfo != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList()) && CollectionUtils.isNotEmpty((Collection)(apiEos = pageInfo.getList()))) {
            Set<String> resultNames = this.getGroupNameSet(apiEos);
            return new ArrayList<String>(resultNames);
        }
        return groupNames;
    }

    @Override
    public List<String> queryGroupName(ApiGroupDto apiGroupDto) {
        String moduleCode = apiGroupDto.getModuleCode();
        ApiEo apiEo = new ApiEo();
        apiEo.setModuleCode(moduleCode);
        PageInfo pageInfo = this.apiDas.selectPage((BaseEo)apiEo, Integer.valueOf(1), Integer.valueOf(3000));
        Set<Object> groupNames = new HashSet();
        if (pageInfo != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List apiEos = pageInfo.getList();
            groupNames = this.getGroupNameSet(apiEos);
        }
        return new ArrayList<String>(groupNames);
    }

    private Set<String> getGroupNameSet(List<ApiEo> apiEos) {
        HashSet<String> groupNames = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(apiEos)) {
            for (ApiEo eo : apiEos) {
                String groupName = eo.getGroupName();
                String afterCutGroupName = this.cutGroupName(groupName);
                if (!StringUtils.isNotBlank((CharSequence)afterCutGroupName)) continue;
                groupNames.add(afterCutGroupName);
            }
        }
        return groupNames;
    }

    private String cutGroupName(String groupName) {
        if (StringUtils.isNotBlank((CharSequence)groupName)) {
            if (groupName.contains(COLON_EN)) {
                return groupName.substring(groupName.indexOf(COLON_EN) + 1);
            }
            if (groupName.contains(COLON_CHS)) {
                return groupName.substring(groupName.indexOf(COLON_CHS) + 1);
            }
        }
        return null;
    }

    private String getModuleName(String moduleCode) {
        if (StringUtils.isBlank((CharSequence)moduleCode)) {
            return null;
        }
        DomainEo domainEo = new DomainEo();
        domainEo.setCode(moduleCode);
        List domainEos = this.domainDas.select((BaseEo)domainEo, Integer.valueOf(1), Integer.valueOf(1));
        if (CollectionUtils.isNotEmpty((Collection)domainEos)) {
            return ((DomainEo)domainEos.get(0)).getName();
        }
        return null;
    }

    @Override
    public Map<String, TwoTuple<String, Long>> queryGroupNameMap() {
        List domainEoList = this.domainDas.selectAll();
        List pairs = this.apiDas.selectGroupCount();
        Map<String, Object> map = new HashMap<String, TwoTuple<String, Long>>(16);
        if (CollectionUtils.isNotEmpty((Collection)domainEoList)) {
            map = domainEoList.stream().collect(Collectors.toMap(StdDomainEo::getCode, value -> new TwoTuple((Object)value.getName(), (Object)0L)));
        }
        if (CollectionUtils.isNotEmpty((Collection)pairs)) {
            for (MyPair pair : pairs) {
                TwoTuple old = (TwoTuple)map.get(pair.getKey());
                if (old == null) continue;
                map.put((String)pair.getKey(), new TwoTuple(old.getFirst(), pair.getValue()));
            }
        }
        return map;
    }

    @Override
    public Map<String, TwoTuple<String, Long>> queryGroupNameMapNew() {
        HashMap finalMap = Maps.newHashMap();
        Map<String, TwoTuple<String, Long>> map = this.queryGroupNameMap();
        List domainAppEos = this.domainAppDas.selectAll();
        if (CollectionUtils.isNotEmpty((Collection)domainAppEos)) {
            domainAppEos.forEach(domainAppEo -> {
                TwoTuple cfr_ignored_0 = (TwoTuple)finalMap.put(domainAppEo.getApplication(), map.get(domainAppEo.getDomain()));
            });
        }
        return finalMap;
    }

    @Override
    public ApiDetailRespDto queryById(Long id) {
        List sceneCodes;
        ApiEo apiEo = (ApiEo)this.apiDas.selectByPrimaryKey(id);
        if (null == apiEo) {
            apiEo = new ApiEo();
            ApiHistoryEo apiHistoryEo = (ApiHistoryEo)this.apiHistoryDas.selectByPrimaryKey(id);
            if (null == apiHistoryEo) {
                return null;
            }
            CubeBeanUtils.copyProperties((Object)apiEo, (Object)apiHistoryEo, (String[])new String[0]);
        }
        ApiDetailRespDto apiReqDto = new ApiDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)apiEo, (BaseVo)apiReqDto);
        List requestParams = JSONObject.parseArray((String)apiEo.getRequestParam(), ApiDetailRespDto.Param.class);
        apiReqDto.setRequestParam(this.processParam(requestParams));
        ApiDetailRespDto.Param respParam = (ApiDetailRespDto.Param)JSONObject.parseObject((String)apiEo.getResponseParam(), ApiDetailRespDto.Param.class, (Feature[])new Feature[0]);
        ArrayList<ApiDetailRespDto.Param> respParams = new ArrayList<ApiDetailRespDto.Param>();
        respParams.add(respParam);
        apiReqDto.setResponseParam(this.processParam(respParams));
        ApiSceneRelationEo relationEo = new ApiSceneRelationEo();
        relationEo.setApiId(id);
        List apiSceneRelationEos = this.relationDas.select((BaseEo)relationEo);
        if (CollectionUtils.isNotEmpty((Collection)apiSceneRelationEos) && CollectionUtils.isNotEmpty(sceneCodes = apiSceneRelationEos.stream().map(StdApiSceneRelationEo::getSceneCode).collect(Collectors.toList()))) {
            List capabilityEos = this.capabilityDas.selectByCodeList(sceneCodes);
            ArrayList sceneDtos = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)capabilityEos)) {
                capabilityEos.forEach(capabilityEo -> {
                    SceneDto sceneDto = new SceneDto();
                    sceneDto.setCode(capabilityEo.getCode());
                    sceneDto.setName(capabilityEo.getName());
                    DocEo docEo = new DocEo();
                    docEo.setAbilityGroupCode(capabilityEo.getCode());
                    docEo.setDocType(DocConstants.SCENE_DOC);
                    List resultDoc = this.docDas.select((BaseEo)docEo, Integer.valueOf(1), Integer.valueOf(1));
                    if (CollectionUtils.isNotEmpty((Collection)resultDoc)) {
                        sceneDto.setBrief(((DocEo)resultDoc.get(0)).getBrief());
                    }
                    sceneDtos.add(sceneDto);
                });
            }
            apiReqDto.setSceneDtos(sceneDtos);
        }
        return apiReqDto;
    }

    @Override
    public PageInfo<ApiRespDto> queryByPage(ApiQueryReqDto apiQueryReqDto, Integer pageNum, Integer pageSize) {
        List<Object> apiIds = new ArrayList();
        if ((StringUtils.isNotBlank((CharSequence)apiQueryReqDto.getFiledCode()) || StringUtils.isNotBlank((CharSequence)apiQueryReqDto.getSceneCode())) && CollectionUtils.isEmpty(apiIds = this.getApiIdByCondition(apiQueryReqDto.getFiledCode(), apiQueryReqDto.getSceneCode()))) {
            return new PageInfo();
        }
        ApiEo apiEo = new ApiEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (!StringUtils.isEmpty((CharSequence)apiQueryReqDto.getApiName())) {
            sqlFilters.add(SqlFilter.like((String)"api_name", (Object)("%" + apiQueryReqDto.getApiName() + "%")));
        }
        if (!StringUtils.isEmpty((CharSequence)apiQueryReqDto.getMethod())) {
            sqlFilters.add(SqlFilter.eq((String)"method", (Object)apiQueryReqDto.getMethod()));
        }
        if (StringUtils.isNotBlank((CharSequence)apiQueryReqDto.getModuleCode())) {
            sqlFilters.add(SqlFilter.eq((String)"module_code", (Object)apiQueryReqDto.getModuleCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)apiQueryReqDto.getGroupName())) {
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)apiQueryReqDto.getModuleCode()), "\u6839\u636e\u5206\u7ec4\u540d\u79f0\u67e5\u8be2\u9700\u8981\u6307\u5b9a\u6240\u5c5e\u4e2d\u5fc3");
            sqlFilters.add(SqlFilter.like((String)"group_name", (Object)("%" + apiQueryReqDto.getGroupName())));
        }
        if (apiQueryReqDto.getStatus() != null) {
            sqlFilters.add(SqlFilter.eq((String)"status", (Object)apiQueryReqDto.getStatus()));
        }
        if (!CollectionUtils.isEmpty(apiIds)) {
            sqlFilters.add(SqlFilter.in((String)"id", apiIds));
        }
        apiEo.setSqlFilters(sqlFilters);
        apiEo.setOrderByDesc("create_time");
        PageInfo apiEoPageInfo = this.apiDas.selectPage((BaseEo)apiEo, pageNum, pageSize);
        List resultApiEos = apiEoPageInfo.getList();
        List<Object> apiRespDtos = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)resultApiEos)) {
            apiRespDtos = this.processApiRespDto(resultApiEos);
        }
        PageInfo pageInfo = new PageInfo(apiRespDtos);
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)apiEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        pageInfo.setList(apiRespDtos);
        return pageInfo;
    }

    private List<ApiRespDto> processApiRespDto(List<ApiEo> apiEos) {
        ArrayList<ApiRespDto> apiRespDtos = new ArrayList<ApiRespDto>();
        for (ApiEo eo : apiEos) {
            ApiRespDto apiRespDto = new ApiRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)apiRespDto);
            if (StringUtils.isNotBlank((CharSequence)apiRespDto.getGroupName())) {
                String afterCutGroupName = this.cutGroupName(apiRespDto.getGroupName());
                apiRespDto.setGroupName(afterCutGroupName);
            }
            if (StringUtils.isNotBlank((CharSequence)eo.getModuleCode())) {
                DomainEo domainEo = new DomainEo();
                domainEo.setCode(eo.getModuleCode());
                List domainEos = this.domainDas.select((BaseEo)domainEo);
                if (CollectionUtils.isNotEmpty((Collection)domainEos)) {
                    apiRespDto.setRealmCode(((DomainEo)domainEos.get(0)).getCode());
                    apiRespDto.setRealmName(((DomainEo)domainEos.get(0)).getName());
                    apiRespDto.setModuleName(((DomainEo)domainEos.get(0)).getName());
                } else {
                    ModuleEo moduleEo = new ModuleEo();
                    moduleEo.setModuleCode(eo.getModuleCode());
                    List moduleEos = this.moduleDas.select((BaseEo)moduleEo);
                    if (CollectionUtils.isNotEmpty((Collection)moduleEos)) {
                        apiRespDto.setRealmCode(((ModuleEo)moduleEos.get(0)).getModuleCode());
                        apiRespDto.setRealmName(((ModuleEo)moduleEos.get(0)).getModuleName());
                        apiRespDto.setModuleName(((ModuleEo)moduleEos.get(0)).getModuleName());
                    } else {
                        apiRespDto.setRealmCode("-");
                        apiRespDto.setRealmName("-");
                        apiRespDto.setModuleName("-");
                    }
                }
            } else {
                apiRespDto.setRealmCode("-");
                apiRespDto.setRealmName("-");
                apiRespDto.setModuleName("-");
            }
            List apiSceneRelationEos = this.apiSceneRelationDas.select(eo.getId());
            if (CollectionUtils.isEmpty((Collection)apiSceneRelationEos)) {
                apiRespDto.setSceneCode("-");
                apiRespDto.setSceneName("-");
            } else {
                Set capabilityCodes = apiSceneRelationEos.stream().map(StdApiSceneRelationEo::getSceneCode).collect(Collectors.toSet());
                List capabilityEos = this.capabilityDas.selectByCodeList(new ArrayList(capabilityCodes));
                if (CollectionUtils.isEmpty((Collection)capabilityEos)) {
                    apiRespDto.setSceneCode("-");
                    apiRespDto.setSceneName("-");
                } else {
                    ArrayList sceneCodes = new ArrayList();
                    ArrayList sceneNames = new ArrayList();
                    capabilityEos.forEach(capabilityEo -> {
                        sceneCodes.add(capabilityEo.getCode());
                        sceneNames.add(capabilityEo.getName());
                    });
                    apiRespDto.setSceneCode(StringUtils.join(sceneCodes, (String)","));
                    apiRespDto.setSceneName(StringUtils.join(sceneNames, (String)","));
                }
            }
            apiRespDtos.add(apiRespDto);
        }
        return apiRespDtos;
    }

    private List<Long> getApiIdByCondition(String domainCode, String sceneCode) {
        List<Object> sceneCodes = new ArrayList<String>();
        List<Long> apiIds = new ArrayList<Long>();
        if (!StringUtils.isEmpty((CharSequence)domainCode)) {
            CapabilityEo capabilityEo = new CapabilityEo();
            capabilityEo.setParentCode("ROOT_NODE");
            capabilityEo.setDomain(domainCode);
            List sceneEos = this.capabilityDas.select((BaseEo)capabilityEo);
            if (!CollectionUtils.isEmpty((Collection)sceneEos)) {
                sceneCodes = sceneEos.stream().map(StdCapabilityEo::getCode).collect(Collectors.toList());
                if (!StringUtils.isEmpty((CharSequence)sceneCode) && !sceneCodes.contains(sceneCode)) {
                    return apiIds;
                }
            }
        } else if (!StringUtils.isEmpty((CharSequence)sceneCode)) {
            sceneCodes.add(sceneCode);
        }
        if (!CollectionUtils.isEmpty(sceneCodes)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"scene_code", (Object)StringUtils.join(sceneCodes, (String)",")));
            ApiSceneRelationEo relationEo = new ApiSceneRelationEo();
            relationEo.setSqlFilters(sqlFilters);
            List apiSceneRelationEos = this.relationDas.select((BaseEo)relationEo);
            if (!CollectionUtils.isEmpty((Collection)apiSceneRelationEos)) {
                apiIds = apiSceneRelationEos.stream().map(StdApiSceneRelationEo::getApiId).collect(Collectors.toList());
            }
        }
        return apiIds;
    }

    @Override
    public List<RealmApiRespDto> queryRealmApi(RealmApiQueryReqDto realmApiQueryReqDto) {
        List<ApiEo> apiEos;
        ArrayList<RealmApiRespDto> realmApiRespDtos = new ArrayList<RealmApiRespDto>();
        ApiEo queryEo = new ApiEo();
        if (StringUtils.isNotBlank((CharSequence)realmApiQueryReqDto.getApiName())) {
            queryEo.setApiName(realmApiQueryReqDto.getApiName());
        }
        if (CollectionUtils.isNotEmpty(apiEos = this.getApiByRealmCode(realmApiQueryReqDto.getRealmCode(), queryEo))) {
            Map<String, List<ApiEo>> apiGroup = apiEos.stream().filter(eo -> StringUtils.isNotBlank((CharSequence)eo.getGroupName())).collect(Collectors.groupingBy(StdApiEo::getGroupName));
            if (apiGroup == null || apiGroup.size() == 0) {
                RealmApiRespDto realmApiRespDto = new RealmApiRespDto();
                ArrayList apiDtos = new ArrayList();
                DtoHelper.eoList2DtoList(apiEos, apiDtos, ApiDto.class);
                realmApiRespDto.setApiDtos(apiDtos);
                realmApiRespDtos.add(realmApiRespDto);
                return realmApiRespDtos;
            }
            for (String groupName : apiGroup.keySet()) {
                List<ApiEo> eos = apiGroup.get(groupName);
                if (!CollectionUtils.isNotEmpty(eos)) continue;
                if (StringUtils.isNotBlank((CharSequence)groupName)) {
                    groupName = this.cutGroupName(groupName);
                }
                RealmApiRespDto realmApiRespDto = new RealmApiRespDto();
                realmApiRespDto.setGroupName(groupName);
                realmApiRespDto.setGroupDesc(eos.get(0).getGroupDesc());
                ArrayList apiDtos = new ArrayList();
                DtoHelper.eoList2DtoList(eos, apiDtos, ApiDto.class);
                realmApiRespDto.setApiDtos(apiDtos);
                realmApiRespDtos.add(realmApiRespDto);
            }
        }
        return realmApiRespDtos;
    }

    private List<ApiEo> getApiByRealmCode(String realmCode, ApiEo apiEo) {
        if (StringUtils.isEmpty((CharSequence)realmCode)) {
            return new ArrayList<ApiEo>();
        }
        return this.apiDas.selectByRealmCode(realmCode, apiEo);
    }

    @Override
    public List<RealmErrorCodeRespDto> queryRealmErrorCode(RealmErrorCodeQueryReqDto realmErrorCodeQueryReqDto) {
        ArrayList<RealmErrorCodeRespDto> realmErrorCodeRespDtos = new ArrayList<RealmErrorCodeRespDto>();
        ErrorCodeEo errorCodeEo = new ErrorCodeEo();
        errorCodeEo.setModuleCode(realmErrorCodeQueryReqDto.getRealmCode());
        errorCodeEo.setCode(realmErrorCodeQueryReqDto.getErrorCode());
        List errorCodeEos = this.errorCodeDas.select((BaseEo)errorCodeEo);
        DtoHelper.eoList2DtoList((Collection)errorCodeEos, realmErrorCodeRespDtos, RealmErrorCodeRespDto.class);
        return realmErrorCodeRespDtos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApiBatch(ApiBatchDto apiBatchDto) {
        if (apiBatchDto == null || StringUtils.isBlank((CharSequence)apiBatchDto.getCenterName())) {
            throw new BizException("\u53c2\u6570\u6216\u4e2d\u5fc3\u540d\u4e0d\u80fd\u4e3anull");
        }
        String moduleCode = apiBatchDto.getCenterCode();
        String moduleName = apiBatchDto.getCenterName();
        String version = apiBatchDto.getVersion();
        try {
            boolean lock = this.cacheService.setCache(moduleCode, (Object)moduleCode, 20);
            if (lock) {
                ModuleEo moduleEo = new ModuleEo();
                moduleEo.setModuleCode(moduleCode);
                this.moduleDas.delete((BaseEo)moduleEo);
                ModuleEo insertEo = new ModuleEo();
                insertEo.setModuleCode(moduleCode);
                insertEo.setModuleName(moduleName);
                this.moduleDas.insert((BaseEo)insertEo);
                logger.info("apiMQ\u5904\u7406\u63d2\u5165\u4e2d\u5fc3\u6210\u529f");
            }
        }
        catch (Throwable e) {
            logger.info("\u83b7\u53d6\u9501\u51fa\u9519\uff1a" + moduleCode + COLON_EN + e.getMessage());
        }
        finally {
            this.cacheService.delCache(moduleCode);
        }
        ArrayList<ApiEo> updateEos = new ArrayList<ApiEo>();
        ArrayList<ApiEo> insertEos = new ArrayList<ApiEo>();
        List groupList = apiBatchDto.getApiList();
        if (CollectionUtils.isNotEmpty((Collection)groupList)) {
            for (ApiBatchDto.ApiList group : groupList) {
                List apiList = group.getPaths();
                if (!CollectionUtils.isNotEmpty((Collection)apiList)) continue;
                for (ApiBatchDto.ApiList.PathList api : apiList) {
                    ApiEo eo = new ApiEo();
                    CubeBeanUtils.copyProperties((Object)eo, (Object)api, (String[])new String[0]);
                    eo.setVersion(version);
                    eo.setRequestParam(JSONObject.toJSONString((Object)api.getRequestParams()));
                    eo.setResponseParam(JSONObject.toJSONString((Object)api.getResponseParam()));
                    eo.setGroupName(group.getGroupName());
                    eo.setGroupDesc(group.getGroupDesc());
                    eo.setModuleCode(moduleCode);
                    eo.setStatus(Integer.valueOf(1));
                    ApiEo queryEo = new ApiEo();
                    queryEo.setPath(api.getPath());
                    queryEo.setMethod(api.getMethod());
                    queryEo.setModuleCode(apiBatchDto.getCenterCode());
                    List exsitEo = this.apiDas.select((BaseEo)queryEo);
                    if (CollectionUtils.isNotEmpty((Collection)exsitEo)) {
                        eo.setId(((ApiEo)exsitEo.get(0)).getId());
                        updateEos.add(eo);
                        continue;
                    }
                    insertEos.add(eo);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(updateEos)) {
            for (ApiEo updateEo : updateEos) {
                this.apiDas.updateSelective((BaseEo)updateEo);
            }
        }
        if (CollectionUtils.isNotEmpty(insertEos)) {
            this.apiDas.insertBatch(insertEos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addErrorCodeBatch(List<ErrorCodeDto> errorCodeDtos) {
        Set moduleCodes = errorCodeDtos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getModuleCode())).map(ErrorCodeDto::getModuleCode).collect(Collectors.toSet());
        if (!CollectionUtils.isNotEmpty(moduleCodes) || !CollectionUtils.isNotEmpty(errorCodeDtos)) {
            throw new BizException(CenterDataExceptionCode.PARAM_INVALID.getCode(), CenterDataExceptionCode.PARAM_INVALID.getMsg());
        }
        ErrorCodeEo errorCodeEo = new ErrorCodeEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"module_code", (Object)StringUtils.join(moduleCodes, (String)",")));
        errorCodeEo.setSqlFilters(sqlFilters);
        this.errorCodeDas.delete((BaseEo)errorCodeEo);
        ArrayList errorCodeEos = new ArrayList();
        DtoHelper.dtoList2EoList(errorCodeDtos, errorCodeEos, ErrorCodeEo.class);
        this.errorCodeDas.insertBatch(errorCodeEos);
        Map<String, String> moduleMap = errorCodeDtos.stream().collect(Collectors.toMap(ErrorCodeDto::getModuleCode, ErrorCodeDto::getModuleName, (k1, k2) -> k1));
        for (String moduleCode : moduleMap.keySet()) {
            try {
                boolean lock = this.cacheService.setCache(moduleCode, (Object)moduleCode, 20);
                if (!lock) continue;
                ModuleEo moduleEo = new ModuleEo();
                moduleEo.setModuleCode(moduleCode);
                this.moduleDas.delete((BaseEo)moduleEo);
                ModuleEo insertEo = new ModuleEo();
                insertEo.setModuleCode(moduleCode);
                insertEo.setModuleName(moduleMap.get(moduleCode));
                this.moduleDas.insert((BaseEo)insertEo);
                logger.info("\u9519\u8bef\u7801MQ\u5904\u7406\u63d2\u5165\u4e2d\u5fc3\u6210\u529f");
            }
            catch (Throwable e) {
                logger.info("\u83b7\u53d6\u9501\u51fa\u9519\uff1a" + moduleCode + COLON_EN + e.getMessage());
            }
            finally {
                this.cacheService.delCache(moduleCode);
            }
        }
    }

    @Override
    public Integer countCenters() {
        DomainEo domainEo = new DomainEo();
        domainEo.setDr(0);
        return this.domainDas.count((BaseEo)domainEo);
    }

    @Override
    public List<ApiBaseRespDto> queryApiBaseInfoByPaths(ApiBaseReqDto apiBaseReqDto) {
        Map<String, TwoTuple<String, Long>> moduleCodeMap = this.queryGroupNameMap();
        HashMap moduleCode2AppCodeMap = Maps.newHashMap();
        List domainAppEos = this.domainAppDas.selectAll();
        if (CollectionUtils.isNotEmpty((Collection)domainAppEos)) {
            domainAppEos.forEach(domainAppEo -> moduleCode2AppCodeMap.put(domainAppEo.getDomain(), domainAppEo.getApplication()));
        }
        ApiEo selectParam = new ApiEo();
        if (StringUtils.isNotEmpty((CharSequence)apiBaseReqDto.getModuleCode())) {
            selectParam.setModuleCode(apiBaseReqDto.getModuleCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)apiBaseReqDto.getMethod())) {
            selectParam.setMethod(apiBaseReqDto.getMethod());
        }
        selectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("path", apiBaseReqDto.getApiPaths()).get());
        List list = this.apiDas.select((BaseEo)selectParam);
        return list.stream().map(apiEo -> {
            ApiBaseRespDto apiBaseRespDto = new ApiBaseRespDto();
            apiBaseRespDto.setApiName(apiEo.getApiName());
            apiBaseRespDto.setModuleName(apiEo.getApiName());
            apiBaseRespDto.setPath(apiEo.getPath());
            apiBaseRespDto.setRequestMethod(apiEo.getMethod());
            apiBaseRespDto.setModuleCode((String)moduleCode2AppCodeMap.get(apiEo.getModuleCode()));
            apiBaseRespDto.setId(apiEo.getId());
            TwoTuple name2CountTuple = (TwoTuple)moduleCodeMap.get(apiEo.getModuleCode());
            if (name2CountTuple != null) {
                apiBaseRespDto.setModuleName((String)name2CountTuple.getFirst());
            }
            return apiBaseRespDto;
        }).collect(Collectors.toList());
    }

    @Override
    public PageInfo<ModuleDto> queryModuleByPage(ModuleDto moduleDto, Integer pageNum, Integer pageSize) {
        DomainEo domainEo = new DomainEo();
        domainEo.setCode(moduleDto.getModuleCode());
        PageInfo pageInfo = this.domainDas.selectPage((BaseEo)domainEo, pageNum, pageSize);
        ArrayList<ModuleDto> moduleDtos = new ArrayList<ModuleDto>();
        if (null != pageInfo && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            for (DomainEo eo : pageInfo.getList()) {
                ModuleDto dto = this.toModuleDto(eo);
                ApiGroupDto apiGroupDto = new ApiGroupDto();
                apiGroupDto.setModuleCode(dto.getModuleCode());
                List<String> groupNames = this.queryGroupName(apiGroupDto);
                if (CollectionUtils.isNotEmpty(groupNames)) {
                    dto.setGroupNames(groupNames);
                } else {
                    dto.setGroupNames(new ArrayList());
                }
                moduleDtos.add(dto);
            }
        }
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList(moduleDtos);
        return dtoPageInfo;
    }

    private ModuleDto toModuleDto(DomainEo domainEo) {
        ModuleDto moduleDto = new ModuleDto();
        moduleDto.setModuleCode(domainEo.getCode());
        moduleDto.setModuleName(domainEo.getName());
        moduleDto.setModuleDesc(domainEo.getRemark());
        return moduleDto;
    }

    @Override
    public List<ApiComboBoxRespDto> comboBoxList(ApiComboBoxReqDto apiComboBoxReqDto) {
        ApiEo selectParam = new ApiEo();
        selectParam.setModuleCode(apiComboBoxReqDto.getModuleCode());
        List list = this.apiDas.select((BaseEo)selectParam);
        HashMap moduleCode2AppCodeMap = Maps.newHashMap();
        List domainAppEos = this.domainAppDas.selectAll();
        if (CollectionUtils.isNotEmpty((Collection)domainAppEos)) {
            domainAppEos.forEach(domainAppEo -> moduleCode2AppCodeMap.put(domainAppEo.getDomain(), domainAppEo.getApplication()));
        }
        return list.stream().map(apiEo -> new ApiComboBoxRespDto(apiEo.getApiName(), apiEo.getMethod(), apiEo.getPath(), (String)moduleCode2AppCodeMap.get(apiEo.getModuleCode()))).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdateBundleApi(BundleApisRespDto bundleApisRespDto, String bundleCode, String dbVersion, String domain) {
        List bundleApiList = bundleApisRespDto.getApis();
        ArrayList<ApiEo> newApiEoList = new ArrayList<ApiEo>();
        if (CollectionUtils.isNotEmpty((Collection)bundleApiList)) {
            List<CapabilityEo> capabilityEos;
            Object capabilityCodes;
            ArrayList pathForProCapList = new ArrayList();
            HashMap<String, String> capCode2DomainCode = new HashMap();
            for (BundleApiRespDto bundleApi : bundleApiList) {
                List pathReqList = bundleApi.getPaths();
                if (!CollectionUtils.isNotEmpty((Collection)pathReqList)) continue;
                pathForProCapList.addAll(pathReqList);
            }
            if (CollectionUtils.isNotEmpty(pathForProCapList) && CollectionUtils.isNotEmpty((Collection)(capabilityCodes = pathForProCapList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCapabilityCode())).map(BundleApiRespDto.Path::getCapabilityCode).collect(Collectors.toSet()))) && CollectionUtils.isNotEmpty(capabilityEos = this.capabilityService.getCapabilityByCodes(new ArrayList<String>((Collection<String>)capabilityCodes)))) {
                capCode2DomainCode = capabilityEos.stream().collect(Collectors.toMap(StdCapabilityEo::getCode, StdCapabilityEo::getDomain, (k1, k2) -> k1));
            }
            for (BundleApiRespDto bundleApi : bundleApiList) {
                List pathList = bundleApi.getPaths();
                if (!CollectionUtils.isNotEmpty((Collection)pathList)) continue;
                for (BundleApiRespDto.Path api : pathList) {
                    ApiEo apiEo = this.getApiEo((BundleBaseDto)bundleApisRespDto, bundleCode, bundleApi, api, domain, capCode2DomainCode);
                    newApiEoList.add(apiEo);
                }
            }
        }
        ApiEo apiEoWithMoudleCode = new ApiEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.isNull((String)"group_id"));
        sqlFilters.add(SqlFilter.isNull((String)"artifact_id"));
        sqlFilters.add(SqlFilter.eq((String)"module_code", (Object)bundleApisRespDto.getArtifactId()));
        apiEoWithMoudleCode.setSqlFilters(sqlFilters);
        List deleteEoByModule = this.apiDas.select((BaseEo)apiEoWithMoudleCode);
        this.apiDas.logicDeleteBatch(deleteEoByModule);
        if (dbVersion == null) {
            this.apiDas.addBatch(newApiEoList);
        } else {
            List apiEoList = this.apiDas.select(bundleCode);
            if (apiEoList == null || apiEoList.size() == 0) {
                this.apiDas.addBatch(newApiEoList);
            } else {
                ArrayList apiVoList = new ArrayList();
                CubeBeanUtils.copyCollection(apiVoList, (Collection)apiEoList, BundleApiVo.class);
                ArrayList newApiVoList = new ArrayList();
                CubeBeanUtils.copyCollection(newApiVoList, newApiEoList, BundleApiVo.class);
                List deleteVos = (List)CollectionUtils.subtract(apiVoList, newApiVoList);
                List insertVos = (List)CollectionUtils.subtract(newApiVoList, apiVoList);
                ArrayList deleteEos = new ArrayList();
                ArrayList insertEos = new ArrayList();
                CubeBeanUtils.copyCollection(deleteEos, (Collection)deleteVos, ApiEo.class);
                CubeBeanUtils.copyCollection(insertEos, (Collection)insertVos, ApiEo.class);
                ArrayList<ApiEo> updateEos = new ArrayList<ApiEo>();
                block3: for (ApiEo apiEo : apiEoList) {
                    for (ApiEo newApiEo : newApiEoList) {
                        if (!Objects.equals(apiEo.getPath(), newApiEo.getPath()) || !Objects.equals(apiEo.getMethod(), newApiEo.getMethod())) continue;
                        CubeBeanUtils.copyProperties((Object)apiEo, (Object)newApiEo, (String[])new String[]{"id"});
                        apiEo.setUpdateTime(new Date());
                        updateEos.add(apiEo);
                        continue block3;
                    }
                }
                this.apiDas.deleteBatch(deleteEos);
                this.apiDas.addBatch(insertEos);
                if (this.batchUpdateSizeConfig.isEnable()) {
                    this.apiDas.batchUpdateInJoin(this.batchUpdateSizeConfig.readCount("bd_api"), updateEos);
                } else {
                    this.apiDas.updateBatch(updateEos);
                }
            }
        }
    }

    private ApiEo getApiEo(BundleBaseDto bundleBaseDto, String bundleCode, BundleApiRespDto bundleApi, BundleApiRespDto.Path api, String domain, Map<String, String> capCode2DomainCode) {
        ApiEo apiEo = new ApiEo();
        CubeBeanUtils.copyProperties((Object)apiEo, (Object)api, (String[])new String[0]);
        apiEo.setBundleGroupId(bundleBaseDto.getGroupId());
        apiEo.setBundleArtifactId(bundleBaseDto.getArtifactId());
        apiEo.setBundleCode(bundleCode);
        apiEo.setVersion(bundleBaseDto.getVersion());
        apiEo.setGroupName(bundleApi.getGroupName());
        apiEo.setGroupDesc(bundleApi.getGroupDesc());
        apiEo.setRequestParam(JSONObject.toJSONString((Object)api.getRequestParams()));
        apiEo.setResponseParam(JSONObject.toJSONString((Object)api.getResponseParam()));
        apiEo.setStatus(Integer.valueOf(1));
        String capabilityCode = api.getCapabilityCode();
        if (StringUtils.isNotEmpty((CharSequence)capabilityCode)) {
            if (null == capCode2DomainCode || StringUtils.isBlank((CharSequence)capCode2DomainCode.get(capabilityCode))) {
                apiEo.setModuleCode(domain);
            } else {
                apiEo.setModuleCode(capCode2DomainCode.get(capabilityCode));
            }
        } else {
            apiEo.setModuleCode(domain);
        }
        return apiEo;
    }

    @Override
    public PageInfo<BundleApiQueryRespDto> queryByPage(BundleApiQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo<BundleApiQueryRespDto> dtoPageInfo;
        ApiEo apiEo = new ApiEo();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)apiEo);
        apiEo.setStatus(Integer.valueOf(1));
        apiEo.setVersion(queryReqDto.getBundleVersion());
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getApiName())) {
            filters.add(SqlFilter.like((String)"api_name", (Object)("%" + queryReqDto.getApiName() + "%")));
            apiEo.setApiName(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getPath())) {
            filters.add(SqlFilter.like((String)"path", (Object)("%" + queryReqDto.getPath() + "%")));
            apiEo.setPath(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getBundleCode())) {
            List<String> codeList = this.bundleService.getBundleCodeList(queryReqDto.getBundleCode());
            if (CollectionUtils.isNotEmpty(codeList)) {
                filters.add(SqlFilter.in((String)"bundle_code", (Object)StringUtils.join(codeList, (String)",")));
                apiEo.setBundleCode(null);
            } else {
                return new PageInfo();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getModuleCode())) {
            filters.add(SqlFilter.in((String)"module_code", (Object)queryReqDto.getModuleCode()));
            apiEo.setModuleCode(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getFirstCapabilityCode())) {
            List<String> capabilityCodeList = Arrays.asList(queryReqDto.getFirstCapabilityCode().split(","));
            List<CapabilityEo> capabilityEoList = this.capabilityService.getChildrenEoByCapabilityCodeList(capabilityCodeList);
            if (CollectionUtils.isNotEmpty(capabilityEoList)) {
                List codeList = capabilityEoList.stream().map(StdCapabilityEo::getCode).collect(Collectors.toList());
                filters.add(SqlFilter.in((String)"capability_code", (Object)StringUtils.join(codeList, (String)",")));
                apiEo.setCapabilityCode(null);
            } else {
                return new PageInfo();
            }
        }
        apiEo.setSqlFilters(filters);
        apiEo.setOrderBy("module_code is NULL,module_code");
        PageInfo eoPageInfo = this.apiDas.selectPage((BaseEo)apiEo, pageNum, pageSize);
        if (CollectionUtils.isEmpty((Collection)eoPageInfo.getList()) && StringUtils.isNotEmpty((CharSequence)queryReqDto.getBundleVersion())) {
            ApiHistoryEo historyEo = new ApiHistoryEo();
            CubeBeanUtils.copyProperties((Object)historyEo, (Object)apiEo, (String[])new String[]{"sqlFilters"});
            historyEo.setSqlFilters(filters);
            PageInfo historyEoPageInfo = this.apiHistoryDas.selectPage((BaseEo)historyEo, pageNum, pageSize);
            dtoPageInfo = QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)historyEoPageInfo, BundleApiQueryRespDto.class);
        } else {
            dtoPageInfo = QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)eoPageInfo, BundleApiQueryRespDto.class);
        }
        if (CollectionUtils.isNotEmpty((Collection)dtoPageInfo.getList())) {
            for (BundleApiQueryRespDto respDto : dtoPageInfo.getList()) {
                this.setFirstCapabilityName(respDto);
                this.setDomainName(respDto);
            }
            List<BundleApiQueryRespDto> respDtos = this.processApiVersion(dtoPageInfo.getList());
            dtoPageInfo.setList(respDtos);
        }
        return dtoPageInfo;
    }

    private void setDomainName(BundleApiQueryRespDto respDto) {
        if (StringUtils.isNotEmpty((CharSequence)respDto.getModuleCode())) {
            respDto.setDomainName(this.capabilityDomainService.getDomainNameByDomainCode(respDto.getModuleCode()));
        }
    }

    private void setFirstCapabilityName(BundleApiQueryRespDto respDto) {
        List rootNodelist;
        List<CapabilityEo> capabilityEoList;
        if (StringUtils.isNotEmpty((CharSequence)respDto.getCapabilityCode()) && CollectionUtils.isNotEmpty(capabilityEoList = this.capabilityService.getCapabilityAndParentByCodes(Collections.singletonList(respDto.getCapabilityCode()))) && CollectionUtils.isNotEmpty(rootNodelist = capabilityEoList.stream().filter(capabilityEo -> "ROOT_NODE".equals(capabilityEo.getParentCode())).collect(Collectors.toList()))) {
            CapabilityEo firstCapabilityEo = (CapabilityEo)rootNodelist.get(0);
            respDto.setFirstCapabilityCode(firstCapabilityEo.getCode());
            respDto.setFirstCapabilityName(firstCapabilityEo.getName());
        }
    }

    private List<BundleApiQueryRespDto> processApiVersion(List<BundleApiQueryRespDto> apiQueryRespDtos) {
        ArrayList<BundleApiQueryRespDto> respDtos = new ArrayList<BundleApiQueryRespDto>();
        HashMap pathWithoutVersion2ApiList = new HashMap();
        HashMap moduleCode2Api = new HashMap();
        apiQueryRespDtos.stream().map(item -> {
            ArrayList<BundleApiQueryRespDto> values;
            String pathWithMethodAfterPro = null;
            String path = item.getPath();
            if (StringUtils.isNotBlank((CharSequence)path) && path.startsWith("/v")) {
                int index = path.indexOf("/");
                if ((index = path.indexOf("/", index + 1)) > 0) {
                    pathWithMethodAfterPro = path.substring(index);
                }
            }
            if (StringUtils.isBlank(pathWithMethodAfterPro)) {
                pathWithMethodAfterPro = path;
            }
            if (CollectionUtils.isNotEmpty((Collection)(values = (ArrayList<BundleApiQueryRespDto>)pathWithoutVersion2ApiList.get(pathWithMethodAfterPro = pathWithMethodAfterPro + item.getMethod())))) {
                values.add((BundleApiQueryRespDto)item);
            } else {
                values = new ArrayList<BundleApiQueryRespDto>();
                values.add((BundleApiQueryRespDto)item);
            }
            pathWithoutVersion2ApiList.put(pathWithMethodAfterPro, values);
            return null;
        }).collect(Collectors.toList());
        for (String key : pathWithoutVersion2ApiList.keySet()) {
            List apiList = (List)pathWithoutVersion2ApiList.get(key);
            String moduleCode = ((BundleApiQueryRespDto)apiList.get(0)).getModuleCode();
            ArrayList moduleApis = (ArrayList)moduleCode2Api.get(moduleCode);
            if (CollectionUtils.isEmpty((Collection)moduleApis)) {
                moduleApis = new ArrayList();
            }
            moduleApis.addAll(apiList);
            moduleCode2Api.put(moduleCode, moduleApis);
        }
        for (String moduleCode : moduleCode2Api.keySet()) {
            respDtos.addAll((Collection)moduleCode2Api.get(moduleCode));
        }
        return respDtos;
    }

    private List<ApiDetailRespDto.Param> processParam(List<ApiDetailRespDto.Param> params) {
        if (CollectionUtils.isEmpty(params)) {
            return params;
        }
        for (ApiDetailRespDto.Param p : params) {
            if (p == null) continue;
            p.setName(this.cutPre(p.getName()));
            p.setType(this.cutPre(p.getType()));
            List childrenParam = p.getProperties();
            if (!CollectionUtils.isNotEmpty((Collection)childrenParam)) continue;
            List<ApiDetailRespDto.Param> properties = this.processParam(childrenParam);
            List<Object> results = new ArrayList();
            if (CollectionUtils.isNotEmpty(properties)) {
                results = properties.stream().filter(Objects::nonNull).sorted(new Comparator<ApiDetailRespDto.Param>(){

                    @Override
                    public int compare(ApiDetailRespDto.Param o1, ApiDetailRespDto.Param o2) {
                        int r = Boolean.compare(o2.getRequired(), o1.getRequired());
                        if (r == 0) {
                            if (o1.getName() == null || o2.getName() == null) {
                                return r;
                            }
                            r = o1.getName().compareToIgnoreCase(o2.getName());
                            return r > 0 ? 1 : -1;
                        }
                        return r;
                    }
                }).collect(Collectors.toList());
            }
            p.setProperties(results);
        }
        return params.stream().filter(Objects::nonNull).sorted(new Comparator<ApiDetailRespDto.Param>(){

            @Override
            public int compare(ApiDetailRespDto.Param o1, ApiDetailRespDto.Param o2) {
                int r = Boolean.compare(o2.getRequired(), o1.getRequired());
                if (r == 0) {
                    if (o1.getName() == null || o2.getName() == null) {
                        return r;
                    }
                    r = o1.getName().compareToIgnoreCase(o2.getName());
                    return r > 0 ? 1 : -1;
                }
                return r;
            }
        }).collect(Collectors.toList());
    }

    private String cutPre(String str) {
        int lastIndex;
        String reg = "([\\w$]+\\.)+";
        if ((str = str.replaceAll(reg, "")).startsWith("RestResponse<") && (lastIndex = (str = str.replace("RestResponse<", "")).lastIndexOf(">")) > 0) {
            str = str.substring(0, lastIndex);
        }
        return str;
    }

    @Override
    public List<ApiDto> queryByModuleCode(String moduleCode) {
        if (StringUtils.isEmpty((CharSequence)moduleCode)) {
            return Collections.emptyList();
        }
        DomainAppEo eo = new DomainAppEo();
        eo.setApplication(moduleCode);
        DomainAppEo domainAppEo = (DomainAppEo)this.domainAppDas.selectOne((BaseEo)eo);
        if (domainAppEo == null) {
            logger.error("\u672a\u627e\u5230\u8be5\u4e2d\u5fc3\u7f16\u7801\u5bf9\u5e94\u7684\u9886\u57df\u4fe1\u606f\uff1a{}", (Object)moduleCode);
            return Collections.emptyList();
        }
        ApiEo apiEo = new ApiEo();
        apiEo.setModuleCode(domainAppEo.getDomain());
        List apiEos = this.apiDas.selectList((BaseEo)apiEo, Integer.valueOf(1), Integer.valueOf(9999));
        ArrayList<ApiDto> result = new ArrayList<ApiDto>();
        DtoHelper.eoList2DtoList((Collection)apiEos, result, ApiDto.class);
        return result;
    }

    @Override
    public List<ApiDto> queryByAppCodeAndVersion(String code, String version) {
        List<AppBundleRespDto> appBundleRespDtos = this.appBundleService.queryByAppCodeAndVersion(code, version);
        if (appBundleRespDtos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ApiDto> result = new ArrayList<ApiDto>();
        for (AppBundleRespDto dto : appBundleRespDtos) {
            List<ApiDto> list = this.queryApiDtosByBundleCodeAndVersion(dto.getBundleCode(), dto.getVersion());
            result.addAll(list);
        }
        return result;
    }

    private List<ApiDto> queryApiDtosByBundleCodeAndVersion(String bundleCode, String version) {
        ApiHistoryEo eo = new ApiHistoryEo();
        eo.setVersion(version);
        eo.setBundleCode(bundleCode);
        List apiHistoryEos = this.apiHistoryDas.selectList((BaseEo)eo, Integer.valueOf(1), Integer.valueOf(9999));
        if (apiHistoryEos.isEmpty()) {
            ApiEo apiEo = new ApiEo();
            apiEo.setBundleCode(bundleCode);
            List apiEos = this.apiDas.selectList((BaseEo)apiEo, Integer.valueOf(1), Integer.valueOf(9999));
            if (apiEos.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<ApiDto> result = new ArrayList<ApiDto>();
            CubeBeanUtils.copyCollection(result, (Collection)apiEos, ApiDto.class);
            return result;
        }
        ArrayList<ApiDto> result = new ArrayList<ApiDto>();
        CubeBeanUtils.copyCollection(result, (Collection)apiHistoryEos, ApiDto.class);
        return result;
    }
}

