/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.starter.bundle.dto.BundleDescDto;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.AppBundleReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.BundleLoadedNotifyDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.BundleLoadedQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AppBundleRespDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.BundleLoadedRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.AppInfoDto;
import com.dtyunxi.yundt.cube.center.func.biz.service.IAppBundleService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IAppInfoService;
import com.dtyunxi.yundt.cube.center.func.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.func.dao.das.AppBundleDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.AppBundleEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdAppBundleEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class AppBundleServiceImpl
implements IAppBundleService {
    private static final Logger logger = LoggerFactory.getLogger(AppBundleServiceImpl.class);
    @Resource
    private AppBundleDas appBundleDas;
    @Autowired
    protected IAppInfoService appInfoService;
    @Resource
    private ICommonsMqService commonsMqService;

    @Override
    public Long addAppBundle(AppBundleReqDto addReqDto) {
        AppBundleEo appBundleEo = new AppBundleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)appBundleEo);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)addReqDto.getVersion())) {
            appBundleEo.setVersion("");
        }
        this.appBundleDas.insert((BaseEo)appBundleEo);
        return appBundleEo.getId();
    }

    public void saveAppInfo(BundleDescDto message) {
        try {
            AppInfoDto appDto = new AppInfoDto();
            appDto.setCode(message.getServiceId());
            appDto.setName(org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)message.getServiceName()) ? message.getServiceId() : message.getServiceName());
            appDto.setVersion(message.getApplicationVersion());
            this.appInfoService.addAndModify(appDto);
        }
        catch (Exception e) {
            logger.error("\u5e94\u7528\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public List<Long> addModifyAppBundle(List<AppBundleReqDto> addReqDtoList) {
        ArrayList<Long> ids = new ArrayList<Long>();
        HashMap<String, Boolean> bundleLoadedMap = new HashMap<String, Boolean>();
        if (CollectionUtils.isEmpty(addReqDtoList)) {
            return ids;
        }
        AppBundleEo queryEo = new AppBundleEo();
        queryEo.setCode(addReqDtoList.get(0).getCode());
        queryEo.setVersion(addReqDtoList.get(0).getVersion());
        List eoList = this.appBundleDas.select((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(1000));
        for (AppBundleReqDto addReqDto : addReqDtoList) {
            if (null == eoList) {
                ids.add(this.addAppBundle(addReqDto));
                bundleLoadedMap.put(addReqDto.getBundleCode(), true);
                continue;
            }
            if (eoList.stream().noneMatch(eo -> eo.getBundleCode().equals(addReqDto.getBundleCode()))) {
                ids.add(this.addAppBundle(addReqDto));
                bundleLoadedMap.put(addReqDto.getBundleCode(), true);
                continue;
            }
            ids.add(this.modifyAppBundle(addReqDto));
        }
        List reqBundleCodes = addReqDtoList.stream().map(AppBundleReqDto::getBundleCode).collect(Collectors.toList());
        List dbBundleCodes = eoList.stream().map(StdAppBundleEo::getBundleCode).collect(Collectors.toList());
        dbBundleCodes.removeAll(reqBundleCodes);
        logger.info("\u5f85\u5220\u9664\u7684\u529f\u80fd\u5305\u7f16\u7801\uff0c{}", (Object)dbBundleCodes.toString());
        for (String reqBundleCode : dbBundleCodes) {
            AppBundleEo deleteEo = new AppBundleEo();
            deleteEo.setCode(addReqDtoList.get(0).getCode());
            deleteEo.setVersion(addReqDtoList.get(0).getVersion());
            deleteEo.setBundleCode(reqBundleCode);
            this.appBundleDas.logicDelete((BaseEo)deleteEo);
            bundleLoadedMap.put(reqBundleCode, false);
        }
        logger.info("\u5e94\u7528\u529f\u80fd\u5305\u5173\u7cfb\u65b0\u589e\u6216\u8005\u4fee\u6539\u7684ids\uff0c{}", (Object)((Object)ids).toString());
        BundleLoadedNotifyDto bundleLoadedDto = new BundleLoadedNotifyDto();
        bundleLoadedDto.setBundleLoadedMap(bundleLoadedMap);
        this.commonsMqService.publishMessageAsync("APP_BUNDLE_RELATION_TOPIC", "APP_BUNDLE_RELATION_TAG", (Object)bundleLoadedDto);
        logger.info("\u529f\u80fd\u5305\u52a0\u8f7d\u60c5\u51b5\uff0cbundleLoadedDto\uff1a", JSON.toJSON((Object)bundleLoadedDto));
        return ids;
    }

    @Override
    public Long modifyAppBundle(AppBundleReqDto modifyReqDto) {
        AppBundleEo queryEo = new AppBundleEo();
        queryEo.setCode(modifyReqDto.getCode());
        queryEo.setVersion(modifyReqDto.getVersion());
        queryEo.setBundleCode(modifyReqDto.getBundleCode());
        queryEo = (AppBundleEo)this.appBundleDas.selectOne((BaseEo)queryEo);
        if (null == queryEo) {
            throw new BizException("11002", "\u627e\u4e0d\u5230\u5e94\u7528\u529f\u80fd\u5305\u7684\u5173\u7cfb\u8bb0\u5f55");
        }
        AppBundleEo appBundleEo = new AppBundleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)appBundleEo);
        appBundleEo.setId(queryEo.getId());
        this.appBundleDas.updateSelective((BaseEo)appBundleEo);
        return queryEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAppBundle(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.appBundleDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public AppBundleRespDto queryByBundleCodeAndVersion(String bundleCode, String version) {
        AppBundleEo appBundleQueryEo = new AppBundleEo();
        appBundleQueryEo.setBundleCode(bundleCode);
        appBundleQueryEo.setBundleVersion(version);
        AppBundleEo appBundleEo = (AppBundleEo)this.appBundleDas.selectOne((BaseEo)appBundleQueryEo);
        AssertUtil.isTrue(null != appBundleEo, "11002", "\u6839\u636e\u529f\u80fd\u5305\u7f16\u7801\u548c\u529f\u80fd\u5305\u7248\u672c\u53f7\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5e94\u7528");
        AppBundleRespDto appBundleRespDto = new AppBundleRespDto();
        DtoHelper.eo2Dto((BaseEo)appBundleEo, (BaseVo)appBundleRespDto);
        return appBundleRespDto;
    }

    @Override
    public BundleLoadedRespDto queryBundleLoadedInfo(BundleLoadedQueryReqDto bundleLoadedQueryReqDto) {
        if (CollectionUtils.isEmpty((Collection)bundleLoadedQueryReqDto.getAppBundleReqDtoList())) {
            return null;
        }
        Set bundleCodes = bundleLoadedQueryReqDto.getAppBundleReqDtoList().stream().map(AppBundleReqDto::getBundleCode).collect(Collectors.toSet());
        AppBundleEo appBundleEo = new AppBundleEo();
        appBundleEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"bundle_code", bundleCodes)));
        List eos = this.appBundleDas.select((BaseEo)appBundleEo);
        ArrayList appBundleRespDtos = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eos, appBundleRespDtos, AppBundleRespDto.class);
        BundleLoadedRespDto bundleLoadedRespDto = new BundleLoadedRespDto();
        bundleLoadedRespDto.setBundleList(appBundleRespDtos);
        return bundleLoadedRespDto;
    }

    @Override
    public Map<String, List<AppBundleRespDto>> queryAllApp() {
        List appBundleEos = this.appBundleDas.selectAll();
        HashMap cache = new HashMap();
        HashMap<String, List<AppBundleRespDto>> result = new HashMap<String, List<AppBundleRespDto>>();
        appBundleEos.stream().filter(eo -> !StringUtils.isEmpty((Object)eo.getVersion())).map(eo -> {
            String key = eo.getVersion() + eo.getCode();
            if (cache.get(key) == null) {
                cache.put(key, eo);
                return eo;
            }
            return null;
        }).filter(Objects::nonNull).forEach(eo -> {
            String key = eo.getVersion();
            ArrayList<AppBundleRespDto> value = (ArrayList<AppBundleRespDto>)result.get(key);
            if (value == null) {
                value = new ArrayList<AppBundleRespDto>();
                result.put(key, value);
            }
            AppBundleRespDto respDto = new AppBundleRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)eo, (String[])new String[0]);
            value.add(respDto);
        });
        return result;
    }

    @Override
    public List<AppBundleRespDto> queryByAppCodeAndVersion(String appCode, String version) {
        AppBundleEo appBundleQueryEo = new AppBundleEo();
        appBundleQueryEo.setCode(appCode);
        appBundleQueryEo.setVersion(version);
        List eoList = this.appBundleDas.selectList((BaseEo)appBundleQueryEo, Integer.valueOf(1), Integer.valueOf(999));
        if (eoList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AppBundleRespDto> result = new ArrayList<AppBundleRespDto>(eoList.size());
        CubeBeanUtils.copyCollection(result, (Collection)eoList, AppBundleRespDto.class);
        return result;
    }
}

