/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.func.api.dto.AppInfoDto;
import com.dtyunxi.yundt.cube.center.func.biz.service.IAppInfoService;
import com.dtyunxi.yundt.cube.center.func.dao.das.AppInfoDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.AppInfoEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppInfoServiceImpl
implements IAppInfoService {
    @Autowired
    private AppInfoDas appInfoDas;

    @Override
    public void addAndModify(AppInfoDto appInfoDto) {
        if (StringUtils.isEmpty((CharSequence)appInfoDto.getCode()) || StringUtils.isEmpty((CharSequence)appInfoDto.getVersion())) {
            throw new BizException(String.format("\u5e94\u7528\u7f16\u7801\u548c\u5e94\u7528\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a\u3002code:%s, version:%s", appInfoDto.getCode(), appInfoDto.getVersion()));
        }
        AppInfoEo eo = new AppInfoEo();
        eo.setCode(appInfoDto.getCode());
        eo.setVersion(appInfoDto.getVersion());
        AppInfoEo appInfoEo = (AppInfoEo)this.appInfoDas.selectOne((BaseEo)eo);
        if (appInfoEo == null) {
            appInfoEo = new AppInfoEo();
            CubeBeanUtils.copyProperties((Object)appInfoEo, (Object)appInfoDto, (String[])new String[0]);
            this.appInfoDas.insert((BaseEo)appInfoEo);
        } else {
            CubeBeanUtils.copyProperties((Object)appInfoEo, (Object)appInfoDto, (String[])new String[]{"id"});
            this.appInfoDas.update((BaseEo)appInfoEo);
        }
    }

    @Override
    public Map<String, List<AppInfoDto>> queryAppListGroupByVersion() {
        List appInfoEos = this.appInfoDas.selectAll();
        if (appInfoEos.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)appInfoEos, AppInfoDto.class);
        return dtoList.stream().collect(Collectors.groupingBy(AppInfoDto::getVersion));
    }
}

