/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AppInstApiReqDto;
import com.dtyunxi.yundt.cube.center.func.biz.service.IAppInstApiService;
import com.dtyunxi.yundt.cube.center.func.dao.das.AppInstApiDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.AppInstApiEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="appInstApiService")
public class AppInstApiServiceImpl
implements IAppInstApiService {
    @Resource
    private AppInstApiDas appInstApiDas;

    @Override
    public Long addAppInstApi(AppInstApiReqDto addReqDto) {
        AppInstApiEo AppInstApiEo2 = new AppInstApiEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)AppInstApiEo2);
        this.appInstApiDas.insert((BaseEo)AppInstApiEo2);
        return AppInstApiEo2.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBatchAppInstApi(List<AppInstApiReqDto> appInstApiReqDtoList) {
        ArrayList<AppInstApiEo> appInstApiEoList = new ArrayList<AppInstApiEo>();
        HashSet<String> appCodeSet = new HashSet<String>(16);
        if (!CollectionUtils.isEmpty(appInstApiReqDtoList)) {
            for (AppInstApiReqDto appInstApiReqDto : appInstApiReqDtoList) {
                AppInstApiEo appInstApiEo = new AppInstApiEo();
                DtoHelper.dto2Eo((BaseVo)appInstApiReqDto, (BaseEo)appInstApiEo);
                appCodeSet.add(appInstApiEo.getAppCode());
                appInstApiEoList.add(appInstApiEo);
            }
            this.deleteExistData(appCodeSet);
            this.appInstApiDas.insertBatch(appInstApiEoList);
        }
    }

    private void deleteExistData(Set<String> appCodeSet) {
        for (String appCode : appCodeSet) {
            AppInstApiEo query = new AppInstApiEo();
            query.setAppCode(appCode);
            this.appInstApiDas.deleteByExample((BaseEo)query);
        }
    }

    @Override
    public void modifyAppInstApi(AppInstApiReqDto modifyReqDto) {
        AppInstApiEo AppInstApiEo2 = new AppInstApiEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)AppInstApiEo2);
        this.appInstApiDas.updateSelective((BaseEo)AppInstApiEo2);
    }

    @Override
    public void removeAppInstApi(Long id) {
        this.appInstApiDas.logicDeleteById(id);
    }

    @Override
    public AppInstApiReqDto queryById(Long id) {
        AppInstApiEo AppInstApiEo2 = (AppInstApiEo)this.appInstApiDas.selectByPrimaryKey(id);
        AppInstApiReqDto AppInstApiReqDto2 = new AppInstApiReqDto();
        DtoHelper.eo2Dto((BaseEo)AppInstApiEo2, (BaseVo)AppInstApiReqDto2);
        return AppInstApiReqDto2;
    }

    @Override
    public PageInfo<AppInstApiReqDto> queryByPage(AppInstApiReqDto reqDto, Integer pageNum, Integer pageSize) {
        AppInstApiEo AppInstApiEo2 = new AppInstApiEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)AppInstApiEo2);
        PageInfo eoPageInfo = this.appInstApiDas.selectPage((BaseEo)AppInstApiEo2, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, AppInstApiReqDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

