/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.ConfigQueryReq;
import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.constants.ParamSelectType;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizRuleBasicReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizid.BizConfigReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizid.BizConfigResDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizid.BizIdCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizid.BizIdModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizid.BizIdQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizid.SpaceIdConfigsReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizid.SpaceIdQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizIdAndBizSpaceDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizIdQueryResDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizIdentityRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizSpaceRespDto;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBizIdService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBizSpaceService;
import com.dtyunxi.yundt.cube.center.func.biz.service.impl.SysParamServiceImpl;
import com.dtyunxi.yundt.cube.center.func.biz.support.BusinessIdentityIdentifyService;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizExtImplDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizExtImplValueDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizExtensionDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizIdDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizSpaceDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.ConfigScopeDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.RBizRuleSpaceIdentityDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SpaceIdDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SysParamDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SysParamItemDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SysParamValueDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizExtImplValueEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizExtensionEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizIdEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ConfigScopeEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.RBizRuleSpaceIdentityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SpaceIdEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdBizExtImplEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdBizExtImplValueEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdBizSpaceEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSpaceIdEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSysParamItemEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSysParamValueEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SysParamEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SysParamValueEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BizIdServiceImpl
implements IBizIdService {
    public static String REDIS_PREFIX = "BizIdServiceImpl:queryBizIdentityByBizSpaceCode:";
    public static String REDIS_KEY_MAP = "BizIdServiceImpl:queryBizIdentityByBizSpaceCode:map";
    private static final Logger logger = LoggerFactory.getLogger(BizIdServiceImpl.class);
    @Resource
    private BizIdDas bizIdDas;
    @Resource
    private BizSpaceDas bizSpaceDas;
    @Resource
    private SpaceIdDas spaceIdDas;
    @Resource
    private SysParamDas sysParamDas;
    @Resource
    private BizExtensionDas bizExtensionDas;
    @Resource
    private SysParamItemDas sysParamItemDas;
    @Resource
    private BizExtImplDas bizExtImplDas;
    @Resource
    private SysParamValueDas sysParamValueDas;
    @Resource
    private BizExtImplValueDas bizExtImplValueDas;
    @Resource
    private ConfigScopeDas configScopeDas;
    @Resource
    private RBizRuleSpaceIdentityDas rBizRuleSpaceIdentityDas;
    @Resource
    private IContext context;
    @Resource
    private IBizSpaceService bizSpaceService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private BusinessIdentityIdentifyService businessIdentityIdentifyService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBizId(BizIdCreateReqDto reqDto) {
        BizIdEo record = new BizIdEo();
        record.setTenantId(this.context.tenantId());
        record.setCode(reqDto.getCode());
        if (this.bizIdDas.count((BaseEo)record) > 0) {
            throw new BizException("\u4e1a\u52a1\u8eab\u4efd\u7f16\u7801\u5df2\u5b58\u5728");
        }
        record = new BizIdEo();
        record.setTenantId(this.context.tenantId());
        record.setName(reqDto.getName());
        if (this.bizIdDas.count((BaseEo)record) > 0) {
            throw new BizException("\u4e1a\u52a1\u8eab\u4efd\u540d\u79f0\u5df2\u5b58\u5728");
        }
        BizIdEo bizIdEo = new BizIdEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)bizIdEo);
        bizIdEo.setStatus(Constants.ENABLE);
        this.bizIdDas.insert((BaseEo)bizIdEo);
        return bizIdEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBizId(BizIdModifyReqDto reqDto) {
        BizIdEo bizIdEo = this.bizIdDas.selectByCode(this.context.tenantId(), reqDto.getCode());
        if (bizIdEo == null) {
            throw new BizException("\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        BizIdEo record = new BizIdEo();
        record.setTenantId(this.context.tenantId());
        record.setName(reqDto.getName());
        record.setSqlFilters(Collections.singletonList(SqlFilter.ne((String)"id", (Object)bizIdEo.getId())));
        if (this.bizIdDas.count((BaseEo)record) > 0) {
            throw new BizException("\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0\u5df2\u5b58\u5728");
        }
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)bizIdEo, (String[])new String[]{"id", "code"});
        this.bizIdDas.updateSelective((BaseEo)bizIdEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBizId(Long tenantId, List<String> codes) {
        tenantId = this.context.tenantId();
        this.bizIdDas.logicDeleteByCodes(tenantId, codes);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void idSpace(Integer type, Long tenantId, String idCode, List<String> spaceCodes) {
        tenantId = this.context.tenantId();
        BizIdEo bizIdEo = this.bizIdDas.selectByCode(tenantId, idCode);
        if (bizIdEo == null) {
            throw new BizException("\u4e1a\u52a1\u8eab\u4efd\u4e0d\u5b58\u5728");
        }
        List bizSpaceEos = this.bizSpaceDas.selectByCodes(tenantId, spaceCodes);
        if (bizSpaceEos.size() != spaceCodes.size()) {
            spaceCodes.removeAll(bizSpaceEos.stream().map(StdBizSpaceEo::getCode).collect(Collectors.toList()));
            throw new BizException("\u4e0d\u5b58\u5728\u4e1a\u52a1\u7a7a\u95f4\u7f16\u7801\uff1a" + StringUtils.collectionToCommaDelimitedString(spaceCodes));
        }
        Map<String, SpaceIdEo> spaceIdMap = this.spaceIdDas.selectByIdCode(tenantId, idCode).stream().collect(Collectors.toMap(StdSpaceIdEo::getSpaceCode, e -> e));
        if (type == 1) {
            List inserts = spaceCodes.stream().filter(e -> !spaceIdMap.containsKey(e)).map(e -> {
                SpaceIdEo eo = new SpaceIdEo();
                eo.setIdCode(idCode);
                eo.setSpaceCode(e);
                eo.setExtension("");
                return eo;
            }).collect(Collectors.toList());
            this.spaceIdDas.insertBatch(inserts);
        } else if (type == 2) {
            spaceIdMap.values().stream().filter(e -> spaceCodes.contains(e.getSpaceCode())).forEach(e -> this.spaceIdDas.logicDeleteById(e.getId()));
        } else {
            throw new BizException("\u7c7b\u578b\u53ea\u80fd\u662f\u7ed1\u5b9a\u6216\u89e3\u7ed1");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void idSpaceConfigs(SpaceIdConfigsReqDto reqDto) {
        reqDto.setTenantId(this.context.tenantId());
        ArrayList paramValueEos = new ArrayList();
        ArrayList extValueEos = new ArrayList();
        reqDto.getConfigs().forEach(e -> {
            Integer type = e.getType();
            if (Objects.equals(Constants.PARAM, type)) {
                this.setParam(reqDto, paramValueEos, (BizConfigReqDto)e);
            } else if (Objects.equals(Constants.EXTENSION, type)) {
                this.setExtension(reqDto, extValueEos, (BizConfigReqDto)e);
            } else {
                throw new BizException("\u914d\u7f6e\u9879\u7c7b\u578b\u53ea\u80fd\u4e3a\u4e1a\u52a1\u53c2\u6570\u6216\u6269\u5c55\u70b9");
            }
        });
        if (paramValueEos.size() > 0) {
            this.sysParamValueDas.insertBatch(paramValueEos);
        }
        if (extValueEos.size() > 0) {
            this.bizExtImplValueDas.insertBatch(extValueEos);
        }
    }

    private void setExtension(SpaceIdConfigsReqDto reqDto, List<BizExtImplValueEo> extValueEos, BizConfigReqDto e) {
        List implEos = this.bizExtImplDas.selectByBextCodes(Collections.singletonList(e.getCode())).stream().map(StdBizExtImplEo::getBextImplCode).collect(Collectors.toList());
        ArrayList implDtos = new ArrayList(e.getValues());
        implDtos.removeAll(implEos);
        if (implDtos.size() > 0) {
            throw new BizException("\u7f16\u7801\u4e3a" + e.getCode() + "\u7684\u6269\u5c55\u70b9\u5b9e\u73b0\u7f16\u7801\u4e0d\u5b58\u5728:" + StringUtils.collectionToCommaDelimitedString(implDtos));
        }
        BizExtImplValueEo record = new BizExtImplValueEo();
        record.setTenantId(this.context.tenantId());
        record.setBizSpaceCode(reqDto.getSpaceCode());
        record.setBizIdCode(reqDto.getIdCode());
        record.setBextCode(e.getCode());
        this.bizExtImplValueDas.logicDelete((BaseEo)record);
        e.getValues().forEach(v -> {
            BizExtImplValueEo eo = new BizExtImplValueEo();
            eo.setTenantId(record.getTenantId());
            eo.setBizSpaceCode(reqDto.getSpaceCode());
            eo.setBizIdCode(reqDto.getIdCode());
            eo.setBextCode(e.getCode());
            eo.setExtension("");
            eo.setBextImplCode(v);
            extValueEos.add(eo);
        });
    }

    private void setParam(SpaceIdConfigsReqDto reqDto, List<SysParamValueEo> paramValueEos, BizConfigReqDto e) {
        SysParamEo paramEo = this.sysParamDas.selectByParamCode(e.getCode());
        if (paramEo == null) {
            throw new BizException("\u7f16\u7801\u4e3a" + e.getCode() + "\u7684\u4e1a\u52a1\u53c2\u6570\u4e0d\u5b58\u5728");
        }
        Integer selectType = paramEo.getSelectType();
        Map<String, String> itemEoMap = null;
        if (selectType == null) {
            throw new BizException("\u7f16\u7801\u4e3a" + e.getCode() + "\u7684\u4e1a\u52a1\u53c2\u6570\u9009\u62e9\u7c7b\u578b\u4e3anull");
        }
        if (selectType.equals(ParamSelectType.TEXT_FIELD.getCode())) {
            e.getValues().forEach(value -> SysParamServiceImpl.validationParamValue(paramEo.getCode(), paramEo.getValueType(), value));
        } else {
            List sysParamItemEos = this.sysParamItemDas.selectByParamCodes(Collections.singletonList(e.getCode()));
            List itemCodeEos = sysParamItemEos.stream().map(StdSysParamItemEo::getItemCode).collect(Collectors.toList());
            ArrayList itemCodeDtos = new ArrayList(e.getValues());
            itemCodeDtos.removeAll(itemCodeEos);
            if (itemCodeDtos.size() > 0) {
                throw new BizException("\u7f16\u7801\u4e3a" + e.getCode() + "\u7684\u4e1a\u52a1\u53c2\u6570\u9009\u9879\u7f16\u7801\u4e0d\u5b58\u5728:" + StringUtils.collectionToCommaDelimitedString(itemCodeDtos));
            }
            itemEoMap = sysParamItemEos.stream().collect(Collectors.toMap(item -> item.getParamCode() + "::" + item.getItemCode(), StdSysParamItemEo::getParamValue));
        }
        SysParamValueEo record = new SysParamValueEo();
        record.setTenantId(this.context.tenantId());
        record.setBizSpaceCode(reqDto.getSpaceCode());
        record.setBizIdCode(reqDto.getIdCode());
        record.setParamCode(e.getCode());
        this.sysParamValueDas.logicDelete((BaseEo)record);
        Map<String, String> finalItemEoMap = itemEoMap;
        e.getValues().forEach(v -> {
            SysParamValueEo eo = new SysParamValueEo();
            eo.setTenantId(reqDto.getTenantId());
            eo.setBizSpaceCode(reqDto.getSpaceCode());
            eo.setBizIdCode(reqDto.getIdCode());
            eo.setParamCode(e.getCode());
            eo.setExtension("");
            if (selectType.equals(ParamSelectType.TEXT_FIELD.getCode())) {
                eo.setParamValue(v);
            } else {
                eo.setItemCode(v);
                eo.setParamValue((String)finalItemEoMap.get(e.getCode() + "::" + v));
            }
            paramValueEos.add(eo);
        });
    }

    @Override
    public BizIdQueryResDto queryByCode(Long tenantId, String code) {
        tenantId = this.context.tenantId();
        BizIdEo bizIdEo = this.bizIdDas.selectByCode(tenantId, code);
        if (bizIdEo == null) {
            return null;
        }
        BizIdQueryResDto resDto = new BizIdQueryResDto();
        DtoHelper.eo2Dto((BaseEo)bizIdEo, (BaseVo)resDto);
        return resDto;
    }

    @Override
    public BizIdAndBizSpaceDto queryBizIdAndBizSpace(String bizIdCode, String bizSpaceCode) {
        BizIdAndBizSpaceDto bizIdAndBizSpaceDto = new BizIdAndBizSpaceDto();
        BizIdQueryResDto bizIdQueryResDto = this.queryByCode(null, bizIdCode);
        if (bizIdQueryResDto == null) {
            return bizIdAndBizSpaceDto;
        }
        BizSpaceReqDto bizSpaceReqDto = new BizSpaceReqDto();
        bizSpaceReqDto.setCode(bizSpaceCode);
        BizSpaceRespDto bizSpaceRespDto = this.bizSpaceService.queryByCode(bizSpaceReqDto);
        if (bizSpaceRespDto != null) {
            bizIdAndBizSpaceDto.setBizSpaceCode(bizSpaceCode);
            bizIdAndBizSpaceDto.setBizSpaceName(bizSpaceRespDto.getName());
            bizIdAndBizSpaceDto.setBizSpaceId(bizSpaceRespDto.getId());
        }
        bizIdAndBizSpaceDto.setBizId(bizIdQueryResDto.getId());
        bizIdAndBizSpaceDto.setBizIdCode(bizIdQueryResDto.getCode());
        bizIdAndBizSpaceDto.setBizIdName(bizIdQueryResDto.getName());
        return bizIdAndBizSpaceDto;
    }

    @Override
    public PageInfo<BizIdQueryResDto> queryByPage(BizIdQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        queryReqDto.setTenantId(this.context.tenantId());
        BizIdEo record = new BizIdEo();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)record);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.hasText((String)queryReqDto.getCode())) {
            sqlFilters.add(SqlFilter.like((String)"code", (Object)("%" + queryReqDto.getCode() + "%")));
        }
        if (StringUtils.hasText((String)queryReqDto.getName())) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + queryReqDto.getName() + "%")));
        }
        record.setSqlFilters(sqlFilters);
        record.setCode(null);
        record.setName(null);
        record.setOrderBy("code");
        PageInfo eoPageInfo = this.bizIdDas.selectPage((BaseEo)record, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BizIdQueryResDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<BizSpaceRespDto> queryBizSpaceByPage(SpaceIdQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        reqDto.setTenantId(this.context.tenantId());
        PageInfo eoPageInfo = PageHelper.startPage((int)pageNum, (int)pageSize).doSelectPageInfo(() -> this.spaceIdDas.selectBizSpaceList(reqDto.getTenantId(), reqDto.getBizIdCode(), reqDto.getCode(), reqDto.getName()));
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BizSpaceRespDto.class);
        for (BizSpaceRespDto dto : dtoList) {
            ConfigScopeEo configScopeEo = new ConfigScopeEo();
            configScopeEo.setBizSpaceCode(dto.getCode());
            Integer configNum = this.configScopeDas.count((BaseEo)configScopeEo);
            RBizRuleSpaceIdentityEo rBizRuleSpaceIdentityEo = new RBizRuleSpaceIdentityEo();
            rBizRuleSpaceIdentityEo.setBizSpaceCode(dto.getCode());
            rBizRuleSpaceIdentityEo.setBizIdentityCode(reqDto.getBizIdCode());
            Integer bizRuleNum = this.rBizRuleSpaceIdentityDas.count((BaseEo)rBizRuleSpaceIdentityEo);
            dto.setConfigNum(configNum);
            dto.setBizRuleNum(bizRuleNum);
            BizIdEo bizIdEo = this.bizIdDas.selectByCode(reqDto.getTenantId(), reqDto.getBizIdCode());
            dto.setBizIdType(bizIdEo == null ? null : bizIdEo.getType());
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<BizConfigResDto> queryBizSpaceIdConfigs(Long tenantId, String spaceCode, String idCode) {
        tenantId = this.context.tenantId();
        SysParamValueEo paramRecord = new SysParamValueEo();
        paramRecord.setTenantId(tenantId);
        paramRecord.setBizSpaceCode(spaceCode);
        paramRecord.setBizIdCode(idCode);
        Map<String, List<SysParamValueEo>> paramMap = this.sysParamValueDas.select((BaseEo)paramRecord).stream().collect(Collectors.groupingBy(StdSysParamValueEo::getParamCode));
        BizExtImplValueEo extRecord = new BizExtImplValueEo();
        extRecord.setTenantId(tenantId);
        extRecord.setBizSpaceCode(spaceCode);
        extRecord.setBizIdCode(idCode);
        Map<String, List<BizExtImplValueEo>> extMap = this.bizExtImplValueDas.select((BaseEo)extRecord).stream().collect(Collectors.groupingBy(StdBizExtImplValueEo::getBextCode));
        ArrayList<BizConfigResDto> resDto = new ArrayList<BizConfigResDto>();
        paramMap.forEach((k, v) -> {
            SysParamEo sysParamEo = this.sysParamDas.selectByParamCode(k);
            if (sysParamEo == null) {
                throw new BizException("\u7f16\u7801\u4e3a" + k + "\u7684\u4e1a\u52a1\u53c2\u6570\u4e0d\u5b58\u5728");
            }
            Integer selectType = sysParamEo.getSelectType();
            if (selectType == null) {
                throw new BizException("\u7f16\u7801\u4e3a" + k + "\u7684\u4e1a\u52a1\u53c2\u6570\u7684\u9009\u62e9\u7c7b\u578b\u4e3anull");
            }
            List values = v.stream().map(e -> Objects.equals(ParamSelectType.TEXT_FIELD.getCode(), selectType) ? e.getParamValue() : e.getItemCode()).collect(Collectors.toList());
            BizConfigResDto config = new BizConfigResDto();
            config.setType(Constants.PARAM);
            config.setCode(k);
            config.setSelectType(selectType);
            config.setValues(values);
            resDto.add(config);
        });
        extMap.forEach((k, v) -> {
            BizExtensionEo extensionEo = this.bizExtensionDas.selectByExtCode(k);
            if (extensionEo == null) {
                throw new BizException("\u7f16\u7801\u4e3a" + k + "\u7684\u6269\u5c55\u70b9\u4e0d\u5b58\u5728");
            }
            Integer selectType = extensionEo.getBextType();
            if (selectType == null) {
                throw new BizException("\u7f16\u7801\u4e3a" + k + "\u7684\u6269\u5c55\u70b9\u7684\u9009\u62e9\u7c7b\u578b\u4e3anull");
            }
            List values = v.stream().map(StdBizExtImplValueEo::getBextImplCode).collect(Collectors.toList());
            BizConfigResDto config = new BizConfigResDto();
            config.setType(Constants.EXTENSION);
            config.setCode(k);
            config.setSelectType(selectType);
            config.setValues(values);
            resDto.add(config);
        });
        return resDto;
    }

    @Override
    public Collection<BizIdentityRespDto> queryBizIdentityByBizSpaceCode(String settingCode, String bizSpaceCode) {
        String redisKey = REDIS_PREFIX + settingCode + "_" + bizSpaceCode;
        List cache = (List)this.cacheService.getCache(redisKey, (TypeReference)new TypeReference<List<BizIdentityRespDto>>(){});
        if (cache != null && !cache.isEmpty()) {
            return cache;
        }
        List list = this.bizIdDas.queryBizIdentityListBySpaceCode(settingCode, bizSpaceCode);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        List<BizIdentityRespDto> result = list.stream().map(bizIdentityExtendEo -> {
            BizIdentityRespDto bizIdentityRespDto = new BizIdentityRespDto();
            bizIdentityRespDto.setId(bizIdentityExtendEo.getId());
            bizIdentityRespDto.setCode(bizIdentityExtendEo.getCode());
            bizIdentityRespDto.setRules(bizIdentityExtendEo.getBizRuleEos().stream().map(bizRuleEo -> {
                BizRuleBasicReqDto bizRuleBasicReqDto = new BizRuleBasicReqDto();
                bizRuleBasicReqDto.setExpression(bizRuleEo.getCodeExpression());
                bizRuleBasicReqDto.setName(bizRuleEo.getName());
                bizRuleBasicReqDto.setStatus(bizRuleEo.getStatus());
                return bizRuleBasicReqDto;
            }).collect(Collectors.toList()));
            return bizIdentityRespDto;
        }).collect(Collectors.toList());
        this.cacheService.setCache(redisKey, result);
        this.cacheService.hset(REDIS_KEY_MAP, redisKey, (Object)redisKey);
        return result;
    }

    @Override
    public String queryBizIdCode(ConfigQueryReq configQueryReq, String finalBizSpaceCode) {
        String configCode = configQueryReq.getCode();
        Collection<BizIdentityRespDto> bizIdentityRespDtos = this.queryBizIdentityByBizSpaceCode(configCode, finalBizSpaceCode);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(bizIdentityRespDtos)) {
            Map<String, List<String>> bizIdentityCode2ExpressionsMap = bizIdentityRespDtos.stream().collect(Collectors.toMap(BizIdentityRespDto::getCode, bizIdentityRespDto -> bizIdentityRespDto.getRules().stream().map(BizRuleBasicReqDto::getExpression).collect(Collectors.toList())));
            long bt = System.currentTimeMillis();
            String bizIdCode = this.businessIdentityIdentifyService.identifyProcess(configQueryReq, bizIdentityCode2ExpressionsMap);
            logger.debug("\u8bc6\u522b\u4e1a\u52a1\u8eab\u4efd\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - bt));
            return bizIdCode;
        }
        return null;
    }

    public void clearBizIdMapCache() {
        Map map = this.cacheService.hgetAll(REDIS_KEY_MAP);
        if (CollectionUtils.isEmpty((Map)map)) {
            return;
        }
        String[] keys = new String[map.size()];
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            this.cacheService.delCache((String)entry.getKey());
            keys[i] = (String)entry.getKey();
            ++i;
        }
        this.cacheService.hdel(REDIS_KEY_MAP, keys);
    }
}

