/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.tree.TreeWorkshop;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.func.api.dto.base.CapabilityBaseDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.CapabilityCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.CapabilityDomainQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.CapabilityModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.CapabilityRemoveReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.CapabilitySettingQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.CapabilityTreeQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.CapabilityRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.CapabilitySettingsRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.CapabilitySimpleRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.CapabilityTreeRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.DomainTreeRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SettingRespDto;
import com.dtyunxi.yundt.cube.center.func.biz.service.ICapabilityDomainService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ICapabilityService;
import com.dtyunxi.yundt.cube.center.func.dao.das.BundleDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.CapabilityDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.ViewCapabilityRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.CapabilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DomainEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdCapabilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdDomainEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSettingEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ViewCapabilityRelationEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class CapabilityServiceImpl
implements ICapabilityService {
    @Resource
    private CapabilityDas capabilityDas;
    @Resource
    private SettingDas settingDas;
    @Resource
    private ICapabilityDomainService capabilityDomainService;
    @Resource
    private BundleDas bundleDas;
    @Resource
    private ViewCapabilityRelationDas viewCapabilityRelationDas;
    @Resource
    private ICacheService cacheService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createCapability(CapabilityCreateReqDto capabilityCreateReqDto) {
        CapabilityEo parent;
        this.validateCapabilityParam(capabilityCreateReqDto.getCode(), capabilityCreateReqDto.getName(), capabilityCreateReqDto.getBundleCode(), true);
        CapabilityEo capabilityEo = new CapabilityEo();
        DtoHelper.dto2Eo((BaseVo)capabilityCreateReqDto, (BaseEo)capabilityEo);
        if (StringUtils.isBlank((CharSequence)capabilityCreateReqDto.getParentCode())) {
            capabilityEo.setParentCode("ROOT_NODE");
        }
        if (!capabilityEo.getParentCode().equals("ROOT_NODE") && (parent = this.capabilityDas.selectByCode(capabilityEo.getParentCode())) != null) {
            capabilityEo.setViewId(parent.getViewId());
        }
        capabilityEo.setBundle(capabilityCreateReqDto.getBundleCode());
        capabilityEo.setDomain(capabilityCreateReqDto.getDomainCode());
        if (StringUtils.isBlank((CharSequence)capabilityCreateReqDto.getExtension())) {
            capabilityEo.setExtension("");
        }
        this.capabilityDas.insert((BaseEo)capabilityEo);
        this.cacheService.delCache("com.dtyunxi.yundt.cube.center.func.queryAbilityOverview");
        return capabilityEo.getCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyCapability(CapabilityModifyReqDto capabilityModifyReqDto) {
        String capabilityCode = capabilityModifyReqDto.getCode();
        CapabilityEo resultEo = this.capabilityDas.selectByCode(capabilityCode);
        Assert.isTrue((null != resultEo ? 1 : 0) != 0, (String)"\u80fd\u529b\u4e0d\u5b58\u5728");
        this.validateCapabilityParam(capabilityCode, capabilityModifyReqDto.getName(), capabilityModifyReqDto.getBundleCode(), false);
        DtoHelper.dto2Eo((BaseVo)capabilityModifyReqDto, (BaseEo)resultEo, (String[])new String[]{"code", "parentCode"});
        resultEo.setBundle(capabilityModifyReqDto.getBundleCode());
        this.capabilityDas.updateSelective((BaseEo)resultEo);
        this.cacheService.delCache("com.dtyunxi.yundt.cube.center.func.queryAbilityOverview");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCapability(CapabilityRemoveReqDto capabilityRemoveReqDto) {
        this.validateCapabilityRelationIsExist(capabilityRemoveReqDto.getCode());
        CapabilityEo removeEo = new CapabilityEo();
        DtoHelper.dto2Eo((BaseVo)capabilityRemoveReqDto, (BaseEo)removeEo);
        this.capabilityDas.delete((BaseEo)removeEo);
        this.cacheService.delCache("com.dtyunxi.yundt.cube.center.func.queryAbilityOverview");
    }

    @Override
    public CapabilitySimpleRespDto queryByCode(String code) {
        CapabilityEo resultEo = this.capabilityDas.selectByCode(code);
        CapabilitySimpleRespDto capabilitySimpleRespDto = new CapabilitySimpleRespDto();
        if (resultEo != null) {
            List<DomainEo> domainResultList;
            String domainCode;
            DtoHelper.eo2Dto((BaseEo)resultEo, (BaseVo)capabilitySimpleRespDto);
            BundleEo bundleEo = this.bundleDas.selectByCode(resultEo.getBundle());
            capabilitySimpleRespDto.setBundleCode(resultEo.getBundle());
            if (bundleEo != null) {
                capabilitySimpleRespDto.setBundleParentCode(bundleEo.getParentCode());
            }
            if (StringUtils.isNotBlank((CharSequence)(domainCode = resultEo.getDomain())) && !CollectionUtils.isEmpty(domainResultList = this.capabilityDomainService.getDomains(domainCode, null))) {
                capabilitySimpleRespDto.setDomainCode(domainCode);
                capabilitySimpleRespDto.setDomainName(domainResultList.get(0).getName());
            }
        }
        return capabilitySimpleRespDto;
    }

    @Override
    public CapabilityTreeRespDto queryCapabilityTree(CapabilityTreeQueryReqDto capabilityTreeQueryReqDto) {
        CapabilityTreeRespDto capabilityTreeRespDto = new CapabilityTreeRespDto();
        ArrayList<DomainTreeRespDto> domainTreeRespDtos = new ArrayList<DomainTreeRespDto>();
        List<DomainEo> domainResultList = this.capabilityDomainService.getDomains(capabilityTreeQueryReqDto.getDomainCode(), capabilityTreeQueryReqDto.getDomainName());
        if (CollectionUtils.isEmpty(domainResultList)) {
            capabilityTreeRespDto.setChildren(domainTreeRespDtos);
            return capabilityTreeRespDto;
        }
        Map<String, String> domainCode2NameMap = domainResultList.stream().collect(Collectors.toMap(StdDomainEo::getCode, StdDomainEo::getName));
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"domain", (Object)StringUtils.join(domainCode2NameMap.keySet(), (String)",")));
        CapabilityEo queryCapabilityEo = new CapabilityEo();
        queryCapabilityEo.setSqlFilters(sqlFilters);
        queryCapabilityEo.setOrderBy("code");
        queryCapabilityEo.setCode(capabilityTreeQueryReqDto.getCapabilityCode());
        queryCapabilityEo.setName(capabilityTreeQueryReqDto.getCapabilityName());
        if (capabilityTreeQueryReqDto.isFirstCapabilityOnly()) {
            queryCapabilityEo.setParentCode("ROOT_NODE");
        }
        List resultCapability = this.capabilityDas.select((BaseEo)queryCapabilityEo);
        Map<String, List<CapabilityEo>> domainCode2Capability = resultCapability.stream().collect(Collectors.groupingBy(StdCapabilityEo::getDomain));
        if (StringUtils.isNotBlank((CharSequence)capabilityTreeQueryReqDto.getCapabilityCode()) || StringUtils.isNotBlank((CharSequence)capabilityTreeQueryReqDto.getCapabilityName())) {
            for (String domainCode : domainCode2Capability.keySet()) {
                List<CapabilityEo> resultCapabilityEos = domainCode2Capability.get(domainCode);
                for (CapabilityEo resultEo : resultCapabilityEos) {
                    List<CapabilityEo> waitingProcessedEo = this.getCapabilityByCondition(resultEo.getCode(), domainCode);
                    List<CapabilityEo> waitDoTreeEos = this.completionCapabilityEo(resultEo.getCode(), resultEo.getParentCode(), waitingProcessedEo);
                    waitDoTreeEos.add(resultEo);
                    String domainName = domainCode2NameMap.get(resultEo.getDomain());
                    DomainTreeRespDto domainTreeRespDto = this.processCapabilityTreeDomainDto(resultEo.getDomain(), domainName, waitDoTreeEos);
                    if (domainTreeRespDto == null) continue;
                    domainTreeRespDtos.add(domainTreeRespDto);
                }
            }
        } else {
            for (DomainEo domainEo : domainResultList) {
                String domainCode = domainEo.getCode();
                List<CapabilityEo> resultCapabilityEos = domainCode2Capability.get(domainCode);
                DomainTreeRespDto domainTreeRespDto = this.processCapabilityTreeDomainDto(domainCode, domainCode2NameMap.get(domainCode), resultCapabilityEos);
                if (domainTreeRespDto == null) continue;
                domainTreeRespDtos.add(domainTreeRespDto);
            }
        }
        capabilityTreeRespDto.setChildren(domainTreeRespDtos);
        return capabilityTreeRespDto;
    }

    @Override
    public CapabilitySettingsRespDto queryCapabilitySettings(CapabilitySettingQueryReqDto capabilitySettingQueryReqDto) {
        String capabilityCode = capabilitySettingQueryReqDto.getCapabilityCode();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)capabilityCode), (String)"\u80fd\u529b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        CapabilityEo result = this.capabilityDas.selectByCode(capabilityCode);
        CapabilitySettingsRespDto capabilitySettingsRespDto = new CapabilitySettingsRespDto();
        DtoHelper.eo2Dto((BaseEo)result, (BaseVo)capabilitySettingsRespDto);
        SettingEo settingEo = new SettingEo();
        DtoHelper.dto2Eo((BaseVo)capabilitySettingQueryReqDto, (BaseEo)settingEo);
        List<SettingRespDto> settings = this.getSettingsByConditions(settingEo);
        capabilitySettingsRespDto.setSettings(settings);
        return this.getChildWithSettingByParentCapability(capabilitySettingsRespDto, result.getDomain());
    }

    @Override
    public PageInfo<CapabilityRespDto> queryCapabilityByDomain(CapabilityDomainQueryReqDto capabilityDomainQueryReqDto, Integer pageNum, Integer pageSize) {
        String domainCode = capabilityDomainQueryReqDto.getDomainCode();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)domainCode), (String)"\u9886\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        CapabilityEo capabilityEo = new CapabilityEo();
        capabilityEo.setDomain(domainCode);
        PageInfo capabilityEoPageInfo = this.capabilityDas.selectPage((BaseEo)capabilityEo, pageNum, pageSize);
        ArrayList<CapabilityRespDto> capabilityRespDtos = new ArrayList<CapabilityRespDto>();
        if (capabilityEoPageInfo != null && !CollectionUtils.isEmpty((Collection)capabilityEoPageInfo.getList())) {
            List capabilityEos = capabilityEoPageInfo.getList();
            for (CapabilityEo eo : capabilityEos) {
                CapabilityRespDto capabilityRespDto = new CapabilityRespDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)capabilityRespDto);
                capabilityRespDtos.add(capabilityRespDto);
            }
        }
        PageInfo capabilityRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)capabilityRespDtoPageInfo, (Object)capabilityEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        capabilityRespDtoPageInfo.setList(capabilityRespDtos);
        return capabilityRespDtoPageInfo;
    }

    @Override
    public List<CapabilityEo> getChildrenEoByCapabilityCode(String capabilityCode) {
        ArrayList<CapabilityEo> resultEos = new ArrayList<CapabilityEo>();
        CapabilityEo queryEo = new CapabilityEo();
        queryEo.setParentCode(capabilityCode);
        List secondCapabilityEos = this.capabilityDas.select((BaseEo)queryEo);
        if (!CollectionUtils.isEmpty((Collection)secondCapabilityEos)) {
            resultEos.addAll(secondCapabilityEos);
            List<String> capabilityCodeSet = secondCapabilityEos.stream().map(StdCapabilityEo::getCode).collect(Collectors.toList());
            List<CapabilityEo> thirdCapabilityEos = this.getCapabilityByParent(capabilityCodeSet);
            if (!CollectionUtils.isEmpty(thirdCapabilityEos)) {
                resultEos.addAll(thirdCapabilityEos);
            }
        }
        return resultEos;
    }

    @Override
    public List<CapabilityEo> getChildrenEoByCapabilityCodeList(List<String> capabilityCode) {
        ArrayList<CapabilityEo> resultEos = new ArrayList<CapabilityEo>();
        List<CapabilityEo> firstChildrenEos = this.getCapabilityByParent(capabilityCode);
        if (!CollectionUtils.isEmpty(firstChildrenEos)) {
            resultEos.addAll(firstChildrenEos);
            List<String> capabilityCodeSet = firstChildrenEos.stream().map(StdCapabilityEo::getCode).collect(Collectors.toList());
            List<CapabilityEo> thirdCapabilityEos = this.getCapabilityByParent(capabilityCodeSet);
            if (!CollectionUtils.isEmpty(thirdCapabilityEos)) {
                resultEos.addAll(thirdCapabilityEos);
            }
        }
        return resultEos;
    }

    @Override
    public List<CapabilityEo> getCapabilityAndChildrenByCodes(List<String> capabilityCodes) {
        List resultEos = this.capabilityDas.selectByCodeList(capabilityCodes);
        if (CollectionUtils.isEmpty((Collection)resultEos)) {
            return new ArrayList<CapabilityEo>();
        }
        List<CapabilityEo> children = this.getChildrenEoByCapabilityCodeList(capabilityCodes);
        if (!CollectionUtils.isEmpty(children)) {
            resultEos.addAll(children);
        }
        return resultEos;
    }

    private List<CapabilityEo> getCapabilityByParent(List<String> capabilityCode) {
        if (CollectionUtils.isEmpty(capabilityCode)) {
            return new ArrayList<CapabilityEo>();
        }
        CapabilityEo queryEo = new CapabilityEo();
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters.add(SqlFilter.in((String)"parent_code", (Object)StringUtils.join(capabilityCode, (String)",")));
        queryEo.setSqlFilters(filters);
        return this.capabilityDas.select((BaseEo)queryEo);
    }

    @Override
    public List<CapabilityEo> getCapabilityByCondition(List<String> bundleCodes, String parentCode) {
        CapabilityEo capabilityEo = new CapabilityEo();
        if (!CollectionUtils.isEmpty(bundleCodes)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"bundle", (Object)StringUtils.join(bundleCodes, (String)",")));
            capabilityEo.setSqlFilters(sqlFilters);
        }
        capabilityEo.setParentCode(parentCode);
        return this.capabilityDas.select((BaseEo)capabilityEo, Integer.valueOf(1), Integer.valueOf(4096));
    }

    @Override
    public List<CapabilityEo> getCapabilityByCodes(List<String> capabilityCodes) {
        return this.capabilityDas.selectByCodeList(capabilityCodes);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateCapabilityEos(List<CapabilityEo> capabilityEos) {
        for (CapabilityEo eo : capabilityEos) {
            this.capabilityDas.updateSelective((BaseEo)eo);
        }
        this.cacheService.delCache("com.dtyunxi.yundt.cube.center.func.queryAbilityOverview");
    }

    @Override
    public List<CapabilityEo> getCapabilityByName(String name, List<String> bundleCodes) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + name + "%")));
        if (!CollectionUtils.isEmpty(bundleCodes)) {
            sqlFilters.add(SqlFilter.in((String)"bundle", (Object)StringUtils.join(bundleCodes, (String)",")));
        }
        CapabilityEo capabilityEo = new CapabilityEo();
        capabilityEo.setSqlFilters(sqlFilters);
        return this.capabilityDas.select((BaseEo)capabilityEo);
    }

    @Override
    public List<CapabilityEo> getCapabilityAndParentByCodes(List<String> codes) {
        List capabilityEos = this.capabilityDas.selectByCodeList(codes);
        ArrayList<CapabilityEo> resultEos = new ArrayList<CapabilityEo>();
        if (!CollectionUtils.isEmpty((Collection)capabilityEos)) {
            List lastCapabilityEos;
            resultEos.addAll(capabilityEos);
            List<String> lastCodes = this.getCapabilityIsNotRoot(capabilityEos);
            if (!CollectionUtils.isEmpty(lastCodes) && !CollectionUtils.isEmpty((Collection)(lastCapabilityEos = this.capabilityDas.selectByCodeList(lastCodes)))) {
                List rootCapabilityEos;
                resultEos.addAll(lastCapabilityEos);
                List<String> rootCodes = this.getCapabilityIsNotRoot(lastCapabilityEos);
                if (!CollectionUtils.isEmpty(rootCodes) && !CollectionUtils.isEmpty((Collection)(rootCapabilityEos = this.capabilityDas.selectByCodeList(rootCodes)))) {
                    resultEos.addAll(rootCapabilityEos);
                }
            }
        }
        return resultEos;
    }

    @Override
    public List<CapabilityEo> getCapabilityByDomain(String domain) {
        CapabilityEo queryEo = new CapabilityEo();
        queryEo.setParentCode("ROOT_NODE");
        queryEo.setDomain(domain);
        return this.capabilityDas.select((BaseEo)queryEo);
    }

    @Override
    public boolean validateViewCancelTenantCapability(Long viewId, List<String> capabilityCodes) {
        if (CollectionUtils.isEmpty(capabilityCodes) || viewId == null) {
            return false;
        }
        ViewCapabilityRelationEo queryEo = new ViewCapabilityRelationEo();
        queryEo.setViewId(viewId);
        List relationEos = this.viewCapabilityRelationDas.select((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(1000));
        if (CollectionUtils.isEmpty((Collection)relationEos)) {
            return false;
        }
        for (ViewCapabilityRelationEo v : relationEos) {
            if (capabilityCodes.contains(v.getCapabilityCode())) continue;
            return true;
        }
        return false;
    }

    private List<String> getCapabilityIsNotRoot(List<CapabilityEo> capabilityEos) {
        ArrayList<String> parentCodes = new ArrayList<String>();
        for (CapabilityEo child : capabilityEos) {
            if (child.getParentCode().equals("ROOT_NODE")) continue;
            parentCodes.add(child.getParentCode());
        }
        return parentCodes;
    }

    private List<CapabilityRespDto> processDomainCapabilityTree(List<CapabilityEo> capabilityEos) {
        TreeWorkshop treeWorkshop = new TreeWorkshop();
        List<Object> resultRespDtos = new ArrayList<CapabilityRespDto>();
        if (!CollectionUtils.isEmpty(capabilityEos)) {
            ArrayList capabilityRespDtos = new ArrayList();
            DtoHelper.eoList2DtoList(capabilityEos, capabilityRespDtos, CapabilityRespDto.class);
            resultRespDtos = treeWorkshop.buildTreeByList(capabilityRespDtos);
        }
        return resultRespDtos;
    }

    private CapabilitySettingsRespDto getChildWithSettingByParentCapability(CapabilitySettingsRespDto parentDto, String domain) {
        TreeWorkshop treeWorkshop;
        List capabilitySettingsRespDtos;
        ArrayList<CapabilitySettingsRespDto> waitingProcessedDtos = new ArrayList<CapabilitySettingsRespDto>();
        waitingProcessedDtos.add(parentDto);
        List<CapabilityEo> waitingProcessedEos = this.getCapabilityByCondition(parentDto.getCode(), domain);
        List<CapabilityEo> waitDoTreeEos = this.completionCapabilityEo(parentDto.getCode(), parentDto.getParentCode(), waitingProcessedEos);
        if (!CollectionUtils.isEmpty(waitDoTreeEos)) {
            List capabilityCodes = waitDoTreeEos.stream().filter(eo -> StringUtils.isNotBlank((CharSequence)eo.getCode())).map(StdCapabilityEo::getCode).collect(Collectors.toList());
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            SettingEo querySettingEo = new SettingEo();
            sqlFilters.add(SqlFilter.in((String)"capability_code", (Object)StringUtils.join(capabilityCodes, (String)",")));
            querySettingEo.setSqlFilters(sqlFilters);
            List resultSettings = this.settingDas.select((BaseEo)querySettingEo);
            Map<Object, Object> capability2SettingsMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)resultSettings)) {
                capability2SettingsMap = resultSettings.stream().collect(Collectors.groupingBy(StdSettingEo::getCapabilityCode));
            }
            for (CapabilityEo capabilityEo : waitDoTreeEos) {
                CapabilitySettingsRespDto capabilitySettingsRespDto = new CapabilitySettingsRespDto();
                DtoHelper.eo2Dto((BaseEo)capabilityEo, (BaseVo)capabilitySettingsRespDto);
                List settingEos = (List)capability2SettingsMap.get(capabilityEo.getCode());
                if (!CollectionUtils.isEmpty((Collection)settingEos)) {
                    ArrayList settingRespDtos = new ArrayList();
                    DtoHelper.eoList2DtoList((Collection)settingEos, settingRespDtos, SettingRespDto.class);
                    capabilitySettingsRespDto.setSettings(settingRespDtos);
                }
                waitingProcessedDtos.add(capabilitySettingsRespDto);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(capabilitySettingsRespDtos = (treeWorkshop = new TreeWorkshop()).buildTreeByList(waitingProcessedDtos)))) {
            return (CapabilitySettingsRespDto)capabilitySettingsRespDtos.get(0);
        }
        return new CapabilitySettingsRespDto();
    }

    private List<CapabilityEo> getCapabilityByCondition(String withoutCapabilityCode, String domain) {
        CapabilityEo queryEoByCondition = new CapabilityEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)withoutCapabilityCode)) {
            sqlFilters.add(SqlFilter.ne((String)"code", (Object)withoutCapabilityCode));
        }
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            sqlFilters.add(SqlFilter.eq((String)"domain", (Object)domain));
        }
        queryEoByCondition.setSqlFilters(sqlFilters);
        queryEoByCondition.setOrderBy("code");
        return this.capabilityDas.select((BaseEo)queryEoByCondition);
    }

    private List<CapabilityEo> completionCapabilityEo(String currentCode, String currentParentCode, List<CapabilityEo> otherCapabilitys) {
        List<CapabilityEo> children;
        CapabilityEo parentEo;
        ArrayList<CapabilityEo> results = new ArrayList<CapabilityEo>();
        Map capabilityEoMap = otherCapabilitys.stream().collect(Collectors.toMap(StdCapabilityEo::getCode, Function.identity()));
        Map<String, List<CapabilityEo>> capabilityParentEoMap = otherCapabilitys.stream().collect(Collectors.groupingBy(StdCapabilityEo::getParentCode));
        if (!currentParentCode.equals("ROOT_NODE") && (parentEo = (CapabilityEo)capabilityEoMap.get(currentParentCode)) != null) {
            results.add(parentEo);
            if (!CollectionUtils.isEmpty(otherCapabilitys)) {
                otherCapabilitys.remove(parentEo);
                results.addAll(this.completionCapabilityEo(parentEo.getCode(), parentEo.getParentCode(), otherCapabilitys));
            }
        }
        if (!CollectionUtils.isEmpty(children = capabilityParentEoMap.get(currentCode))) {
            results.addAll(children);
            if (!CollectionUtils.isEmpty(otherCapabilitys)) {
                otherCapabilitys.removeAll(children);
                for (CapabilityEo child : children) {
                    results.addAll(this.completionCapabilityEo(child.getCode(), child.getParentCode(), otherCapabilitys));
                }
            }
        }
        return results;
    }

    private List<SettingRespDto> getSettingsByConditions(SettingEo settingEo) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)settingEo.getCode())) {
            sqlFilters.add(SqlFilter.like((String)"code", (Object)("%" + settingEo.getCode() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)settingEo.getName())) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + settingEo.getName() + "%")));
        }
        settingEo.setSqlFilters(sqlFilters);
        List settingEos = this.settingDas.select((BaseEo)settingEo);
        ArrayList<SettingRespDto> settingRespDtos = new ArrayList<SettingRespDto>();
        DtoHelper.eoList2DtoList((Collection)settingEos, settingRespDtos, SettingRespDto.class);
        return settingRespDtos;
    }

    private DomainTreeRespDto processCapabilityTreeDomainDto(String domainCode, String domainName, List<CapabilityEo> capabilityEos) {
        DomainTreeRespDto domainTreeRespDto = new DomainTreeRespDto();
        domainTreeRespDto.setDomainCode(domainCode);
        domainTreeRespDto.setDomainName(domainName);
        List<CapabilityRespDto> capabilityRespDtos = this.processDomainCapabilityTree(capabilityEos);
        domainTreeRespDto.setChildren(capabilityRespDtos);
        return domainTreeRespDto;
    }

    private void validateCapabilityParam(String code, String name, String bundleCode, boolean isCreateCapabilityMethod) {
        if (isCreateCapabilityMethod) {
            CapabilityEo queryCodeEo = new CapabilityEo();
            queryCodeEo.setCode(code);
            Assert.isTrue((this.capabilityDas.count((BaseEo)queryCodeEo) == 0 ? 1 : 0) != 0, (String)"\u80fd\u529b\u7f16\u7801\u91cd\u590d,\u8bf7\u91cd\u8f93");
            CapabilityEo queryNameEo = new CapabilityEo();
            queryNameEo.setName(name);
            Assert.isTrue((this.capabilityDas.count((BaseEo)queryNameEo) == 0 ? 1 : 0) != 0, (String)"\u80fd\u529b\u540d\u79f0\u91cd\u590d,\u8bf7\u91cd\u8f93");
        } else if (StringUtils.isNotBlank((CharSequence)name)) {
            CapabilityEo queryNameEo = new CapabilityEo();
            queryNameEo.setName(name);
            List capabilityEos = this.capabilityDas.select((BaseEo)queryNameEo);
            if (!CollectionUtils.isEmpty((Collection)capabilityEos)) {
                Assert.isTrue((capabilityEos.size() == 1 ? 1 : 0) != 0, (String)"\u80fd\u529b\u91cd\u590d");
                if (!((CapabilityEo)capabilityEos.get(0)).getCode().equals(code)) {
                    throw new BizException("\u80fd\u529b\u540d\u79f0\u91cd\u590d,\u8bf7\u91cd\u8f93");
                }
            }
        }
    }

    private void validateCapabilityRelationIsExist(String capabilityCode) {
        SettingEo settingEo = new SettingEo();
        settingEo.setCapabilityCode(capabilityCode);
        Assert.isTrue((this.settingDas.count((BaseEo)settingEo) == 0 ? 1 : 0) != 0, (String)"\u5b58\u5728\u914d\u7f6e\u9879\u5173\u8054");
        CapabilityEo capabilityEo = new CapabilityEo();
        capabilityEo.setParentCode(capabilityCode);
        Assert.isTrue((this.capabilityDas.count((BaseEo)capabilityEo) == 0 ? 1 : 0) != 0, (String)"\u5b58\u5728\u5b50\u80fd\u529b\u5173\u8054");
    }

    @Override
    public PageInfo<CapabilityBaseDto> queryRootNode(Integer pageNum, Integer pageSize) {
        CapabilityEo capabilityEo = new CapabilityEo();
        capabilityEo.setParentCode("ROOT_NODE");
        capabilityEo.setOrderByDesc("update_time");
        PageInfo eoPageInfo = this.capabilityDas.selectPage((BaseEo)capabilityEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CapabilityBaseDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

