/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.func.api.constants.DocConstants;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DocBindApiReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DocCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DocQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DocRemoveReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DocUpdateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ShelfStatusReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ApiRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.DocDetailRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.DocOverviewDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.DocRespDto;
import com.dtyunxi.yundt.cube.center.func.api.exception.CenterDataExceptionCode;
import com.dtyunxi.yundt.cube.center.func.api.exception.DocApiExceptionCode;
import com.dtyunxi.yundt.cube.center.func.biz.service.IDocService;
import com.dtyunxi.yundt.cube.center.func.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.func.dao.das.ApiDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.ApiSceneRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.CapabilityDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.DocDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.DomainDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.ModuleDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ApiEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ApiSceneRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.CapabilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DocEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DomainEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ModuleEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdApiSceneRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdCapabilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.vo.DocOverViewVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DocServiceImpl
implements IDocService {
    private final Logger logger = LoggerFactory.getLogger(DocServiceImpl.class);
    @Resource
    private DocDas docDas;
    @Resource
    private ApiSceneRelationDas relationDas;
    @Resource
    private ApiDas apiDas;
    @Resource
    private ModuleDas moduleDas;
    @Resource
    private DomainDas domainDas;
    @Resource
    private CapabilityDas capabilityDas;
    @Resource
    private ICacheService cacheService;
    private static final String REGEX = "[:\uff1a]";

    @Override
    public Long addDoc(DocCreateReqDto docCreateReqDto) {
        String string = DocConstants.NULL_VALUE = DocConstants.REALM_DOC.equals(docCreateReqDto.getDocType()) ? "\u9886\u57df" : "\u573a\u666f";
        if (StringUtils.isEmpty((Object)docCreateReqDto.getAbilityGroupCode())) {
            throw new BizException(CenterDataExceptionCode.PARAM_VALUE_NON_NULL.getCode(), CenterDataExceptionCode.PARAM_VALUE_NON_NULL.getMsg());
        }
        this.validDomainCapability(docCreateReqDto.getDocType(), docCreateReqDto.getAbilityGroupCode());
        DocEo docEo = new DocEo();
        DtoHelper.dto2Eo((BaseVo)docCreateReqDto, (BaseEo)docEo);
        docEo.setStatus(DocConstants.OFF_SHELF);
        this.docDas.insert((BaseEo)docEo);
        this.cacheService.delCache("com.dtyunxi.yundt.cube.center.func.queryAbilityOverview");
        return docEo.getId();
    }

    @Override
    public void modifyDoc(DocUpdateReqDto docUpdateReqDto) {
        DocEo docEo = new DocEo();
        DtoHelper.dto2Eo((BaseVo)docUpdateReqDto, (BaseEo)docEo);
        this.docDas.updateSelective((BaseEo)docEo);
        this.cacheService.delCache("com.dtyunxi.yundt.cube.center.func.queryAbilityOverview");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDoc(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.docDas.logicDeleteById(Long.valueOf(id));
        }
        this.cacheService.delCache("com.dtyunxi.yundt.cube.center.func.queryAbilityOverview");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void shelfDoc(ShelfStatusReqDto statusReqDto) {
        DocEo docEoById = (DocEo)this.docDas.selectByPrimaryKey(statusReqDto.getId());
        String string = DocConstants.NULL_VALUE = DocConstants.REALM_DOC.equals(docEoById.getDocType()) ? "\u9886\u57df" : "\u573a\u666f";
        if (!statusReqDto.getStatus().equals(docEoById.getStatus())) {
            if (DocConstants.ON_SHElF.equals(statusReqDto.getStatus())) {
                DocEo docEo = new DocEo();
                docEo.setAbilityGroupCode(docEoById.getAbilityGroupCode());
                docEo.setDocType(docEoById.getDocType());
                docEo.setStatus(DocConstants.ON_SHElF);
                ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                sqlFilters.add(SqlFilter.ne((String)"id", (Object)statusReqDto.getId()));
                docEo.setSqlFilters(sqlFilters);
                List resultDocEos = this.docDas.select((BaseEo)docEo);
                if (CollectionUtils.isEmpty((Collection)resultDocEos)) {
                    docEoById.setStatus(DocConstants.ON_SHElF);
                    this.docDas.updateSelective((BaseEo)docEoById);
                } else {
                    if (!DocConstants.CONFIRM.equals(statusReqDto.getConfirm())) throw new BizException(DocApiExceptionCode.OFF_SHElF_TO_ON.getCode(), DocApiExceptionCode.OFF_SHElF_TO_ON.getMsg());
                    resultDocEos.forEach(eo -> {
                        eo.setStatus(DocConstants.OFF_SHELF);
                        this.docDas.updateSelective((BaseEo)eo);
                    });
                    docEoById.setStatus(DocConstants.ON_SHElF);
                    this.docDas.updateSelective((BaseEo)docEoById);
                }
            } else if (DocConstants.OFF_SHELF.equals(statusReqDto.getStatus())) {
                if (!DocConstants.CONFIRM.equals(statusReqDto.getConfirm())) throw new BizException(DocApiExceptionCode.ON_SHELF_TO_OFF.getCode(), DocApiExceptionCode.ON_SHELF_TO_OFF.getMsg());
                docEoById.setStatus(DocConstants.OFF_SHELF);
                this.docDas.updateSelective((BaseEo)docEoById);
            }
        }
        this.cacheService.delCache("com.dtyunxi.yundt.cube.center.func.queryAbilityOverview");
    }

    @Override
    public void remove(DocRemoveReqDto docRemoveReqDto) {
        Long id = docRemoveReqDto.getId();
        AssertUtil.isTrue(id != null, CenterDataExceptionCode.PARAM_INVALID.getMsg());
        DocEo docEo = (DocEo)this.docDas.selectByPrimaryKey(id);
        AssertUtil.isTrue(docEo != null, CenterDataExceptionCode.RECORD_NOT_EXISTS.getMsg());
        AssertUtil.isTrue(!docEo.getStatus().equals(DocConstants.ON_SHElF), "\u4e0a\u67b6\u7684\u6587\u6863\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u8bf7\u5148\u4e0b\u67b6");
        this.docDas.logicDelete((BaseEo)docEo);
        this.cacheService.delCache("com.dtyunxi.yundt.cube.center.func.queryAbilityOverview");
    }

    @Override
    public DocDetailRespDto queryById(Long id) {
        List<ApiSceneRelationEo> apiSceneRelationEos;
        DocEo docEo = (DocEo)this.docDas.selectByPrimaryKey(id);
        if (null == docEo) {
            return new DocDetailRespDto();
        }
        DocDetailRespDto docReqDto = new DocDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)docEo, (BaseVo)docReqDto);
        if (DocConstants.SCENE_DOC.equals(docEo.getDocType()) && !CollectionUtils.isEmpty(apiSceneRelationEos = this.queryByCode(docEo.getAbilityGroupCode()))) {
            List apiIds = apiSceneRelationEos.stream().filter(item -> null != item.getApiId()).map(StdApiSceneRelationEo::getApiId).collect(Collectors.toList());
            ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
            filters.add(SqlFilter.in((String)"id", (Object)org.apache.commons.lang3.StringUtils.join(apiIds, (String)",")));
            ApiEo apiEo = new ApiEo();
            apiEo.setSqlFilters(filters);
            List apiEos = this.apiDas.select((BaseEo)apiEo);
            ArrayList apiRespDtos = new ArrayList();
            CubeBeanUtils.copyCollection(apiRespDtos, (Collection)apiEos, ApiRespDto.class);
            docReqDto.setApiRespDtos(apiRespDtos);
        }
        return docReqDto;
    }

    @Override
    public PageInfo<DocRespDto> queryByPage(DocQueryReqDto docQueryReqDto, Integer pageNum, Integer pageSize) {
        DocEo docEo = new DocEo();
        DtoHelper.dto2Eo((BaseVo)docQueryReqDto, (BaseEo)docEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.hasText((String)docQueryReqDto.getDocName())) {
            sqlFilters.add(SqlFilter.like((String)"doc_name", (Object)("%" + docQueryReqDto.getDocName() + "%")));
            docEo.setDocName(null);
        }
        if (DocConstants.REALM_DOC.equals(docQueryReqDto.getDocType()) && !StringUtils.isEmpty((Object)docQueryReqDto.getFiledCode())) {
            sqlFilters.add(SqlFilter.eq((String)"ability_group_code", (Object)docQueryReqDto.getFiledCode()));
        } else if (DocConstants.SCENE_DOC.equals(docQueryReqDto.getDocType())) {
            if (!StringUtils.isEmpty((Object)docQueryReqDto.getFiledCode())) {
                CapabilityEo capabilityEo = new CapabilityEo();
                capabilityEo.setDomain(docQueryReqDto.getFiledCode());
                capabilityEo.setParentCode("ROOT_NODE");
                List sceneEos = this.capabilityDas.select((BaseEo)capabilityEo, Integer.valueOf(1), Integer.valueOf(1500));
                if (CollectionUtils.isEmpty((Collection)sceneEos)) {
                    return new PageInfo();
                }
                List<String> sceneCodes = sceneEos.stream().map(StdCapabilityEo::getCode).collect(Collectors.toList());
                if (!StringUtils.isEmpty((Object)docQueryReqDto.getSceneCode())) {
                    if (!sceneCodes.contains(docQueryReqDto.getSceneCode())) {
                        return new PageInfo();
                    }
                    sceneCodes = Collections.singletonList(docQueryReqDto.getSceneCode());
                }
                sqlFilters.add(SqlFilter.in((String)"ability_group_code", (Object)org.apache.commons.lang3.StringUtils.join((Iterable)sceneCodes, (String)",")));
            } else if (!StringUtils.isEmpty((Object)docQueryReqDto.getSceneCode())) {
                sqlFilters.add(SqlFilter.eq((String)"ability_group_code", (Object)docQueryReqDto.getSceneCode()));
            }
        }
        docEo.setSqlFilters(sqlFilters);
        docEo.setOrderByDesc("create_time");
        PageInfo pageInfo = this.docDas.selectPage((BaseEo)docEo, pageNum, pageSize);
        ArrayList<DocRespDto> dtoList = new ArrayList<DocRespDto>();
        for (DocEo eo : pageInfo.getList()) {
            DocRespDto docRespDto = new DocRespDto();
            BeanUtils.copyProperties((Object)eo, (Object)docRespDto);
            if (DocConstants.SCENE_DOC.equals(docQueryReqDto.getDocType())) {
                List<ApiSceneRelationEo> apiSceneRelationEos = this.queryByCode(eo.getAbilityGroupCode());
                if (!CollectionUtils.isEmpty(apiSceneRelationEos)) {
                    docRespDto.setRelateNum(Integer.valueOf(apiSceneRelationEos.size()));
                }
                CapabilityEo capabilityEo = new CapabilityEo();
                capabilityEo.setParentCode("ROOT_NODE");
                capabilityEo.setCode(eo.getAbilityGroupCode());
                List sceneEos = this.capabilityDas.select((BaseEo)capabilityEo, Integer.valueOf(1), Integer.valueOf(1));
                if (!CollectionUtils.isEmpty((Collection)sceneEos)) {
                    docRespDto.setScenario(((CapabilityEo)sceneEos.get(0)).getName());
                    if (!StringUtils.isEmpty((Object)((CapabilityEo)sceneEos.get(0)).getDomain())) {
                        DomainEo domainEo = new DomainEo();
                        domainEo.setCode(((CapabilityEo)sceneEos.get(0)).getDomain());
                        List domainEos = this.domainDas.select((BaseEo)domainEo, Integer.valueOf(1), Integer.valueOf(1));
                        if (!CollectionUtils.isEmpty((Collection)domainEos)) {
                            docRespDto.setRealmName(((DomainEo)domainEos.get(0)).getName());
                        }
                    }
                }
            } else {
                DomainEo domainEo = new DomainEo();
                domainEo.setCode(eo.getAbilityGroupCode());
                List domainEos = this.domainDas.select((BaseEo)domainEo, Integer.valueOf(1), Integer.valueOf(1));
                if (!CollectionUtils.isEmpty((Collection)domainEos)) {
                    docRespDto.setRealmName(((DomainEo)domainEos.get(0)).getName());
                }
            }
            dtoList.add(docRespDto);
        }
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ApiRespDto> queryBindApi(DocBindApiReqDto bindApiReqDto) {
        List apiIds;
        List<ApiSceneRelationEo> apiSceneRelationEos;
        DocEo docEo = (DocEo)this.docDas.selectByPrimaryKey(bindApiReqDto.getDocId());
        ArrayList<ApiRespDto> apiRespDtos = new ArrayList<ApiRespDto>();
        if (null != docEo && !CollectionUtils.isEmpty(apiSceneRelationEos = this.queryByCode(docEo.getAbilityGroupCode())) && !CollectionUtils.isEmpty(apiIds = apiSceneRelationEos.stream().map(StdApiSceneRelationEo::getApiId).collect(Collectors.toList()))) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"id", (Object)org.apache.commons.lang3.StringUtils.join(apiIds, (String)",")));
            if (!StringUtils.isEmpty((Object)bindApiReqDto.getApiName())) {
                sqlFilters.add(SqlFilter.like((String)"api_name", (Object)('%' + bindApiReqDto.getApiName() + '%')));
            }
            ApiEo apiEo = new ApiEo();
            apiEo.setSqlFilters(sqlFilters);
            List apiEos = this.apiDas.select((BaseEo)apiEo);
            CubeBeanUtils.copyCollection(apiRespDtos, (Collection)apiEos, ApiRespDto.class);
            if (!CollectionUtils.isEmpty(apiRespDtos)) {
                apiRespDtos.forEach(apiRespDto -> {
                    String moduleCode = apiRespDto.getModuleCode();
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)moduleCode)) {
                        apiRespDto.setModuleName("-");
                    } else {
                        ModuleEo moduleEo = new ModuleEo();
                        moduleEo.setModuleCode(moduleCode);
                        List moduleEos = this.moduleDas.select((BaseEo)moduleEo, Integer.valueOf(1), Integer.valueOf(1));
                        if (!CollectionUtils.isEmpty((Collection)moduleEos)) {
                            String moduleName = ((ModuleEo)moduleEos.get(0)).getModuleName();
                            String afterCutGroupName = this.cutGroupName(apiRespDto.getGroupName(), moduleName);
                            apiRespDto.setGroupName(afterCutGroupName);
                            apiRespDto.setModuleName(moduleName);
                        } else {
                            DomainEo domainEo = new DomainEo();
                            domainEo.setCode(moduleCode);
                            List domainEos = this.domainDas.select((BaseEo)domainEo, Integer.valueOf(1), Integer.valueOf(1));
                            if (CollectionUtils.isEmpty((Collection)domainEos)) {
                                apiRespDto.setModuleName("-");
                            } else {
                                String moduleName = ((DomainEo)domainEos.get(0)).getName();
                                String afterCutGroupName = this.cutGroupName(apiRespDto.getGroupName(), moduleName);
                                apiRespDto.setGroupName(afterCutGroupName);
                                apiRespDto.setModuleName(moduleName);
                            }
                        }
                    }
                });
            }
        }
        return apiRespDtos;
    }

    @Override
    public List<DocOverviewDto> queryDocOverview() {
        List docOverViewVos = this.docDas.queryCount();
        ArrayList<DocOverviewDto> overviewDtos = new ArrayList<DocOverviewDto>();
        DocOverviewDto realmDto = new DocOverviewDto();
        realmDto.setName("\u9886\u57df\u6587\u6863");
        realmDto.setDescription("\u5305\u542b\u9886\u57df\u4ecb\u7ecd\u3001\u5e94\u7528\u573a\u666f\u3001API\u6e05\u5355");
        realmDto.setType(DocConstants.REALM_DOC);
        DocOverviewDto sceneDto = new DocOverviewDto();
        sceneDto.setName("\u5e94\u7528\u573a\u666f\u6587\u6863");
        sceneDto.setDescription("\u5305\u542b\u573a\u666f\u4ecb\u7ecd\u3001\u4e1a\u52a1\u573a\u666f\u6d41\u7a0b\u3001API\u8c03\u7528\u65b9\u6848\u3001\u573a\u666f\u6240\u7528API\u6e05\u5355");
        sceneDto.setType(DocConstants.SCENE_DOC);
        if (!CollectionUtils.isEmpty((Collection)docOverViewVos)) {
            docOverViewVos.forEach(docOverViewVo -> {
                Integer shelfNum = docOverViewVo.getShelfNum();
                Integer total = docOverViewVo.getTotal();
                if (DocConstants.REALM_DOC.equals(docOverViewVo.getType())) {
                    realmDto.setShelfNum(shelfNum);
                    realmDto.setTotal(total);
                } else if (DocConstants.SCENE_DOC.equals(docOverViewVo.getType())) {
                    sceneDto.setShelfNum(shelfNum);
                    sceneDto.setTotal(total);
                }
            });
        } else {
            realmDto.setTotal(Integer.valueOf(0));
            realmDto.setShelfNum(Integer.valueOf(0));
            sceneDto.setShelfNum(Integer.valueOf(0));
            sceneDto.setTotal(Integer.valueOf(0));
        }
        overviewDtos.add(realmDto);
        overviewDtos.add(sceneDto);
        DocOverViewVo docOverViewVo2 = this.apiDas.queryCount();
        if (null != docOverViewVo2) {
            DocOverviewDto overviewDto = new DocOverviewDto();
            overviewDto.setName("API\u6587\u6863");
            overviewDto.setDescription("\u5305\u542bAPI\u8bf7\u6c42\u53c2\u6570\u3001\u54cd\u5e94\u53c2\u6570\u3001\u8bf7\u6c42/\u54cd\u5e94\u8303\u4f8b\u53ca\u5e94\u7528\u573a\u666f");
            BeanUtils.copyProperties((Object)docOverViewVo2, (Object)overviewDto);
            overviewDto.setType(DocConstants.API_DOC);
            overviewDtos.add(overviewDto);
        }
        return overviewDtos;
    }

    private List<ApiSceneRelationEo> queryByCode(String sceneCode) {
        ApiSceneRelationEo relationEo = new ApiSceneRelationEo();
        relationEo.setSceneCode(sceneCode);
        return this.relationDas.select((BaseEo)relationEo);
    }

    private void validDomainCapability(Integer type, String code) {
        if (type.equals(DocConstants.REALM_DOC)) {
            DomainEo domainEo = new DomainEo();
            domainEo.setCode(code);
            List domainEoResults = this.domainDas.select((BaseEo)domainEo, Integer.valueOf(1), Integer.valueOf(1));
            if (CollectionUtils.isEmpty((Collection)domainEoResults)) {
                throw new BizException(DocApiExceptionCode.CODE_DELETE.getCode(), DocApiExceptionCode.CODE_DELETE.getMsg());
            }
        } else if (type.equals(DocConstants.SCENE_DOC)) {
            CapabilityEo capabilityEo = new CapabilityEo();
            capabilityEo.setCode(code);
            capabilityEo.setParentCode("ROOT_NODE");
            capabilityEo.setStatus(DocConstants.ENABLE);
            List capabilityEoResults = this.capabilityDas.select((BaseEo)capabilityEo, Integer.valueOf(1), Integer.valueOf(1));
            if (CollectionUtils.isEmpty((Collection)capabilityEoResults)) {
                throw new BizException(DocApiExceptionCode.CODE_DELETE.getCode(), DocApiExceptionCode.CODE_DELETE.getMsg());
            }
        }
    }

    private String cutGroupName(String groupName, String moduleName) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)groupName) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)moduleName)) {
            String afterCutGroupName = groupName.replaceAll(moduleName, "");
            afterCutGroupName = afterCutGroupName.replaceAll(REGEX, "");
            return afterCutGroupName;
        }
        return groupName;
    }
}

