/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.func.api.constants.AbilityConstants;
import com.dtyunxi.yundt.cube.center.func.api.constants.ParamSelectType;
import com.dtyunxi.yundt.cube.center.func.api.constants.ParamValueType;
import com.dtyunxi.yundt.cube.center.func.api.constants.SettingEditType;
import com.dtyunxi.yundt.cube.center.func.api.constants.SettingValueType;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SysParamCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SysParamItemCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SysParamItemModifyDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SysParamItemModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SysParamItemReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SysParamModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SysParamQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SysParamSingleQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SysParamValueReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AbilityRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ConfigImportDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ConfigImportFailDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SysParamItemRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SysParamRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SysParamValueRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.TenantSysParamRespDto;
import com.dtyunxi.yundt.cube.center.func.api.exception.CenterDataExceptionCode;
import com.dtyunxi.yundt.cube.center.func.biz.service.IAbilityService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ISysParamService;
import com.dtyunxi.yundt.cube.center.func.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.func.biz.vo.SysParamImportVo;
import com.dtyunxi.yundt.cube.center.func.dao.das.AbilityConfigRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.AbilityDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.ConfigScopeDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingOptionDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SysParamDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SysParamItemDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SysParamItemScopeDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SysParamValueDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.AbilityConfigRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ConfigScopeEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingOptionEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdAbilityConfigRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSysParamItemEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSysParamItemScopeEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSysParamValueEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SysParamEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SysParamItemEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SysParamItemScopeEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SysParamValueEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SysParamServiceImpl
implements ISysParamService {
    private static final Logger logger = LoggerFactory.getLogger(SysParamServiceImpl.class);
    private static final String FORMAT = "[^\\u4E00-\\u9FA5\\uF900-\\uFA2D\\w-_]";
    private static final String EXT_PART_IMPORT_SUCCESS = "4505";
    @Autowired
    private SysParamDas sysParamDas;
    @Autowired
    private SysParamItemDas sysParamItemDas;
    @Autowired
    private SysParamItemScopeDas sysParamItemScopeDas;
    @Autowired
    private SysParamValueDas sysParamValueDas;
    @Resource
    private IAbilityService iAbilityService;
    @Resource
    private ConfigScopeDas configScopeDas;
    @Resource
    private AbilityConfigRelationDas abilityConfigRelationDas;
    @Resource
    private AbilityDas abilityDas;
    @Resource
    private SettingDas settingDas;
    @Resource
    private SettingOptionDas settingOptionDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addSysParam(SysParamCreateReqDto sysParamCreateReqDto) {
        if (!this.checkFeild(sysParamCreateReqDto)) {
            throw new BizException(CenterDataExceptionCode.PARAM_INVALID.getCode(), "\u68c0\u67e5\u53c2\u6570\u5b57\u6bb5\u662f\u5426\u4e3a\u7a7a\u6216\u957f\u5ea6\u5927\u5c0f\u4e0d\u7b26\u5408\u8981\u6c42");
        }
        SysParamEo sysParamEo = this.sysParamDas.selectByParamCode(sysParamCreateReqDto.getCode());
        AssertUtil.isTrue(null == sysParamEo, CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + ":\u4e1a\u52a1\u53c2\u6570\u7f16\u7801\u91cd\u590d");
        SysParamEo sysParamName = new SysParamEo();
        sysParamName.setName(sysParamCreateReqDto.getName());
        AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)this.sysParamDas.select((BaseEo)sysParamName)), CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + ":\u4e1a\u52a1\u53c2\u6570\u540d\u79f0\u91cd\u590d");
        sysParamEo = new SysParamEo();
        DtoHelper.dto2Eo((BaseVo)sysParamCreateReqDto, (BaseEo)sysParamEo);
        if (StringUtils.isBlank((CharSequence)sysParamCreateReqDto.getExtension())) {
            sysParamEo.setExtension("");
        }
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)sysParamCreateReqDto.getAbilityCodes()), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u81f3\u5c11\u5173\u8054\u4e00\u4e2a\u80fd\u529b");
        List abilityCodes = sysParamCreateReqDto.getAbilityCodes();
        List abilityEos = this.abilityDas.selectByCodes(abilityCodes, sysParamCreateReqDto.getTenantId());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)abilityEos) && abilityEos.size() == abilityCodes.size(), CenterDataExceptionCode.RECORD_NOT_EXISTS.getMsg() + "\uff1a\u5173\u8054\u80fd\u529b\u4e0d\u5b58\u5728");
        ArrayList<AbilityConfigRelationEo> abilityConfigRelationEos = new ArrayList<AbilityConfigRelationEo>();
        for (String abilityCode : abilityCodes) {
            AbilityConfigRelationEo abilityConfigRelationEo = new AbilityConfigRelationEo();
            abilityConfigRelationEo.setConfigCode(sysParamCreateReqDto.getCode());
            abilityConfigRelationEo.setType(AbilityConstants.PARAM);
            abilityConfigRelationEo.setAbilityCode(abilityCode);
            abilityConfigRelationEo.setExtension("");
            abilityConfigRelationEos.add(abilityConfigRelationEo);
        }
        this.abilityConfigRelationDas.insertBatch(abilityConfigRelationEos);
        this.sysParamDas.insert((BaseEo)sysParamEo);
        if (CollectionUtils.isNotEmpty((Collection)sysParamCreateReqDto.getSysParamItemList())) {
            List sysParamItemList = sysParamCreateReqDto.getSysParamItemList();
            HashMap<String, String> itemCodeMap = new HashMap<String, String>();
            HashMap<String, String> itemNameMap = new HashMap<String, String>();
            ArrayList<SysParamItemEo> sysParamItemEos = new ArrayList<SysParamItemEo>();
            for (SysParamItemCreateReqDto itemDto : sysParamItemList) {
                if (StringUtils.isBlank((CharSequence)itemDto.getParamValue()) || !SysParamServiceImpl.checkValueDescFormat(itemDto.getValueDesc()) || !SysParamServiceImpl.checkValueDescFormat(itemDto.getParamValue()) || !SysParamServiceImpl.checkDescFormat(itemDto.getRemark())) {
                    throw new BizException(CenterDataExceptionCode.PARAM_INVALID.getCode(), "\u68c0\u67e5\u53c2\u6570\u5b57\u6bb5\u662f\u5426\u4e3a\u7a7a\u6216\u957f\u5ea6\u5927\u5c0f\u4e0d\u7b26\u5408\u8981\u6c42");
                }
                String itemCode = itemDto.getParamValue();
                AssertUtil.isTrue(StringUtils.isBlank((CharSequence)((CharSequence)itemCodeMap.get(itemCode))), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u4e1a\u52a1\u53c2\u6570\u9009\u9879\u503c\u5185\u5bb9\u5165\u53c2\u91cd\u590d");
                itemCodeMap.put(itemCode, itemCode);
                AssertUtil.isTrue(StringUtils.isBlank((CharSequence)((CharSequence)itemNameMap.get(itemDto.getValueDesc()))), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u4e1a\u52a1\u53c2\u6570\u9009\u9879\u503c\u540d\u79f0\u5165\u53c2\u91cd\u590d");
                itemNameMap.put(itemCode, itemCode);
                SysParamServiceImpl.validationParamValue(sysParamEo.getCode(), sysParamEo.getValueType(), itemDto.getParamValue());
                SysParamItemEo sysParamItemEo = new SysParamItemEo();
                DtoHelper.dto2Eo((BaseVo)itemDto, (BaseEo)sysParamItemEo);
                sysParamItemEo.setItemCode(itemDto.getParamValue());
                if (StringUtils.isBlank((CharSequence)itemDto.getExtension())) {
                    sysParamItemEo.setExtension("");
                }
                sysParamItemEo.setParamCode(sysParamEo.getCode());
                sysParamItemEos.add(sysParamItemEo);
            }
            this.sysParamItemDas.insertBatch(sysParamItemEos);
        }
        return sysParamEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ConfigImportDto importSysParam(List<SysParamCreateReqDto> sysParamCreateReqDtos, Integer portion) {
        List<SettingOptionEo> settingOptionEos;
        List<SettingEo> settingEos;
        SysParamImportVo sysParamImportVo;
        boolean part = false;
        if (portion != null && portion.equals(1)) {
            part = true;
        }
        ConfigImportDto configImportDto = new ConfigImportDto();
        ArrayList<ConfigImportFailDto> configImportFailDtos = new ArrayList<ConfigImportFailDto>();
        HashMap<String, SysParamCreateReqDto> errorParam = new HashMap<String, SysParamCreateReqDto>();
        ArrayList<SysParamCreateReqDto> feildError = new ArrayList<SysParamCreateReqDto>();
        HashMap<String, SysParamCreateReqDto> code2Param = new HashMap<String, SysParamCreateReqDto>();
        HashMap name2Param = new HashMap();
        block2: for (SysParamCreateReqDto sysParamCreateReqDto : sysParamCreateReqDtos) {
            SettingEo queryEo;
            if (!this.checkFeild(sysParamCreateReqDto)) {
                feildError.add(sysParamCreateReqDto);
                continue;
            }
            if (code2Param.get(sysParamCreateReqDto.getCode()) != null) {
                errorParam.put(sysParamCreateReqDto.getCode(), sysParamCreateReqDto);
            } else {
                queryEo = new SettingEo();
                queryEo.setCode(sysParamCreateReqDto.getCode());
                if (this.settingDas.count((BaseEo)queryEo) > 0) {
                    errorParam.put(sysParamCreateReqDto.getCode(), sysParamCreateReqDto);
                } else {
                    code2Param.put(sysParamCreateReqDto.getCode(), sysParamCreateReqDto);
                }
            }
            if (name2Param.get(sysParamCreateReqDto.getName()) != null) {
                errorParam.put(sysParamCreateReqDto.getName(), sysParamCreateReqDto);
            } else {
                queryEo = new SettingEo();
                queryEo.setName(sysParamCreateReqDto.getName());
                if (this.settingDas.count((BaseEo)queryEo) > 0) {
                    errorParam.put(sysParamCreateReqDto.getCode(), sysParamCreateReqDto);
                } else {
                    code2Param.put(sysParamCreateReqDto.getCode(), sysParamCreateReqDto);
                }
            }
            Map availableValues = sysParamCreateReqDto.getAvailableValues();
            ArrayList<Object> itemParamDtos = new ArrayList<Object>();
            if (availableValues != null && availableValues.size() > 0) {
                for (String string : availableValues.keySet()) {
                    SysParamItemCreateReqDto sysParamItemCreateReqDto = new SysParamItemCreateReqDto();
                    sysParamItemCreateReqDto.setParamValue((String)availableValues.get(string));
                    sysParamItemCreateReqDto.setValueDesc(string);
                    itemParamDtos.add(sysParamItemCreateReqDto);
                }
            }
            ArrayList sysParamItemList = sysParamCreateReqDto.getSysParamItemList();
            if (CollectionUtils.isNotEmpty(itemParamDtos)) {
                if (CollectionUtils.isNotEmpty((Collection)sysParamItemList)) {
                    sysParamItemList.addAll(itemParamDtos);
                } else {
                    sysParamItemList = new ArrayList(itemParamDtos);
                }
                sysParamCreateReqDto.setSysParamItemList(sysParamItemList);
            }
            if (!CollectionUtils.isNotEmpty((Collection)sysParamItemList)) continue;
            Set set = sysParamItemList.stream().map(SysParamItemCreateReqDto::getParamValue).collect(Collectors.toSet());
            if (set != null && set.size() != sysParamItemList.size()) {
                errorParam.put(sysParamCreateReqDto.getCode(), sysParamCreateReqDto);
            }
            for (SysParamItemCreateReqDto itemDto : sysParamItemList) {
                try {
                    if (!(SysParamServiceImpl.checkValueDescFormat(itemDto.getValueDesc()) && SysParamServiceImpl.checkValueDescFormat(itemDto.getParamValue()) && SysParamServiceImpl.checkDescFormat(itemDto.getRemark()))) {
                        errorParam.put(sysParamCreateReqDto.getCode(), sysParamCreateReqDto);
                        continue block2;
                    }
                    SysParamServiceImpl.validationParamValue(sysParamCreateReqDto.getCode(), sysParamCreateReqDto.getValueType(), itemDto.getParamValue());
                }
                catch (Exception e) {
                    errorParam.put(sysParamCreateReqDto.getCode(), sysParamCreateReqDto);
                    continue block2;
                }
            }
        }
        List<SysParamEo> sysParamInsertEos = new ArrayList<SysParamEo>();
        List<SysParamItemEo> sysParamItemInsertEos = new ArrayList<SysParamItemEo>();
        ArrayList<Object> errorDtoList = new ArrayList<SysParamCreateReqDto>();
        if (errorParam.size() > 0) {
            errorDtoList = new ArrayList(errorParam.values());
        }
        if (CollectionUtils.isNotEmpty(feildError)) {
            errorDtoList.addAll(feildError);
        }
        if (errorDtoList.size() > 0 && errorDtoList.size() == sysParamCreateReqDtos.size()) {
            configImportDto.setResultCode(CenterDataExceptionCode.CONFIG_IMPORT_ALL_FAIL.getCode());
            configImportDto.setResultMsg("\u63d0\u4ea4\u5931\u8d25\uff0c\u5168\u90e8\u4e1a\u52a1\u53c2\u6570\u5df2\u5b58\u5728\u6216\u6570\u636e\u4e0d\u7b26\u5408\u8981\u6c42");
            configImportDto.setData(configImportFailDtos);
        } else if (errorDtoList.size() > 0 && errorDtoList.size() != sysParamCreateReqDtos.size()) {
            if (part) {
                sysParamCreateReqDtos.removeAll(errorDtoList);
                sysParamImportVo = this.proccessInsertEo(sysParamCreateReqDtos);
                sysParamInsertEos = sysParamImportVo.getSysParamInsertEos();
                sysParamItemInsertEos = sysParamImportVo.getSysParamItemInsertEos();
                configImportDto.setResultCode(EXT_PART_IMPORT_SUCCESS);
                configImportDto.setResultMsg("\u90e8\u5206\u4e1a\u52a1\u53c2\u6570\u5bfc\u5165\u65b0\u589e\u6210\u529f");
                for (SysParamCreateReqDto sysParamCreateReqDto : errorDtoList) {
                    ConfigImportFailDto configImportFailDto = new ConfigImportFailDto();
                    configImportFailDto.setCode(sysParamCreateReqDto.getCode());
                    configImportFailDto.setName(sysParamCreateReqDto.getName());
                    configImportFailDtos.add(configImportFailDto);
                }
                configImportDto.setData(configImportFailDtos);
            } else {
                configImportDto.setResultCode(CenterDataExceptionCode.CONFIG_IMPORT_PART_FAIL.getCode());
                configImportDto.setResultMsg("\u63d0\u4ea4\u5931\u8d25\uff0c\u90e8\u5206\u4e1a\u52a1\u53c2\u6570\u5df2\u5b58\u5728\u6216\u6570\u636e\u4e0d\u7b26\u5408\u8981\u6c42");
                configImportDto.setData(configImportFailDtos);
            }
        } else if (errorDtoList.size() == 0) {
            sysParamImportVo = this.proccessInsertEo(sysParamCreateReqDtos);
            sysParamInsertEos = sysParamImportVo.getSysParamInsertEos();
            sysParamItemInsertEos = sysParamImportVo.getSysParamItemInsertEos();
            configImportDto.setResultCode("0");
            configImportDto.setResultMsg("\u5bfc\u5165\u6210\u529f");
            configImportDto.setData(configImportFailDtos);
        }
        if (CollectionUtils.isNotEmpty(sysParamInsertEos) && CollectionUtils.isNotEmpty(settingEos = this.sysParam2Setting(sysParamInsertEos))) {
            this.settingDas.insertBatch(settingEos);
        }
        if (CollectionUtils.isNotEmpty(sysParamItemInsertEos) && CollectionUtils.isNotEmpty(settingOptionEos = this.sysParamItem2SettingOption(sysParamItemInsertEos))) {
            this.settingOptionDas.insertBatch(settingOptionEos);
        }
        return configImportDto;
    }

    private List<SettingEo> sysParam2Setting(List<SysParamEo> sysParamInsertEos) {
        ArrayList<SettingEo> settingEos = new ArrayList<SettingEo>();
        for (SysParamEo sysParamEo : sysParamInsertEos) {
            SettingEo settingEo = new SettingEo();
            settingEo.setCode(sysParamEo.getCode());
            settingEo.setName(sysParamEo.getName());
            settingEo.setDescr(sysParamEo.getDescription());
            settingEo.setDefaultValue(sysParamEo.getDefaultValue());
            settingEo.setDisplayLevel(Integer.valueOf(3));
            settingEo.setViewVisible(Integer.valueOf(1));
            settingEo.setIsControlled(Integer.valueOf(1));
            settingEo.setCapabilityCode(sysParamEo.getCapabilityCode());
            if (sysParamEo.getSelectType() != null) {
                if (sysParamEo.getSelectType().equals(ParamSelectType.TEXT_FIELD.getCode())) {
                    settingEo.setEditType(Integer.valueOf(SettingEditType.INPUT.getCode()));
                    if (sysParamEo.getValueType() != null) {
                        if (sysParamEo.getValueType().equals(ParamValueType.TEXT.getCode())) {
                            settingEo.setValueType(Integer.valueOf(SettingValueType.STRING.getCode()));
                        }
                        if (sysParamEo.getValueType().equals(ParamValueType.INTEGER.getCode())) {
                            settingEo.setValueType(Integer.valueOf(SettingValueType.INTEGER.getCode()));
                        }
                        if (sysParamEo.getValueType().equals(ParamValueType.DATE.getCode())) {
                            settingEo.setValueType(Integer.valueOf(SettingValueType.DATE.getCode()));
                        }
                        if (sysParamEo.getValueType().equals(ParamValueType.DECIMAL.getCode())) {
                            settingEo.setValueType(Integer.valueOf(SettingValueType.NUMBERIC.getCode()));
                        }
                    }
                } else if (sysParamEo.getSelectType().equals(ParamSelectType.SINGLE_SELECT.getCode())) {
                    settingEo.setEditType(Integer.valueOf(SettingEditType.CHOICE.getCode()));
                    settingEo.setIsMultiChoice(Integer.valueOf(0));
                    if (sysParamEo.getValueType().equals(ParamValueType.BOOLEAN.getCode())) {
                        settingEo.setValueType(Integer.valueOf(SettingValueType.BOOLEAN.getCode()));
                    }
                    if (sysParamEo.getValueType().equals(ParamValueType.TEXT.getCode())) {
                        settingEo.setValueType(Integer.valueOf(SettingValueType.ENUM.getCode()));
                    }
                } else if (sysParamEo.getSelectType().equals(ParamSelectType.MULTI_SELECT.getCode())) {
                    settingEo.setEditType(Integer.valueOf(SettingEditType.CHOICE.getCode()));
                    settingEo.setIsMultiChoice(Integer.valueOf(1));
                    if (sysParamEo.getValueType().equals(ParamValueType.TEXT.getCode())) {
                        settingEo.setValueType(Integer.valueOf(SettingValueType.ENUM.getCode()));
                    }
                }
            }
            settingEo.setExtension("");
            settingEos.add(settingEo);
        }
        return settingEos;
    }

    private List<SettingOptionEo> sysParamItem2SettingOption(List<SysParamItemEo> sysParamItemInsertEos) {
        ArrayList<SettingOptionEo> settingOptionEos = new ArrayList<SettingOptionEo>();
        for (SysParamItemEo itemEo : sysParamItemInsertEos) {
            SettingOptionEo settingOptionEo = new SettingOptionEo();
            settingOptionEo.setSettingCode(itemEo.getParamCode());
            settingOptionEo.setCode(itemEo.getItemCode());
            settingOptionEo.setName(itemEo.getValueDesc());
            settingOptionEo.setOptionValue(itemEo.getParamValue());
            settingOptionEo.setDescr(itemEo.getRemark());
            settingOptionEo.setExtension("");
            settingOptionEos.add(settingOptionEo);
        }
        return settingOptionEos;
    }

    private void insertSysParamItem(SysParamEo sysParamEo, List<SysParamItemReqDto> sysParamItemDtoList) {
        if (CollectionUtils.isEmpty(sysParamItemDtoList)) {
            return;
        }
        List sysParamItemEoList = sysParamItemDtoList.stream().map(itemDto -> {
            SysParamServiceImpl.validationParamValue(sysParamEo.getCode(), sysParamEo.getValueType(), itemDto.getParamValue());
            SysParamItemEo sysParamItemEo = new SysParamItemEo();
            DtoHelper.dto2Eo((BaseVo)itemDto, (BaseEo)sysParamItemEo);
            if (StringUtils.isBlank((CharSequence)itemDto.getExtension())) {
                sysParamItemEo.setExtension("");
            }
            sysParamItemEo.setParamCode(sysParamEo.getCode());
            return sysParamItemEo;
        }).collect(Collectors.toList());
        this.sysParamItemDas.insertBatch(sysParamItemEoList);
    }

    public static void validationParamValue(String paramCode, Integer valueType, String paramValue) {
        AssertUtil.isTrue(valueType != null, "\u7f16\u7801\u4e3a" + paramCode + "\u7684\u4e1a\u52a1\u53c2\u6570\u7684\u503c\u7c7b\u578b\u4e0d\u80fd\u4e3anull");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)paramValue), "\u7f16\u7801\u4e3a" + paramCode + "\u7684\u4e1a\u52a1\u53c2\u6570\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        ParamValueType valueTypeEnum = ParamValueType.fromCode((int)valueType);
        switch (valueTypeEnum) {
            case TEXT: {
                break;
            }
            case INTEGER: {
                AssertUtil.isTrue(SysParamServiceImpl.isInteger(paramValue), "\u7f16\u7801\u4e3a" + paramCode + "\u7684\u4e1a\u52a1\u53c2\u6570\u503c\u5e94\u4e3a\u6574\u578b");
                break;
            }
            case BOOLEAN: {
                AssertUtil.isTrue(Arrays.asList("true", "false").contains(paramValue.toLowerCase()), "\u7f16\u7801\u4e3a" + paramCode + "\u7684\u4e1a\u52a1\u53c2\u6570\u7684\u503c\u5e94\u4e3a\u5e03\u5c14\u7c7b\u578b,\u4f8b\uff1atrue/false");
                break;
            }
            case DATE: {
                AssertUtil.isTrue(null != DateUtil.parse((String)paramValue), "\u7f16\u7801\u4e3a" + paramCode + "\u7684\u4e1a\u52a1\u53c2\u6570\u7684\u503c\u5e94\u4e3a\u65e5\u671f\u7c7b\u578b");
                break;
            }
            case DECIMAL: {
                AssertUtil.isTrue(SysParamServiceImpl.isDECIMAL(paramValue), "\u7f16\u7801\u4e3a" + paramCode + "\u7684\u4e1a\u52a1\u53c2\u6570\u7684\u503c\u5e94\u4e3a\u6d6e\u70b9\u7c7b\u578b");
                break;
            }
            default: {
                throw new BizException("\u7f16\u7801\u4e3a" + paramCode + "\u7684\u4e1a\u52a1\u53c2\u6570\u7684\u503c\u7c7b\u578b\u65e0\u6548");
            }
        }
    }

    private static boolean isInteger(String str) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)str), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        Pattern pattern = Pattern.compile("^[-+]?[0-9][\\d]*$");
        return pattern.matcher(str).matches();
    }

    private static boolean isDECIMAL(String str) {
        return StringUtils.isNumeric((CharSequence)str) || NumberUtils.isNumber((String)str);
    }

    private static boolean checkNameFormat(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[\\u4E00-\\u9FA5\\w]{0,20}$");
        return pattern.matcher(str).matches();
    }

    private static boolean checkCodeFormat(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[a-zA-Z][0-9a-zA-Z\\w.]{0,200}$");
        return pattern.matcher(str).matches();
    }

    private static boolean checkDescFormat(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            Pattern pattern = Pattern.compile("^.{0,200}$");
            return pattern.matcher(str).matches();
        }
        return true;
    }

    private static boolean checkValueDescFormat(String str) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)str), (String)"\u53c2\u6570paramValue \u6216 valueDesc\u4e0d\u80fd\u4e3a\u7a7a");
        Pattern pattern = Pattern.compile("^.{0,20}$");
        return pattern.matcher(str).matches();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSysParam(String paramCode) {
        this.checkExsitBizSpaceRelation(paramCode, new ArrayList<String>());
        this.sysParamDas.deleteByParamCode(paramCode);
        this.sysParamItemDas.deleteByParamCode(paramCode);
        this.sysParamValueDas.deleteByParamCode(paramCode);
        this.iAbilityService.removeAbilityConfigRelation(paramCode, AbilityConstants.PARAM);
    }

    private void checkExsitBizSpaceRelation(String paramCode, List<String> itemCodes) {
        ConfigScopeEo configScopeEo = new ConfigScopeEo();
        configScopeEo.setConfigCode(paramCode);
        configScopeEo.setType(AbilityConstants.PARAM);
        if (CollectionUtils.isNotEmpty(itemCodes)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"config_item_code", (Object)StringUtils.join(itemCodes, (String)",")));
            configScopeEo.setSqlFilters(sqlFilters);
        }
        AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)this.configScopeDas.select((BaseEo)configScopeEo)), CenterDataExceptionCode.RELATION_EXISTS.getMsg() + ":\u8be5\u4e1a\u52a1\u53c2\u6570\u88ab\u4e1a\u52a1\u7a7a\u95f4\u5173\u8054\uff0c\u4e0d\u80fd\u5220\u9664");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifySysParam(SysParamModifyReqDto reqDto) {
        SysParamEo paramEo = this.sysParamDas.selectByParamCode(reqDto.getCode());
        if (paramEo == null) {
            throw new BizException("\u4e1a\u52a1\u53c2\u6570\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        String name = reqDto.getName();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            SysParamEo record = new SysParamEo();
            record.setName(name);
            record.setSqlFilters(Collections.singletonList(SqlFilter.ne((String)"id", (Object)paramEo.getId())));
            if (this.sysParamDas.count((BaseEo)record) > 0) {
                throw new BizException("\u4e1a\u52a1\u53c2\u6570\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)reqDto.getAbilityCodes()), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u81f3\u5c11\u5173\u8054\u4e00\u4e2a\u80fd\u529b");
        this.iAbilityService.processAbilityRelation(reqDto.getCode(), AbilityConstants.PARAM, reqDto.getAbilityCodes(), null);
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)paramEo, (String[])new String[]{"code"});
        paramEo.setId(paramEo.getId());
        this.sysParamDas.updateSelective((BaseEo)paramEo);
        if (null != reqDto.getValueType()) {
            SysParamItemEo sysParamItemEo = new SysParamItemEo();
            sysParamItemEo.setParamCode(reqDto.getCode());
            List sysParamItemEos = this.sysParamItemDas.select((BaseEo)sysParamItemEo);
            for (SysParamItemEo eo : sysParamItemEos) {
                SysParamServiceImpl.validationParamValue(reqDto.getCode(), reqDto.getValueType(), eo.getParamValue());
            }
        }
        List paramItems = reqDto.getSysParamItemModifyDtos();
        List queryList = this.sysParamItemDas.selectByParamCodeAndItemCodes(reqDto.getCode(), new ArrayList());
        List<String> deleteItemCodes = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Collection)paramItems) && CollectionUtils.isNotEmpty((Collection)queryList)) {
            deleteItemCodes = queryList.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getItemCode())).map(StdSysParamItemEo::getItemCode).collect(Collectors.toList());
        } else if (CollectionUtils.isNotEmpty((Collection)paramItems) && CollectionUtils.isNotEmpty((Collection)queryList)) {
            HashMap<String, String> itemInsertMap = new HashMap<String, String>();
            for (SysParamItemModifyDto itemModifyDto : paramItems) {
                String itemCode = itemModifyDto.getItemCode();
                if (StringUtils.isBlank((CharSequence)itemCode)) {
                    itemCode = itemModifyDto.getParamValue();
                }
                itemInsertMap.put(itemCode, itemCode);
            }
            if (itemInsertMap.size() > 0) {
                for (SysParamItemEo itemEo : queryList) {
                    if (itemInsertMap.get(itemEo.getItemCode()) != null) continue;
                    deleteItemCodes.add(itemEo.getItemCode());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(deleteItemCodes)) {
            this.checkExsitBizSpaceRelation(reqDto.getCode(), deleteItemCodes);
        }
        SysParamItemEo sysParamItemEo = new SysParamItemEo();
        sysParamItemEo.setParamCode(reqDto.getCode());
        this.sysParamItemDas.logicDelete((BaseEo)sysParamItemEo);
        if (CollectionUtils.isNotEmpty((Collection)paramItems)) {
            ArrayList<SysParamItemReqDto> sysParamItemDtoList = new ArrayList<SysParamItemReqDto>();
            HashMap<String, String> itemCodeMap = new HashMap<String, String>();
            HashMap<String, String> itemNameMap = new HashMap<String, String>();
            for (SysParamItemModifyDto sysParamItemModifyDto : paramItems) {
                String itemCode = sysParamItemModifyDto.getItemCode();
                String itemName = sysParamItemModifyDto.getValueDesc();
                AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)itemCode), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u4e1a\u52a1\u53c2\u6570\u9009\u9879\u503c\u7f16\u7801\u4e0d\u80fd\u4e3anull");
                AssertUtil.isTrue(StringUtils.isBlank((CharSequence)((CharSequence)itemCodeMap.get(itemCode))), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u4e1a\u52a1\u53c2\u6570\u9009\u9879\u503c\u7f16\u7801\u5165\u53c2\u91cd\u590d");
                itemCodeMap.put(itemCode, itemCode);
                AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)itemName), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u4e1a\u52a1\u53c2\u6570\u9009\u9879\u503c\u540d\u79f0\u4e0d\u80fd\u4e3anull");
                AssertUtil.isTrue(StringUtils.isBlank((CharSequence)((CharSequence)itemNameMap.get(itemName))), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u4e1a\u52a1\u53c2\u6570\u9009\u9879\u503c\u540d\u79f0\u5165\u53c2\u91cd\u590d");
                itemNameMap.put(itemName, itemName);
                SysParamItemReqDto sysParamItemReqDto = new SysParamItemReqDto();
                CubeBeanUtils.copyProperties((Object)sysParamItemReqDto, (Object)sysParamItemModifyDto, (String[])new String[0]);
                sysParamItemReqDto.setParamCode(paramEo.getCode());
                sysParamItemDtoList.add(sysParamItemReqDto);
            }
            this.insertSysParamItem(paramEo, sysParamItemDtoList);
        }
    }

    @Override
    public void addSysParamItem(String paramCode, List<SysParamItemReqDto> sysParamItemDtoList) {
        SysParamEo sysParamEo = this.sysParamDas.selectByParamCode(paramCode);
        AssertUtil.isTrue(null != sysParamEo, CenterDataExceptionCode.PARAM_NOT_EXISTS.getMsg());
        this.insertSysParamItem(sysParamEo, sysParamItemDtoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setSysParamValue(String paramCode, List<SysParamValueReqDto> sysParamValueDtoList) {
        this.sysParamValueDas.deleteByParamCode(paramCode);
        SysParamEo sysParamEo = this.sysParamDas.selectByParamCode(paramCode);
        AssertUtil.isTrue(null != sysParamEo, CenterDataExceptionCode.PARAM_NOT_EXISTS.getMsg());
        List valueEoList = sysParamValueDtoList.stream().map(valueDto -> {
            SysParamServiceImpl.validationParamValue(sysParamEo.getCode(), sysParamEo.getValueType(), valueDto.getParamValue());
            SysParamValueEo sysParamValueEo = new SysParamValueEo();
            DtoHelper.dto2Eo((BaseVo)valueDto, (BaseEo)sysParamValueEo);
            sysParamValueEo.setParamCode(paramCode);
            return sysParamValueEo;
        }).collect(Collectors.toList());
        this.sysParamValueDas.insertBatch(valueEoList);
    }

    @Override
    public void modifySysParamItem(String paramCode, String itemCode, SysParamItemModifyReqDto sysParamItemModifyReqDto) {
        SysParamItemEo sysParamItemEo = new SysParamItemEo();
        sysParamItemEo.setParamCode(paramCode);
        sysParamItemEo.setItemCode(itemCode);
        List sysParamItemEoList = this.sysParamItemDas.select((BaseEo)sysParamItemEo);
        if (CollectionUtils.isEmpty((Collection)sysParamItemEoList)) {
            SysParamItemEo insertEo = new SysParamItemEo();
            DtoHelper.dto2Eo((BaseVo)sysParamItemModifyReqDto, (BaseEo)insertEo);
            insertEo.setItemCode(itemCode);
            insertEo.setParamCode(paramCode);
            this.sysParamItemDas.insert((BaseEo)insertEo);
        } else {
            if (sysParamItemEoList.size() > 1) {
                throw new BizException("\u5bf9\u5e94\u6570\u636e\u8fc7\u591a,\u4e00\u822c\u671f\u5f85\u53ea\u6709\u4e00\u4e2a\u6570\u636e");
            }
            DtoHelper.dto2Eo((BaseVo)sysParamItemModifyReqDto, (BaseEo)sysParamItemEo, (String[])new String[]{"param_code", "item_code"});
            sysParamItemEo.setId(((SysParamItemEo)sysParamItemEoList.get(0)).getId());
            this.sysParamItemDas.updateSelective((BaseEo)sysParamItemEo);
        }
    }

    @Override
    public void removeSysParamItem(String paramCode, String itemCode) {
        SysParamItemEo sysParamItemEo = new SysParamItemEo();
        sysParamItemEo.setParamCode(paramCode);
        sysParamItemEo.setItemCode(itemCode);
        this.sysParamItemDas.logicDelete((BaseEo)sysParamItemEo);
    }

    @Override
    public SysParamRespDto queryByCode(String code, SysParamSingleQueryReqDto sysParamSingleQueryReqDto) {
        SysParamRespDto result = new SysParamRespDto();
        SysParamEo sysParamEo = new SysParamEo();
        sysParamEo.setCode(code);
        List sysParamEos = this.sysParamDas.select((BaseEo)sysParamEo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)sysParamEos) && sysParamEos.size() == 1, CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + "\u6216\u6570\u636e\u4e0d\u5b58\u5728: \u671f\u5f85\u4e00\u822c\u6709\u4e14\u53ea\u6709\u4e00\u6761\u6570\u636e");
        DtoHelper.eo2Dto((BaseEo)((BaseEo)sysParamEos.get(0)), (BaseVo)result);
        if (sysParamSingleQueryReqDto != null && CollectionUtils.isNotEmpty((Collection)sysParamSingleQueryReqDto.getReses()) && sysParamSingleQueryReqDto.getReses().contains("item")) {
            SysParamItemEo sysParamItemEo = new SysParamItemEo();
            sysParamItemEo.setParamCode(code);
            List sysParamItemEos = this.sysParamItemDas.select((BaseEo)sysParamItemEo);
            ArrayList sysParamItemRespDtos = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)sysParamItemEos, sysParamItemRespDtos, SysParamItemRespDto.class);
            result.setSysParamItemList(sysParamItemRespDtos);
        }
        return result;
    }

    @Override
    public PageInfo<SysParamRespDto> queryByPage(SysParamQueryReqDto sysParamQueryDto, Integer pageNum, Integer pageSize) {
        SysParamEo queryEo = new SysParamEo();
        DtoHelper.dto2Eo((BaseVo)sysParamQueryDto, (BaseEo)queryEo);
        queryEo.setOrderByDesc("create_time");
        PageInfo pageInfo = new PageInfo();
        if (StringUtils.isNotBlank((CharSequence)sysParamQueryDto.getAbilityCodes())) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
            Object[] abilityCode = sysParamQueryDto.getAbilityCodes().split(",");
            ArrayList abilityCodes = new ArrayList(abilityCode.length);
            CollectionUtils.addAll(abilityCodes, (Object[])abilityCode);
            List sysParamEos = this.sysParamDas.selectSysParemEos(queryEo, abilityCodes);
            pageInfo = new PageInfo(sysParamEos);
        } else {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            if (StringUtils.isNotBlank((CharSequence)sysParamQueryDto.getCode())) {
                sqlFilters.add(SqlFilter.like((String)"code", (Object)("%" + sysParamQueryDto.getCode() + "%")));
                queryEo.setCode(null);
            }
            if (StringUtils.isNotBlank((CharSequence)sysParamQueryDto.getName())) {
                sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + sysParamQueryDto.getName() + "%")));
                queryEo.setName(null);
            }
            queryEo.setSqlFilters(sqlFilters);
            pageInfo = this.sysParamDas.selectPage((BaseEo)queryEo, pageNum, pageSize);
        }
        ArrayList<SysParamRespDto> dtoList = new ArrayList<SysParamRespDto>();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), dtoList, SysParamRespDto.class);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            for (SysParamRespDto sysParamRespDto : dtoList) {
                AbilityConfigRelationEo abilityConfigRelationEo = new AbilityConfigRelationEo();
                abilityConfigRelationEo.setConfigCode(sysParamRespDto.getCode());
                abilityConfigRelationEo.setType(AbilityConstants.PARAM);
                PageInfo abilityConfigRelationEoPageInfo = this.abilityConfigRelationDas.selectPage((BaseEo)abilityConfigRelationEo, Integer.valueOf(1), Integer.valueOf(1000));
                if (abilityConfigRelationEoPageInfo == null || !CollectionUtils.isNotEmpty((Collection)abilityConfigRelationEoPageInfo.getList())) continue;
                List abilityCodes = abilityConfigRelationEoPageInfo.getList().stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getAbilityCode())).map(StdAbilityConfigRelationEo::getAbilityCode).collect(Collectors.toList());
                List abilityEos = this.abilityDas.selectByCodes(abilityCodes, null);
                ArrayList abilityRespDtos = new ArrayList();
                DtoHelper.eoList2DtoList((Collection)abilityEos, abilityRespDtos, AbilityRespDto.class);
                sysParamRespDto.setAbilityRespDtos(abilityRespDtos);
            }
        }
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList(dtoList);
        List<String> codeList = dtoList.stream().map(SysParamRespDto::getCode).collect(Collectors.toList());
        this.setSysParamItemList(dtoList, codeList);
        this.setSysParamValueList(dtoList, codeList);
        return dtoPageInfo;
    }

    private void setSysParamItemList(List<SysParamRespDto> dtoList, List<String> codeList) {
        List itemEoList = this.sysParamItemDas.selectByParamCodes(codeList);
        Map<String, List<SysParamItemEo>> itemEoMap = itemEoList.stream().collect(Collectors.groupingBy(StdSysParamItemEo::getParamCode));
        dtoList.forEach(paramDto -> {
            List eoList = (List)itemEoMap.get(paramDto.getCode());
            DtoHelper.eoList2DtoList((Collection)eoList, (Collection)paramDto.getSysParamItemList(), SysParamItemRespDto.class);
        });
    }

    private void setSysParamValueList(List<SysParamRespDto> dtoList, List<String> codeList) {
        List valueEoList = this.sysParamValueDas.selectByParamCodes(codeList);
        Map<String, List<SysParamValueEo>> valueEoMap = valueEoList.stream().collect(Collectors.groupingBy(StdSysParamValueEo::getParamCode));
        dtoList.forEach(paramDto -> {
            List eoList = (List)valueEoMap.get(paramDto.getCode());
            DtoHelper.eoList2DtoList((Collection)eoList, (Collection)paramDto.getSysParamValueList(), SysParamValueRespDto.class);
        });
    }

    @Override
    public List<SysParamRespDto> queryByGroupCode(String groupCode) {
        SysParamEo queryEo = new SysParamEo();
        queryEo.setGroupCode(groupCode);
        List eoList = this.sysParamDas.select((BaseEo)queryEo);
        ArrayList<SysParamRespDto> dtoList = new ArrayList<SysParamRespDto>();
        DtoHelper.eoList2DtoList((Collection)eoList, dtoList, SysParamRespDto.class);
        return dtoList;
    }

    @Override
    public List<SysParamValueRespDto> queryValueByParamCode(String paramCode) {
        SysParamValueEo queryEo = new SysParamValueEo();
        queryEo.setParamCode(paramCode);
        List eoList = this.sysParamValueDas.select((BaseEo)queryEo);
        ArrayList<SysParamValueRespDto> dtoList = new ArrayList<SysParamValueRespDto>();
        DtoHelper.eoList2DtoList((Collection)eoList, dtoList, SysParamValueRespDto.class);
        return dtoList;
    }

    @Override
    public List<SysParamValueEo> queryValue(String code, String bizIdCode) {
        SysParamValueEo criteria = new SysParamValueEo();
        criteria.setBizIdCode(bizIdCode);
        criteria.setParamCode(code);
        List eoList = this.sysParamValueDas.select((BaseEo)criteria);
        return eoList;
    }

    @Override
    public List<SysParamItemRespDto> queryItemByParamCode(String paramCode) {
        SysParamItemEo queryEo = new SysParamItemEo();
        queryEo.setParamCode(paramCode);
        List eoList = this.sysParamItemDas.select((BaseEo)queryEo);
        ArrayList<SysParamItemRespDto> dtoList = new ArrayList<SysParamItemRespDto>();
        DtoHelper.eoList2DtoList((Collection)eoList, dtoList, SysParamItemRespDto.class);
        return dtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSysParamValue(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            String[] valueIds;
            for (String valueId : valueIds = ids.split(",")) {
                this.sysParamValueDas.logicDeleteById(Long.valueOf(valueId));
            }
        }
    }

    @Override
    public PageInfo<TenantSysParamRespDto> queryByPageForInstance(Long tenantId, SysParamQueryReqDto sysParamQueryDto, Integer pageNum, Integer pageSize) {
        SysParamEo queryEo = new SysParamEo();
        DtoHelper.dto2Eo((BaseVo)sysParamQueryDto, (BaseEo)queryEo);
        queryEo.setTenantId(tenantId);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List sysParamEoList = this.sysParamDas.selectListForInstance(queryEo);
        PageInfo pageInfo = new PageInfo(sysParamEoList);
        ArrayList sysParamForInstanceRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)sysParamEoList, sysParamForInstanceRespDtoList, TenantSysParamRespDto.class);
        PageInfo instanceRespDtoPageInfo = new PageInfo(sysParamForInstanceRespDtoList);
        CubeBeanUtils.copyProperties((Object)instanceRespDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        return instanceRespDtoPageInfo;
    }

    @Override
    public List<SysParamItemScopeEo> queryItemByCode4tenant(Long tenantId, String paramCode) {
        AssertUtil.isTrue(paramCode != null, "\u7f3a\u5c11paramCode");
        AssertUtil.isTrue(tenantId != null, "\u7f3a\u5c11tenantId");
        SysParamItemScopeEo queryEo = new SysParamItemScopeEo();
        queryEo.setParamCode(paramCode);
        queryEo.setTenantId(tenantId);
        return this.sysParamItemScopeDas.select((BaseEo)queryEo);
    }

    @Override
    public List<ConfigScopeEo> queryConfigScope(Long tenantId, String paramCode) {
        AssertUtil.isTrue(paramCode != null, "\u7f3a\u5c11paramCode");
        AssertUtil.isTrue(tenantId != null, "\u7f3a\u5c11tenantId");
        ConfigScopeEo configScopeEo = new ConfigScopeEo();
        configScopeEo.setConfigCode(paramCode);
        configScopeEo.packBizIdCodeByTenantId(tenantId);
        configScopeEo.setType(AbilityConstants.PARAM);
        return this.configScopeDas.select((BaseEo)configScopeEo);
    }

    @Override
    public SysParamItemEo queryItemByCode(String paramCode, String itemCode) {
        SysParamItemEo queryEo = new SysParamItemEo();
        queryEo.setParamCode(paramCode);
        queryEo.setItemCode(itemCode);
        List itemEos = this.sysParamItemDas.select((BaseEo)queryEo);
        if (itemEos != null && itemEos.size() == 1) {
            return (SysParamItemEo)itemEos.get(0);
        }
        if (CollectionUtils.isEmpty((Collection)itemEos)) {
            throw new BizException(CenterDataExceptionCode.PARAM_VALUE_NOT_FOUND.getCode(), "\u53c2\u6570:" + paramCode + ",\u503c\u4ee3\u7801:" + itemCode + "\u4e0d\u5b58\u5728");
        }
        return null;
    }

    private void setSysParamItemList(Long tenantId, List<SysParamRespDto> dtoList, List<String> codeList) {
        List sysParamItemScopeEoList = this.sysParamItemScopeDas.selectByParamCodes(tenantId, codeList);
        Map<String, List<SysParamItemScopeEo>> scopeEoMap = sysParamItemScopeEoList.stream().collect(Collectors.groupingBy(StdSysParamItemScopeEo::getParamCode));
        List sysParamItemEoList = this.sysParamItemDas.selectByParamCodes(codeList);
        Map<String, List<SysParamItemEo>> itemEoMap = sysParamItemEoList.stream().collect(Collectors.groupingBy(StdSysParamItemEo::getParamCode));
        dtoList.forEach(paramDto -> {
            ArrayList<SysParamItemEo> eoList = new ArrayList<SysParamItemEo>();
            List scopeEoList = (List)scopeEoMap.get(paramDto.getCode());
            List itemEoList = (List)itemEoMap.get(paramDto.getCode());
            if (CollectionUtils.isNotEmpty((Collection)scopeEoList) && CollectionUtils.isNotEmpty((Collection)itemEoList)) {
                Map<String, List<SysParamItemEo>> eoMap = itemEoList.stream().filter(eo -> StringUtils.isNotBlank((CharSequence)eo.getItemCode())).collect(Collectors.groupingBy(StdSysParamItemEo::getItemCode));
                for (SysParamItemScopeEo eo2 : scopeEoList) {
                    List<SysParamItemEo> list = eoMap.get(eo2.getItemCode());
                    if (!CollectionUtils.isNotEmpty(list)) continue;
                    eoList.addAll(list);
                }
                DtoHelper.eoList2DtoList(eoList, (Collection)paramDto.getSysParamItemList(), SysParamItemRespDto.class);
            }
        });
    }

    private void setSysParamValueList(Long tenantId, List<SysParamRespDto> dtoList, List<String> codeList) {
        List valueEoList = this.sysParamValueDas.selectByParamCodes(tenantId, null, codeList);
        Map<String, List<SysParamValueEo>> valueEoMap = valueEoList.stream().collect(Collectors.groupingBy(StdSysParamValueEo::getParamCode));
        dtoList.forEach(paramDto -> {
            List eoList = (List)valueEoMap.get(paramDto.getCode());
            DtoHelper.eoList2DtoList((Collection)eoList, (Collection)paramDto.getSysParamValueList(), SysParamValueRespDto.class);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setSysParamValueForTenant(String bizSpaceCode, List<SysParamValueReqDto> sysParamValueDtoList) {
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        AssertUtil.isTrue(tenantId != null, "tenantId\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(sysParamValueDtoList), "\u53c2\u6570\u503c\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        String bizIdCode = "tenantId=" + tenantId;
        Map<String, List<SysParamValueReqDto>> map = sysParamValueDtoList.stream().collect(Collectors.groupingBy(SysParamValueReqDto::getParamCode));
        List paramCodeList = sysParamValueDtoList.stream().filter(dto -> StringUtils.isNotBlank((CharSequence)dto.getParamCode())).map(SysParamValueReqDto::getParamCode).collect(Collectors.toList());
        List sysParamItemEoList = this.sysParamItemDas.selectByParamCodes(paramCodeList);
        ArrayList<SysParamValueEo> valueEoList = new ArrayList<SysParamValueEo>();
        for (Map.Entry<String, List<SysParamValueReqDto>> entry : map.entrySet()) {
            String paramCode = entry.getKey();
            SysParamEo sysParamEo = this.sysParamDas.selectByParamCode(paramCode);
            AssertUtil.isTrue(null != sysParamEo, CenterDataExceptionCode.PARAM_NOT_EXISTS.getMsg());
            this.sysParamValueDas.deleteByParamCodeAndBizIdCode(bizSpaceCode, paramCode, bizIdCode);
            this.sysParamValueDas.deleteByParamCodeAndBizIdCode(bizSpaceCode, paramCode, "");
            List<SysParamValueReqDto> dtoList = entry.getValue();
            for (SysParamValueReqDto valueDto : dtoList) {
                if (Integer.valueOf(ParamSelectType.TEXT_FIELD.getCode()).equals(sysParamEo.getSelectType()) && StringUtils.isNotBlank((CharSequence)valueDto.getParamValue())) {
                    SysParamServiceImpl.validationParamValue(sysParamEo.getCode(), sysParamEo.getValueType(), valueDto.getParamValue());
                }
                SysParamValueEo sysParamValueEo = new SysParamValueEo();
                DtoHelper.dto2Eo((BaseVo)valueDto, (BaseEo)sysParamValueEo);
                if ((Integer.valueOf(ParamSelectType.SINGLE_SELECT.getCode()).equals(sysParamEo.getSelectType()) || Integer.valueOf(ParamSelectType.MULTI_SELECT.getCode()).equals(sysParamEo.getSelectType())) && StringUtils.isNotBlank((CharSequence)valueDto.getItemCode()) && CollectionUtils.isNotEmpty((Collection)sysParamItemEoList)) {
                    for (SysParamItemEo itemEo : sysParamItemEoList) {
                        if (!sysParamEo.getCode().equals(itemEo.getParamCode()) || !valueDto.getItemCode().equals(itemEo.getItemCode())) continue;
                        sysParamValueEo.setParamValue(itemEo.getParamValue());
                        break;
                    }
                }
                sysParamValueEo.setTenantId(tenantId);
                sysParamValueEo.setBizIdCode("");
                if (StringUtils.isBlank((CharSequence)sysParamValueEo.getExtension())) {
                    sysParamValueEo.setExtension("");
                }
                valueEoList.add(sysParamValueEo);
            }
        }
        this.sysParamValueDas.insertBatch(valueEoList);
    }

    private SysParamImportVo proccessInsertEo(List<SysParamCreateReqDto> sysParamCreateReqDtos) {
        SysParamImportVo sysParamImportVo = new SysParamImportVo();
        ArrayList<SysParamEo> sysParamInsertEos = new ArrayList<SysParamEo>();
        ArrayList<SysParamItemEo> sysParamItemInsertEos = new ArrayList<SysParamItemEo>();
        ArrayList<AbilityConfigRelationEo> abilityConfigRelationInsertEos = new ArrayList<AbilityConfigRelationEo>();
        for (SysParamCreateReqDto sysParamCreateReqDto : sysParamCreateReqDtos) {
            SysParamEo sysParamEo = new SysParamEo();
            DtoHelper.dto2Eo((BaseVo)sysParamCreateReqDto, (BaseEo)sysParamEo);
            if (StringUtils.isBlank((CharSequence)sysParamCreateReqDto.getExtension())) {
                sysParamEo.setExtension("");
            }
            if (StringUtils.isBlank((CharSequence)sysParamCreateReqDto.getSource())) {
                sysParamEo.setSource("");
            }
            sysParamEo.setCapabilityCode(sysParamCreateReqDto.getCapabilityCode());
            sysParamInsertEos.add(sysParamEo);
            List sysParamItemList = sysParamCreateReqDto.getSysParamItemList();
            if (CollectionUtils.isNotEmpty((Collection)sysParamItemList)) {
                for (SysParamItemCreateReqDto itemDto : sysParamItemList) {
                    String itemCode = itemDto.getParamValue();
                    SysParamItemEo sysParamItemEo = new SysParamItemEo();
                    DtoHelper.dto2Eo((BaseVo)itemDto, (BaseEo)sysParamItemEo);
                    sysParamItemEo.setItemCode(itemCode);
                    if (StringUtils.isBlank((CharSequence)itemDto.getExtension())) {
                        sysParamItemEo.setExtension("");
                    }
                    sysParamItemEo.setParamCode(sysParamEo.getCode());
                    sysParamItemInsertEos.add(sysParamItemEo);
                }
            }
            if (!CollectionUtils.isNotEmpty((Collection)sysParamCreateReqDto.getAbilityCodes())) continue;
            for (String abilityCode : sysParamCreateReqDto.getAbilityCodes()) {
                AbilityConfigRelationEo abilityConfigRelationEo = new AbilityConfigRelationEo();
                abilityConfigRelationEo.setConfigCode(sysParamCreateReqDto.getCode());
                abilityConfigRelationEo.setType(AbilityConstants.PARAM);
                abilityConfigRelationEo.setAbilityCode(abilityCode);
                abilityConfigRelationEo.setExtension("");
                abilityConfigRelationInsertEos.add(abilityConfigRelationEo);
            }
        }
        sysParamImportVo.setSysParamInsertEos(sysParamInsertEos);
        sysParamImportVo.setSysParamItemInsertEos(sysParamItemInsertEos);
        sysParamImportVo.setAbilityConfigRelationInsertEos(abilityConfigRelationInsertEos);
        return sysParamImportVo;
    }

    private boolean checkFeild(SysParamCreateReqDto sysParamCreateReqDto) {
        if (!SysParamServiceImpl.checkCodeFormat(sysParamCreateReqDto.getCode())) {
            return false;
        }
        if (!SysParamServiceImpl.checkNameFormat(sysParamCreateReqDto.getName())) {
            return false;
        }
        if (!SysParamServiceImpl.checkDescFormat(sysParamCreateReqDto.getDescription())) {
            return false;
        }
        if (sysParamCreateReqDto.getSelectType() == null || ParamSelectType.fromCode((int)sysParamCreateReqDto.getSelectType()) == null) {
            return false;
        }
        return sysParamCreateReqDto.getValueType() != null && ParamValueType.fromCode((int)sysParamCreateReqDto.getValueType()) != null;
    }
}

