/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.support;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.identity.AviatorParam;
import com.dtyunxi.cube.identity.AviatorParamParseUtils;
import com.dtyunxi.cube.identity.ExpressionConstants;
import com.dtyunxi.cube.identity.IIdentificationBizObject;
import com.dtyunxi.cube.identity.IdentificationObject;
import com.dtyunxi.cube.identity.annotations.PropertyMapping;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.ConfigQueryReq;
import com.dtyunxi.yundt.cube.center.func.api.dto.TwoTuple;
import com.dtyunxi.yundt.cube.center.func.biz.support.AviatorExpressionItemEmum;
import com.dtyunxi.yundt.cube.center.func.biz.support.ConvertMapEmum;
import com.dtyunxi.yundt.cube.center.func.biz.support.identifications.AbstractIdentification;
import com.dtyunxi.yundt.cube.center.func.biz.util.ClassUtils;
import com.dtyunxi.yundt.cube.center.func.biz.util.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizObjDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizObjPropertyDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.RBizRuleObjPropertyDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizObjEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizObjPropertyEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.RBizRuleObjPropertyEo;
import com.google.common.collect.Maps;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class BusinessIdentityIdentifyService {
    private static final Logger logger = LoggerFactory.getLogger(BusinessIdentityIdentifyService.class);
    @Resource
    private BizObjDas bizObjDas;
    @Resource
    private BizObjPropertyDas bizObjPropertyDas;
    @Resource
    private RBizRuleObjPropertyDas rBizRuleObjPropertyDas;

    public static void putValueIntoParamMap(String bizObjCode, Field field, Object value, Map<String, Object> paramMap) {
        if (value == null) {
            return;
        }
        PropertyMapping propertyMapping = field.getAnnotation(PropertyMapping.class);
        String finalPropertyKey = propertyMapping != null ? propertyMapping.value() : field.getName();
        Class<?> clz = field.getType();
        if (Collection.class.isAssignableFrom(clz)) {
            BusinessIdentityIdentifyService.finalPutValueIntoParamMap(bizObjCode, finalPropertyKey, value.toString(), paramMap);
        } else if (Map.class.isAssignableFrom(clz)) {
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                BusinessIdentityIdentifyService.finalPutValueIntoParamMap(bizObjCode, String.valueOf(entry.getKey()), entry.getValue(), paramMap);
            }
        } else if (Date.class.isAssignableFrom(clz)) {
            BusinessIdentityIdentifyService.finalPutValueIntoParamMap(bizObjCode, finalPropertyKey, value, paramMap);
        } else if (clz.isArray()) {
            Object[] objects = (Object[])value;
            StringBuilder valueChain = new StringBuilder();
            for (int i = 0; i < objects.length; ++i) {
                valueChain.append(objects[i]).append(",");
            }
            BusinessIdentityIdentifyService.finalPutValueIntoParamMap(bizObjCode, finalPropertyKey, valueChain, paramMap);
        } else if (Enum.class.isAssignableFrom(clz)) {
            BusinessIdentityIdentifyService.finalPutValueIntoParamMap(bizObjCode, finalPropertyKey, value, paramMap);
        } else {
            BusinessIdentityIdentifyService.finalPutValueIntoParamMap(bizObjCode, finalPropertyKey, value, paramMap);
        }
    }

    public static void finalPutValueIntoParamMap(String bizObjCode, String finalPropertyKey, Object value, Map<String, Object> paramMap) {
        String key = AviatorParamParseUtils.getPropertyKey((String)bizObjCode, (String)finalPropertyKey);
        if (paramMap.containsKey(key)) {
            paramMap.put(key, String.valueOf(paramMap.get(key)) + "," + value);
        } else {
            paramMap.put(key, value);
        }
    }

    public static String getBizObjProperty(String source) {
        Pattern quotationMarkPattern = Pattern.compile(ConvertMapEmum.PARENTHESES_PATTERN.getSource());
        Matcher quotationMarkMatcher = quotationMarkPattern.matcher(source);
        if (quotationMarkMatcher.matches()) {
            return BusinessIdentityIdentifyService.getOriginPropertyName(source);
        }
        return null;
    }

    public static String getOriginPropertyName(String source) {
        StringBuilder midSource = new StringBuilder(source);
        return midSource.deleteCharAt(0).deleteCharAt(midSource.length() - 1).toString();
    }

    public String expressionConvert(String textExPression, Long ruleId) {
        String[] expressionItems = textExPression.split(" ");
        LinkedList<Object> stack = new LinkedList<Object>();
        StringBuilder expressionSb = new StringBuilder();
        String currentObjName = null;
        Map<String, TwoTuple<String, Map<String, String>>> objName2CodeMap = this.buildObjAndPropertyMapData(ruleId, expressionItems, currentObjName);
        currentObjName = null;
        for (int i = 0; i < expressionItems.length; ++i) {
            TwoTuple<AviatorExpressionItemEmum, String> target;
            String finalItem;
            String lastItem;
            String item = expressionItems[i];
            if (ConvertMapEmum.CONTAIN.getSource().equals(item) || ConvertMapEmum.NOT_CONTAIN.getSource().equals(item)) {
                lastItem = (String)stack.pop();
                finalItem = AviatorParamParseUtils.getPropertyKey((String)((String)objName2CodeMap.get(currentObjName).getFirst()), (String)lastItem);
                expressionSb = new StringBuilder(expressionSb.toString().replace(finalItem, ""));
                target = ConvertMapEmum.getTarget(expressionItems[++i], currentObjName, objName2CodeMap);
                expressionSb.append(ConvertMapEmum.CONTAIN.getTarget()).append("(").append(finalItem).append(",").append((String)target.getSecond()).append(")").append(" ");
                continue;
            }
            if (ConvertMapEmum.NOT_CONTAIN.getSource().equals(item)) {
                lastItem = (String)stack.pop();
                finalItem = AviatorParamParseUtils.getPropertyKey((String)((String)objName2CodeMap.get(currentObjName).getFirst()), (String)lastItem);
                expressionSb = new StringBuilder(expressionSb.toString().replace(finalItem, ""));
                target = ConvertMapEmum.getTarget(expressionItems[i], currentObjName, objName2CodeMap);
                expressionSb.append(ConvertMapEmum.NOT_CONTAIN.getTarget()).append("(").append(finalItem).append(",").append((String)target.getSecond()).append(")").append(" ");
                continue;
            }
            TwoTuple<AviatorExpressionItemEmum, String> target2 = ConvertMapEmum.getTarget(item, currentObjName, objName2CodeMap);
            if (AviatorExpressionItemEmum.OBJ == target2.getFirst()) {
                currentObjName = (String)target2.getSecond();
                continue;
            }
            if (AviatorExpressionItemEmum.LEFT_OBJ == target2.getFirst()) {
                currentObjName = (String)target2.getSecond();
                stack.push(ConvertMapEmum.LEFT_PARENTHESES.getTarget());
                expressionSb.append(ConvertMapEmum.LEFT_PARENTHESES.getTarget()).append(" ");
                continue;
            }
            if (AviatorExpressionItemEmum.RIGHT_OBJ == target2.getFirst()) {
                currentObjName = (String)target2.getSecond();
                stack.push(ConvertMapEmum.RIGHT_PARENTHESES0.getTarget());
                expressionSb.append(ConvertMapEmum.RIGHT_PARENTHESES0.getTarget()).append(" ");
                continue;
            }
            if (AviatorExpressionItemEmum.OTHER == target2.getFirst()) {
                stack.push(target2.getSecond());
                expressionSb.append((String)target2.getSecond()).append(" ");
                continue;
            }
            if (AviatorExpressionItemEmum.PROPERTY == target2.getFirst()) {
                stack.push(target2.getSecond());
                expressionSb.append(AviatorParamParseUtils.getPropertyKey((String)((String)objName2CodeMap.get(currentObjName).getFirst()), (String)((String)target2.getSecond()))).append(" ");
                continue;
            }
            if (AviatorExpressionItemEmum.OP == target2.getFirst()) {
                stack.push(target2.getSecond());
                expressionSb.append(AviatorParamParseUtils.getPropertyKey((String)((String)objName2CodeMap.get(currentObjName).getFirst()), (String)((String)target2.getSecond()))).append(" ");
                continue;
            }
            if (AviatorExpressionItemEmum.RIGHT_VALUE == target2.getFirst()) {
                stack.push(target2.getSecond());
                expressionSb.append((String)target2.getSecond()).append(" ) ");
                continue;
            }
            stack.push(target2.getSecond());
            expressionSb.append((String)target2.getSecond()).append(" ");
        }
        return expressionSb.toString();
    }

    private Map<String, TwoTuple<String, Map<String, String>>> buildObjAndPropertyMapData(Long ruleId, String[] expressionItems, String currentObjName) {
        Map<String, TwoTuple<String, Map<String, String>>> objName2CodeMap = this.parseExpressionItems(expressionItems, currentObjName);
        if (MapUtils.isNotEmpty(objName2CodeMap)) {
            BizObjEo objSelectParam = new BizObjEo();
            objSelectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("name", objName2CodeMap.keySet()).get());
            List bizObjEos = this.bizObjDas.select((BaseEo)objSelectParam);
            LinkedList rBizRuleObjPropertyEos = new LinkedList();
            if (CollectionUtils.isNotEmpty((Collection)bizObjEos)) {
                bizObjEos.forEach(bizObjEo -> {
                    RBizRuleObjPropertyEo rBizRuleObjEo = new RBizRuleObjPropertyEo();
                    rBizRuleObjEo.setBizObjCode(ExpressionConstants.convert((String)bizObjEo.getCode()));
                    rBizRuleObjEo.setBizRuleId(ruleId);
                    rBizRuleObjEo.setExtension("");
                    rBizRuleObjPropertyEos.add(rBizRuleObjEo);
                    TwoTuple mapTwoTuple = (TwoTuple)objName2CodeMap.get(bizObjEo.getName());
                    Map propertyName2CodeMap = (Map)mapTwoTuple.getSecond();
                    BizObjPropertyEo propertySelectParam = new BizObjPropertyEo();
                    propertySelectParam.setBizObjCode(bizObjEo.getCode());
                    propertySelectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("name", propertyName2CodeMap.keySet()).get());
                    List bizObjPropertyEos = this.bizObjPropertyDas.select((BaseEo)propertySelectParam);
                    if (CollectionUtils.isNotEmpty((Collection)bizObjPropertyEos)) {
                        bizObjPropertyEos.forEach(bizObjPropertyEo -> {
                            propertyName2CodeMap.put(bizObjPropertyEo.getName(), bizObjPropertyEo.getCode());
                            RBizRuleObjPropertyEo rBizRuleObjPropertyEo = new RBizRuleObjPropertyEo();
                            rBizRuleObjPropertyEo.setBizObjCode(ExpressionConstants.convert((String)bizObjEo.getCode()));
                            rBizRuleObjPropertyEo.setBizRuleId(ruleId);
                            rBizRuleObjPropertyEo.setBizObjPropertyCode(bizObjPropertyEo.getCode());
                            rBizRuleObjPropertyEo.setExtension("");
                            rBizRuleObjPropertyEos.add(rBizRuleObjPropertyEo);
                        });
                    }
                    mapTwoTuple.setFirst((Object)ExpressionConstants.convert((String)bizObjEo.getCode()));
                });
            }
            if (CollectionUtils.isNotEmpty(rBizRuleObjPropertyEos)) {
                this.rBizRuleObjPropertyDas.insertBatch(rBizRuleObjPropertyEos);
            }
        }
        return objName2CodeMap;
    }

    private Map<String, TwoTuple<String, Map<String, String>>> parseExpressionItems(String[] expressionItems, String currentObjName) {
        HashMap<String, TwoTuple<String, Map<String, String>>> objName2CodeMap = new HashMap<String, TwoTuple<String, Map<String, String>>>(10);
        for (String expressionItem : expressionItems) {
            TwoTuple<AviatorExpressionItemEmum, String> objTwoTuple = ConvertMapEmum.parse2BizObj(expressionItem);
            if (objTwoTuple == null) {
                String bizObjPropertyName = BusinessIdentityIdentifyService.getBizObjProperty(expressionItem);
                if (bizObjPropertyName == null || currentObjName == null) continue;
                TwoTuple mapTwoTuple = (TwoTuple)objName2CodeMap.get(currentObjName);
                if (mapTwoTuple.getSecond() == null) {
                    mapTwoTuple.setSecond(new HashMap());
                }
                ((Map)mapTwoTuple.getSecond()).put(bizObjPropertyName, null);
                continue;
            }
            if (!objName2CodeMap.containsKey(objTwoTuple.getSecond())) {
                objName2CodeMap.put((String)objTwoTuple.getSecond(), (TwoTuple<String, Map<String, String>>)new TwoTuple(null, new HashMap()));
            }
            currentObjName = (String)objTwoTuple.getSecond();
        }
        return objName2CodeMap;
    }

    public boolean identify0(String expression, AviatorParam aviatorParam) {
        Map env = aviatorParam.getParamMap();
        try {
            if (MapUtils.isEmpty((Map)env)) {
                return false;
            }
            Expression compiledExp = AviatorEvaluator.compile((String)expression);
            List variableFullNames = compiledExp.getVariableFullNames();
            for (String variableName : variableFullNames) {
                if (env.containsKey(variableName)) continue;
                return false;
            }
            Boolean result = (Boolean)compiledExp.execute(env);
            logger.info("Aviator\u89c4\u5219\u8868\u8fbe\u5f0f\uff1a{}\uff0c\n\u53c2\u6570\uff1a{},\n\u6700\u7ec8\u53c2\u6570\uff1a{},\n\u8bc6\u522b\u7ed3\u679c\uff1a{}", new Object[]{expression, aviatorParam.getParamMap(), env, result});
            return result == null ? false : result;
        }
        catch (Exception e) {
            logger.info("Aviator\u89c4\u5219\u8868\u8fbe\u5f0f\uff1a{}\uff0c\u53c2\u6570\uff1a{},\u89e3\u6790\u5f02\u5e38\uff1a", new Object[]{expression, aviatorParam.getParamMap(), e});
            return false;
        }
    }

    public boolean identityWithIdentificationObject(Collection<String> expressions, IdentificationObject iIdentificationObject) {
        return this.identityList(expressions, iIdentificationObject.getIdentificationBizObjects());
    }

    public boolean identityList(Collection<String> expressions, List<IIdentificationBizObject> identificationBizObjects) {
        AviatorParam aviatorParam = AviatorParamParseUtils.identificationConvert(identificationBizObjects);
        return this.identiyWithAviatorParam(expressions, aviatorParam);
    }

    public boolean identiyWithAviatorParam(Collection<String> expressions, AviatorParam aviatorParam) {
        if (MapUtils.isEmpty((Map)aviatorParam.getParamMap())) {
            return false;
        }
        for (String expression : expressions) {
            if (!this.identify0(expression, aviatorParam)) continue;
            return true;
        }
        return false;
    }

    public String identifyProcess(ConfigQueryReq req, Map<String, List<String>> bizIdentityCode2ExpressionsMap) {
        HashMap params = Maps.newHashMap();
        if (!StringUtils.isEmpty((Object)req.getBizObjs())) {
            JSONObject idObjs = (JSONObject)JSONObject.parse((String)req.getBizObjs());
            idObjs.forEach((idObjCode, jsonValue) -> {
                JSONObject idObj = (JSONObject)jsonValue;
                idObj.forEach((idObjPropCode, value) -> {
                    if (value instanceof Collection) {
                        value = StringUtils.collectionToCommaDelimitedString((Collection)((Collection)value));
                    } else if (value.getClass().isArray()) {
                        value = StringUtils.arrayToCommaDelimitedString((Object[])((Object[])value));
                    }
                    params.put(idObjCode.replaceAll("\\.", "_") + "$" + idObjPropCode, value);
                });
            });
        }
        AviatorParam aviatorParam = new AviatorParam();
        aviatorParam.setParamMap((Map)params);
        for (Map.Entry<String, List<String>> entry : bizIdentityCode2ExpressionsMap.entrySet()) {
            if (!this.identiyWithAviatorParam((Collection<String>)entry.getValue(), aviatorParam)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String identifyProcess(Map<String, List<String>> bizIdentityCode2ExpressionsMap) {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        try {
            String isAviatorParam = request.getHeader("IS_AVIATOR_PARAM");
            if (!StringUtils.hasText((String)isAviatorParam) && Boolean.parseBoolean(isAviatorParam)) {
                String aviatorParamJson = request.getHeader("AVIATOR_PARAM");
                logger.info("\u4e1a\u52a1\u8bc6\u522b\u53c2\u6570Json:{}", (Object)aviatorParamJson);
                if (!StringUtils.hasText((String)aviatorParamJson)) {
                    return null;
                }
                String json = URLDecoder.decode(aviatorParamJson, "utf-8");
                AviatorParam aviatorParam = (AviatorParam)JSONObject.parseObject((String)json, AviatorParam.class);
                for (Map.Entry<String, List<String>> entry : bizIdentityCode2ExpressionsMap.entrySet()) {
                    if (!this.identiyWithAviatorParam((Collection<String>)entry.getValue(), aviatorParam)) continue;
                    return entry.getKey();
                }
            } else {
                String identificationObjectJson = request.getHeader("IDENTIFICATION_OBJECT");
                logger.info("\u4e1a\u52a1\u8bc6\u522b\u5bf9\u8c61Json:{}", (Object)identificationObjectJson);
                if (StringUtils.isEmpty((Object)identificationObjectJson)) {
                    return null;
                }
                String json = URLDecoder.decode(identificationObjectJson, "utf-8");
                IdentificationObject identificationObject = BusinessIdentityIdentifyService.jsonObject2IdentificationObject(json);
                for (Map.Entry<String, List<String>> entry : bizIdentityCode2ExpressionsMap.entrySet()) {
                    if (!this.identityWithIdentificationObject((Collection<String>)entry.getValue(), identificationObject)) continue;
                    return entry.getKey();
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("\u53d6\u8bf7\u6c42header\u7684\u4e0a\u4e0b\u6587\u8bc6\u522b\u5bf9\u8c61\u5e8f\u5217\u5316\u5b57\u7b26\u4e32\u5f02\u5e38:", (Throwable)e);
        }
        return null;
    }

    public static IdentificationObject jsonObject2IdentificationObject(String json) {
        Field[] fields = ClassUtils.getAllFields(AbstractIdentification.class);
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Field field : fields) {
            fieldMap.put(field.getName(), field);
        }
        JSONArray jsonArray = JSONObject.parseArray((String)json);
        if (jsonArray == null) {
            return new IdentificationObject(new ArrayList());
        }
        IdentificationObject identificationObject = new IdentificationObject(new ArrayList(jsonArray.size()));
        for (Object object : jsonArray) {
            JSONObject beanJson = (JSONObject)object;
            AbstractIdentification abstractIdentification = BusinessIdentityIdentifyService.newAbstractIdentification();
            for (String key : beanJson.keySet()) {
                if (fieldMap.containsKey(key)) {
                    try {
                        Field field = (Field)fieldMap.get(key);
                        boolean accessible = field.isAccessible();
                        if (!accessible) {
                            field.setAccessible(true);
                        }
                        field.set(abstractIdentification, beanJson.getObject(key, field.getType()));
                        if (accessible) continue;
                        field.setAccessible(false);
                    }
                    catch (IllegalAccessException e) {
                        logger.warn("\u8bbe\u7f6eAbstractIdentification\u7684{}\u5c5e\u6027\u503c\u5f02\u5e38\uff1a", (Object)key, (Object)e);
                    }
                    continue;
                }
                Map<String, Object> extensionMap = abstractIdentification.getExtensionMap();
                extensionMap.put(key, beanJson.get((Object)key));
            }
            identificationObject.getIdentificationBizObjects().add(abstractIdentification);
        }
        return identificationObject;
    }

    private static AbstractIdentification newAbstractIdentification() {
        return new AbstractIdentification(){

            @Override
            public String getCode() {
                return super.getCode();
            }

            @Override
            public void setCode(String code) {
                super.setCode(code);
            }

            @Override
            public Map<String, Object> getExtensionMap() {
                return super.getExtensionMap();
            }

            @Override
            public void setExtensionMap(Map<String, Object> extensionMap) {
                super.setExtensionMap(extensionMap);
            }
        };
    }
}

