package com.dtyunxi.yundt.cube.center.wechat.org.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request.OrgAndEmployeeReqDto;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request.SyncDepartmentDto;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.response.OrgAndEmployeeRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Api(tags = {"用户中心：企业微信组织服务"})
@FeignClient(contextId = "com.dtyunxi.yundt.cube.center.wechat.org.api-IWeChatOrganizationApi",
            name = "${dtyunxi.yundt.cube_wechat-organization-center-user_api.name:bundle-wechat-organization-center-user}",
            path = "/v1/we-chat/org",
            url = "${dtyunxi.yundt.cube_wechat-organization-center-user_api:}")
public interface IWeChatOrganizationApi {

    /**
     * 全量或增量同步BOC组织及员工到企业微信
     *
     * @return 同步组织个数
     */
    @PostMapping("/sync")
    @ApiOperation(value = "全量或增量同步BOC组织及员工到企业微信", notes = "全量或增量同步BOC组织及员工到企业微信")
    RestResponse<Long> syncDepartment(@RequestBody SyncDepartmentDto syncDepartmentDto);

    /**
     * 全量同步企业微信部门及员工到BOC
     *
     * @return 同步组织个数
     */
    @PostMapping("/sync/to-boc")
    @ApiOperation(value = "全量同步企业微信部门及员工到BOC", notes = "全量同步企业微信部门及员工到BOC")
    RestResponse<Long> syncDepartmentToBoc(@RequestBody SyncDepartmentDto syncDepartmentDto);

    /**
     * 查询企业微信下应用可见范围的部门和成员列表
     *
     * @param orgAndEmployeeReqDto
     * @return
     */
    @GetMapping("/employee")
    @ApiOperation(value = "查询企业微信下应用可见范围的部门和成员列表", notes = "查询企业微信下应用可见范围的部门和成员列表")
    RestResponse<OrgAndEmployeeRespDto> queryOrgAndEmployee(@SpringQueryMap OrgAndEmployeeReqDto orgAndEmployeeReqDto);
}
