package com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;

@ApiModel(value = "ExternalContactReqDto", description = "批量获取客户详情请求dto")
public class ExternalContactReqDto extends FollowUserReqDto{

    private static final long serialVersionUID = 4689089082029443486L;

    @NotEmpty
    @ApiModelProperty(value = "企业成员的userId，字符串类型，对应员工编号employeeNo")
    private String userId;

    @ApiModelProperty(value = "用于分页查询的游标，字符串类型，由上一次调用返回，首次调用可不填")
    private String cursor;

    @ApiModelProperty(value = "返回的最大记录数，整型，最大值100，默认值50，超过最大值时取最大值")
    private Integer limit;

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getCursor() {
        return cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public Integer getLimit() {
        return limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }
}
