package com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

@ApiModel(value = "GetFollowUserReqDto", description = "获取配置了客户联系功能的成员列表请求dto")
public class FollowUserReqDto extends RequestDto {

    private static final long serialVersionUID = 8271708966640327611L;

    @ApiModelProperty(value = "渠道账号[例如微信的appId]，获取全量配置了客户联系功能的成员")
    private String channelAccount;

    @ApiModelProperty(value = "应用实例id，应用获取到可见范围内的配置了客户联系功能的成员")
    private Long appInstanceId;

    @NotNull
    @ApiModelProperty(value = "查询类型，1 全量成员，2 应用可见范围成员")
    private Integer queryType;


    public String getChannelAccount() {
        return channelAccount;
    }

    public void setChannelAccount(String channelAccount) {
        this.channelAccount = channelAccount;
    }

    public Long getAppInstanceId() {
        return appInstanceId;
    }

    public void setAppInstanceId(Long appInstanceId) {
        this.appInstanceId = appInstanceId;
    }

    public Integer getQueryType() {
        return queryType;
    }

    public void setQueryType(Integer queryType) {
        this.queryType = queryType;
    }
}
