package com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

@ApiModel(value = "GroupChatReqDto", description = "获取客户群列表请求dto")
public class GroupChatReqDto extends FollowUserReqDto{

    private static final long serialVersionUID = -2843474946699300506L;

    @ApiModelProperty(value = "客户群跟进状态过滤。\n" +
            "0 - 所有列表(即不过滤)\n" +
            "1 - 离职待继承\n" +
            "2 - 离职继承中\n" +
            "3 - 离职继承完成\n" +
            "\n" +
            "默认为0")
    private int statusFilter;

    @ApiModelProperty(value = "群主过滤。\n" +
            "如果不填，表示获取应用可见范围内全部群主的数据（但是不建议这么用，如果可见范围人数超过1000人，为了防止数据包过大，会报错 81017）")
    private OwnerFilter ownerFilter;

    @ApiModelProperty(value = "用于分页查询的游标，字符串类型，由上一次调用返回，首次调用可不填")
    private String cursor;

    @NotNull
    @ApiModelProperty(value = "分页，预期请求的数据量，取值范围 1 ~ 1000")
    private Integer limit;

    public static class OwnerFilter{
        @ApiModelProperty(value = "用户ID列表。最多100个")
        private List<String> userIdList;

        public List<String> getUserIdList() {
            return userIdList;
        }

        public void setUserIdList(List<String> userIdList) {
            this.userIdList = userIdList;
        }
    }

    public int getStatusFilter() {
        return statusFilter;
    }

    public void setStatusFilter(int statusFilter) {
        this.statusFilter = statusFilter;
    }

    public OwnerFilter getOwnerFilter() {
        return ownerFilter;
    }

    public void setOwnerFilter(OwnerFilter ownerFilter) {
        this.ownerFilter = ownerFilter;
    }

    public String getCursor() {
        return cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public Integer getLimit() {
        return limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }
}
