package com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;

@ApiModel(value = "OrgAndEmployeeReqDto", description = "查询企业微信下应用可见范围部门和成员请求dto")
public class OrgAndEmployeeReqDto extends RequestDto {

    private static final long serialVersionUID = 8730650159083949653L;

    /**
     * 应用实例id
     */
    @NotNull
    @ApiModelProperty(value = "应用实例id")
    private Long appInstanceId;

    @ApiModelProperty(value = "员工姓名")
    private String employeeName;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "createTimeStart", value = "员工创建开始时间")
    private Date createTimeStart;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "createTimeEnd", value = "员工创建结束时间")
    private Date createTimeEnd;

    public Long getAppInstanceId() {
        return appInstanceId;
    }

    public void setAppInstanceId(Long appInstanceId) {
        this.appInstanceId = appInstanceId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getCreateTimeStart() {
        return createTimeStart;
    }

    public void setCreateTimeStart(Date createTimeStart) {
        this.createTimeStart = createTimeStart;
    }

    public Date getCreateTimeEnd() {
        return createTimeEnd;
    }

    public void setCreateTimeEnd(Date createTimeEnd) {
        this.createTimeEnd = createTimeEnd;
    }
}
