package com.dtyunxi.yundt.cube.center.wechat.org.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request.ExternalContactReqDto;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request.FollowUserReqDto;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request.GroupChatDetailReqDto;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request.GroupChatReqDto;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.response.WeChatEmployeeRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Api(tags = {"用户中心：企业微信客户联系服务"})
@FeignClient(contextId = "com.dtyunxi.yundt.cube.center.wechat.org.api-IExternalContactQueryApi",
        name = "${dtyunxi.yundt.cube_wechat-organization-center-user_api.name:bundle-wechat-organization-center-user}",
        path = "/v1/we-chat/contact",
        url = "${dtyunxi.yundt.cube_wechat-organization-center-user_api:}")
public interface IExternalContactQueryApi {

    /**
     * 获取配置了客户联系功能的成员列表
     *
     * @param followUserReqDto
     * @return
     */
    @GetMapping("/user")
    @ApiOperation(value = "获取配置了客户联系功能的成员列表", notes = "获取配置了客户联系功能的成员列表")
    RestResponse<List<WeChatEmployeeRespDto>> queryFollowUserList(@SpringQueryMap FollowUserReqDto followUserReqDto);

    /**
     * 批量获取客户详情
     *
     * @param externalContactReqDto
     * @return
     */
    @PostMapping("")
    @ApiOperation(value = "批量获取客户详情", notes = "批量获取客户详情")
    RestResponse<String> getExternalContactByUser(@RequestBody ExternalContactReqDto externalContactReqDto);

    /**
     * 获取客户群列表
     *
     * @param groupChatReqDto
     * @return
     */
    @PostMapping("/group-chat")
    @ApiOperation(value = "获取客户群列表", notes = "获取客户群列表")
    RestResponse<String> getGroupChatList(@RequestBody GroupChatReqDto groupChatReqDto);

    /**
     * 获取客户群详情
     *
     * @param groupChatDetailReqDto
     * @return
     */
    @PostMapping("/group-chat/detail")
    @ApiOperation(value = "获取客户群详情", notes = "获取客户群详情")
    RestResponse<String> getGroupChatDetail(@RequestBody GroupChatDetailReqDto groupChatDetailReqDto);
}
