/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.biz.activity.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.opensearch.provider.es68.RestSearchClientUtils;
import com.dtyunxi.huieryun.opensearch.vo.OpenSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.ConflictSingleItemReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.SupportSingleItemDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.NotSupportSingleItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.SrcTypeUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.stereotype.Component;

@Component(value="itemActivityStockeEsServiceImpl")
public class ItemActivityStockeEsServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(ItemActivityStockeEsServiceImpl.class);
    private static final DefaultConversionService CONVERSION_SERVICE = new DefaultConversionService();
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Resource
    private OpenSearchVo searchVo;
    private static volatile ItemActivityStockeEsServiceImpl singleton = null;
    private RestHighLevelClient client;

    public List<NotSupportSingleItemDto> queryNotSupportSingleItem(SupportSingleItemDto supportSingleItemDto) {
        logger.info("[\u67e5\u8be2\u4e0d\u652f\u6301\u5355\u72ec\u8d2d\u4e70\u5546\u54c1]\uff0c\u5165\u53c2\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)supportSingleItemDto));
        if (CollectionUtils.isEmpty((Collection)supportSingleItemDto.getItemIds()) || CollectionUtils.isEmpty((Collection)supportSingleItemDto.getShopIds()) || CollectionUtils.isEmpty((Collection)supportSingleItemDto.getCustomerRespDtos())) {
            return Lists.newArrayList();
        }
        supportSingleItemDto.setPageNum(Integer.valueOf(1));
        supportSingleItemDto.setPageSize(Integer.valueOf(10000));
        ArrayList list = Lists.newArrayList();
        for (CustomerRespDto customerRespDto : supportSingleItemDto.getCustomerRespDtos()) {
            BoolQueryBuilder boolQueryBuilder = this.buildOSSearchVo(supportSingleItemDto, customerRespDto);
            SearchResultVo searchResultVo = this.doQuery(boolQueryBuilder, supportSingleItemDto.getPageNum(), supportSingleItemDto.getPageSize());
            if (null == searchResultVo) {
                return Lists.newArrayList();
            }
            list.addAll(this.convert(searchResultVo.getDocValues()));
        }
        return list;
    }

    public List<NotSupportSingleItemDto> queryConflictSingleItems(ConflictSingleItemReqDto conflictSingleItemReqDto) {
        if (CollectionUtils.isEmpty((Collection)conflictSingleItemReqDto.getItemIds())) {
            return Lists.newArrayList();
        }
        if (conflictSingleItemReqDto.getShopId() == null) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        BoolQueryBuilder boolQueryBuilder = this.buildConflictQuery(conflictSingleItemReqDto);
        SearchResultVo searchResultVo = this.doQuery(boolQueryBuilder, 1, 10000);
        if (null == searchResultVo) {
            return Lists.newArrayList();
        }
        list.addAll(this.convert(searchResultVo.getDocValues()));
        return list;
    }

    public PageInfo<NotSupportSingleItemDto> queryCustomerSingleItemPage(SupportSingleItemDto supportSingleItemDto) {
        if (CollectionUtils.isEmpty((Collection)supportSingleItemDto.getCustomerRespDtos())) {
            return new PageInfo();
        }
        BoolQueryBuilder boolQueryBuilder = this.buildMgmtPageOSSearchVo(supportSingleItemDto, (CustomerRespDto)supportSingleItemDto.getCustomerRespDtos().get(0));
        SearchResultVo searchResultVo = this.doQuery(boolQueryBuilder, supportSingleItemDto.getPageNum(), supportSingleItemDto.getPageSize());
        if (null == searchResultVo) {
            return new PageInfo();
        }
        List<NotSupportSingleItemDto> list = this.convert(searchResultVo.getDocValues());
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(supportSingleItemDto.getPageNum().intValue());
        pageInfo.setPageSize(supportSingleItemDto.getPageSize().intValue());
        pageInfo.setSize(list.size());
        pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
        pageInfo.setTotal(searchResultVo.getTotalSize());
        pageInfo.setList(list);
        return pageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private SearchResultVo doQuery(BoolQueryBuilder boolQueryBuilder, int pageNum, int pageSize) {
        SearchResponse response;
        if (singleton == null) {
            Class<ItemActivityStockeEsServiceImpl> clazz = ItemActivityStockeEsServiceImpl.class;
            // MONITORENTER : com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.biz.activity.base.service.impl.ItemActivityStockeEsServiceImpl.class
            if (singleton == null) {
                singleton = new ItemActivityStockeEsServiceImpl();
                this.client = RestSearchClientUtils.createClient((OpenSearchVo)this.searchVo);
            }
            // MONITOREXIT : clazz
        }
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().timeout(new TimeValue(3L, TimeUnit.SECONDS)).from(this.getStartIndex(pageNum, pageSize)).size(pageSize).explain(Boolean.valueOf(false)).fetchSource(true).query((QueryBuilder)boolQueryBuilder);
        logger.info("[es\u67e5\u8be2\u547d\u4ee4]{}", (Object)sourceBuilder);
        SearchRequest request = new SearchRequest(new String[]{"single_buy_item_" + this.globalProfile}).source(sourceBuilder);
        logger.info("[searchRequest]>>>{}", (Object)request);
        try {
            response = this.client.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException var7) {
            throw new RuntimeException("\u67e5\u8be2\u5f02\u5e38", var7);
        }
        logger.info("[\u6362\u8d2d\u5546\u54c1es\u54cd\u5e94\u6570\u636e]{}", (Object)JSON.toJSONString((Object)response));
        return this.wrapSearchResultVo(response, pageNum, pageSize);
    }

    private int getStartIndex(int page, int pageSize) {
        return page > 0 ? (page - 1) * pageSize : 0;
    }

    private SearchResultVo wrapSearchResultVo(SearchResponse response, Integer pageNum, Integer pageSize) {
        SearchHits hits = response.getHits();
        SearchResultVo result = new SearchResultVo();
        result.setTotalSize(hits.getTotalHits());
        result.setPageSize(pageSize.intValue());
        result.setStartIndex(this.getStartIndex(pageNum, pageSize));
        result.setDocValues(this.wrapDocValue(hits));
        return result;
    }

    protected List<Map<String, Object>> wrapDocValue(SearchHits hits) {
        SearchHit[] searchHits = hits.getHits();
        ArrayList<Map<String, Object>> docValue = new ArrayList<Map<String, Object>>(searchHits.length);
        SearchHit[] var4 = searchHits;
        int var5 = searchHits.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            SearchHit searchHit = var4[var6];
            Map highlightFields = searchHit.getHighlightFields();
            Map item = searchHit.getSourceAsMap();
            if (!highlightFields.isEmpty()) {
                StringBuilder highlightFieldStringBuilder = new StringBuilder();
                for (String key : highlightFields.keySet()) {
                    for (Text text : ((HighlightField)highlightFields.get(key)).fragments()) {
                        highlightFieldStringBuilder.append(text.string());
                    }
                    item.put(key, highlightFieldStringBuilder.toString());
                }
            }
            item.put("_score", Float.valueOf(searchHit.getScore()));
            docValue.add(item);
        }
        return docValue;
    }

    public BoolQueryBuilder buildConflictQuery(ConflictSingleItemReqDto conflictSingleItemReqDto) {
        List itemIds = conflictSingleItemReqDto.getItemIds().stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList());
        String shopId = String.valueOf(conflictSingleItemReqDto.getShopId());
        Integer mallType = conflictSingleItemReqDto.getMallType();
        List regionCodes = Optional.ofNullable(conflictSingleItemReqDto.getRegionCodes()).orElse(Lists.newArrayList()).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List customerTypeIds = conflictSingleItemReqDto.getCustomerTypeIds();
        List customerIds = conflictSingleItemReqDto.getCustomerIds();
        Integer selectCustomer = conflictSingleItemReqDto.getSelectCustomer();
        List excludeActivityIds = conflictSingleItemReqDto.getExcludeActivityIds();
        List blackCustomerIds = conflictSingleItemReqDto.getBlackCustomerIds();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"itemId", itemIds));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"shopId", (String)shopId));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"activityStatus", (String[])new String[]{"NEW", "ACTIVATE"}));
        if (CollectionUtils.isNotEmpty((Collection)excludeActivityIds)) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"activityId", (Collection)excludeActivityIds.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList())));
        }
        BoolQueryBuilder mallShouldQuery = QueryBuilders.boolQuery();
        mallShouldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"mallTypes", (String)"0"));
        mallShouldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"mallTypes", (Object)mallType));
        boolQueryBuilder.filter((QueryBuilder)mallShouldQuery);
        if (!Objects.equals(0, selectCustomer)) {
            BoolQueryBuilder shouldQuery = QueryBuilders.boolQuery();
            shouldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"selectCustomer", (String)"0"));
            BoolQueryBuilder customerShouldQuery = QueryBuilders.boolQuery();
            if (CollectionUtils.isNotEmpty((Collection)customerIds)) {
                customerShouldQuery.should((QueryBuilder)QueryBuilders.termsQuery((String)"customerIds", (Collection)customerIds.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList())));
            }
            shouldQuery.should((QueryBuilder)customerShouldQuery);
            if (CollectionUtils.isNotEmpty(regionCodes) || CollectionUtils.isNotEmpty((Collection)customerTypeIds)) {
                BoolQueryBuilder typeShouldQuery = QueryBuilders.boolQuery();
                typeShouldQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"selectCustomer", (String)"1"));
                if (CollectionUtils.isNotEmpty(regionCodes)) {
                    BoolQueryBuilder customerAreaShouldQuery = QueryBuilders.boolQuery();
                    BoolQueryBuilder existsAreaCodeQueryBool = QueryBuilders.boolQuery();
                    existsAreaCodeQueryBool.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"customerAreaCodes"));
                    customerAreaShouldQuery.should((QueryBuilder)existsAreaCodeQueryBool);
                    customerAreaShouldQuery.should((QueryBuilder)QueryBuilders.termsQuery((String)"customerAreaCodes", regionCodes));
                    typeShouldQuery.filter((QueryBuilder)customerAreaShouldQuery);
                }
                if (CollectionUtils.isNotEmpty((Collection)customerTypeIds)) {
                    BoolQueryBuilder customerTypeShouldQuery = QueryBuilders.boolQuery();
                    BoolQueryBuilder existsTypeQueryBool = QueryBuilders.boolQuery();
                    existsTypeQueryBool.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"customerTypeIds"));
                    customerTypeShouldQuery.should((QueryBuilder)existsTypeQueryBool);
                    customerTypeShouldQuery.should((QueryBuilder)QueryBuilders.termsQuery((String)"customerTypeIds", (Collection)customerTypeIds.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList())));
                    typeShouldQuery.filter((QueryBuilder)customerTypeShouldQuery);
                }
                shouldQuery.filter((QueryBuilder)typeShouldQuery);
            }
            boolQueryBuilder.filter((QueryBuilder)shouldQuery);
        }
        return boolQueryBuilder;
    }

    private BoolQueryBuilder buildOSSearchVo(SupportSingleItemDto supportSingleItemDto, CustomerRespDto customerRespDto) {
        List regionCodeList = Optional.ofNullable(customerRespDto.getRegionCodeList()).orElse(Lists.newArrayList()).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (CollectionUtils.isNotEmpty((Collection)supportSingleItemDto.getItemIds())) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"itemId", (Collection)supportSingleItemDto.getItemIds().stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList())));
        }
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"organizationId", (String)String.valueOf(customerRespDto.getMerchantId())));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"supportSingleBuy", (String)"1"));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"activityStatus", (Collection)supportSingleItemDto.getActivityStatus()));
        if (StringUtils.isNotBlank((CharSequence)supportSingleItemDto.getItemName())) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.wildcardQuery((String)"itemName", (String)("*" + supportSingleItemDto.getItemName() + "*")));
        }
        BoolQueryBuilder mallShouldQuery = QueryBuilders.boolQuery();
        mallShouldQuery.should().add(QueryBuilders.termQuery((String)"mallTypes", (String)"0"));
        mallShouldQuery.should().add(QueryBuilders.termQuery((String)"mallTypes", (String)String.valueOf(SrcTypeUtil.getCurrSrcType())));
        boolQueryBuilder.filter((QueryBuilder)mallShouldQuery);
        if (CollectionUtils.isNotEmpty((Collection)supportSingleItemDto.getActivityIds())) {
            String[] activityIdStrs = (String[])supportSingleItemDto.getActivityIds().stream().map(String::valueOf).toArray(String[]::new);
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"activityId", (String[])activityIdStrs));
        }
        BoolQueryBuilder shouldQuery = QueryBuilders.boolQuery();
        shouldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"selectCustomer", (String)"0"));
        BoolQueryBuilder typeShouldQuery = QueryBuilders.boolQuery();
        typeShouldQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"selectCustomer", (String)"1"));
        BoolQueryBuilder customerAreaShouldQuery = QueryBuilders.boolQuery();
        BoolQueryBuilder existsAreaCodeQueryBool = QueryBuilders.boolQuery();
        existsAreaCodeQueryBool.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"customerAreaCodes"));
        customerAreaShouldQuery.should((QueryBuilder)existsAreaCodeQueryBool);
        if (CollectionUtils.isNotEmpty(regionCodeList)) {
            customerAreaShouldQuery.should((QueryBuilder)QueryBuilders.termsQuery((String)"customerAreaCodes", regionCodeList));
        }
        typeShouldQuery.filter((QueryBuilder)customerAreaShouldQuery);
        BoolQueryBuilder customerTypeShouldQuery = QueryBuilders.boolQuery();
        BoolQueryBuilder existsTypeQueryBool = QueryBuilders.boolQuery();
        existsTypeQueryBool.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"customerTypeIds"));
        customerTypeShouldQuery.should((QueryBuilder)existsTypeQueryBool);
        if (customerRespDto.getCustomerTypeId() != null) {
            customerTypeShouldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"customerTypeIds", (String)String.valueOf(customerRespDto.getCustomerTypeId())));
        }
        typeShouldQuery.filter((QueryBuilder)customerTypeShouldQuery);
        BoolQueryBuilder blackCustomerIdQuery = QueryBuilders.boolQuery();
        blackCustomerIdQuery.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"blackCustomerIds", (String)String.valueOf(customerRespDto.getId())));
        typeShouldQuery.filter((QueryBuilder)blackCustomerIdQuery);
        shouldQuery.should((QueryBuilder)typeShouldQuery);
        shouldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"customerIds", (String)String.valueOf(customerRespDto.getId())));
        boolQueryBuilder.filter((QueryBuilder)shouldQuery);
        return boolQueryBuilder;
    }

    private BoolQueryBuilder buildMgmtPageOSSearchVo(SupportSingleItemDto supportSingleItemDto, CustomerRespDto customerRespDto) {
        List regionCodeList = Optional.ofNullable(customerRespDto.getRegionCodeList()).orElse(Lists.newArrayList()).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (CollectionUtils.isNotEmpty((Collection)supportSingleItemDto.getItemIds())) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"itemId", (Collection)supportSingleItemDto.getItemIds().stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList())));
        }
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"organizationId", (String)String.valueOf(customerRespDto.getMerchantId())));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"supportSingleBuy", (String)"1"));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"activityStatus", (Collection)supportSingleItemDto.getActivityStatus()));
        if (StringUtils.isNotBlank((CharSequence)supportSingleItemDto.getItemName())) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.wildcardQuery((String)"itemName", (String)("*" + supportSingleItemDto.getItemName() + "*")));
        }
        if (CollectionUtils.isNotEmpty((Collection)supportSingleItemDto.getActivityIds())) {
            String[] activityIdStrs = (String[])supportSingleItemDto.getActivityIds().stream().map(String::valueOf).toArray(String[]::new);
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"activityId", (String[])activityIdStrs));
        }
        BoolQueryBuilder shouldQuery = QueryBuilders.boolQuery();
        shouldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"selectCustomer", (String)"0"));
        BoolQueryBuilder typeShouldQuery = QueryBuilders.boolQuery();
        typeShouldQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"selectCustomer", (String)"1"));
        BoolQueryBuilder customerAreaShouldQuery = QueryBuilders.boolQuery();
        BoolQueryBuilder existsAreaCodeQueryBool = QueryBuilders.boolQuery();
        existsAreaCodeQueryBool.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"customerAreaCodes"));
        customerAreaShouldQuery.should((QueryBuilder)existsAreaCodeQueryBool);
        if (CollectionUtils.isNotEmpty(regionCodeList)) {
            customerAreaShouldQuery.should((QueryBuilder)QueryBuilders.termsQuery((String)"customerAreaCodes", regionCodeList));
        }
        typeShouldQuery.filter((QueryBuilder)customerAreaShouldQuery);
        BoolQueryBuilder customerTypeShouldQuery = QueryBuilders.boolQuery();
        BoolQueryBuilder existsTypeQueryBool = QueryBuilders.boolQuery();
        existsTypeQueryBool.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"customerTypeIds"));
        customerTypeShouldQuery.should((QueryBuilder)existsTypeQueryBool);
        if (customerRespDto.getCustomerTypeId() != null) {
            customerTypeShouldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"customerTypeIds", (String)String.valueOf(customerRespDto.getCustomerTypeId())));
        }
        typeShouldQuery.filter((QueryBuilder)customerTypeShouldQuery);
        BoolQueryBuilder blackCustomerIdQuery = QueryBuilders.boolQuery();
        blackCustomerIdQuery.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"blackCustomerIds", (String)String.valueOf(customerRespDto.getId())));
        typeShouldQuery.filter((QueryBuilder)blackCustomerIdQuery);
        shouldQuery.should((QueryBuilder)typeShouldQuery);
        shouldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"customerIds", (String)String.valueOf(customerRespDto.getId())));
        boolQueryBuilder.filter((QueryBuilder)shouldQuery);
        return boolQueryBuilder;
    }

    private List<NotSupportSingleItemDto> convert(List<Map<String, Object>> docValues) {
        if (CollectionUtils.isEmpty(docValues)) {
            return Lists.newArrayList();
        }
        List<NotSupportSingleItemDto> notSupportSingleItemDtos = docValues.stream().map(doc -> {
            NotSupportSingleItemDto notSupportSingleItemDto = new NotSupportSingleItemDto();
            notSupportSingleItemDto.setItemId((Long)CONVERSION_SERVICE.convert(doc.get("itemId"), Long.class));
            notSupportSingleItemDto.setActivityId((Long)CONVERSION_SERVICE.convert(doc.get("activityId"), Long.class));
            notSupportSingleItemDto.setShopId((Long)CONVERSION_SERVICE.convert(doc.get("shopId"), Long.class));
            notSupportSingleItemDto.setSupportSingleBuy((Integer)CONVERSION_SERVICE.convert(doc.get("supportSingleBuy"), Integer.class));
            notSupportSingleItemDto.setSkuId((Long)CONVERSION_SERVICE.convert(doc.get("skuId"), Long.class));
            return notSupportSingleItemDto;
        }).collect(Collectors.toList());
        return notSupportSingleItemDtos;
    }
}

