/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.biz.activity.engine.condition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.CouponTemplateItemSkuDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityTagService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ItemConditionTemplate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouponBlackSkuCondition
extends ItemConditionTemplate {
    public static final String BLACK_ITEM_CONDITION = "CouponBlackSkuCondition.items";
    private Logger logger = LoggerFactory.getLogger(CouponBlackSkuCondition.class);
    @Resource
    private IActivityService activityService;
    @Resource
    private IItemActivityTagService itemActivityTagService;

    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        Param param = define.getParam(BLACK_ITEM_CONDITION);
        if (null == param) {
            throw new ProBizException("\u5355\u54c1\u6761\u4ef6\u672a\u914d\u7f6e");
        }
        Collection items = (Collection)ConditionTemplate.converter(configParams.get(BLACK_ITEM_CONDITION), (Param)param, (String)define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)items)) {
            return true;
        }
        List<String> excludeSkuIds = CouponBlackSkuCondition.parseIncludeParams(items, true);
        context.getItems().removeIf(itemVo -> excludeSkuIds.stream().anyMatch(skuId -> Objects.equals(itemVo.getSkuId(), skuId)));
        if (CollectionUtils.isEmpty((Collection)context.getItems()) || !((ItemVo)context.getItems().get(0)).getShopId().equals(((CouponTemplateItemSkuDto)items.stream().findFirst().get()).getShopId().toString())) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u5546\u54c1\u54c1\u7c7b\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u5f53\u524d\u4f18\u60e0\u5238\u4e0d\u53ef\u7528"}));
        }
        return true;
    }

    public static List<CouponTemplateItemSkuDto> parseParams(String conditionParams) {
        if (StringUtils.isBlank((CharSequence)conditionParams)) {
            return Collections.emptyList();
        }
        JSONArray jsonArray = JSON.parseObject((String)conditionParams).getJSONArray(BLACK_ITEM_CONDITION);
        if (jsonArray == null) {
            return Collections.emptyList();
        }
        return jsonArray.toJavaList(CouponTemplateItemSkuDto.class);
    }

    public static List<String> parseIncludeParams(Collection<CouponTemplateItemSkuDto> items, boolean isExclude) {
        if (CollectionUtils.isEmpty(items)) {
            return Lists.newArrayList();
        }
        ArrayList skuIds = items.stream().filter(param -> param.isExclude() == isExclude).map(e -> e.getSkuId().toString()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(skuIds)) {
            skuIds = Lists.newArrayList();
        }
        return skuIds;
    }

    public boolean apply(TemplateDefine define, ConditionRespDto conditionRespDto, ItemVo itemVo) {
        JSONObject configParams = JSON.parseObject((String)conditionRespDto.getConditionParams());
        ArrayList<ItemVo> items = new ArrayList<ItemVo>();
        items.add(itemVo);
        EngineParams engineParams = new EngineParams();
        engineParams.setItems(items);
        engineParams.setActivityId(conditionRespDto.getActivityId().longValue());
        try {
            this.execute(define, conditionRespDto, (EngineParams)engineParams, (Map<String, ?>)configParams);
        }
        catch (ProBizException e) {
            this.logger.info("\u6761\u4ef6\u68c0\u67e5\u4e0d\u901a\u8fc7", (Throwable)e);
            return false;
        }
        return true;
    }

    public Set<ActivityItemDto> getItems(TemplateDefine define, ConditionRespDto conditionRespDto, Map<String, ?> configParams) {
        Param param = define.getParam(BLACK_ITEM_CONDITION);
        if (null == param) {
            throw new ProBizException("\u5355\u54c1\u6761\u4ef6\u672a\u914d\u7f6e");
        }
        Collection items = (Collection)ConditionTemplate.converter(configParams.get(BLACK_ITEM_CONDITION), (Param)param, (String)define.getLoadClass());
        ActivityRespDto activityRespDto = this.activityService.queryById(conditionRespDto.getActivityId());
        if (null == activityRespDto) {
            return Collections.EMPTY_SET;
        }
        ItemShelfQueryReqDto queryReqDto = new ItemShelfQueryReqDto();
        queryReqDto.setInstanceId(activityRespDto.getInstanceId());
        queryReqDto.setTenantId(activityRespDto.getTenantId());
        queryReqDto.setSellerId(activityRespDto.getSellerId());
        queryReqDto.setShopId(activityRespDto.getShopId());
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            List outSkuIds = items.stream().map(CouponTemplateItemSkuDto::getSkuId).collect(Collectors.toList());
            queryReqDto.setOutSkuIds(outSkuIds);
        }
        return this.itemActivityTagService.queryItemsForB2b(queryReqDto);
    }
}

