/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.biz.activity.engine.condition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.TargetMallType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ILoadConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.seckill.util.SeckillKeyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetMallCondition
extends ConditionTemplate
implements ILoadConditionTemplate {
    private static final String TARGET_CUSTOMER_TYPES = "TargetMallCondition.mallTypes";
    private static final Logger logger = LoggerFactory.getLogger(TargetMallCondition.class);
    @Resource
    private ICacheService commonCacheService;

    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        if (!context.getPopulationFlag().booleanValue()) {
            return true;
        }
        Param param = define.getParam(TARGET_CUSTOMER_TYPES);
        if (null == param) {
            throw new ProBizException("\u76ee\u6807\u5546\u57ce\u7c7b\u578b\u5217\u8868\u672a\u914d\u7f6e");
        }
        Object data = configParams.get(TARGET_CUSTOMER_TYPES);
        if (null != data) {
            logger.warn("\u89e3\u6790\u51fa\u6765\u7684\u662f=={}", (Object)JSONObject.toJSONString(data));
            List types = (List)ConditionTemplate.converter(data, (Param)param, (String)define.getLoadClass());
            if (CollectionUtils.isNotEmpty((Collection)types)) {
                if (types.size() == 1 && ((Integer)types.get(0)).equals(TargetMallType.ALL.getType())) {
                    return true;
                }
                ServiceContext serviceContext = ServiceContext.getContext();
                String object = serviceContext.getAttachment("yes.req.cus.b2b.srctype");
                if (object != null) {
                    context.setSrcType(Integer.valueOf(object));
                }
                return types.contains(context.getSrcType());
            }
        }
        throw new ProBizException("\u76ee\u6807\u5546\u57ce\u7c7b\u578b\u5217\u8868\u672a\u914d\u7f6e");
    }

    public void load(TemplateDefine define, ConditionRespDto conditionRespDto, Map<String, ?> activityParams, int expire) {
        Long activityId = conditionRespDto.getActivityId();
        logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u52a0\u8f7d\u5546\u57ce\u6761\u4ef6\u7684\u76ee\u6807\u5546\u57ce\u7c7b\u578b\u5f00\u59cb=====", (Object)activityId);
        Param param = define.getParam(TARGET_CUSTOMER_TYPES);
        List types = (List)ConditionTemplate.converter(activityParams.get(TARGET_CUSTOMER_TYPES), (Param)param, (String)define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)types)) {
            logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u9002\u7528\u5546\u57ce\u7c7b\u578b\u5217\u8868\u672a\u914d\u7f6e", (Object)activityId);
        }
        if (CollectionUtils.isNotEmpty((Collection)types)) {
            this.commonCacheService.setCache(SeckillKeyUtil.getCacheKey((String)"activity_target_mall", (Long)activityId), (Object)JSON.toJSONString((Object)types), expire);
        }
        logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u52a0\u8f7d\u5546\u57ce\u7c7b\u578b\u6761\u4ef6\u7684\u76ee\u6807\u5546\u57ce\u7c7b\u578b\u7ed3\u675f=====", (Object)activityId);
    }
}

