/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.dao.base.das;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSkuQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.mapper.ItemSkuMapper;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ItemRelationSkuVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ItemSkuConditionVo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ItemSkuDas
extends AbstractBaseDas<ItemSkuEo, String> {
    @Resource
    private ItemSkuMapper itemSkuMapper;

    public List<ItemSkuEo> selectByItemId(Long itemId) {
        ItemSkuEo ex = ItemSkuEo.newInstance();
        ex.setItemId(itemId);
        return this.select((BaseEo)ex);
    }

    public void deleteBatchItemSku(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ItemSkuMapper mapper = (ItemSkuMapper)this.getMapper();
        mapper.deleteBatchItemSku(ids);
    }

    public List<ItemSkuEo> selectItemSkuByIds(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return Lists.newArrayList();
        }
        ItemSkuEo skuEo = ItemSkuEo.newInstance();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(skuIds, (String)",")));
        skuEo.setSqlFilters((List)sqlFilters);
        return this.select((BaseEo)skuEo);
    }

    public List<ItemSkuEo> selectByItemIds(List<Long> itemIds) {
        if (CollectionUtils.isEmpty(itemIds)) {
            return Lists.newArrayList();
        }
        ItemSkuEo skuEo = ItemSkuEo.newInstance();
        skuEo.setOrderBy("id");
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"item_id", (Object)StringUtils.join(itemIds, (String)",")));
        skuEo.setSqlFilters((List)sqlFilters);
        return this.select((BaseEo)skuEo);
    }

    public List<ItemRelationSkuVo> queryItemRelationSku(ItemRelationSkuVo itemRelationSkuVo) {
        return this.itemSkuMapper.queryItemRelationSku(itemRelationSkuVo);
    }

    public Integer updateByItemIdAndSkuId(StdItemSkuEo stdItemSkuEo) {
        return this.itemSkuMapper.updateByItemIdAndSkuId(stdItemSkuEo);
    }

    public PageInfo<ItemRelationSkuVo> queryItemSkuPageByCondition(ItemSkuConditionVo itemSkuConditionVo, Integer pageNum, Integer pageSize) {
        ItemSkuMapper itemSkuMapper = (ItemSkuMapper)this.getMapper();
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List<ItemRelationSkuVo> itemSkuVoList = itemSkuMapper.queryItemSkuByCondition(itemSkuConditionVo);
        return new PageInfo(itemSkuVoList);
    }

    public List<ItemSkuQueryRespDto> querySkuPage(ItemSkuQueryReqDto itemSkuQueryReqDto, Integer pageNum, Integer pageSize) {
        if (Objects.isNull(pageNum) || pageNum <= 0) {
            pageNum = 1;
        }
        if (Objects.isNull(pageSize) || pageSize <= 0) {
            pageSize = 10;
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return this.itemSkuMapper.querySkuPage(itemSkuQueryReqDto);
    }
}

