/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections.MapUtils;

public class ProportionUtil {
    public static BigDecimal avgDisCounts(List<ItemVo> matchItem, BigDecimal sumPrice, int scale, int roundModel) {
        AtomicReference<BigDecimal> bg = new AtomicReference<BigDecimal>(sumPrice);
        BigDecimal totalSum = new BigDecimal(matchItem.parallelStream().mapToDouble(itemVo -> itemVo.getDiscountPrice().setScale(scale, roundModel).doubleValue() * (double)itemVo.getNum()).sum());
        double residue = matchItem.stream().map(itemVo -> {
            BigDecimal lastSum = sumPrice.multiply(itemVo.getDiscountPrice().multiply(new BigDecimal(itemVo.getNum()))).divide(totalSum, scale, roundModel);
            BigDecimal distinctPrice = itemVo.getDiscountPrice().subtract(lastSum.divide(new BigDecimal(itemVo.getNum()), scale, roundModel)).setScale(scale, roundModel);
            bg.getAndAccumulate(ProportionUtil.setDistinctPrice(itemVo, distinctPrice), (a, b) -> a.subtract(b.multiply(BigDecimal.valueOf(itemVo.getNum()))));
            return lastSum.doubleValue();
        }).reduce((sum, a) -> {
            sum = sum + a;
            return sum;
        }).get();
        ItemVo last = matchItem.get(matchItem.size() - 1);
        if (new BigDecimal(residue).compareTo(sumPrice) != 0) {
            BigDecimal bigDecimal = ProportionUtil.setDistinctPrice(last, last.getDiscountPrice().subtract(sumPrice.subtract(new BigDecimal(residue)).divide(new BigDecimal(last.getNum()), scale, roundModel)).setScale(scale, roundModel));
        }
        return bg.get();
    }

    private static BigDecimal setDistinctPrice(ItemVo itemVo, BigDecimal distinct) {
        if (distinct.compareTo(BigDecimal.ZERO) <= 0) {
            itemVo.setDiscountPrice(BigDecimal.ZERO);
            return distinct.negate();
        }
        itemVo.setDiscountPrice(distinct);
        return BigDecimal.ZERO;
    }

    public static <T extends EngineParams> void avgDisPoints(T context, BigDecimal totalItemAmt, BigDecimal totalDiscountAmt) {
        List itemVos = context.getItems();
        BigDecimal hasCalculate = BigDecimal.ZERO;
        for (int i = 0; i < itemVos.size(); ++i) {
            BigDecimal currItemDiscountAmt;
            ItemVo currItem = (ItemVo)itemVos.get(i);
            BigDecimal percentage = currItem.getDiscountPrice().multiply(BigDecimal.valueOf(currItem.getNum())).divide(totalItemAmt, 6, 2);
            if (i == itemVos.size() - 1) {
                currItemDiscountAmt = totalDiscountAmt.subtract(hasCalculate);
                ProportionUtil.setPoint2extendsAttribute(currItem, currItemDiscountAmt);
                continue;
            }
            currItemDiscountAmt = percentage.multiply(totalDiscountAmt).setScale(0, 1);
            hasCalculate = hasCalculate.add(currItemDiscountAmt);
            ProportionUtil.setPoint2extendsAttribute(currItem, currItemDiscountAmt);
        }
    }

    public static void setPoint2extendsAttribute(ItemVo itemVo, BigDecimal points) {
        Map extendsAttribute = itemVo.getExtendsAttribute();
        if (MapUtils.isEmpty((Map)extendsAttribute)) {
            HashMap newMap = Maps.newHashMap();
            newMap.put("returnPoints", points);
            itemVo.setExtendsAttribute((Map)newMap);
        } else {
            BigDecimal sourcePoints = (BigDecimal)MapUtils.getObject((Map)extendsAttribute, (Object)"returnPoints", (Object)BigDecimal.ZERO);
            extendsAttribute.put("returnPoints", sourcePoints.add(points));
        }
    }

    public static void setPoint2Context(EngineParams context, BigDecimal totalPoints) {
        Map extendsAttribute = context.getExtendsAttribute();
        BigDecimal sourcePoints = (BigDecimal)MapUtils.getObject((Map)extendsAttribute, (Object)"returnPoints", (Object)BigDecimal.ZERO);
        extendsAttribute.put("returnPoints", sourcePoints.add(totalPoints));
    }
}

