/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.utils;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.DiscountAmount;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalcUtil {
    private static Logger logger = LoggerFactory.getLogger(CalcUtil.class);

    private static BigDecimal countCutPrice(ItemVo itemVo, BigDecimal totalAmount, BigDecimal cutPrice) {
        BigDecimal skuTotalAmount = itemVo.getPrice().multiply(new BigDecimal(itemVo.getNum()));
        BigDecimal rate = skuTotalAmount.divide(totalAmount, 4, 1);
        return rate.multiply(cutPrice).setScale(2, RoundingMode.HALF_UP);
    }

    public static void main(String[] args) {
        List combinationItems = JSON.parseArray((String)"[{\"activityDiscountAmount\":[],\"activityList\":[\"1304868574228143220\"],\"clearExchangeItem\":0,\"combinedPackageActivityId\":\"1304868574228143220\",\"couponId\":0,\"discountPrice\":8.00,\"exchange\":0,\"extendsAttribute\":{},\"giftCost\":0.00,\"giftSkuList\":[],\"isCombinedPackage\":1,\"itemBrands\":[\"22655682049015873\"],\"itemCategory\":[\"1288630386802423099\"],\"itemId\":\"1288931280734513955\",\"lackRemainingStockMap\":{},\"num\":1,\"origPrice\":8.0,\"price\":8.0,\"sellerId\":\"0\",\"shopId\":\"1293978523072144418\",\"shopPointDeductRule\":-1,\"shopPointDeductRuleId\":\"0\",\"skuId\":\"1288931280754436901\",\"totoalDiscountAmount\":0},{\"activityDiscountAmount\":[],\"activityList\":[\"1304868574228143220\"],\"clearExchangeItem\":0,\"combinedPackageActivityId\":\"1304868574228143220\",\"couponId\":0,\"discountPrice\":284.80,\"exchange\":0,\"extendsAttribute\":{},\"giftCost\":0.00,\"giftSkuList\":[],\"isCombinedPackage\":1,\"itemBrands\":[\"22655682049015873\"],\"itemCategory\":[\"1288108784217113758\"],\"itemId\":\"1288931269102660305\",\"lackRemainingStockMap\":{},\"num\":1,\"origPrice\":284.8,\"price\":284.8,\"sellerId\":\"0\",\"shopId\":\"1293978523072144418\",\"shopPointDeductRule\":-1,\"shopPointDeductRuleId\":\"0\",\"skuId\":\"1288931269122583251\",\"totoalDiscountAmount\":0}]", ItemVo.class);
        CalcUtil.calculateDiscount(1304868574228143220L, combinationItems, new BigDecimal("272.8"), null, null);
        System.out.println(JSON.toJSONString((Object)combinationItems));
    }

    public static BigDecimal calculateDiscount(Long activityId, List<ItemVo> needDivideItemList, BigDecimal cutAmount, BigDecimal discount, String range) {
        for (ItemVo itemVo2 : needDivideItemList) {
            if (itemVo2.getDiscountPrice() == null) {
                itemVo2.setDiscountTotalPrice(itemVo2.getPrice());
            }
            if (itemVo2.getDiscountTotalPrice() != null) continue;
            itemVo2.setDiscountTotalPrice(itemVo2.getDiscountPrice().multiply(new BigDecimal(itemVo2.getNum())));
        }
        BigDecimal totalAmount = needDivideItemList.stream().map(itemVo -> itemVo.getPrice().multiply(new BigDecimal(itemVo.getNum()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal beforeDiscountAmount = needDivideItemList.stream().map(itemVo -> itemVo.getDiscountTotalPrice()).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (beforeDiscountAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return BigDecimal.ZERO;
        }
        if (discount != null) {
            BigDecimal discountRate = BigDecimal.ONE.subtract(discount.divide(BigDecimal.TEN, 4, 1));
            cutAmount = totalAmount.multiply(discountRate);
        }
        if (cutAmount != null && beforeDiscountAmount.compareTo(cutAmount) < 0) {
            cutAmount = beforeDiscountAmount;
        }
        BigDecimal totalDiscountAmount = BigDecimal.ZERO;
        for (int i = 0; i < needDivideItemList.size(); ++i) {
            BigDecimal itemCutTotalAmount;
            ItemVo itemVo3 = needDivideItemList.get(i);
            if (needDivideItemList.size() - 1 == i) {
                itemCutTotalAmount = cutAmount.subtract(totalDiscountAmount);
            } else {
                itemCutTotalAmount = CalcUtil.countCutPrice(itemVo3, totalAmount, cutAmount);
                totalDiscountAmount = totalDiscountAmount.add(itemCutTotalAmount);
            }
            DiscountAmount discountAmount = new DiscountAmount();
            discountAmount.setAmount(itemCutTotalAmount);
            discountAmount.setRange(range);
            discountAmount.setActivityId(activityId);
            itemVo3.getActivityDiscountAmount().add(discountAmount);
            itemVo3.setDiscountTotalPrice(itemVo3.getDiscountTotalPrice().subtract(discountAmount.getAmount()));
        }
        logger.info("\u6d3b\u52a8id\uff1a{}\uff0c\u4f18\u60e0\u91d1\u989d:{}", (Object)activityId, (Object)cutAmount);
        return cutAmount;
    }

    private static BigDecimal getItemDiscountAmount(ItemVo itemVo, Long activityId) {
        DiscountAmount discountAmount = itemVo.getDiscountAmountByActivityId(activityId);
        if (null == discountAmount || null == discountAmount.getAmount()) {
            return BigDecimal.ZERO;
        }
        return discountAmount.getAmount();
    }

    private BigDecimal getForMinAmount(int num) {
        return BigDecimal.valueOf(num).multiply(BigDecimal.valueOf(0.01));
    }
}

