/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.exchangecoupon;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.ExchangeItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon.CouponItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon.CouponItemSkuDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.CouponTemplateDetailRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.AbstractBaseTemplate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ExchangeItemCondition
extends AbstractBaseTemplate {
    @Override
    protected <T extends BaseActivityDto> void parse(ConditionRespDto conditionRespDto, T t) {
        if (t instanceof CouponTemplateDetailRespDto) {
            CouponTemplateDetailRespDto coupon = (CouponTemplateDetailRespDto)t;
            JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
            List items = JSON.parseArray((String)jsonObject.getString("ExchangeItemCondition.items"), ExchangeItemDto.class);
            if (CollectionUtils.isNotEmpty((Collection)items)) {
                ArrayList couponItemSkuDtos = Lists.newArrayList();
                ArrayList itemIds = Lists.newArrayList();
                HashSet shopIds = Sets.newHashSet();
                ArrayList skuIds = Lists.newArrayList();
                ArrayList shelfReqDtos = Lists.newArrayList();
                items.forEach(exchangeItemDto -> {
                    CouponItemSkuDto couponItemSkuDto = new CouponItemSkuDto();
                    CubeBeanUtils.copyProperties((Object)couponItemSkuDto, (Object)exchangeItemDto, (String[])new String[0]);
                    couponItemSkuDtos.add(couponItemSkuDto);
                    shopIds.add(exchangeItemDto.getShopId());
                    itemIds.add(exchangeItemDto.getItemId());
                    skuIds.add(exchangeItemDto.getSkuId());
                    ShelfReqDto shelfReqDto = new ShelfReqDto();
                    shelfReqDto.setShopId(exchangeItemDto.getShopId());
                    shelfReqDto.setSkuId(exchangeItemDto.getSkuId());
                    shelfReqDtos.add(shelfReqDto);
                });
                Map<String, List<CouponItemSkuDto>> group = couponItemSkuDtos.stream().collect(Collectors.groupingBy(sku -> sku.getItemId().toString() + sku.getShopId()));
                ArrayList couponItemDtos = Lists.newArrayList();
                Map<Long, ItemRespDto> itemMap = this.queryItemByIds(itemIds);
                Map<Long, ShopBaseDto> shopMap = this.queryShopByIds(shopIds);
                Map<Long, ItemSkuRespDto> skuMap = this.queryItemSku(skuIds);
                Map<String, BigDecimal> priceMap = this.queryItemPrice(shelfReqDtos);
                Map<String, Long> stockMap = this.queryItemStock(shelfReqDtos);
                for (List<CouponItemSkuDto> skus : group.values()) {
                    CouponItemDto couponItemDto = new CouponItemDto();
                    Long itemId = skus.get(0).getItemId();
                    Long shopId = skus.get(0).getShopId();
                    if (!itemMap.containsKey(itemId)) continue;
                    ItemRespDto itemRespDto = itemMap.get(itemId);
                    couponItemDto.setItemCode(itemRespDto.getCode());
                    couponItemDto.setItemName(itemRespDto.getName());
                    if (shopMap.containsKey(shopId)) {
                        couponItemDto.setShopName(shopMap.get(shopId).getName());
                    }
                    Long totalStock = 0L;
                    for (CouponItemSkuDto sku2 : skus) {
                        Long stock;
                        ItemSkuRespDto skuRespDto;
                        Long skuId = sku2.getSkuId();
                        if (skuMap.containsKey(skuId) && StringUtils.isNotBlank((String)(skuRespDto = skuMap.get(skuId)).getAttr())) {
                            Map skuAttrMap = (Map)ObjectHelper.Json2Bean((String)skuRespDto.getAttr(), Map.class);
                            String skuName = StringUtils.join(skuAttrMap.values(), (String)" ");
                            sku2.setSkuName(skuName);
                        }
                        String shopItemKey = shopId + skuId.toString();
                        sku2.setSellPrice(priceMap.get(shopItemKey));
                        if (ItemTypeEnum.BUNDLE.getType().equals(itemRespDto.getType())) {
                            stock = this.queryBundleItemStock(itemId, skuId, shopId);
                        } else {
                            stock = stockMap.get(shopItemKey);
                            if (null == stock) {
                                stock = 0L;
                            }
                        }
                        sku2.setStock(stock);
                        totalStock = totalStock + stock;
                    }
                    couponItemDto.setId(this.generateId());
                    couponItemDto.setItemId(itemId);
                    couponItemDto.setShopId(shopId);
                    couponItemDto.setSkus(skus);
                    couponItemDto.setTotalStock(totalStock);
                    couponItemDtos.add(couponItemDto);
                    coupon.setExchangeItems((List)couponItemDtos);
                }
            }
        }
    }

    @Override
    public long getConditionTemplateId() {
        return 1196944771412880290L;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return ActivityType.COUPON_ACTIVITY.equals((Object)type);
    }

    @Override
    public <T extends BaseActivityDto> ConditionReqDto convertToCondition(T t) {
        return null;
    }
}

