/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.CheckPointQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.CheckPointReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.CheckpointRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBusinessRuntimeException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.ICheckPointService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.CheckpointDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.CheckPointEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CheckPointServiceImpl
implements ICheckPointService {
    @Autowired
    private CheckpointDas checkpointDas;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public long addCheckPoint(CheckPointReqDto dto) {
        CheckPointEo eo = BeanCopyUtil.copyProperties(CheckPointEo.class, dto, new String[0]);
        this.checkpointDas.insert((BaseEo)eo);
        return eo.getId();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void modifyCheckPoint(Long id, CheckPointReqDto dto) {
        CheckPointEo eo = BeanCopyUtil.copyProperties(CheckPointEo.class, dto, new String[0]);
        eo.setId(id);
        this.checkpointDas.update((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void deleteCheckPoint(Long cpId) {
        this.checkpointDas.logicDeleteById(cpId);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void enableCheckPoint(Long cpId) {
        CheckPointEo eo = CheckPointEo.newInstance();
        eo.setId(cpId);
        eo.setCheckpointStatus("ENABLE");
        this.checkpointDas.updateSelective((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void disableCheckPoint(Long cpId) {
        CheckPointEo eo = (CheckPointEo)this.checkpointDas.selectByPrimaryKey(cpId);
        if (eo == null) {
            throw new ProBusinessRuntimeException(ProExceptionCode.RECORD_NOT_EXIST);
        }
        eo.setCheckpointStatus("DISABLE");
        this.checkpointDas.update((BaseEo)eo);
    }

    @Override
    public CheckpointRespDto findByCheckCode(String checkpointCode) {
        if (StringUtils.isNotBlank((CharSequence)checkpointCode)) {
            CheckPointEo cpEo = CheckPointEo.newInstance();
            cpEo.setCheckpointCode(checkpointCode);
            return BeanCopyUtil.copyProperties(CheckpointRespDto.class, this.checkpointDas.selectOne((BaseEo)cpEo), new String[0]);
        }
        return null;
    }

    @Override
    public CheckpointRespDto queryCheckPointDetail(Long id) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        CheckPointEo eo = this.checkById(id, ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        CheckpointRespDto dto = new CheckpointRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)eo, (String[])new String[0]);
        return dto;
    }

    @Override
    public List<CheckpointRespDto> queryCheckPointList(CheckPointQueryReqDto dto) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        CheckPointEo eo = CheckPointEo.newInstance();
        CubeBeanUtils.copyProperties((Object)eo, (Object)dto, (String[])new String[0]);
        if (null != dto.getCheckpointStatusEnum()) {
            eo.setCheckpointStatus(dto.getCheckpointStatusEnum().getKey());
        }
        this.setQueryTimeConditions(eo, dto.getCreateStartTime(), dto.getCreateEndTime());
        eo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        eo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        List eoList = this.checkpointDas.select((BaseEo)eo);
        ArrayList<CheckpointRespDto> dtoList = new ArrayList<CheckpointRespDto>();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoList, CheckpointRespDto.class);
        return dtoList;
    }

    @Override
    public PageInfo<CheckpointRespDto> queryCheckPointPage(CheckPointQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        CheckPointEo eo = CheckPointEo.newInstance();
        CubeBeanUtils.copyProperties((Object)eo, (Object)reqDto, (String[])new String[0]);
        if (null != reqDto.getCheckpointStatusEnum()) {
            eo.setCheckpointStatus(reqDto.getCheckpointStatusEnum().getKey());
        }
        this.setQueryTimeConditions(eo, reqDto.getCreateStartTime(), reqDto.getCreateEndTime());
        eo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        eo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        PageInfo pageInfo = this.checkpointDas.selectPage((BaseEo)eo, pageNum, pageSize);
        ArrayList respDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), respDtoList, CheckpointRespDto.class);
        pageInfo.setList(respDtoList);
        return pageInfo;
    }

    private void checkBase(Long instanceId, Long tenantId) {
    }

    private void setQueryTimeConditions(CheckPointEo eo, String startTime, String endTime) {
        ArrayList<SqlFilter> sqlFilterList = eo.getSqlFilters();
        if (StringUtils.isNotEmpty((CharSequence)startTime)) {
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList<SqlFilter>();
            }
            sqlFilterList.add(SqlFilter.gt((String)"create_time", (Object)startTime));
        }
        if (StringUtils.isNotEmpty((CharSequence)endTime)) {
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList();
            }
            sqlFilterList.add(SqlFilter.lt((String)"create_time", (Object)endTime));
        }
        eo.setSqlFilters(sqlFilterList);
    }

    private CheckPointEo checkById(Long id, Long instanceId, Long tenantId) {
        CheckPointEo eo = (CheckPointEo)this.checkpointDas.selectByPrimaryKey(id);
        return eo;
    }
}

