/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.condition;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.BizActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.UnuesdActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityRelationService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.condition.PointDeductMutexCondition;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.SpringContextHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class MutexCondition
extends ConditionTemplate {
    private static Logger logger = LoggerFactory.getLogger(MutexCondition.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private IActivityRelationService activityRelationService;
    @Autowired
    private PointDeductMutexCondition pointDeductMutexCondition;
    @Resource
    private IItemActivityService itemActivityService;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T params, Map<String, ?> activityParams) {
        int index;
        Long currentActivityId = params.getActivityId();
        ArrayList removeIds = Lists.newArrayList();
        logger.info("\u6240\u6709\u6d3b\u52a8:{}", (Object)JSON.toJSONString((Object)params.getActivityIds()));
        for (int i = index = params.getActivityIds().indexOf(currentActivityId); i < params.getActivityIds().size(); ++i) {
            Long nextActivityId;
            if (i == index || this.isOverlap(currentActivityId, nextActivityId = (Long)params.getActivityIds().get(i), params, false)) continue;
            removeIds.add(nextActivityId);
        }
        params.getActivityIds().removeAll(removeIds);
        if (!CollectionUtils.isEmpty((Collection)params.getUnusedActivityList())) {
            ArrayList unusedActivityList = Lists.newArrayList();
            for (UnuesdActivityDto unuesdActivityDto : params.getUnusedActivityList()) {
                if (!this.contain(params, currentActivityId, unuesdActivityDto) && !this.isOverlap(currentActivityId, unuesdActivityDto.getActivityId(), params, true)) continue;
                unusedActivityList.add(unuesdActivityDto);
            }
            params.setUnusedActivityList((List)unusedActivityList);
        }
        return true;
    }

    private boolean contain(EngineParams params, Long currentActivityId, UnuesdActivityDto unuesdActivityDto) {
        if (null != unuesdActivityDto.getCouponId()) {
            List activityCoupons = params.getActivityCouponList();
            return currentActivityId.equals(unuesdActivityDto.getActivityId()) && activityCoupons.stream().anyMatch(activityCoupon -> activityCoupon.getCouponIds().contains(unuesdActivityDto.getCouponId()));
        }
        return currentActivityId.equals(unuesdActivityDto.getActivityId());
    }

    private <T extends EngineParams> boolean isOverlap(Long currentId, Long nextId, T params, boolean unused) {
        if (nextId.longValue() == BizActivityType.POINT_DEDUCT_ACTIVITY.getId()) {
            boolean mutex;
            if (this.pointDeductMutexCondition == null) {
                try {
                    this.pointDeductMutexCondition = (PointDeductMutexCondition)SpringContextHelper.getBean(Class.forName("com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.condition.PointDeductMutexCondition"));
                }
                catch (ClassNotFoundException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BizException("\u79ef\u5206\u62b5\u6263\u6761\u4ef6\u6a21\u677f\u65e0\u6cd5\u52a0\u8f7d");
                }
            }
            if (mutex = this.pointDeductMutexCondition.checkNextIsPointDeduct(currentId, nextId, params)) {
                String message = String.format("\u4eb2\uff0c\u60a8\u5df2\u9009\u62e9\u4f7f\u7528\u5176\u5b83\u4f18\u60e0\uff0c\u4e0d\u53ef\u518d\u4f7f\u7528\u79ef\u5206\u62b5\u6263\u54e6", new Object[0]);
                params.getActivityReasonMap().put(nextId.toString(), message);
            }
            return !mutex;
        }
        List combinationIds = params.getItems().stream().map(ItemVo::getCombinedPackageActivityId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        logger.info("\u4e92\u65a5\u6761\u4ef6\u53c2\u6570:\u5546\u54c1{},\u7b26\u5408\u4f18\u60e0\u5546\u54c1ID:{},\u4e0b\u4e00\u4e2a\u6d3b\u52a8ID:{},\u5f53\u524d\u6d3b\u52a8ID:{}", new Object[]{JSON.toJSONString((Object)params.getItems()), JSON.toJSONString(combinationIds), nextId, currentId});
        if (!CollectionUtils.isEmpty(combinationIds) && combinationIds.contains(nextId) && combinationIds.contains(currentId)) {
            return true;
        }
        if (!this.together(nextId, params, unused)) {
            return true;
        }
        boolean isOverlap = this.activityRelationService.overlap(currentId, nextId);
        if (!isOverlap) {
            params.getActivityReasonMap().put(nextId.toString(), "\u4e0e\u5176\u5b83\u4f18\u60e0\u4e92\u65a5");
        }
        return isOverlap;
    }

    private <T extends EngineParams> boolean together(Long nextActivityId, T params, boolean unused) {
        for (ItemVo itemVo : params.getItems()) {
            List itemActivityIds;
            Long skuId = Long.valueOf(itemVo.getSkuId());
            Long itemId = Long.valueOf(itemVo.getItemId());
            Long shopId = Long.valueOf(itemVo.getShopId());
            if (!(unused ? this.itemActivityService.apply(itemId, skuId, nextActivityId, shopId) : (itemActivityIds = (List)params.getItemActivitiesMapping().get(shopId + "_" + skuId)).contains(nextActivityId))) continue;
            return true;
        }
        return false;
    }
}

