/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.apiimpl.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponBaseDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplate4MemberRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateQueryRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponTemplateExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponPushMethodEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.IMarketingCouponQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.ICouponExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="couponTemplateExtQueryApi")
public class CouponTemplateExtQueryApiImpl
implements ICouponTemplateExtQueryApi {
    @Autowired
    private ICouponTemplateExtQueryService couponTemplateExtQueryService;
    @Autowired
    private IMarketingCouponQueryService marketingCouponQueryService;
    @Autowired
    private ICouponExtQueryService couponExtQueryService;

    public RestResponse<CouponTemplateExtRespDto> queryById(Long id) {
        return new RestResponse((Object)this.couponTemplateExtQueryService.queryById(id));
    }

    public RestResponse<CouponTemplateExtRespDto> queryByCode(String code) {
        return new RestResponse((Object)this.couponTemplateExtQueryService.queryByCode(code));
    }

    public RestResponse<Long> queryTempIdByCode(String code) {
        return new RestResponse((Object)this.couponTemplateExtQueryService.queryTempIdByCode(code));
    }

    public RestResponse<PageInfo<CouponTemplateExtRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.couponTemplateExtQueryService.queryByPage(filter, pageNum, pageSize));
    }

    public RestResponse<List<CouponTemplateExtRespDto>> queryByIds(List<Long> ids) {
        return new RestResponse(this.couponTemplateExtQueryService.listByIds(ids));
    }

    public RestResponse<CouponTemplateExtRespDto> queryByCodeSimple(String code) {
        return new RestResponse((Object)this.couponTemplateExtQueryService.queryByCodeSimple(code));
    }

    public RestResponse<List<CouponTemplateExtRespDto>> queryByMemberId(Long memberId) {
        List<CouponTemplate4MemberRespDto> couponTemplate4MemberRespDtoList = this.marketingCouponQueryService.unclaimedsCouponTemplate4Member(memberId);
        if (couponTemplate4MemberRespDtoList == null) {
            return null;
        }
        Map couponTemplate4MemberRespDtoMap = couponTemplate4MemberRespDtoList.stream().collect(Collectors.toMap(CouponTemplate4MemberRespDto::getCouponPushMethod, Function.identity()));
        List pushCouponTemplateIds = null;
        List spellCouponTemplateIds = null;
        if (couponTemplate4MemberRespDtoMap.get(CouponPushMethodEnum.PUSH.getKey()) != null) {
            List pushCouponBaseDtos = ((CouponTemplate4MemberRespDto)couponTemplate4MemberRespDtoMap.get(CouponPushMethodEnum.PUSH.getKey())).getCouponTemplates();
            pushCouponTemplateIds = pushCouponBaseDtos.stream().map(CouponBaseDto::getId).distinct().collect(Collectors.toList());
        }
        if (couponTemplate4MemberRespDtoMap.get(CouponPushMethodEnum.SPELL.getKey()) != null) {
            List spellCouponBaseDtos = ((CouponTemplate4MemberRespDto)couponTemplate4MemberRespDtoMap.get(CouponPushMethodEnum.SPELL.getKey())).getCouponTemplates();
            spellCouponTemplateIds = spellCouponBaseDtos.stream().map(CouponBaseDto::getId).distinct().collect(Collectors.toList());
        }
        List couponBaseDtos = couponTemplate4MemberRespDtoList.stream().map(dto -> dto.getCouponTemplates()).collect(ArrayList::new, List::addAll, (left, right) -> left.addAll(right));
        List<Long> couponTemplateIds = couponBaseDtos.stream().map(CouponBaseDto::getId).distinct().collect(Collectors.toList());
        List<String> sourceCodes = couponBaseDtos.stream().map(couponBaseDto -> Long.toString(couponBaseDto.getTaskCustomerCouponId())).collect(Collectors.toList());
        Map<Long, List<CouponBaseDto>> couponCountMap = couponBaseDtos.stream().collect(Collectors.groupingBy(CouponBaseDto::getTaskCustomerCouponId));
        List<Object> couponTemplateExtRespDtos = this.couponTemplateExtQueryService.listByIds(couponTemplateIds);
        couponTemplateExtRespDtos = couponTemplateExtRespDtos.stream().filter(couponTemplateExtRespDto -> {
            if (!couponTemplateExtRespDto.getCouponTemplateStatus().equals(CouponTemplateStatusEnum.ACTIVATE.getStatus())) {
                return false;
            }
            return !couponTemplateExtRespDto.getValidityType().equals(CouponValidityTypeEnum.FIXED_DATE.getType()) || !new Date().after(couponTemplateExtRespDto.getInvalidTime());
        }).collect(Collectors.toList());
        ArrayList<Object> newCouponTemplateExtRespDtos = new ArrayList<Object>();
        for (Object couponTemplateExtRespDto2 : couponTemplateExtRespDtos) {
            if (!CollectionUtils.isNotEmpty(pushCouponTemplateIds) || !pushCouponTemplateIds.contains(couponTemplateExtRespDto2.getId())) continue;
            newCouponTemplateExtRespDtos.add(couponTemplateExtRespDto2);
        }
        Integer pushMethod = CouponPushMethodEnum.PUSH.getKey();
        if (CollectionUtils.isEmpty(newCouponTemplateExtRespDtos)) {
            for (CouponTemplateExtRespDto couponTemplateExtRespDto2 : couponTemplateExtRespDtos) {
                if (!CollectionUtils.isNotEmpty(spellCouponTemplateIds) || !spellCouponTemplateIds.contains(couponTemplateExtRespDto2.getId())) continue;
                newCouponTemplateExtRespDtos.add(couponTemplateExtRespDto2);
            }
            pushMethod = CouponPushMethodEnum.SPELL.getKey();
        }
        Integer currentPushMethod = pushMethod;
        List<Long> list = newCouponTemplateExtRespDtos.stream().map(CouponTemplateExtRespDto::getId).collect(Collectors.toList());
        Map couponTemplateMap = newCouponTemplateExtRespDtos.stream().collect(Collectors.toMap(CouponTemplateExtRespDto::getId, Function.identity()));
        List<CouponExtRespDto> couponExtRespDtoList = this.couponExtQueryService.listByUserId(memberId, list, sourceCodes);
        Map<String, Long> couponMap = couponExtRespDtoList.stream().collect(Collectors.groupingBy(couponExtRespDto -> couponExtRespDto.getActivityCode() + couponExtRespDto.getCouponTemplateId(), Collectors.counting()));
        ArrayList result = new ArrayList();
        couponCountMap.forEach((taskCustomerCouponId, couponBaseDtoList) -> couponBaseDtoList.forEach(couponBaseDto -> {
            CouponTemplateExtRespDto couponTemplateExtRespDto;
            Integer couponPushMethod = couponBaseDto.getCouponPushMethod();
            if (currentPushMethod.equals(couponPushMethod) && newCouponTemplateIds.contains(couponBaseDto.getId()) && (couponTemplateExtRespDto = (CouponTemplateExtRespDto)couponTemplateMap.get(couponBaseDto.getId())) != null) {
                String activityCode = taskCustomerCouponId.toString();
                String couponKey = activityCode + couponTemplateExtRespDto.getId();
                Long receiveNum = (Long)couponMap.get(couponKey);
                CouponTemplateExtRespDto newDto = BeanCopyUtil.copyProperties(CouponTemplateExtRespDto.class, couponTemplateExtRespDto, new String[0]);
                newDto.setMemberId(memberId);
                newDto.setReceiveNum(receiveNum);
                newDto.setLimitQty(Integer.valueOf(couponBaseDto.getCount()));
                newDto.setActivityGroupCode(activityCode);
                result.add(newDto);
            }
        }));
        return new RestResponse(result);
    }

    public RestResponse<CouponTemplateExtRespDto> queryReceiveDetailByCode(String couponTemplateCode, String activityGroupCode) {
        CouponBaseDto couponBaseDto;
        CouponTemplateExtRespDto couponTemplateExtRespDto = this.couponTemplateExtQueryService.queryByCode(couponTemplateCode);
        if (StringUtils.isNotBlank((CharSequence)activityGroupCode) && null != (couponBaseDto = this.marketingCouponQueryService.detail(Long.parseLong(activityGroupCode)))) {
            couponTemplateExtRespDto.setLimitQty(Integer.valueOf(couponBaseDto.getCount()));
            couponTemplateExtRespDto.setActivityGroupCode(activityGroupCode);
        }
        return new RestResponse((Object)couponTemplateExtRespDto);
    }

    public RestResponse<PageInfo<CouponTemplateQueryRespDto>> queryWithActivity(CouponTemplateQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.couponTemplateExtQueryService.queryWithActivity(queryReqDto, pageNum, pageSize));
    }
}

