/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.biz.commons.utils.Object2FilterUtil;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.member.api.common.condition.Criteria;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponBatchRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponCacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateStockService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.ICouponExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.utils.SerialCodeGenerateUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponGenBatchFlowDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.PersonalizeCouponItemDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponGenBatchFlowEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponTemplateEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.PersonalizeCouponItemEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.StdCouponEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.StdPersonalizeCouponItemEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponExtQueryServiceImpl
implements ICouponExtQueryService {
    private static final Logger logger = LoggerFactory.getLogger(CouponExtQueryServiceImpl.class);
    @Autowired
    private CouponDas couponDas;
    @Autowired
    private ICouponTemplateExtQueryService couponTemplateExtQueryService;
    @Autowired
    private ICouponCacheService couponCacheService;
    @Autowired
    private CouponGenBatchFlowDas couponGenBatchFlowDas;
    @Autowired
    private PersonalizeCouponItemDas personalizeCouponItemDas;
    @Autowired
    private ICouponTemplateStockService couponTemplateStockService;
    @Resource
    private ICouponTemplateService couponTemplateService;

    @Override
    public PageInfo<CouponExtRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        List eoList;
        Criteria criteria;
        PageInfo responseInfo = new PageInfo();
        try {
            criteria = (Criteria)ObjectHelper.Json2Bean((String)filter, Criteria.class);
        }
        catch (Exception e3) {
            logger.error(e3.getMessage(), (Throwable)e3);
            throw new RuntimeException();
        }
        CouponEo query = CouponEo.newInstance();
        if (null != criteria) {
            query.setSqlFilters(criteria.getFilters());
            query.setOrderByDesc(criteria.getOrderByDesc());
        }
        if (null != pageNum && pageSize != null) {
            PageInfo pageInfo = this.couponDas.selectPage((BaseEo)query, pageNum, pageSize);
            BeanUtils.copyProperties((Object)pageInfo, (Object)responseInfo);
            eoList = pageInfo.getList();
        } else {
            eoList = this.couponDas.select((BaseEo)query);
        }
        List<CouponExtRespDto> dtoList = BeanCopyUtil.copyCollections(eoList, CouponExtRespDto.class, new String[0]);
        List<Long> couponTemplateIds = dtoList.stream().map(CouponExtRespDto::getCouponTemplateId).distinct().collect(Collectors.toList());
        List<CouponTemplateExtRespDto> couponTemplates = this.couponTemplateService.queryByIds(couponTemplateIds);
        Map<Long, CouponTemplateExtRespDto> map = couponTemplates.stream().collect(Collectors.toMap(dto -> dto.getId(), e -> e, (e1, e2) -> e1));
        dtoList.forEach(dto -> {
            CouponTemplateExtRespDto couponTemplate = (CouponTemplateExtRespDto)map.get(dto.getCouponTemplateId());
            if (couponTemplate != null) {
                dto.setCouponTemplate(couponTemplate);
                dto.setCouponRange(couponTemplate.getCouponRange());
                dto.setActivityTag(couponTemplate.getActivityTag());
                dto.setShopId(couponTemplate.getShopId());
            }
            dto.setCouponStatusDescription(CouponStatusEnum.getByStatus((String)dto.getCouponStatus()).getDescription());
        });
        responseInfo.setList(dtoList);
        return responseInfo;
    }

    @Override
    public PageInfo<CouponExtRespDto> queryByPage(Criteria criteria, Integer pageNum, Integer pageSize) {
        List eoList;
        PageInfo responseInfo = new PageInfo();
        CouponEo query = CouponEo.newInstance();
        if (null != criteria) {
            query.setSqlFilters(criteria.getFilters());
            query.setOrderByDesc(criteria.getOrderByDesc());
        }
        if (null != pageNum && pageSize != null) {
            PageInfo pageInfo = this.couponDas.selectPage((BaseEo)query, pageNum, pageSize);
            BeanUtils.copyProperties((Object)pageInfo, (Object)responseInfo);
            eoList = pageInfo.getList();
        } else {
            eoList = this.couponDas.select((BaseEo)query);
        }
        List<CouponExtRespDto> dtoList = BeanCopyUtil.copyCollections(eoList, CouponExtRespDto.class, new String[0]);
        List<Long> couponTemplateIds = dtoList.stream().map(CouponExtRespDto::getCouponTemplateId).distinct().collect(Collectors.toList());
        List<CouponTemplateExtRespDto> couponTemplates = this.couponTemplateService.queryByIds(couponTemplateIds);
        Map<Long, CouponTemplateExtRespDto> map = couponTemplates.stream().collect(Collectors.toMap(dto -> dto.getId(), e -> e, (e1, e2) -> e1));
        dtoList.forEach(dto -> {
            CouponTemplateExtRespDto couponTemplate = (CouponTemplateExtRespDto)map.get(dto.getCouponTemplateId());
            if (couponTemplate != null) {
                dto.setCouponTemplate(couponTemplate);
                dto.setCouponRange(couponTemplate.getCouponRange());
                dto.setActivityTag(couponTemplate.getActivityTag());
                dto.setShopId(couponTemplate.getShopId());
            }
            dto.setCouponStatusDescription(CouponStatusEnum.getByStatus((String)dto.getCouponStatus()).getDescription());
        });
        responseInfo.setList(dtoList);
        return responseInfo;
    }

    @Override
    public CouponExtRespDto queryById(Long id) {
        if (id == null) {
            return null;
        }
        CouponEo couponEo = (CouponEo)this.couponDas.selectByPrimaryKey(id);
        CouponExtRespDto couponExtRespDto = this.eo2Dto(couponEo);
        if (null != couponExtRespDto) {
            CouponTemplateExtRespDto couponTemplateExtRespDto = this.couponTemplateExtQueryService.queryById(couponExtRespDto.getCouponTemplateId());
            couponExtRespDto.setCouponTemplate(couponTemplateExtRespDto);
        }
        return couponExtRespDto;
    }

    @Override
    public List<CouponExtRespDto> listByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        CouponEo couponEo = new CouponEo();
        List<SqlFilter> sqlFilters = Arrays.asList(SqlFilter.in((String)"id", ids));
        couponEo.setSqlFilters(sqlFilters);
        List list = this.couponDas.select((BaseEo)couponEo);
        List<CouponExtRespDto> couponExtRespDtoList = this.eoList2DtoList(list);
        List<Long> couponTemplateIds = couponExtRespDtoList.stream().map(CouponExtRespDto::getCouponTemplateId).distinct().collect(Collectors.toList());
        Map<Long, CouponTemplateExtRespDto> longCouponTemplateExtRespDtoMap = this.couponTemplateExtQueryService.listByIds2Map(couponTemplateIds);
        couponExtRespDtoList.forEach(couponExtRespDto -> {
            CouponTemplateExtRespDto couponTemplateExtRespDto = (CouponTemplateExtRespDto)longCouponTemplateExtRespDtoMap.get(couponExtRespDto.getCouponTemplateId());
            couponExtRespDto.setCouponTemplate(couponTemplateExtRespDto);
        });
        return couponExtRespDtoList;
    }

    @Override
    public CouponExtRespDto queryEoByCode(Long userId, String couponCode) {
        if (StringUtils.isBlank((CharSequence)couponCode)) {
            return null;
        }
        if (userId == null) {
            userId = SerialCodeGenerateUtil.gennarateUserIdByCouponCode(couponCode);
        }
        CouponEo couponEo = new CouponEo();
        couponEo.setCouponCode(couponCode);
        couponEo.setUserId(userId);
        couponEo = (CouponEo)this.couponDas.selectOne((BaseEo)couponEo);
        if (null == couponEo) {
            couponEo = new CouponEo();
            couponEo.setCouponCode(couponCode);
            couponEo = (CouponEo)this.couponDas.selectOne((BaseEo)couponEo);
        }
        return this.eo2Dto(couponEo);
    }

    @Override
    public CouponExtRespDto queryByCode(Long userId, String couponCode) {
        CouponExtRespDto couponExtRespDto = this.queryEoByCode(userId, couponCode);
        if (null != couponExtRespDto) {
            CouponTemplateExtRespDto couponTemplateExtRespDto = this.couponTemplateExtQueryService.queryById(couponExtRespDto.getCouponTemplateId());
            couponExtRespDto.setCouponTemplate(couponTemplateExtRespDto);
        }
        return couponExtRespDto;
    }

    @Override
    public CouponExtRespDto eo2Dto(CouponEo couponEo) {
        return null != couponEo ? BeanCopyUtil.copyProperties(CouponExtRespDto.class, couponEo, new String[0]) : null;
    }

    @Override
    public List<CouponExtRespDto> eoList2DtoList(List<CouponEo> list) {
        return CollectionUtils.isEmpty(list) ? Collections.emptyList() : BeanCopyUtil.copyCollections(list, CouponExtRespDto.class, new String[0]);
    }

    @Override
    public List<CouponExtRespDto> listByUserId(Long memberId, String couponStatus) {
        if (memberId == null || memberId == 0L) {
            return Collections.emptyList();
        }
        List<CouponExtRespDto> cacheList = this.couponCacheService.findMemberCoupon(memberId, couponStatus);
        if (cacheList != null) {
            return cacheList;
        }
        CouponEo query = CouponEo.newInstance();
        query.setUserId(memberId);
        query.setCouponStatus(couponStatus);
        List list = this.couponDas.select((BaseEo)query);
        List<CouponExtRespDto> couponExtRespDtos = BeanCopyUtil.copyCollections(list, CouponExtRespDto.class, new String[0]);
        this.couponCacheService.setMemberCouponCache(memberId, couponStatus, couponExtRespDtos);
        return couponExtRespDtos;
    }

    @Override
    public List<CouponExtRespDto> listByOuterOrderCode(Long memberId, String outerOrderCode) {
        if (StringUtils.isBlank((CharSequence)outerOrderCode)) {
            return Collections.emptyList();
        }
        CouponEo query = CouponEo.newInstance();
        query.setUserId(memberId);
        query.setOuterOrderCode(outerOrderCode);
        List list = this.couponDas.select((BaseEo)query);
        return this.eoList2DtoList(list);
    }

    @Override
    public List<CouponExtRespDto> listByOuterOrderCode(List<Long> memberIds, String outerOrderCode) {
        if (StringUtils.isBlank((CharSequence)outerOrderCode)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isNotEmpty(memberIds)) {
            memberIds = memberIds.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
        CouponEo couponEo = new CouponEo();
        if (CollectionUtils.isNotEmpty(memberIds)) {
            List<SqlFilter> sqlFilters = Arrays.asList(SqlFilter.in((String)"userId", memberIds));
            couponEo.setOuterOrderCode(outerOrderCode);
            couponEo.setSqlFilters(sqlFilters);
        }
        couponEo.setOuterOrderCode(outerOrderCode);
        List list = this.couponDas.select((BaseEo)couponEo);
        return this.eoList2DtoList(list);
    }

    @Override
    public List<CouponExtRespDto> listByPaymentCode(String paymentCode) {
        if (StringUtils.isBlank((CharSequence)paymentCode)) {
            return Collections.emptyList();
        }
        CouponEo query = CouponEo.newInstance();
        query.setPaymentCode(paymentCode);
        List list = this.couponDas.select((BaseEo)query);
        return this.eoList2DtoList(list);
    }

    @Override
    public List<CouponExtRespDto> listByCodes(Long memberId, List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        if (codes.size() == 1) {
            CouponExtRespDto couponExtRespDto2 = this.queryByCode(memberId, codes.get(0));
            return couponExtRespDto2 == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new CouponExtRespDto[]{couponExtRespDto2});
        }
        CouponEo couponEo = new CouponEo();
        List<SqlFilter> sqlFilters = Arrays.asList(SqlFilter.in((String)"couponCode", codes));
        couponEo.setSqlFilters(sqlFilters);
        List list = this.couponDas.select((BaseEo)couponEo);
        List<CouponExtRespDto> couponExtRespDtoList = this.eoList2DtoList(list);
        List<Long> couponTemplateIds = couponExtRespDtoList.stream().map(CouponExtRespDto::getCouponTemplateId).distinct().collect(Collectors.toList());
        Map<Long, CouponTemplateExtRespDto> couponTemplateExtRespDtoMap = this.couponTemplateExtQueryService.listByIds2Map(couponTemplateIds);
        couponExtRespDtoList.forEach(couponExtRespDto -> couponExtRespDto.setCouponTemplate((CouponTemplateExtRespDto)couponTemplateExtRespDtoMap.get(couponExtRespDto.getCouponTemplateId())));
        return couponExtRespDtoList;
    }

    @Override
    public Map<String, CouponExtRespDto> listByCodes2Map(Long memberId, List<String> codes) {
        List<CouponExtRespDto> couponExtRespDtoList = this.queryCouponDatesByCodes(memberId, codes);
        return couponExtRespDtoList.stream().collect(Collectors.toMap(CouponExtRespDto::getCouponCode, Function.identity()));
    }

    private List<CouponExtRespDto> queryCouponDatesByCodes(Long memberId, List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        if (codes.size() == 1) {
            CouponExtRespDto couponExtRespDto = this.queryEoByCode(memberId, codes.get(0));
            if (null != couponExtRespDto) {
                CouponTemplateEo couponTemplateEo = this.couponTemplateExtQueryService.queryEoById(couponExtRespDto.getCouponTemplateId());
                CouponTemplateExtRespDto couponTemplateExtRespDto = BeanCopyUtil.copyProperties(CouponTemplateExtRespDto.class, couponTemplateEo, new String[0]);
                couponExtRespDto.setCouponTemplate(couponTemplateExtRespDto);
            }
            return couponExtRespDto == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new CouponExtRespDto[]{couponExtRespDto});
        }
        List<CouponExtRespDto> couponExtRespDtos = this.listByCodes(memberId, codes);
        return couponExtRespDtos;
    }

    @Override
    public List<CouponExtRespDto> listByUserId(Long memberId, List<Long> couponTemplateIds, List<String> activityCodes) {
        if (memberId == null || memberId == 0L) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(couponTemplateIds) || CollectionUtils.isEmpty(activityCodes)) {
            return Collections.emptyList();
        }
        CouponEo query = CouponEo.newInstance();
        query.setUserId(memberId);
        List<SqlFilter> sqlFilters = Arrays.asList(SqlFilter.in((String)"couponTemplateId", couponTemplateIds), SqlFilter.in((String)"activityCode", activityCodes));
        query.setSqlFilters(sqlFilters);
        List list = this.couponDas.select((BaseEo)query);
        return BeanCopyUtil.copyCollections(list, CouponExtRespDto.class, new String[0]);
    }

    @Override
    public List<CouponExtRespDto> listByMemberId(Long userId, List<String> couponTemplateCodes, List<String> activityCodes) {
        if (userId == null || userId == 0L) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(couponTemplateCodes)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(activityCodes)) {
            return Collections.emptyList();
        }
        CouponEo query = CouponEo.newInstance();
        query.setUserId(userId);
        List<SqlFilter> sqlFilters = Arrays.asList(SqlFilter.in((String)"couponTemplateCode", couponTemplateCodes), SqlFilter.in((String)"activityCode", activityCodes));
        query.setSqlFilters(sqlFilters);
        List list = this.couponDas.select((BaseEo)query);
        return BeanCopyUtil.copyCollections(list, CouponExtRespDto.class, new String[0]);
    }

    @Override
    public List<CouponExtRespDto> listByUserId(Long userId, Long couponTemplateId, String activityCode) {
        if (userId == null || userId == 0L) {
            return Collections.emptyList();
        }
        if (couponTemplateId == null || couponTemplateId == 0L) {
            return Collections.emptyList();
        }
        CouponEo query = CouponEo.newInstance();
        query.setUserId(userId);
        query.setCouponTemplateId(couponTemplateId);
        query.setActivityCode(activityCode);
        List list = this.couponDas.select((BaseEo)query);
        return BeanCopyUtil.copyCollections(list, CouponExtRespDto.class, new String[0]);
    }

    @Override
    public Integer countCouponNum(CouponReqDto reqDto) {
        String filter = Object2FilterUtil.object2Filter((Object)reqDto);
        Criteria criteria = (Criteria)ObjectHelper.Json2Bean((String)filter, Criteria.class);
        CouponEo query = CouponEo.newInstance();
        if (null != criteria) {
            query.setSqlFilters(criteria.getFilters());
        }
        return this.couponDas.count((BaseEo)query);
    }

    @Override
    public List<CouponBatchRespDto> listByTemplateId(Long couponTemplateId) {
        CouponGenBatchFlowEo couponGenBatchFlowEo = new CouponGenBatchFlowEo();
        couponGenBatchFlowEo.setCouponTemplateId(couponTemplateId);
        couponGenBatchFlowEo.setOrderBy("createTime");
        List list = this.couponGenBatchFlowDas.select((BaseEo)couponGenBatchFlowEo);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        List dtos = JSON.parseArray((String)JSON.toJSONString((Object)list), CouponBatchRespDto.class);
        return dtos;
    }

    @Override
    public List<CouponExtRespDto> queryCouponByUserIdAndTemplateId(Long targetMemberId, Long couponTemplateId) {
        CouponEo queryEo = new CouponEo();
        queryEo.setUserId(targetMemberId);
        queryEo.setCouponTemplateId(couponTemplateId);
        List eoList = this.couponDas.select((BaseEo)queryEo);
        List<Object> dtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            dtoList = BeanCopyUtil.copyCollections(eoList, CouponExtRespDto.class, new String[0]);
        }
        return dtoList;
    }

    @Override
    public List<Long> queryPersonalizedCouponItemIds(Long couponId, String couponCode) {
        List select;
        if (null == couponId && StringUtils.isBlank((CharSequence)couponCode)) {
            return Lists.newArrayList();
        }
        PersonalizeCouponItemEo queryEo = new PersonalizeCouponItemEo();
        if (null != couponId) {
            queryEo.setCouponId(couponId);
        }
        if (StringUtils.isNotBlank((CharSequence)couponCode)) {
            queryEo.setCouponCode(couponCode);
        }
        if (CollectionUtils.isEmpty((Collection)(select = this.personalizeCouponItemDas.select((BaseEo)queryEo)))) {
            return Lists.newArrayList();
        }
        List<Long> itemIds = select.stream().map(StdPersonalizeCouponItemEo::getItemId).collect(Collectors.toList());
        return itemIds;
    }

    @Override
    public List<CouponRespDto> queryUseCouponByTime(String startTime, String endTime) {
        Long requestTenantId = ServiceContext.getContext().getRequestTenantId();
        CouponEo queryEo = new CouponEo();
        queryEo.setTenantId(requestTenantId);
        queryEo.setCouponStatus(CouponStatusEnum.STOP.getStatus());
        ArrayList filters = Lists.newArrayList();
        filters.add(SqlFilter.le((String)"use_time", (Object)endTime));
        filters.add(SqlFilter.ge((String)"use_time", (Object)startTime));
        queryEo.setSqlFilters((List)filters);
        List eoList = this.couponDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            ArrayList results = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)eoList, (Collection)results, CouponRespDto.class);
            return results;
        }
        return Lists.newArrayList();
    }

    @Override
    public PageInfo<CouponExtRespDto> queryUserCoupons(Long userId, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo = this.couponDas.queryUserCoupons(userId, pageNum.intValue(), pageSize.intValue());
        List<Long> activityIds = pageInfo.getList().stream().map(StdCouponEo::getActivityId).collect(Collectors.toList());
        Map<Long, String> tagMap = this.couponTemplateService.queryActivityListByIds(activityIds);
        ArrayList dtoList = new ArrayList();
        pageInfo.getList().forEach(vo -> {
            CouponExtRespDto respDto = new CouponExtRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)vo, (String[])new String[0]);
            respDto.setCouponStatusDescription(CouponStatusEnum.getByStatus((String)vo.getCouponStatus()).getDescription());
            respDto.setCouponRange(vo.getCouponRange());
            respDto.setCouponCategory(vo.getCouponCategory());
            respDto.setActivityTag((String)tagMap.get(vo.getActivityId()));
            dtoList.add(respDto);
        });
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)pageInfo, (String[])new String[]{"navigatepageNums", "list"});
        respDtoPageInfo.setList(dtoList);
        return respDtoPageInfo;
    }
}

