/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.timediscount.TimeDiscountActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.IActivityAggService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.IItem;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.ITimeDiscountActivity;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.ActivityFactory;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.AbstractActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.MarketingModuleHelper;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TimeDiscountActivityImpl
extends AbstractActivityService
implements ITimeDiscountActivity {
    @Resource
    private IContext context;
    @Resource(name="activityQueryApiImpl")
    private IActivityQueryApi activityQueryApi;
    @Resource
    private MarketingModuleHelper marketingModuleHelper;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItem itemService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IActivityAggService activityService;

    @Override
    public Long add(TimeDiscountActivityDto activityReqDto) {
        this.validate(activityReqDto);
        activityReqDto.setActivityCode(this.marketingModuleHelper.generateCode("TD"));
        return this.addActivity(activityReqDto);
    }

    private void validate(TimeDiscountActivityDto activityReqDto) {
        activityReqDto.getActivityItems().forEach(itemDto -> {
            if (null == itemDto.getShopId()) {
                throw new BizException("\u5546\u54c1\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            itemDto.getSkus().forEach(sku -> {
                BigDecimal sellPrice = this.itemService.queryItemPrice(itemDto.getShopId(), itemDto.getItemId(), sku.getSkuId());
                if (null == sku.getPromotionPrice()) {
                    throw new BizException("\u5546\u54c1\u4fc3\u9500\u6d3b\u52a8\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == sellPrice || sku.getPromotionPrice().compareTo(BigDecimal.ZERO) == -1) {
                    throw new BizException("\u5546\u54c1\u4fc3\u9500\u6d3b\u52a8\u4ef7\u683c\u4e0d\u80fd\u5c0f\u4e8e0");
                }
                if (sellPrice.compareTo(sku.getPromotionPrice()) == -1) {
                    throw new BizException("\u4fc3\u9500\u4ef7\u683c\u4e0d\u80fd\u5927\u4e8e\u5546\u54c1\u552e\u4ef7");
                }
            });
        });
    }

    @Override
    protected <T extends BaseActivityDto> List<ActivityItemReqDto> getActivityItems(T activityReqDto) {
        TimeDiscountActivityDto activityDto = (TimeDiscountActivityDto)activityReqDto;
        ArrayList activityItemReqDtos = Lists.newArrayList();
        activityDto.getActivityItems().stream().forEach(itemDto -> itemDto.getSkus().forEach(skuDto -> {
            ActivityItemReqDto activityItemReqDto = new ActivityItemReqDto();
            activityItemReqDto.setItemId(skuDto.getItemId());
            activityItemReqDto.setItemName(itemDto.getItemName());
            activityItemReqDto.setSkuId(skuDto.getSkuId());
            activityItemReqDto.setInstanceId(this.context.instanceId());
            activityItemReqDto.setTenantId(this.context.tenantId());
            activityItemReqDto.setItemType(ActivityItemTypeEnum.ITEM.getKey());
            activityItemReqDto.setStatus(EnableStatusEnum.ENABLE);
            activityItemReqDto.setOriginalStock(Long.valueOf(null != skuDto.getStock() ? skuDto.getStock() : 0L));
            activityItemReqDto.setRemainingStock(Long.valueOf(null != skuDto.getStock() ? skuDto.getStock() : 0L));
            activityItemReqDto.setActivityPrice(skuDto.getPromotionPrice());
            activityItemReqDto.setShopId(itemDto.getShopId());
            activityItemReqDtos.add(activityItemReqDto);
        }));
        return activityItemReqDtos;
    }

    @Override
    public TimeDiscountActivityDto getDetail(Long id) {
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(id.longValue()).getData();
        if (activityRespDto == null) {
            return null;
        }
        TimeDiscountActivityDto timeDiscountActivityDto = new TimeDiscountActivityDto();
        CubeBeanUtils.copyProperties((Object)timeDiscountActivityDto, (Object)activityRespDto, (String[])new String[0]);
        List<ConditionTemplate> templateList = ActivityFactory.getActivityTemplate(ActivityType.TIME_DISCOUNT_ACTIVITY);
        templateList.forEach(conditionTemplate -> conditionTemplate.parseCondition(activityRespDto.getConditionDtos(), timeDiscountActivityDto));
        timeDiscountActivityDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
        timeDiscountActivityDto.setOrganizationIds((List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryAllSuperiorOrgIdList()));
        return timeDiscountActivityDto;
    }
}

