/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.crowdordering.condition;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.model.ItemPurchaseLimit;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.crowdordering.service.ICacheGroupService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;

public class PurchaseQuantityLimitCondition
extends ConditionTemplate {
    private static final String CONFIG_PARAM_KEY_ITEMS = "PurchaseQuantityLimitCondition.items";
    @Resource
    private ICacheGroupService cacheGroupService;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T params, Map<String, ?> activityParams) {
        List items = params.getItems();
        if (CollectionUtils.isEmpty((Collection)items)) {
            throw new BizException("\u5546\u54c1\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Param param = define.getParam(CONFIG_PARAM_KEY_ITEMS);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u9002\u7528\u9650\u8d2d\u672a\u914d\u7f6e"}));
        }
        List purchaseLimits = (List)ConditionTemplate.converter(activityParams.get(CONFIG_PARAM_KEY_ITEMS), param, define.getLoadClass());
        Map<String, Integer> limitQuantityMap = purchaseLimits.stream().collect(Collectors.toMap(key -> key.getItemId().toString() + key.getShopId(), ItemPurchaseLimit::getLimitQuantity, (e1, e2) -> e1));
        Map<String, List<ItemVo>> listMap = items.stream().collect(Collectors.groupingBy(ItemVo::getItemId));
        for (ItemVo itemVo : items) {
            Long joinNum = this.cacheGroupService.getJoinNum(params.getActivityId(), params.getUserId(), itemVo.getItemId(), Long.valueOf(itemVo.getShopId()));
            Integer limitNum = limitQuantityMap.get(itemVo.getItemId() + itemVo.getShopId());
            if (joinNum == null) {
                joinNum = 0L;
            }
            if (joinNum == null || limitNum == null) continue;
            List<ItemVo> itemVos = listMap.get(itemVo.getItemId());
            Long itemBuyNum = 0L;
            for (ItemVo item : itemVos) {
                itemBuyNum = itemBuyNum + (long)item.getNum();
            }
            if (joinNum + itemBuyNum <= (long)limitNum.intValue()) continue;
        }
        return true;
    }
}

