/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityPersonQueryDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityShareLinkDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityShareLinkGroupDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityShareLinkPersonDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityShareLinkAnalysisService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityShareLinkDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityShareLinkPersonDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityShareLinkEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityShareLinkPersonEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StdActivityShareLinkEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StdActivityShareLinkPersonEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jgrapht.Graph;
import org.jgrapht.alg.scoring.BetweennessCentrality;
import org.jgrapht.alg.scoring.ClosenessCentrality;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultUndirectedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ActivityShareLinkAnalysisServiceImpl
implements IActivityShareLinkAnalysisService {
    private static final Logger logger = LoggerFactory.getLogger(ActivityShareLinkAnalysisServiceImpl.class);
    @Resource
    private ActivityShareLinkDas activityShareLinkDas;
    @Resource
    private ActivityShareLinkPersonDas activityShareLinkPersonDas;
    public static List<String> orderByList = new ArrayList<String>();

    @Override
    public void analysisActivity(Long actId) {
        DefaultDirectedGraph directedGraph = this.buildGraph(actId, new DefaultDirectedGraph(DefaultEdge.class));
        Map<String, Graph<String, DefaultEdge>> groupMap = this.getGroup((Graph<String, DefaultEdge>)directedGraph);
        if (CollectionUtils.isEmpty(groupMap.keySet())) {
            return;
        }
        BetweennessCentrality betweenCentrality = new BetweennessCentrality((Graph)directedGraph, true);
        Map betweenScoreMap = betweenCentrality.getScores();
        HashMap closenessScoreMap = new HashMap(10);
        groupMap.keySet().forEach(key -> {
            Graph graph = (Graph)groupMap.get(key);
            ClosenessCentrality closenessCentrality = new ClosenessCentrality(graph);
            closenessScoreMap.put(key, closenessCentrality.getScores());
        });
        for (String key2 : groupMap.keySet()) {
            Set group = groupMap.get(key2).vertexSet();
            ActivityShareLinkEo selectEo = ActivityShareLinkEo.newInstance();
            selectEo.setSqlFilters(Arrays.asList(SqlFilter.in((String)"wechat_open_id", (Object)group), SqlFilter.eq((String)"act_id", (Object)actId)));
            List linkList = this.activityShareLinkDas.select((BaseEo)selectEo);
            Map<String, ActivityShareLinkEo> linkMap = linkList.stream().collect(Collectors.toMap(StdActivityShareLinkEo::getWechatOpenId, link -> link));
            group.forEach(wechatId -> {
                ActivityShareLinkEo link = (ActivityShareLinkEo)linkMap.get(wechatId);
                if (link != null) {
                    ActivityShareLinkPersonEo eo = ActivityShareLinkPersonEo.newInstance();
                    eo.setActId(actId);
                    eo.setWechatOpenId(wechatId);
                    ActivityShareLinkEo groupPersonEo = (ActivityShareLinkEo)linkMap.get(key2);
                    eo.setGroupPersonId(Long.valueOf(groupPersonEo.getOneId()));
                    eo.setSharePv(link.getSharePv());
                    eo.setShareUv(link.getShareUv());
                    eo.setWechatNickName(link.getWechatNickName());
                    eo.setCenterScore((Double)((Map)closenessScoreMap.get(key2)).get(wechatId));
                    eo.setSpreadScore((Double)betweenScoreMap.get(wechatId));
                    eo.setTotalScore(this.getTotalScore(eo));
                    this.activityShareLinkPersonDas.insert((BaseEo)eo);
                }
            });
        }
    }

    private Double getTotalScore(ActivityShareLinkPersonEo eo) {
        double uvScore = eo.getShareUv() == 0L ? Double.valueOf(eo.getShareUv().longValue()) : 1.0 - 1.0 / (double)eo.getShareUv().longValue();
        double pvScore = eo.getSharePv() == 0L ? Double.valueOf(eo.getSharePv().longValue()) : 1.0 - 1.0 / (double)eo.getSharePv().longValue();
        return uvScore + pvScore + eo.getCenterScore() + eo.getSpreadScore();
    }

    private Map<String, Graph<String, DefaultEdge>> getGroup(Graph<String, DefaultEdge> directedGraph) {
        boolean flag;
        ArrayList vertexList = new ArrayList(Objects.requireNonNull(directedGraph).vertexSet());
        HashMap<String, Integer> vertexIndexMap = new HashMap<String, Integer>(vertexList.size());
        ArrayList groupList = new ArrayList(vertexList.size());
        for (int i = 0; i < vertexList.size(); ++i) {
            String vertex2 = (String)vertexList.get(i);
            vertexIndexMap.put(vertex2, i);
            HashSet<Integer> vertexSet = new HashSet<Integer>();
            vertexSet.add(i);
            groupList.add(vertexSet);
        }
        ArrayList<Double> vertexPointList = new ArrayList<Double>(vertexList.size());
        for (int i = 0; i < vertexList.size(); ++i) {
            vertexPointList.add(0.0);
        }
        ArrayList targetVertexList = new ArrayList(vertexList.size());
        for (int i = 0; i < vertexList.size(); ++i) {
            targetVertexList.add(new ArrayList());
        }
        vertexList.forEach(vertex -> {
            Integer index = (Integer)vertexIndexMap.get(vertex);
            vertexPointList.set(index, Double.valueOf(directedGraph.outDegreeOf(vertex)));
            Set edgeSet = directedGraph.edgesOf(vertex);
            ArrayList targetVertexSet = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)edgeSet)) {
                targetVertexSet.addAll(edgeSet.stream().map(edge -> (Integer)vertexIndexMap.get(directedGraph.getEdgeTarget(edge))).collect(Collectors.toSet()));
            }
            targetVertexList.set(index, targetVertexSet);
            ((Set)groupList.get(index)).addAll(new HashSet(targetVertexSet));
        });
        do {
            flag = false;
            for (int i = 0; i < targetVertexList.size(); ++i) {
                Double point = (Double)vertexPointList.get(i);
                List outDegreeList = (List)targetVertexList.get(i);
                if (CollectionUtils.isEmpty((Collection)outDegreeList)) continue;
                TreeMap outDegreePointMap = new TreeMap();
                outDegreeList.forEach(outDegree -> outDegreePointMap.put(vertexPointList.get((int)outDegree), outDegree));
                Map.Entry firstEntry = outDegreePointMap.lastEntry();
                if ((Double)firstEntry.getKey() <= point) continue;
                ((Set)groupList.get((Integer)firstEntry.getValue())).add(i);
                vertexPointList.set(i, (point + (Double)firstEntry.getKey()) / 2.0);
                flag = true;
            }
        } while (flag);
        HashMap<Integer, Integer> groupSizeMap = new HashMap<Integer, Integer>(16);
        for (int i = 0; i < groupList.size(); ++i) {
            Set groupSet = (Set)groupList.get(i);
            if (groupSet.size() <= 1) continue;
            groupSizeMap.put(i, groupSet.size());
        }
        List list = new ArrayList(groupSizeMap.entrySet());
        list.sort((o1, o2) -> (Integer)o2.getValue() - (Integer)o1.getValue());
        list = list.subList(0, list.size() > 10 ? 10 : list.size());
        HashMap<String, Graph<String, DefaultEdge>> result = new HashMap<String, Graph<String, DefaultEdge>>(10);
        for (Map.Entry i : list) {
            String key = (String)vertexList.get((Integer)i.getKey());
            DefaultUndirectedGraph graph = new DefaultUndirectedGraph(DefaultEdge.class);
            Set group = (Set)groupList.get((Integer)i.getKey());
            group.forEach(arg_0 -> ActivityShareLinkAnalysisServiceImpl.lambda$getGroup$7((Graph)graph, vertexList, arg_0));
            graph.vertexSet().forEach(arg_0 -> ActivityShareLinkAnalysisServiceImpl.lambda$getGroup$8(directedGraph, (Graph)graph, arg_0));
            result.put(key, (Graph<String, DefaultEdge>)graph);
        }
        return result;
    }

    private <T extends Graph<String, DefaultEdge>> T buildGraph(Long actId, T graph) {
        List activityShareLinkEoList;
        Long startId = 0L;
        HashSet vertexSet = new HashSet();
        do {
            if (CollectionUtils.isEmpty((Collection)(activityShareLinkEoList = this.activityShareLinkDas.listActivityShareLink(actId, startId, Integer.valueOf(10000))))) continue;
            activityShareLinkEoList.forEach(activityShareLink -> {
                String lstWechatOpenId = activityShareLink.getLstWechatOpenId();
                String wechatOpenId = activityShareLink.getWechatOpenId();
                if (!vertexSet.contains(lstWechatOpenId) && StringUtils.isNotBlank((CharSequence)lstWechatOpenId)) {
                    vertexSet.add(lstWechatOpenId);
                    graph.addVertex((Object)lstWechatOpenId);
                }
                if (!vertexSet.contains(wechatOpenId) && StringUtils.isNotBlank((CharSequence)wechatOpenId)) {
                    vertexSet.add(wechatOpenId);
                    graph.addVertex((Object)wechatOpenId);
                }
                if (StringUtils.isNotBlank((CharSequence)lstWechatOpenId) && StringUtils.isNotBlank((CharSequence)wechatOpenId)) {
                    graph.addEdge((Object)lstWechatOpenId, (Object)wechatOpenId);
                }
            });
            startId = ((ActivityShareLinkEo)activityShareLinkEoList.get(activityShareLinkEoList.size() - 1)).getId();
        } while (CollectionUtils.isNotEmpty((Collection)activityShareLinkEoList));
        return graph;
    }

    @Override
    public List<ActivityShareLinkGroupDto> listActivityGroup(Long actId) {
        List list = this.activityShareLinkPersonDas.listActivityGroup(actId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        List groupPersonIdList = list.stream().map(m -> String.valueOf(m.get("group_person_id"))).collect(Collectors.toList());
        ActivityShareLinkEo eo = ActivityShareLinkEo.newInstance();
        eo.setSqlFilters(Arrays.asList(SqlFilter.eq((String)"act_id", (Object)actId), SqlFilter.in((String)"one_id", groupPersonIdList)));
        List groupPersonList = this.activityShareLinkDas.select((BaseEo)eo);
        if (CollectionUtils.isEmpty((Collection)groupPersonList)) {
            return Collections.emptyList();
        }
        Map<String, String> groupPersonNameMap = groupPersonList.stream().collect(Collectors.toMap(StdActivityShareLinkEo::getOneId, StdActivityShareLinkEo::getWechatNickName));
        ArrayList<ActivityShareLinkGroupDto> resultList = new ArrayList<ActivityShareLinkGroupDto>();
        list.forEach(m -> {
            ActivityShareLinkGroupDto dto = new ActivityShareLinkGroupDto();
            Long groupPersonId = Long.valueOf(m.get("group_person_id").toString());
            dto.setName((String)groupPersonNameMap.get(String.valueOf(groupPersonId)));
            dto.setGroupPersonId(groupPersonId);
            dto.setCount(Integer.valueOf(m.get("count").toString()));
            resultList.add(dto);
        });
        return resultList;
    }

    @Override
    public PageInfo<ActivityShareLinkPersonDto> pageActivityPerson(ActivityPersonQueryDto dto) {
        if (CollectionUtils.isEmpty((Collection)dto.getGroupPersonId())) {
            return new PageInfo();
        }
        ActivityShareLinkPersonEo eo = ActivityShareLinkPersonEo.newInstance();
        eo.setActId(dto.getActId());
        eo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"group_person_id", (Object)dto.getGroupPersonId())));
        if (dto.getOrderBy() != null) {
            eo.setOrderByDesc(orderByList.get(dto.getOrderBy()));
        } else {
            eo.setOrderByDesc("total_score");
        }
        PageInfo page = this.activityShareLinkPersonDas.selectPage((BaseEo)eo, dto.getPageNum(), dto.getPageSize());
        if (CollectionUtils.isEmpty((Collection)page.getList())) {
            return new PageInfo();
        }
        ArrayList list = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)page.getList(), (Collection)list, ActivityShareLinkPersonDto.class);
        page.setList((List)list);
        return page;
    }

    @Override
    public List<ActivityShareLinkDto> listActivityGroupPerson(Long actId, Long groupPersonId) {
        ActivityShareLinkPersonEo eo = ActivityShareLinkPersonEo.newInstance();
        eo.setActId(actId);
        eo.setGroupPersonId(groupPersonId);
        List personList = this.activityShareLinkPersonDas.select((BaseEo)eo);
        if (CollectionUtils.isEmpty((Collection)personList)) {
            return Collections.emptyList();
        }
        List list = this.activityShareLinkDas.listActivityGroupPerson(actId, personList.stream().map(StdActivityShareLinkPersonEo::getWechatOpenId).collect(Collectors.toList()));
        ArrayList<ActivityShareLinkDto> dtoList = new ArrayList<ActivityShareLinkDto>();
        DtoHelper.eoList2DtoList((Collection)list, dtoList, ActivityShareLinkDto.class);
        return dtoList;
    }

    private static /* synthetic */ void lambda$getGroup$8(Graph directedGraph, Graph graph, String vertex) {
        Set edgeSet = directedGraph.outgoingEdgesOf((Object)vertex);
        if (CollectionUtils.isNotEmpty((Collection)edgeSet)) {
            for (DefaultEdge edge : edgeSet) {
                String target = (String)directedGraph.getEdgeTarget((Object)edge);
                if (!graph.containsVertex((Object)target)) continue;
                graph.addEdge(directedGraph.getEdgeSource((Object)edge), (Object)target, (Object)edge);
            }
        }
    }

    private static /* synthetic */ void lambda$getGroup$7(Graph graph, List vertexList, Integer vertexIndex) {
        graph.addVertex(vertexList.get(vertexIndex));
    }

    static {
        orderByList.add("share_uv");
        orderByList.add("spread_score");
        orderByList.add("center_score");
    }
}

