/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.converter.promotion.condition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.dataengine.center.tag.api.dto.response.TagClusterDetailsRespDto;
import com.dtyunxi.yundt.dataengine.center.tag.api.query.IClusterQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ConditionTemplateType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.ConditionDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PopulationRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PromotionInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.converter.promotion.condition.ConditionTemplate;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MemberCondition
implements ConditionTemplate {
    private static final Logger logger = LoggerFactory.getLogger(MemberCondition.class);

    @Override
    public long getConditionTemplateId() {
        return ConditionTemplateType.TARGET_POPULATION.getId();
    }

    @Override
    public long getRuleId() {
        return 1196945569982147605L;
    }

    @Override
    public boolean support(ActivityType type) {
        return true;
    }

    @Override
    public ConditionReqDto changeToCondition(PromotionDto dto) {
        ConditionReqDto member = new ConditionReqDto();
        member.setConditionTemplateId(Long.valueOf(this.getConditionTemplateId()));
        member.setRuleId(Long.valueOf(this.getRuleId()));
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("PopulationCondition.type", dto.getBaseConditionDto().getMemberType());
        param.put("PopulationCondition.value", dto.getBaseConditionDto().getMemberIds());
        member.setConditionParams(JSON.toJSONString(param));
        return member;
    }

    @Override
    public List<ConditionDto> changeToRules(ConditionRespDto conditionRespDto, PromotionInfoRespDto resp) {
        if (Objects.equals(conditionRespDto.getConditionTemplateId(), this.getConditionTemplateId())) {
            JSONObject conditionObj = JSON.parseObject((String)conditionRespDto.getConditionParams());
            Integer type = conditionObj.getInteger("PopulationCondition.type");
            PopulationRespDto populationRespDto = new PopulationRespDto();
            populationRespDto.setType(type);
            String valueStr = conditionObj.getString("PopulationCondition.value");
            if (!StringUtils.isEmpty((Object)valueStr)) {
                List ids = JSON.parseArray((String)valueStr, Long.class);
                if (type == 1) {
                    Long groupId = (Long)ids.get(0);
                    if (groupId != null) {
                        TagClusterDetailsRespDto tagData = this.getTagCluster(groupId);
                        populationRespDto.setGroupId(groupId);
                        if (tagData != null) {
                            populationRespDto.setGroupName(tagData.getAliasCn());
                        }
                    }
                } else if (type == 2) {
                    populationRespDto.setLevelIds(ids);
                }
            }
            resp.setPopulationRespDto(populationRespDto);
        }
        return null;
    }

    private TagClusterDetailsRespDto getTagCluster(Long groupId) {
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        Long instanceId = ServiceContext.getContext().getRequestInstanceId();
        try {
            return (TagClusterDetailsRespDto)((IClusterQueryApi)SpringBeanUtil.getBean(IClusterQueryApi.class)).queryClusterDetails(tenantId, instanceId, groupId).getData();
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4eba\u7fa4\u5f02\u5e38{}", (Object)e.getMessage());
            return null;
        }
    }
}

