/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.SystemException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.member.api.basis.query.IMemberQueryApi;
import com.dtyunxi.yundt.cube.center.member.api.common.dto.response.MemberRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.InstallmentStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.InstallmentTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.InstallmentReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizExceptionCodeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.IInstallmentService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.promotion.das.InstallmentDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.promotion.das.InstallmentDetailDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.promotion.InstallmentDetailEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.promotion.InstallmentEo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="installmentService")
@Transactional(rollbackFor={Exception.class})
public class InstallmentServiceImpl
implements IInstallmentService {
    @Resource
    private InstallmentDas installmentDas;
    @Resource
    private InstallmentDetailDas installmentDetailDas;
    @Resource
    private IMemberQueryApi memberQueryApi;

    @Override
    public void sendPoints(Long memberId, InstallmentReqDto reqDto) {
        this.checkRepeat(InstallmentTypeEnum.POINTS, memberId, reqDto);
        InstallmentEo forInsert = new InstallmentEo();
        forInsert.setUserId(memberId);
        forInsert.setType(InstallmentTypeEnum.POINTS.getType());
        this.fillBase(forInsert, reqDto);
        forInsert.setRemark("\u50a8\u503c\u8d60\u793c-\u5206\u671f\u8d60\u9001\u79ef\u5206");
        MemberRespDto memberInfo = (MemberRespDto)this.memberQueryApi.queryById(memberId).getData();
        if (memberInfo != null) {
            forInsert.setMemberModelId(memberInfo.getMemberModelId());
        }
        this.installmentDas.insert((BaseEo)forInsert);
        this.handleMonth(forInsert.getId(), reqDto);
    }

    @Override
    public void sendStoredValue(Long memberId, InstallmentReqDto reqDto) {
        this.checkRepeat(InstallmentTypeEnum.STORED_VALUE, memberId, reqDto);
        InstallmentEo forInsert = new InstallmentEo();
        forInsert.setUserId(memberId);
        forInsert.setType(InstallmentTypeEnum.STORED_VALUE.getType());
        this.fillBase(forInsert, reqDto);
        forInsert.setRemark("\u50a8\u503c\u8d60\u793c-\u5206\u671f\u8d60\u9001\u50a8\u503c");
        this.installmentDas.insert((BaseEo)forInsert);
        this.handleMonth(forInsert.getId(), reqDto);
    }

    @Override
    public void sendCoupon(Long memberId, InstallmentReqDto reqDto) {
        this.checkRepeat(InstallmentTypeEnum.COUPON, memberId, reqDto);
        InstallmentEo forInsert = new InstallmentEo();
        forInsert.setUserId(memberId);
        forInsert.setObjId(reqDto.getObjId());
        forInsert.setType(InstallmentTypeEnum.COUPON.getType());
        this.fillBase(forInsert, reqDto);
        forInsert.setRemark("\u50a8\u503c\u8d60\u793c-\u5206\u671f\u8d60\u9001\u4f18\u60e0\u5238");
        this.installmentDas.insert((BaseEo)forInsert);
        this.handleMonth(forInsert.getId(), reqDto);
    }

    @Override
    public void done(Long detailId, InstallmentStatusEnum result, String tradeNo, String failMsg) {
        InstallmentDetailEo detailEo = (InstallmentDetailEo)this.installmentDetailDas.selectByPrimaryKey(detailId);
        if (detailEo == null) {
            return;
        }
        InstallmentDetailEo forUpd = new InstallmentDetailEo();
        forUpd.setId(detailId);
        forUpd.setExecuteTime(new Date());
        forUpd.setTradeNo(tradeNo);
        if (Objects.equals(result.getStatus(), InstallmentStatusEnum.SUCCESS.getStatus())) {
            forUpd.setStatus(InstallmentStatusEnum.SUCCESS.getStatus());
        } else {
            forUpd.setStatus(InstallmentStatusEnum.FAIL.getStatus());
            forUpd.setFailMsg(failMsg);
        }
        this.installmentDetailDas.updateSelective((BaseEo)forUpd);
    }

    private void fillBase(InstallmentEo forInsert, InstallmentReqDto reqDto) {
        forInsert.setActivityId(reqDto.getActivityId());
        forInsert.setBusinessNo(reqDto.getBusinessNo());
        forInsert.setBatchNum(reqDto.getMonthlyInstallment());
        forInsert.setTotalNum(reqDto.getTotalNum());
        forInsert.setValidityDay(reqDto.getValidityDay());
        forInsert.setPostpone(reqDto.getPostpone());
        forInsert.setExtension(JSON.toJSONString((Object)reqDto.getExtension()));
    }

    private void handleMonth(Long installmentId, InstallmentReqDto reqDto) {
        ArrayList detailEoList = Lists.newArrayList();
        BigDecimal totalNum = reqDto.getTotalNum();
        Integer month = reqDto.getMonthlyInstallment();
        BigDecimal[] everyArr = totalNum.divideAndRemainder(BigDecimal.valueOf(month.intValue()));
        BigDecimal everyMonthNum = everyArr[0];
        BigDecimal firstMonthNum = everyMonthNum.add(everyArr[1]);
        Date firstMonth = this.getDelayDate(reqDto.getPostpone());
        InstallmentDetailEo first = this.getDetailBase(installmentId);
        first.setStartTime(firstMonth);
        first.setPeriodNum(Integer.valueOf(1));
        first.setNum(firstMonthNum);
        detailEoList.add(first);
        Integer i = 1;
        while (i < month) {
            Date nextMonth = this.addMonth(firstMonth, i);
            InstallmentDetailEo next = this.getDetailBase(installmentId);
            next.setStartTime(nextMonth);
            next.setPeriodNum(Integer.valueOf(i + 1));
            next.setNum(everyMonthNum);
            detailEoList.add(next);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        this.installmentDetailDas.insertBatch((List)detailEoList);
    }

    private InstallmentDetailEo getDetailBase(Long installmentId) {
        InstallmentDetailEo detailEo = new InstallmentDetailEo();
        detailEo.setInstallmentId(installmentId);
        detailEo.setStatus(InstallmentStatusEnum.WAIT.getStatus());
        return detailEo;
    }

    private Date getDelayDate(Integer d) {
        Calendar ca = Calendar.getInstance();
        if (d != null) {
            ca.add(5, d);
        }
        return ca.getTime();
    }

    private Date addMonth(Date source, Integer num) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(source);
        ca.add(2, num);
        ca.set(5, 1);
        return ca.getTime();
    }

    private void checkRepeat(InstallmentTypeEnum type, Long memberId, InstallmentReqDto installmentReqDto) {
        InstallmentEo forQuery = new InstallmentEo();
        forQuery.setBusinessNo(installmentReqDto.getBusinessNo());
        forQuery.setUserId(memberId);
        forQuery.setType(type.getType());
        if (CollectionUtils.isNotEmpty((Collection)this.installmentDas.select((BaseEo)forQuery))) {
            throw new SystemException(ProBizExceptionCodeEnum.INSTALLMENT_REPEAT.getCode(), ProBizExceptionCodeEnum.INSTALLMENT_REPEAT.getMsg());
        }
    }
}

