/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.exchange;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.exchange.ExchangeActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExcSkuDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExchangeRule;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.AbstractBaseTemplate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ExchangeCondition
extends AbstractBaseTemplate {
    @Override
    protected <T extends BaseActivityDto> void parse(ConditionRespDto conditionRespDto, T t) {
        ExchangeActivityDto exchangeActivityDto = (ExchangeActivityDto)t;
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        ExchangeRule exchangeRule = (ExchangeRule)JSON.parseObject((String)jsonObject.getString("ExchangeCondition.rule"), ExchangeRule.class);
        exchangeActivityDto.setItemLimit(exchangeRule.getItemLimit());
        exchangeActivityDto.setPromotionContents(exchangeRule.getExcRuleContents());
        exchangeActivityDto.setThresholdType(exchangeRule.getThresholdType());
        exchangeActivityDto.setPromotionCondition(exchangeRule.getPromotionCondition());
        ArrayList itemIds = Lists.newArrayList();
        HashSet shopIds = Sets.newHashSet();
        ArrayList skuIds = Lists.newArrayList();
        ArrayList shelfReqDtos = Lists.newArrayList();
        exchangeRule.getExcRuleContents().forEach(ruleContent -> ruleContent.getExchangeItems().forEach(itemDto -> itemDto.getExcSkuDtos().forEach(excSkuDto -> {
            itemIds.add(excSkuDto.getItemId());
            skuIds.add(excSkuDto.getSkuId());
            shopIds.add(itemDto.getShopId());
            ShelfReqDto shelfReqDto = new ShelfReqDto();
            shelfReqDto.setSkuId(excSkuDto.getSkuId());
            shelfReqDto.setShopId(itemDto.getShopId());
            shelfReqDtos.add(shelfReqDto);
        })));
        Map<Long, ItemRespDto> itemMap = this.queryItemByIds(itemIds);
        Map<Long, ShopBaseDto> shopMap = this.queryShopByIds(shopIds);
        Map<Long, ItemSkuRespDto> skuMap = this.queryItemSku(skuIds);
        Map<String, BigDecimal> priceMap = this.queryItemPrice(shelfReqDtos);
        Map<String, Long> stockMap = this.queryItemStock(shelfReqDtos);
        exchangeRule.getExcRuleContents().forEach(ruleContent -> ruleContent.getExchangeItems().forEach(itemDto -> {
            ItemRespDto itemRespDto = (ItemRespDto)itemMap.get(itemDto.getItemId());
            ShopBaseDto shopBaseDto = (ShopBaseDto)shopMap.get(itemDto.getShopId());
            itemDto.setItemName(itemRespDto.getName());
            itemDto.setShopName(shopBaseDto.getName());
            Long totalStock = 0L;
            for (ExcSkuDto excSkuDto : itemDto.getExcSkuDtos()) {
                String key = itemDto.getShopId() + excSkuDto.getSkuId().toString();
                Long stock = stockMap.getOrDefault(key, 0L);
                BigDecimal sellPrice = priceMap.getOrDefault(key, null);
                String skuName = null;
                ItemSkuRespDto skuRespDto = (ItemSkuRespDto)skuMap.get(excSkuDto.getSkuId());
                if (StringUtils.isNotBlank((String)skuRespDto.getAttr())) {
                    Map skuAttrMap = (Map)ObjectHelper.Json2Bean((String)skuRespDto.getAttr(), Map.class);
                    skuName = StringUtils.join(skuAttrMap.values(), (String)" ");
                }
                excSkuDto.setStock(stock);
                excSkuDto.setSellPrice(sellPrice);
                excSkuDto.setSkuName(skuName);
                totalStock = totalStock + stock;
            }
            itemDto.setTotalStock(totalStock);
        }));
    }

    @Override
    public long getConditionTemplateId() {
        return 1196944771412880296L;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return ActivityType.EXCHANGE_ACTIVITY.equals((Object)type);
    }

    @Override
    public <T extends BaseActivityDto> ConditionReqDto convertToCondition(T t) {
        ConditionReqDto conditionReqDto = this.getConditionReqDto();
        ExchangeActivityDto exchangeActivityDto = (ExchangeActivityDto)t;
        ExchangeRule exchangeRule = new ExchangeRule();
        exchangeRule.setExcRuleContents(exchangeActivityDto.getPromotionContents());
        exchangeRule.setPromotionMethod(Integer.valueOf(1));
        exchangeRule.setPromotionCondition(Integer.valueOf(1));
        exchangeRule.setItemLimit(exchangeActivityDto.getItemLimit());
        exchangeRule.setThresholdType(exchangeActivityDto.getThresholdType());
        HashMap param = Maps.newHashMap();
        param.put("ExchangeCondition.rule", exchangeRule);
        conditionReqDto.setConditionParams(JSON.toJSONString((Object)param));
        return conditionReqDto;
    }
}

