/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.serializa;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.CouponTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.CouponUseTimeDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.DynamicDate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.IDeserializationDynamicDate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.enums.CouponUseTimeEnum;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class DeserializationNextDay
implements IDeserializationDynamicDate {
    private static final Integer NEXT_DAY = 2;

    @Override
    public Integer getSupportAfterDay() {
        return NEXT_DAY;
    }

    @Override
    public void deserialization(CouponTemplate couponTemplate, DynamicDate dynamicDate) {
        if (dynamicDate == null) {
            return;
        }
        if (dynamicDate.getAfterDate() != NEXT_DAY) {
            return;
        }
        CouponUseTimeDto dto = new CouponUseTimeDto();
        dto.setType(CouponUseTimeEnum.NETX_DAY.getKey());
        dto.setValue((Object)dynamicDate.getDay());
        couponTemplate.setCouponUseTimeReqDto(dto);
        couponTemplate.setCouponUseBeginTime(DateUtil.addDays((Date)DateUtil.getDayBegin(), (int)1));
        Date endTime = DateUtil.getEndOfDay((Date)couponTemplate.getCouponUseBeginTime());
        if (dynamicDate.getDay() > 1) {
            endTime = DateUtil.addDays((Date)endTime, (int)(dynamicDate.getDay() - 1));
        }
        couponTemplate.setCouponUseEndTime(endTime);
    }
}

