/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.crowdordering.service.impl;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.crowdordering.service.ICacheGroupService;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CacheGroupServiceImpl
implements ICacheGroupService {
    @Resource
    private ICacheService cacheService;
    public final String JOIN_NUM = "join_num";
    public final String JOIN_AMOUNT = "join_amount";
    public Long scaleNum = 10000L;
    public int scale = 4;
    public final Integer ALL_ADD_MINUTES = 2592000;
    private Logger logger = LoggerFactory.getLogger(CacheGroupServiceImpl.class);

    public void initCloseTime(String groupId, Integer addMinutes) {
        Integer delay = this.getDelayMinutes(addMinutes);
        this.logger.info("\u6d3b\u52a8{}\u521d\u59cb\u5316\u5ef6\u957f\u65f6\u95f4{}", (Object)groupId, (Object)delay);
        String dateFormat = DateUtil.getDateFormat((Date)DateUtil.addSeconds((Date)new Date(), (int)delay), (String)"yyyy-MM-dd HH:mm:ss");
        this.cacheService.hset(this.getGroupKey(groupId), "close_time", (Object)dateFormat, delay.intValue());
    }

    private String getGroupKey(String groupId) {
        return "group_activity:" + groupId;
    }

    private String getActivityKey(Long activityId, Long userId, String itemId, Long shopId) {
        return "activity:" + activityId + "_user_" + userId + "_item_" + itemId + "_shop_" + shopId;
    }

    int getDelayMinutes(Integer addMinutes) {
        return addMinutes + this.ALL_ADD_MINUTES;
    }

    @Override
    public boolean increaseJoinNum(Long activityId, Long userId, String itemId, Long shopId, Long num, Integer addMinutes) {
        boolean isAdd = this.cacheService.add(this.getActivityKey(activityId, userId, itemId, shopId), (Object)num, this.getDelayMinutes(addMinutes));
        if (!isAdd) {
            Long result = this.cacheService.incrBy(this.getActivityKey(activityId, userId, itemId, shopId), num.longValue());
            this.logger.info("{}\u7ed3\u679c{}", (Object)this.getActivityKey(activityId, userId, itemId, shopId), (Object)result);
        }
        return true;
    }

    @Override
    public Long getJoinNum(Long activityId, Long userId, String itemId, Long shopId) {
        return (Long)this.cacheService.getCache(this.getActivityKey(activityId, userId, itemId, shopId), Long.class);
    }

    @Override
    public Long subJoinNum(String groupId, Long num) {
        if (this.getRemainJoinNum(groupId) == null) {
            return null;
        }
        Long resultNum = this.cacheService.hincrBy(this.getGroupKey(groupId), "join_num", Long.valueOf(-num.longValue()));
        this.logger.info("\u53c2\u56e2\u6d3b\u52a8{}\u6263\u51cf\u6570\u91cf{},\u5269\u4f59\u6570\u91cf{}", new Object[]{groupId, num, resultNum});
        return resultNum;
    }

    public boolean initJoinNum(String groupId, Long num, Integer addMinutes) {
        this.cacheService.hset(this.getGroupKey(groupId), "join_num", (Object)num, this.getDelayMinutes(addMinutes));
        this.logger.info("\u53c2\u56e2\u6d3b\u52a8{}\u521d\u59cb\u5316\u6570\u91cf{}", (Object)groupId, (Object)num);
        return true;
    }

    @Override
    public Long getRemainJoinNum(String groupId) {
        Long num = (Long)this.cacheService.hget(this.getGroupKey(groupId), "join_num", Long.class);
        return num;
    }

    @Override
    public BigDecimal getRemainJoinAmount(String groupId) {
        Long amount = (Long)this.cacheService.hget(this.getGroupKey(groupId), "join_amount", Long.class);
        BigDecimal bigDecimal = new BigDecimal(amount);
        return bigDecimal.divide(new BigDecimal(this.scaleNum), this.scale);
    }

    public void initJoinAmount(String groupId, BigDecimal bigAmount, Integer addMinutes) {
        long amount = bigAmount.subtract(new BigDecimal(this.scaleNum)).longValue();
        this.cacheService.hset(this.getGroupKey(groupId), "join_amount", (Object)amount, this.getDelayMinutes(addMinutes));
    }

    @Override
    public BigDecimal subJoinAmount(String groupId, BigDecimal bigAmount) {
        long amount = bigAmount.subtract(new BigDecimal(this.scaleNum)).longValue();
        Long resultNum = this.cacheService.hincrBy(this.getGroupKey(groupId), "join_amount", Long.valueOf(-amount));
        if (resultNum < 0L) {
            this.cacheService.hincrBy(this.getGroupKey(groupId), "join_amount", Long.valueOf(amount));
        }
        this.logger.info("\u53c2\u56e2\u6d3b\u52a8{}\u6263\u51cf\u91d1\u989d\u6570\u91cf{},\u662f\u5426\u6210\u529f{}", (Object)groupId, (Object)amount);
        BigDecimal bigDecimal = new BigDecimal(resultNum);
        return bigDecimal.divide(new BigDecimal(this.scaleNum), this.scale);
    }

    @Override
    public void init(String groupId, Integer addMinutes, Long num, BigDecimal amount) {
        this.initCloseTime(groupId, addMinutes);
        if (num != null) {
            this.initJoinNum(groupId, num, addMinutes);
        }
        if (amount != null) {
            this.initJoinAmount(groupId, amount, addMinutes);
        }
    }
}

