/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityExtDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityListRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ConditionTemplateRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityDimensionEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ConditionTemplateType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.ActivityItemBranchReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PointExchangeItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.ActivityItemBranchRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PointExchangeActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionExtCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExcItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExcRuleContentDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExchangeRule;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.MapUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.IActivityExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.IConditionExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.vo.PointExchangeVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActionService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityItemService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IConditionService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IConditionTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityAuditDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityExtDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityItemDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ConditionDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponTemplateDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.vo.ActivityListVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityAuditEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ConditionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StdActivityEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StdConditionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponTemplateEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.StdCouponTemplateEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="activityExtQueryService")
public class ActivityExtQueryServiceImpl
implements IActivityExtQueryService {
    private static final Logger logger = LoggerFactory.getLogger(ActivityExtQueryServiceImpl.class);
    @Resource
    private ActivityDas activityDas;
    @Resource
    private ActivityExtDas activityExtDas;
    @Resource
    private ActivityAuditDas activityAuditDas;
    @Resource
    private IConditionTemplateService conditionTemplateService;
    @Resource
    private IConditionExtQueryService conditionQueryService;
    @Resource
    private IActivityService activityService;
    @Resource
    private IActivityItemService activityItemService;
    @Autowired
    private ActivityItemDas activityItemDas;
    @Autowired
    private ConditionDas conditionDas;
    @Autowired
    private IConditionService conditionService;
    @Autowired
    private IActionService actionService;
    @Resource
    private CouponTemplateDas couponTemplateDas;

    @Override
    public PageInfo<ActivityListRespDto> queryActivityPage(ActivityExtDto queryDto, Integer pageNum, Integer pageSize) {
        ActivityListVo vo = new ActivityListVo();
        BeanUtils.copyProperties((Object)queryDto, (Object)vo, (String[])new String[]{"activityStatusEnum", "auditStatusEnum"});
        if (queryDto.getActivityStatusEnum() != null) {
            vo.setActivityStatus(queryDto.getActivityStatusEnum().getKey());
        }
        if (queryDto.getAuditStatusEnum() != null) {
            vo.setAuditStatus(queryDto.getAuditStatusEnum().getKey());
        }
        if (!CollectionUtils.isEmpty((Collection)queryDto.getActivityTemplateIds())) {
            vo.setTemplateIds(queryDto.getActivityTemplateIds());
        }
        if (!CollectionUtils.isEmpty((Collection)queryDto.getActivityStatus())) {
            vo.setActivityStatusList(queryDto.getActivityStatus());
        }
        if (!CollectionUtils.isEmpty((Collection)queryDto.getAuditStatusEnums())) {
            vo.setAuditStatusList(queryDto.getAuditStatusEnums());
        }
        if (!CollectionUtils.isEmpty((Collection)queryDto.getOutActivityIds())) {
            vo.setOutIds(queryDto.getOutActivityIds());
        }
        if (!CollectionUtils.isEmpty((Collection)queryDto.getActivityIds())) {
            vo.setActivityIds(queryDto.getActivityIds());
        }
        vo.setUpdatePerson(queryDto.getUpdateAcc());
        if (!StringUtils.isEmpty((CharSequence)queryDto.getAuditPerson())) {
            ActivityAuditEo forQuery = new ActivityAuditEo();
            forQuery.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{new SqlFilter("create_person", SqlFilter.Operator.like, (Object)("%" + queryDto.getAuditPerson() + "%"))}));
            forQuery.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getKey());
            List ads = this.activityAuditDas.select((BaseEo)forQuery);
            if (!CollectionUtils.isEmpty((Collection)ads)) {
                ArrayList adIds = Lists.newArrayList();
                ads.forEach(eo -> adIds.add(eo.getActivityId()));
                vo.setIds((List)adIds);
            } else {
                return new PageInfo();
            }
        }
        PageInfo pageInfo = this.activityExtDas.queryFatList(vo, pageNum, pageSize);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)result, (String[])new String[]{"list"});
        if (!CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            ArrayList resultList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), (Collection)resultList, ActivityListRespDto.class);
            resultList.forEach(activity -> {
                ActivityAuditEo forQuery = new ActivityAuditEo();
                forQuery.setActivityId(activity.getId());
                forQuery.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getKey());
                List auditEos = this.activityAuditDas.select((BaseEo)forQuery);
                if (!CollectionUtils.isEmpty((Collection)auditEos)) {
                    activity.setAuditPerson(((ActivityAuditEo)auditEos.get(0)).getCreatePerson());
                }
                if (activity.getActivityTemplateId().equals(ActivityType.COUPON_TOB_ACTIVITY.getId())) {
                    CouponTemplateEo couponQuery = new CouponTemplateEo();
                    couponQuery.setActivityId(activity.getId());
                    List couponTemplateEos = this.couponTemplateDas.select((BaseEo)couponQuery);
                    if (!CollectionUtils.isEmpty((Collection)couponTemplateEos)) {
                        activity.setCouponTemplateId(((CouponTemplateEo)couponTemplateEos.get(0)).getId());
                        activity.setCouponTemplateStatus(((CouponTemplateEo)couponTemplateEos.get(0)).getCouponTemplateStatus());
                        activity.setBeginTime(((CouponTemplateEo)couponTemplateEos.get(0)).getEffectiveTime());
                        activity.setEndTime(((CouponTemplateEo)couponTemplateEos.get(0)).getInvalidTime());
                    }
                }
            });
            result.setList((List)resultList);
        }
        return result;
    }

    private void fillTemplateCondition(ActivityListVo vo) {
        ArrayList templateIds = Lists.newArrayList();
        templateIds.add(ActivityType.FULL_DISCOUNT_ACTIVITY.getId());
        templateIds.add(ActivityType.OVERALL_REDUCTION_ACTIVITY.getId());
        templateIds.add(ActivityType.FULL_RETURNING_ACTIVITY.getId());
        templateIds.add(ActivityType.FULL_PRESENT_ACTIVITY.getId());
        templateIds.add(ActivityType.ADDITIONAL_PURCHASE_ACTIVITY.getId());
        templateIds.add(ActivityType.DEPOSIT_PRESENT_ACTIVITY.getId());
        templateIds.add(ActivityType.INTEGRAL_EXCHANGE_ACTIVITY.getId());
        vo.setTemplateIds((List)templateIds);
    }

    @Override
    public List<PointExchangeActivityRespDto> pointExchangeItem(Long activityTemplateId, long memberId, String shopCode, String itemCode) {
        List<ActivityEo> activityEos = this.activateAcList(activityTemplateId);
        List<Long> acIds = activityEos.parallelStream().map(BaseEo::getId).collect(Collectors.toList());
        EngineParams params = new EngineParams();
        if (memberId > 0L) {
            params.setUserId(memberId);
            acIds = this.filerByCondition(acIds, params, ConditionTemplateType.TARGET_POPULATION);
        }
        if (!StringUtils.isEmpty((CharSequence)shopCode)) {
            params.setShopId(shopCode);
            acIds = this.filerByCondition(acIds, params, ConditionTemplateType.ACTIVITY_SHOP);
        }
        if (!StringUtils.isEmpty((CharSequence)itemCode)) {
            ItemVo item = new ItemVo();
            item.setItemId(itemCode);
            params.setItems((List)Lists.newArrayList((Object[])new ItemVo[]{item}));
            acIds = this.filerByCondition(acIds, params, ConditionTemplateType.POINT_EXCHANGE);
        }
        if (!CollectionUtils.isEmpty(acIds)) {
            acIds = this.checkDayLimit(acIds, memberId);
        }
        if (CollectionUtils.isEmpty(acIds)) {
            throw new ProBizException((ProExceptionCode)ProExceptionExtCode.ACTIVITY_NOT_EXIST);
        }
        List<Long> tempAcIds = acIds;
        Collection<ActivityEo> mutex = this.mutex(activityEos.stream().filter(a -> tempAcIds.stream().anyMatch(id -> Objects.equals(id, a.getId()))).collect(Collectors.toSet()));
        List<ConditionEo> conditionRespDtos = this.conditionQueryService.listByActivityIds(mutex.stream().map(BaseEo::getId).collect(Collectors.toList()), ConditionTemplateType.POINT_EXCHANGE.getId());
        return conditionRespDtos.stream().map(c -> {
            JSONObject jsonObject = JSON.parseObject((String)c.getConditionParams());
            PointExchangeActivityRespDto dto = new PointExchangeActivityRespDto();
            int type = MapUtils.getIntValue((Map)jsonObject, (Object)"PointExchangeCondition.type", (int)1);
            ActivityEo activityEo = mutex.stream().filter(e -> Objects.equals(e.getId(), c.getActivityId())).findFirst().orElse(null);
            dto.setAcId(activityEo.getId().longValue());
            dto.setCreateTime(activityEo.getCreateTime());
            List vo = (List)jsonObject.getObject("PointExchangeCondition.condition", (TypeReference)new TypeReference<List<PointExchangeVo>>(){});
            dto.setItems(vo.stream().map(v -> {
                PointExchangeItemRespDto item = new PointExchangeItemRespDto();
                item.setObjCode(v.getObjCode());
                item.setObjId(v.getObjId());
                item.setPoints(v.getPoints());
                item.setPrice(v.getPrice());
                item.setSalePrice(v.getSalePrice());
                item.setType(type);
                return item;
            }).collect(Collectors.toList()));
            return dto;
        }).collect(Collectors.toList());
    }

    @Override
    public List<ActivityEo> activateAcListByPayTime(ActivityType type, Date payTime) {
        String payTimeStr = DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)payTime);
        ArrayList activityList = Lists.newArrayList();
        ActivityEo activityEo = new ActivityEo();
        activityEo.setActivityTemplateId(Long.valueOf(type.getId()));
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(new SqlFilter("activity_status", SqlFilter.Operator.in, (Object)Lists.newArrayList((Object[])new String[]{ActivityStatusEnum.ACTIVATE.getKey(), ActivityStatusEnum.FINISH.getKey()})));
        if (StringUtils.isNotEmpty((CharSequence)payTimeStr)) {
            sqlFilters.add(new SqlFilter("begin_time", SqlFilter.Operator.lt, (Object)payTimeStr));
            sqlFilters.add(new SqlFilter("end_time", SqlFilter.Operator.gt, (Object)payTimeStr));
        }
        activityEo.setSqlFilters((List)sqlFilters);
        activityEo.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getKey());
        List<ActivityEo> activityEos = this.queryList(activityEo);
        if (!CollectionUtils.isEmpty(activityEos)) {
            activityEos.forEach(eo -> {
                ActivityAuditEo forQuery = new ActivityAuditEo();
                forQuery.setActivityId(eo.getId());
                forQuery.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getKey());
                forQuery.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{new SqlFilter("create_time", SqlFilter.Operator.lt, (Object)payTimeStr)}));
                if (!CollectionUtils.isEmpty((Collection)this.activityAuditDas.select((BaseEo)forQuery))) {
                    activityList.add(eo);
                }
            });
        }
        return activityList;
    }

    @Override
    public PageInfo<ActivityRespDto> queryActivityByActivityStatus(List<String> statusList, String activityName, Integer pageNum, Integer pageSize) {
        ActivityEo query = new ActivityEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"activityStatus", (Object)StringUtils.join(statusList, (String)",")));
        if (!StringUtils.isEmpty((CharSequence)activityName)) {
            sqlFilters.add(SqlFilter.like((String)"activity_name", (Object)("%" + activityName + "%")));
        }
        query.setOrderByDesc("createTime");
        query.setSqlFilters(sqlFilters);
        PageInfo pageInfo = this.activityDas.selectPage((BaseEo)query, pageNum, pageSize);
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), dtoList, ActivityRespDto.class);
        pageInfo.setList(dtoList);
        return pageInfo;
    }

    @Override
    public List<ActivityRespDto> queryActivityListByIds(List<Long> idList) {
        ActivityEo query = new ActivityEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(idList, (String)",")));
        query.setSqlFilters(sqlFilters);
        List activityEoList = this.activityDas.select((BaseEo)query);
        ArrayList<ActivityRespDto> dtoList = new ArrayList<ActivityRespDto>();
        ActivityRespDto activityRespDto = null;
        for (ActivityEo eo : activityEoList) {
            activityRespDto = new ActivityRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)activityRespDto);
            dtoList.add(activityRespDto);
        }
        long id = ActivityType.COUPON_TOB_ACTIVITY.getId();
        List ids = dtoList.stream().filter(dto -> dto.getActivityTemplateId().equals(id)).map(ActivityRespDto::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return dtoList;
        }
        Map<Long, Long> tempMap = this.couponTemplateDas.getMapper().selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{StdCouponTemplateEo::getActivityId, BaseEo::getId}).in(StdCouponTemplateEo::getActivityId, ids)).eq(BaseEo::getDr, (Object)0)).stream().collect(Collectors.toMap(StdCouponTemplateEo::getActivityId, BaseEo::getId, (o, o1) -> o));
        for (ActivityRespDto activityDto : dtoList) {
            if (!activityDto.getActivityTemplateId().equals(id)) continue;
            activityDto.setCouponTemplateId(tempMap.get(activityDto.getId()));
        }
        return dtoList;
    }

    @Override
    public ActivityRespDto queryActivityById(Long id) {
        ActivityEo query = new ActivityEo();
        query.setId(id);
        ActivityEo activityEo = (ActivityEo)this.activityDas.selectOne((BaseEo)query);
        if (activityEo != null) {
            ActivityRespDto activityRespDto = new ActivityRespDto();
            DtoHelper.eo2Dto((BaseEo)activityEo, (BaseVo)activityRespDto);
            return activityRespDto;
        }
        return null;
    }

    @Override
    public List<ActivityEo> queryList(ActivityEo eo) {
        return this.activityDas.select((BaseEo)eo);
    }

    @Override
    public Collection<ActivityEo> mutex(Collection<ActivityEo> eos) {
        if (CollectionUtils.isEmpty(eos)) {
            throw new ProBizException((ProExceptionCode)ProExceptionExtCode.ACTIVITY_NOT_ACTIVATE);
        }
        int maxMutex = eos.stream().mapToInt(StdActivityEo::getMutexLevel).max().orElse(0);
        if (maxMutex == 0) {
            return eos;
        }
        return eos.stream().filter(eo -> Objects.equals(maxMutex, eo.getMutexLevel()) || Objects.equals(0, eo.getMutexLevel())).collect(Collectors.toList());
    }

    @Override
    public List<ActivityEo> activateAcList(Long activityTemplateId) {
        if (activityTemplateId == null) {
            throw new ProBizException((ProExceptionCode)ProExceptionExtCode.ACTIVITY_NOT_EXIST);
        }
        ActivityEo eo = new ActivityEo();
        eo.setActivityTemplateId(activityTemplateId);
        eo.setActivityStatus(ActivityStatusEnum.ACTIVATE.getKey());
        List<ActivityEo> activityEos = this.queryList(eo);
        if (CollectionUtils.isEmpty(activityEos)) {
            throw new ProBizException((ProExceptionCode)ProExceptionExtCode.ACTIVITY_NOT_ACTIVATE);
        }
        return activityEos;
    }

    private List<Long> filerByCondition(List<Long> acIds, EngineParams params, ConditionTemplateType templateType) {
        List<ConditionEo> conditionEos = this.conditionQueryService.listByActivityIds(acIds, templateType.getId());
        List<ConditionRespDto> conditionRespDtos = BeanCopyUtil.copyCollections(conditionEos, ConditionRespDto.class, new String[0]);
        acIds = conditionRespDtos.stream().filter(cr -> {
            ConditionTemplateRespDto conditionTemplateRespDto = this.conditionTemplateService.queryById(cr.getConditionTemplateId());
            try {
                return ConditionTemplate.execute(conditionTemplateRespDto, cr, params);
            }
            catch (Exception e) {
                logger.info("\u7531\u4e8e:{} \u3002\u6d3b\u52a8:{}\u4e0d\u53ef\u53c2\u4e0e.", (Object)e.getMessage(), (Object)cr.getActivityId());
                return false;
            }
        }).map(ConditionRespDto::getActivityId).collect(Collectors.toList());
        return acIds;
    }

    private List<Long> checkDayLimit(List<Long> acIds, long memberId) {
        List<ConditionEo> conditionEos = this.conditionQueryService.listByActivityIds(acIds, ConditionTemplateType.POINT_EXCHANGE.getId());
        return conditionEos.stream().filter(conditionEo -> {
            try {
                JSONObject obj = JSON.parseObject((String)conditionEo.getConditionParams());
                Integer limit = MapUtils.getInteger((Map)obj, (Object)"PointExchangeCondition.dayLimit");
                if (limit != null) {
                    Integer num = (Integer)((ICacheService)SpringBeanUtil.getBean(ICacheService.class)).getCache("PointExchangeCondition.dayLimit" + conditionEo.getActivityId() + memberId, Integer.class);
                    return num == null || num < limit;
                }
            }
            catch (Exception e) {
                logger.error("\u79ef\u5206\u5151\u6362\u67e5\u8be2\u6821\u9a8c\u5151\u6362\u6b21\u6570\u51fa\u9519\uff1a{}.\u6d3b\u52a8:[{}]\u88ab\u8ba4\u4e3a\u4e0d\u53ef\u53c2\u4e0e", (Object)e.getMessage(), (Object)conditionEo.getActivityId());
                return false;
            }
            return true;
        }).map(StdConditionEo::getActivityId).collect(Collectors.toList());
    }

    @Override
    public ActivityItemBranchRespDto queryActivityItemBranch(ActivityItemBranchReqDto activityItemBranchReqDto) {
        ArrayList<ActivityItemRespDto> activityItems = new ArrayList<ActivityItemRespDto>();
        ActivityItemBranchRespDto activityItemBranchRespDto = new ActivityItemBranchRespDto();
        ArrayList<ActivityRespDto> activityList = new ArrayList<ActivityRespDto>();
        for (Long id : activityItemBranchReqDto.getActivityIds()) {
            ActivityRespDto activityRespDto = this.activityService.getById(id);
            activityList.add(activityRespDto);
            if (!ActivityDimensionEnum.ITEM.getKey().equals(activityRespDto.getActivityTemplate().getDimension())) continue;
            for (Long itemId : activityItemBranchReqDto.getItemIds()) {
                List<ActivityItemRespDto> activityItemRespDtos = this.activityItemService.queryActivityItems(id, itemId);
                if (CollectionUtils.isEmpty(activityItemRespDtos)) continue;
                activityItems.addAll(activityItemRespDtos);
            }
        }
        activityItemBranchRespDto.setActivityList(activityList);
        activityItemBranchRespDto.setActivityItems(activityItems);
        return activityItemBranchRespDto;
    }

    @Override
    public List<ActivityRespDto> queryActivityList(ActivityQueryReqDto queryReqDto) {
        ActivityEo query = new ActivityEo();
        CubeBeanUtils.copyProperties((Object)query, (Object)queryReqDto, (String[])new String[0]);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isEmpty((Collection)queryReqDto.getActivityStatusList())) {
            sqlFilters.add(SqlFilter.in((String)"activityStatus", (Object)queryReqDto.getActivityStatusList()));
        }
        query.setOrderByDesc("createTime");
        query.setSqlFilters(sqlFilters);
        List activityEoList = this.activityDas.select((BaseEo)query);
        ArrayList<ActivityRespDto> dtoList = new ArrayList<ActivityRespDto>();
        activityEoList.forEach(activityEo -> {
            ActivityRespDto activityRespDto = this.activityService.getById(activityEo.getId());
            dtoList.add(activityRespDto);
        });
        return dtoList;
    }

    @Override
    public ActivityRespDto queryExchangeActivityDetailById(Long id) {
        ActivityEo eo = new ActivityEo();
        eo.setId(id);
        eo.setActivityStatus(ActivityStatusEnum.ACTIVATE.getKey());
        eo = (ActivityEo)this.activityDas.selectOne((BaseEo)eo);
        ActivityRespDto activityRespDto = null;
        if (eo != null) {
            activityRespDto = new ActivityRespDto();
            CubeBeanUtils.copyProperties((Object)activityRespDto, (Object)eo, (String[])new String[0]);
            ConditionEo conditionEo = new ConditionEo();
            conditionEo.setActivityId(id);
            conditionEo.setConditionTemplateId(Long.valueOf(1196944771412880296L));
            conditionEo = (ConditionEo)this.conditionDas.selectOne((BaseEo)conditionEo);
            ArrayList itemRespDtos = Lists.newArrayList();
            if (conditionEo != null) {
                String conditionParams = conditionEo.getConditionParams();
                JSONObject jsonObject = JSON.parseObject((String)conditionParams);
                ExchangeRule exchangeRule = (ExchangeRule)JSON.parseObject((String)jsonObject.getString("ExchangeCondition.rule"), ExchangeRule.class);
                List exchangeItems = ((ExcRuleContentDto)exchangeRule.getExcRuleContents().get(0)).getExchangeItems();
                for (ExcItemDto exchangeItem : exchangeItems) {
                    ActivityItemRespDto itemRespDto = new ActivityItemRespDto();
                    itemRespDto.setItemId(exchangeItem.getItemId());
                    itemRespDto.setActivityPrice(exchangeItem.getExchangePrice());
                    itemRespDtos.add(itemRespDto);
                }
            }
            activityRespDto.setActivityItemRespDtos((List)itemRespDtos);
        }
        return activityRespDto;
    }

    @Override
    public List<ActivityRespDto> queryExchangeActivityDetailByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        ActivityEo eo = new ActivityEo();
        ArrayList sqlFiters = Lists.newArrayList();
        sqlFiters.add(SqlFilter.in((String)"id", ids));
        eo.setSqlFilters((List)sqlFiters);
        eo.setActivityStatus(ActivityStatusEnum.ACTIVATE.getKey());
        List eos = this.activityDas.select((BaseEo)eo);
        ArrayList activityRespDtos = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)eos)) {
            CubeBeanUtils.copyCollection((Collection)activityRespDtos, (Collection)eos, ActivityRespDto.class);
            ConditionEo conditionEo = new ConditionEo();
            ArrayList conditionSqlFiters = Lists.newArrayList();
            sqlFiters.add(SqlFilter.in((String)"activity_id", ids));
            conditionEo.setSqlFilters((List)conditionSqlFiters);
            conditionEo.setConditionTemplateId(Long.valueOf(1196944771412880296L));
            List conditionEos = this.conditionDas.select((BaseEo)conditionEo);
            Map<Long, ConditionEo> conditionEoMap = conditionEos.stream().collect(Collectors.toMap(StdConditionEo::getActivityId, e -> e, (e1, e2) -> e1));
            for (ActivityRespDto activityRespDto : activityRespDtos) {
                ArrayList itemRespDtos = Lists.newArrayList();
                if (conditionEoMap.containsKey(activityRespDto.getId())) {
                    ConditionEo conditionEo1 = conditionEoMap.get(activityRespDto.getId());
                    String conditionParams = conditionEo1.getConditionParams();
                    JSONObject jsonObject = JSON.parseObject((String)conditionParams);
                    ExchangeRule exchangeRule = (ExchangeRule)JSON.parseObject((String)jsonObject.getString("ExchangeCondition.rule"), ExchangeRule.class);
                    List exchangeItems = ((ExcRuleContentDto)exchangeRule.getExcRuleContents().get(0)).getExchangeItems();
                    for (ExcItemDto exchangeItem : exchangeItems) {
                        ActivityItemRespDto itemRespDto = new ActivityItemRespDto();
                        itemRespDto.setItemId(exchangeItem.getItemId());
                        itemRespDto.setActivityPrice(exchangeItem.getExchangePrice());
                        itemRespDtos.add(itemRespDto);
                    }
                }
                activityRespDto.setActivityItemRespDtos((List)itemRespDtos);
            }
        }
        return activityRespDtos;
    }

    public List<ConditionRespDto> queryConditionList(Long activityId) {
        return this.conditionService.queryConditionListByActivityId(activityId);
    }

    public List<ActionRespDto> queryActionList(Long activityId) {
        return this.actionService.queryActionListByActivityId(activityId);
    }
}

