/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IConditionCacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.IConditionExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ConditionDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ConditionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StdConditionEo;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConditionExtQueryServiceImpl
implements IConditionExtQueryService {
    @Autowired
    private ConditionDas conditionDas;
    @Autowired
    private IConditionCacheService conditionCacheService;

    @Override
    public List<ConditionEo> listByActivityId(Long activity) {
        return this.listByActivityIds(Lists.newArrayList((Object[])new Long[]{activity}), 0L);
    }

    @Override
    public List<ConditionEo> listByActivityIds(List<Long> activityIds, long conditionTemplateId) {
        if (CollectionUtils.isEmpty(activityIds)) {
            return Collections.emptyList();
        }
        List<Object> conditionList = this.conditionCacheService.findConditionListCache(activityIds);
        if (CollectionUtils.isNotEmpty(conditionList)) {
            List existIds = conditionList.stream().map(StdConditionEo::getActivityId).distinct().collect(Collectors.toList());
            activityIds.removeIf(existIds::contains);
            if (CollectionUtils.isNotEmpty(activityIds)) {
                conditionList.addAll(this.queryByActivityIds(activityIds));
            }
        } else {
            conditionList = this.queryByActivityIds(activityIds);
        }
        if (conditionTemplateId > 0L) {
            conditionList = conditionList.stream().filter(conditionEo -> conditionEo.getConditionTemplateId().equals(conditionTemplateId)).collect(Collectors.toList());
        }
        return conditionList;
    }

    public List<ConditionEo> queryByActivityIds(List<Long> activityIds) {
        if (CollectionUtils.isEmpty(activityIds)) {
            return Collections.emptyList();
        }
        ConditionEo query = ConditionEo.newInstance();
        query.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("activityId", activityIds).get());
        List list = this.conditionDas.select((BaseEo)query);
        this.conditionCacheService.setConditionListCache(list);
        return list;
    }

    @Override
    public Map<Long, List<ConditionEo>> listByActivityIds2Map(List<Long> activityIds) {
        List<ConditionEo> conditionEos = this.listByActivityIds(activityIds, 0L);
        return conditionEos.stream().collect(Collectors.groupingBy(StdConditionEo::getActivityId));
    }
}

