/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.impl;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateCacheService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponTemplateCacheServiceImpl
implements ICouponTemplateCacheService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICacheService cacheService;

    public String getCouponTemplateCacheKey(Long couponTemplateId) {
        return "CACHE:" + CouponTemplateExtRespDto.class.getName() + ":" + couponTemplateId;
    }

    @Override
    public void setCouponTemplateListCache(List<CouponTemplateExtRespDto> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(couponTemplate -> {
                String couponTemplateCacheKey = this.getCouponTemplateCacheKey(couponTemplate.getId());
                this.cacheService.setCache(couponTemplateCacheKey, couponTemplate, 3600);
            });
        }
    }

    @Override
    public List<CouponTemplateExtRespDto> findCouponTemplateListCache(List<Long> couponTemplateIds) {
        ArrayList<CouponTemplateExtRespDto> responseList = new ArrayList<CouponTemplateExtRespDto>();
        if (CollectionUtils.isNotEmpty(couponTemplateIds)) {
            couponTemplateIds.forEach(couponTemplateId -> {
                String couponTemplateCacheKey = this.getCouponTemplateCacheKey((Long)couponTemplateId);
                CouponTemplateExtRespDto couponTemplateExtRespDto = (CouponTemplateExtRespDto)this.cacheService.getCache(couponTemplateCacheKey, CouponTemplateExtRespDto.class);
                if (null != couponTemplateExtRespDto) {
                    responseList.add(couponTemplateExtRespDto);
                }
            });
        }
        return responseList;
    }

    @Override
    public void deleteCouponTemplateListCache(Long couponTemplateId) {
        String couponTemplateCacheKey = this.getCouponTemplateCacheKey(couponTemplateId);
        try {
            this.cacheService.delCache(couponTemplateCacheKey);
        }
        catch (Exception e) {
            this.logger.error("\u6e05\u9664\u7528\u6237\u6761\u4ef6\u7f13\u5b58\u51fa\u73b0\u5f02\u5e38, couponTemplateId={}, message={}", new Object[]{couponTemplateId, e.getMessage(), e});
        }
    }
}

